/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.AssertionFailedException;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.EscapeProcessor;
import com.mysql.jdbc.EscapeProcessorResult;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowDataStatic;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.profiler.ProfileEventSink;
import com.mysql.jdbc.profiler.ProfilerEvent;
import com.mysql.jdbc.util.LRUCache;
import java.sql.BatchUpdateException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Statement
implements java.sql.Statement {
    protected static int statementCounter = 1;
    public static final byte USES_VARIABLES_FALSE = 0;
    public static final byte USES_VARIABLES_TRUE = 1;
    public static final byte USES_VARIABLES_UNKNOWN = -1;
    protected List batchedArgs;
    protected SingleByteCharsetConverter charConverter;
    protected String charEncoding;
    protected Connection connection;
    protected String currentCatalog;
    protected boolean doEscapeProcessing;
    protected ProfileEventSink eventSink;
    private int fetchSize;
    protected boolean isClosed;
    protected long lastInsertId;
    protected int maxFieldSize;
    protected int maxRows;
    protected boolean maxRowsChanged;
    protected List openResults;
    protected boolean pedantic;
    protected Throwable pointOfOrigin;
    protected boolean profileSQL;
    protected ResultSet results;
    protected int resultSetConcurrency;
    protected LRUCache resultSetMetadataCache;
    protected int resultSetType;
    protected int statementId;
    protected int timeout;
    protected long updateCount;
    protected boolean useUsageAdvisor;
    protected SQLWarning warningChain;

    public synchronized void addBatch(String sql) throws SQLException {
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        if (sql != null) {
            this.batchedArgs.add(sql);
        }
    }

    public void cancel() throws SQLException {
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(Messages.getString("Statement.49"), "08003");
        }
    }

    protected void checkForDml(String sql, char firstStatementChar) throws SQLException {
        if ((firstStatementChar == 'I' || firstStatementChar == 'U' || firstStatementChar == 'D' || firstStatementChar == 'A' || firstStatementChar == 'C') && (StringUtils.startsWithIgnoreCaseAndWs(sql, "INSERT") || StringUtils.startsWithIgnoreCaseAndWs(sql, "UPDATE") || StringUtils.startsWithIgnoreCaseAndWs(sql, "DELETE") || StringUtils.startsWithIgnoreCaseAndWs(sql, "DROP") || StringUtils.startsWithIgnoreCaseAndWs(sql, "CREATE") || StringUtils.startsWithIgnoreCaseAndWs(sql, "ALTER"))) {
            throw new SQLException(Messages.getString("Statement.57"), "S1009");
        }
    }

    protected void checkNullOrEmptyQuery(String sql) throws SQLException {
        if (sql == null) {
            throw new SQLException(Messages.getString("Statement.59"), "S1009");
        }
        if (sql.length() == 0) {
            throw new SQLException(Messages.getString("Statement.61"), "S1009");
        }
    }

    public synchronized void clearBatch() throws SQLException {
        if (this.batchedArgs != null) {
            this.batchedArgs.clear();
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    public synchronized void close() throws SQLException {
        this.realClose(true);
    }

    protected void closeAllOpenResults() {
        if (this.openResults != null) {
            Iterator iter = this.openResults.iterator();
            while (iter.hasNext()) {
                ResultSet element = (ResultSet)iter.next();
                try {
                    element.realClose(false);
                }
                catch (SQLException sqlEx) {
                    AssertionFailedException.shouldNotHappen(sqlEx);
                }
            }
            this.openResults.clear();
        }
    }

    protected boolean createStreamingResultSet() {
        boolean bl = false;
        if (this.resultSetType == 1003 && this.resultSetConcurrency == 1007 && this.fetchSize == Integer.MIN_VALUE) {
            bl = true;
        }
        return bl;
    }

    public void enableStreamingResults() throws SQLException {
        this.setFetchSize(Integer.MIN_VALUE);
        this.setResultSetType(1003);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean execute(String sql) throws SQLException {
        this.checkNullOrEmptyQuery(sql);
        this.checkClosed();
        char firstNonWsChar = StringUtils.firstNonWsCharUc(sql);
        boolean isSelect = true;
        if (firstNonWsChar != 'S') {
            isSelect = false;
            if (this.connection.isReadOnly()) {
                throw new SQLException(Messages.getString("Statement.27") + Messages.getString("Statement.28"), "S1009");
            }
        }
        if (this.doEscapeProcessing) {
            Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.connection.serverSupportsConvertFn());
            sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
        }
        if (this.results != null && !this.connection.getHoldResultsOpenOverStatementClose()) {
            this.results.realClose(false);
        }
        CachedResultSetMetaData cachedMetaData = null;
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog;
            block23: {
                block19: {
                    int rowLimit;
                    block22: {
                        block20: {
                            block21: {
                                oldCatalog = null;
                                if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                                    oldCatalog = this.connection.getCatalog();
                                    this.connection.setCatalog(this.currentCatalog);
                                }
                                if (this.connection.getCacheResultSetMetadata()) {
                                    cachedMetaData = this.getCachedMetaData(sql);
                                }
                                if (!this.connection.useMaxRows()) break block19;
                                rowLimit = -1;
                                if (!isSelect) break block20;
                                if (StringUtils.indexOfIgnoreCase(sql, "LIMIT") == -1) break block21;
                                rowLimit = this.maxRows;
                                break block22;
                            }
                            if (this.maxRows <= 0) {
                                this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                                break block22;
                            } else {
                                this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                            }
                            break block22;
                        }
                        this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                    }
                    boolean bl = this.createStreamingResultSet();
                    boolean bl2 = false;
                    if (cachedMetaData == null) {
                        bl2 = true;
                    }
                    rs = this.connection.execSQL(this, sql, rowLimit, null, this.resultSetType, this.resultSetConcurrency, bl, isSelect, this.currentCatalog, bl2);
                    break block23;
                }
                boolean bl = this.createStreamingResultSet();
                boolean bl3 = false;
                if (cachedMetaData == null) {
                    bl3 = true;
                }
                rs = this.connection.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, bl, isSelect, this.currentCatalog, bl3);
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.lastInsertId = rs.getUpdateID();
        if (rs != null) {
            this.results = rs;
            rs.setFirstCharOfQuery(firstNonWsChar);
            if (rs.reallyResult()) {
                if (cachedMetaData != null) {
                    this.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
                } else if (this.connection.getCacheResultSetMetadata()) {
                    this.initializeResultsMetadataFromCache(sql, null, this.results);
                }
            }
        }
        boolean bl = false;
        if (rs == null) return bl;
        if (!rs.reallyResult()) return bl;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String sql, int returnGeneratedKeys) throws SQLException {
        if (returnGeneratedKeys != 1) {
            return this.execute(sql);
        }
        this.checkClosed();
        Object object = this.connection.getMutex();
        synchronized (object) {
            boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
            this.connection.setReadInfoMsgEnabled(true);
            try {
                boolean bl = this.execute(sql);
                Object var8_6 = null;
                this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                return bl;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String sql, int[] generatedKeyIndices) throws SQLException {
        if (generatedKeyIndices == null || generatedKeyIndices.length <= 0) return this.execute(sql);
        this.checkClosed();
        Object object = this.connection.getMutex();
        synchronized (object) {
            boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
            this.connection.setReadInfoMsgEnabled(true);
            try {
                boolean bl = this.execute(sql);
                Object var8_6 = null;
                this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                return bl;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String sql, String[] generatedKeyNames) throws SQLException {
        if (generatedKeyNames == null || generatedKeyNames.length <= 0) return this.execute(sql);
        this.checkClosed();
        Object object = this.connection.getMutex();
        synchronized (object) {
            boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
            this.connection.setReadInfoMsgEnabled(true);
            try {
                boolean bl = this.execute(sql);
                Object var8_6 = null;
                this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                return bl;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] executeBatch() throws SQLException {
        int[] nArray;
        if (this.connection.isReadOnly()) {
            throw new SQLException(Messages.getString("Statement.34") + Messages.getString("Statement.35"), "S1009");
        }
        if (this.results != null && !this.connection.getHoldResultsOpenOverStatementClose()) {
            this.results.realClose(false);
        }
        try {
            int[] updateCounts = null;
            if (this.batchedArgs != null) {
                int nbrCommands = this.batchedArgs.size();
                updateCounts = new int[nbrCommands];
                int i = 0;
                while (i < nbrCommands) {
                    updateCounts[i] = -3;
                    ++i;
                }
                Throwable sqlEx = null;
                int commandIndex = 0;
                commandIndex = 0;
                while (commandIndex < nbrCommands) {
                    try {
                        updateCounts[commandIndex] = this.executeUpdate((String)this.batchedArgs.get(commandIndex));
                    }
                    catch (SQLException ex) {
                        updateCounts[commandIndex] = -3;
                        if (this.connection.getContinueBatchOnError()) {
                            sqlEx = ex;
                        }
                        int[] newUpdateCounts = new int[commandIndex];
                        System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                    }
                    ++commandIndex;
                }
                if (sqlEx != null) {
                    throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                }
            }
            nArray = updateCounts != null ? updateCounts : new int[]{};
            Object var2_9 = null;
        }
        catch (Throwable throwable) {
            Object var2_10 = null;
            this.clearBatch();
            throw throwable;
        }
        this.clearBatch();
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized java.sql.ResultSet executeQuery(String sql) throws SQLException {
        this.checkNullOrEmptyQuery(sql);
        this.checkClosed();
        if (this.doEscapeProcessing) {
            Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.connection.serverSupportsConvertFn());
            sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
        }
        char firstStatementChar = StringUtils.firstNonWsCharUc(sql);
        this.checkForDml(sql, firstStatementChar);
        if (this.results != null && !this.connection.getHoldResultsOpenOverStatementClose()) {
            this.results.realClose(false);
        }
        CachedResultSetMetaData cachedMetaData = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog;
            block17: {
                block15: {
                    block16: {
                        oldCatalog = null;
                        if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                            oldCatalog = this.connection.getCatalog();
                            this.connection.setCatalog(this.currentCatalog);
                        }
                        if (this.connection.getCacheResultSetMetadata()) {
                            cachedMetaData = this.getCachedMetaData(sql);
                        }
                        if (!this.connection.useMaxRows()) break block15;
                        if (StringUtils.indexOfIgnoreCase(sql, "LIMIT") == -1) break block16;
                        boolean bl = this.createStreamingResultSet();
                        boolean bl2 = false;
                        if (cachedMetaData == null) {
                            bl2 = true;
                        }
                        this.results = this.connection.execSQL(this, sql, this.maxRows, null, this.resultSetType, this.resultSetConcurrency, bl, true, this.currentCatalog, bl2);
                        break block17;
                    }
                    if (this.maxRows <= 0) {
                        this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                    } else {
                        this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                    }
                    boolean bl = this.createStreamingResultSet();
                    boolean bl3 = false;
                    if (cachedMetaData == null) {
                        bl3 = true;
                    }
                    this.results = this.connection.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, bl, true, this.currentCatalog, bl3);
                    if (oldCatalog != null) {
                        this.connection.setCatalog(oldCatalog);
                    }
                    break block17;
                }
                boolean bl = this.createStreamingResultSet();
                boolean bl4 = false;
                if (cachedMetaData == null) {
                    bl4 = true;
                }
                this.results = this.connection.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, bl, true, this.currentCatalog, bl4);
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.lastInsertId = this.results.getUpdateID();
        if (cachedMetaData != null) {
            this.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
            return this.results;
        }
        if (!this.connection.getCacheResultSetMetadata()) return this.results;
        this.initializeResultsMetadataFromCache(sql, null, this.results);
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int executeUpdate(String sql) throws SQLException {
        int truncatedUpdateCount;
        this.checkNullOrEmptyQuery(sql);
        this.checkClosed();
        if (this.connection.isReadOnly()) {
            throw new SQLException(Messages.getString("Statement.42") + Messages.getString("Statement.43"), "S1009");
        }
        if (StringUtils.startsWithIgnoreCaseAndWs(sql, "select")) {
            throw new SQLException(Messages.getString("Statement.46"), "01S03");
        }
        char firstStatementChar = StringUtils.firstNonWsCharUc(sql);
        if (this.doEscapeProcessing) {
            Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.connection.serverSupportsConvertFn());
            sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
        }
        if (this.results != null && !this.connection.getHoldResultsOpenOverStatementClose()) {
            this.results.realClose(false);
        }
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, false, this.currentCatalog, true);
            }
            rs = this.connection.execSQL(this, sql, -1, null, 1003, 1007, false, false, this.currentCatalog, true);
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl27 : MonitorExitStatement: MONITOREXIT : var4_4
            this.results = rs;
            rs.setFirstCharOfQuery(firstStatementChar);
            this.updateCount = rs.getUpdateCount();
            truncatedUpdateCount = 0;
            truncatedUpdateCount = this.updateCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.updateCount;
        }
        this.lastInsertId = rs.getUpdateID();
        return truncatedUpdateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String sql, int returnGeneratedKeys) throws SQLException {
        if (returnGeneratedKeys != 1) {
            return this.executeUpdate(sql);
        }
        this.checkClosed();
        Object object = this.connection.getMutex();
        synchronized (object) {
            boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
            this.connection.setReadInfoMsgEnabled(true);
            try {
                int n = this.executeUpdate(sql);
                Object var8_6 = null;
                this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                return n;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String sql, int[] generatedKeyIndices) throws SQLException {
        if (generatedKeyIndices == null || generatedKeyIndices.length <= 0) return this.executeUpdate(sql);
        this.checkClosed();
        Object object = this.connection.getMutex();
        synchronized (object) {
            boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
            this.connection.setReadInfoMsgEnabled(true);
            try {
                int n = this.executeUpdate(sql);
                Object var8_6 = null;
                this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                return n;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String sql, String[] generatedKeyNames) throws SQLException {
        if (generatedKeyNames == null || generatedKeyNames.length <= 0) return this.executeUpdate(sql);
        this.checkClosed();
        Object object = this.connection.getMutex();
        synchronized (object) {
            boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
            this.connection.setReadInfoMsgEnabled(true);
            try {
                int n = this.executeUpdate(sql);
                Object var8_6 = null;
                this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                return n;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                throw throwable;
            }
        }
    }

    protected CachedResultSetMetaData getCachedMetaData(String sql) {
        if (this.resultSetMetadataCache != null) {
            return (CachedResultSetMetaData)this.resultSetMetadataCache.get(sql);
        }
        return null;
    }

    public synchronized java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public synchronized java.sql.ResultSet getGeneratedKeys() throws SQLException {
        return this.getGeneratedKeysInternal();
    }

    protected synchronized java.sql.ResultSet getGeneratedKeysInternal() throws SQLException {
        Field[] fields = new Field[]{new Field("", "GENERATED_KEY", -5, 17)};
        fields[0].setConnection(this.connection);
        ArrayList<byte[][]> rowSet = new ArrayList<byte[][]>();
        long beginAt = this.getLastInsertID();
        int numKeys = this.getUpdateCount();
        String serverInfo = this.results.getServerInfo();
        if (numKeys > 0 && this.results.getFirstCharOfQuery() == 'R' && serverInfo != null && serverInfo.length() > 0) {
            numKeys = this.getRecordCountFromInfo(serverInfo);
        }
        if (beginAt > 0L && numKeys > 0) {
            int i = 0;
            while (i < numKeys) {
                byte[][] row = new byte[][]{Long.toString(beginAt++).getBytes()};
                rowSet.add(row);
                ++i;
            }
        }
        return new ResultSet(this.currentCatalog, fields, new RowDataStatic(rowSet), this.connection, this);
    }

    protected int getId() {
        return this.statementId;
    }

    public synchronized long getLastInsertID() {
        return this.lastInsertId;
    }

    public synchronized long getLongUpdateCount() {
        if (this.results == null) {
            return -1;
        }
        if (this.results.reallyResult()) {
            return -1;
        }
        return this.updateCount;
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public synchronized int getMaxRows() throws SQLException {
        if (this.maxRows <= 0) {
            return 0;
        }
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public synchronized boolean getMoreResults(int current) throws SQLException {
        if (this.results == null) {
            return false;
        }
        ResultSet nextResultSet = this.results.getNextResultSet();
        switch (current) {
            case 1: {
                if (this.results == null) break;
                this.results.close();
                this.results.clearNextResult();
                break;
            }
            case 3: {
                if (this.results != null) {
                    this.results.close();
                    this.results.clearNextResult();
                }
                this.closeAllOpenResults();
                break;
            }
            case 2: {
                if (!this.connection.getDontTrackOpenResources()) {
                    this.openResults.add(this.results);
                }
                this.results.clearNextResult();
                break;
            }
            default: {
                throw new SQLException(Messages.getString("Statement.19"), "S1009");
            }
        }
        this.results = nextResultSet;
        if (this.results == null) {
            this.updateCount = -1;
            this.lastInsertId = -1;
        } else if (this.results.reallyResult()) {
            this.updateCount = -1;
            this.lastInsertId = -1;
        } else {
            this.updateCount = this.results.getUpdateCount();
            this.lastInsertId = this.results.getUpdateID();
        }
        boolean bl = false;
        if (this.results != null && this.results.reallyResult()) {
            bl = true;
        }
        return bl;
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    private final int getRecordCountFromInfo(String serverInfo) {
        StringBuffer recordsBuf = new StringBuffer();
        int recordsCount = 0;
        int duplicatesCount = 0;
        char c = '\u0000';
        int length = serverInfo.length();
        int i = 0;
        while (i < length) {
            c = serverInfo.charAt(i);
            if (Character.isDigit(c)) break;
            ++i;
        }
        recordsBuf.append(c);
        ++i;
        while (i < length) {
            c = serverInfo.charAt(i);
            if (!Character.isDigit(c)) break;
            recordsBuf.append(c);
            ++i;
        }
        recordsCount = Integer.parseInt(recordsBuf.toString());
        StringBuffer duplicatesBuf = new StringBuffer();
        while (i < length) {
            c = serverInfo.charAt(i);
            if (Character.isDigit(c)) break;
            ++i;
        }
        duplicatesBuf.append(c);
        ++i;
        while (i < length) {
            c = serverInfo.charAt(i);
            if (!Character.isDigit(c)) break;
            duplicatesBuf.append(c);
            ++i;
        }
        duplicatesCount = Integer.parseInt(duplicatesBuf.toString());
        return recordsCount - duplicatesCount;
    }

    public synchronized java.sql.ResultSet getResultSet() throws SQLException {
        return this.results != null && this.results.reallyResult() ? this.results : null;
    }

    public synchronized int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public synchronized int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public synchronized int getUpdateCount() throws SQLException {
        if (this.results == null) {
            return -1;
        }
        if (this.results.reallyResult()) {
            return -1;
        }
        int truncatedUpdateCount = 0;
        truncatedUpdateCount = this.results.getUpdateCount() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.results.getUpdateCount();
        return truncatedUpdateCount;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        if (this.connection.versionMeetsMinimum(4, 1, 0)) {
            SQLWarning pendingWarningsFromServer = SQLError.convertShowWarningsToSQLWarnings(this.connection);
            if (this.warningChain != null) {
                this.warningChain.setNextWarning(pendingWarningsFromServer);
            } else {
                this.warningChain = pendingWarningsFromServer;
            }
            return this.warningChain;
        }
        return this.warningChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initializeResultsMetadataFromCache(String sql, CachedResultSetMetaData cachedMetaData, ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        synchronized (resultSet2) {
            block5: {
                block4: {
                    if (cachedMetaData != null) break block4;
                    cachedMetaData = new CachedResultSetMetaData();
                    cachedMetaData.fields = this.results.fields;
                    resultSet.buildIndexMapping();
                    cachedMetaData.columnNameToIndex = resultSet.columnNameToIndex;
                    cachedMetaData.fullColumnNameToIndex = resultSet.fullColumnNameToIndex;
                    cachedMetaData.metadata = resultSet.getMetaData();
                    if (this.resultSetMetadataCache == null) {
                        this.resultSetMetadataCache = new LRUCache(this.connection.getMetadataCacheSize());
                    }
                    this.resultSetMetadataCache.put(sql, cachedMetaData);
                    break block5;
                }
                resultSet.fields = cachedMetaData.fields;
                resultSet.columnNameToIndex = cachedMetaData.columnNameToIndex;
                resultSet.fullColumnNameToIndex = cachedMetaData.fullColumnNameToIndex;
                resultSet.hasBuiltIndexMapping = true;
            }
            return;
        }
    }

    protected void realClose(boolean calledExplicitly) throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.useUsageAdvisor && !calledExplicitly) {
            String message = Messages.getString("Statement.63") + Messages.getString("Statement.64");
            this.eventSink.consumeEvent(new ProfilerEvent(0, "", this.currentCatalog, this.connection.getId(), this.getId(), -1, System.currentTimeMillis(), 0, null, this.pointOfOrigin, message));
        }
        if (this.results != null && this.connection != null && !this.connection.getHoldResultsOpenOverStatementClose()) {
            try {
                this.results.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            if (this.maxRowsChanged) {
                this.connection.unsetMaxRows(this);
            }
            if (!this.connection.getDontTrackOpenResources()) {
                this.connection.unregisterStatement(this);
            }
        }
        this.closeAllOpenResults();
        this.results = null;
        this.connection = null;
        this.warningChain = null;
        this.openResults = null;
        this.isClosed = true;
    }

    public void setCursorName(String name) throws SQLException {
    }

    public synchronized void setEscapeProcessing(boolean enable) throws SQLException {
        this.doEscapeProcessing = enable;
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw new SQLException(Messages.getString("Statement.5"), "S1009");
            }
        }
    }

    public synchronized void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE || this.maxRows != 0 && this.maxRows != -1 && rows > this.getMaxRows()) {
            throw new SQLException(Messages.getString("Statement.7"), "S1009");
        }
        this.fetchSize = rows;
    }

    public synchronized void setMaxFieldSize(int max) throws SQLException {
        int maxBuf;
        if (max < 0) {
            throw new SQLException(Messages.getString("Statement.11"), "S1009");
        }
        int n = maxBuf = this.connection != null ? this.connection.getMaxAllowedPacket() : MysqlIO.getMaxBuf();
        if (max > maxBuf) {
            throw new SQLException(Messages.getString("Statement.13", new Object[]{new Long(maxBuf)}), "S1009");
        }
        this.maxFieldSize = max;
    }

    public synchronized void setMaxRows(int max) throws SQLException {
        if (max > 50000000 || max < 0) {
            throw new SQLException(Messages.getString("Statement.15") + max + " > 50000000.", "S1009");
        }
        if (max == 0) {
            max = -1;
        }
        this.maxRows = max;
        this.maxRowsChanged = true;
        if (this.maxRows == -1) {
            this.connection.unsetMaxRows(this);
            this.maxRowsChanged = false;
        } else {
            this.connection.maxRowsChanged(this);
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException(Messages.getString("Statement.21"), "S1009");
        }
        this.timeout = seconds;
    }

    synchronized void setResultSetConcurrency(int concurrencyFlag) {
        this.resultSetConcurrency = concurrencyFlag;
    }

    synchronized void setResultSetType(int typeFlag) {
        this.resultSetType = typeFlag;
    }

    private final /* synthetic */ void this() {
        this.charConverter = null;
        this.charEncoding = null;
        this.connection = null;
        this.currentCatalog = null;
        this.doEscapeProcessing = true;
        this.eventSink = null;
        this.fetchSize = 0;
        this.isClosed = false;
        this.lastInsertId = -1;
        this.maxFieldSize = MysqlIO.getMaxBuf();
        this.maxRows = -1;
        this.maxRowsChanged = false;
        this.openResults = new ArrayList();
        this.pedantic = false;
        this.profileSQL = false;
        this.results = null;
        this.resultSetConcurrency = 0;
        this.resultSetType = 0;
        this.timeout = 0;
        this.updateCount = -1;
        this.useUsageAdvisor = false;
        this.warningChain = null;
    }

    public Statement(Connection c, String catalog) throws SQLException {
        int maxRowsConn;
        boolean profiling;
        this.this();
        if (c == null || c.isClosed()) {
            throw new SQLException(Messages.getString("Statement.0"), "08003");
        }
        this.connection = c;
        this.currentCatalog = catalog;
        this.pedantic = this.connection.getPedantic();
        if (!this.connection.getDontTrackOpenResources()) {
            this.connection.registerStatement(this);
        }
        if (this.connection != null) {
            this.maxFieldSize = this.connection.getMaxAllowedPacket();
        }
        if (this.connection.getUseUnicode()) {
            this.charEncoding = this.connection.getEncoding();
            this.charConverter = this.connection.getCharsetConverter(this.charEncoding);
        }
        boolean bl = false;
        if (this.connection.getProfileSql() || this.connection.getUseUsageAdvisor()) {
            bl = profiling = true;
        }
        if (this.connection.getAutoGenerateTestcaseScript() || profiling) {
            this.statementId = statementCounter++;
        }
        if (profiling) {
            this.pointOfOrigin = new Throwable();
            this.profileSQL = this.connection.getProfileSql();
            this.useUsageAdvisor = this.connection.getUseUsageAdvisor();
            this.eventSink = ProfileEventSink.getInstance(this.connection);
        }
        if ((maxRowsConn = this.connection.getMaxRows()) != -1) {
            this.setMaxRows(maxRowsConn);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CachedResultSetMetaData {
        Map columnNameToIndex;
        Field[] fields;
        Map fullColumnNameToIndex;
        ResultSetMetaData metadata;

        private final /* synthetic */ void this() {
            this.columnNameToIndex = null;
            this.fullColumnNameToIndex = null;
        }

        CachedResultSetMetaData() {
            this.this();
        }
    }
}

