/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PropertyCacheFile;
import com.puppycrawl.tools.checkstyle.StringArrayReader;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.grammars.GeneratedJava14Lexer;
import com.puppycrawl.tools.checkstyle.grammars.GeneratedJava14Recognizer;
import com.puppycrawl.tools.checkstyle.grammars.GeneratedJavaLexer;
import com.puppycrawl.tools.checkstyle.grammars.GeneratedJavaRecognizer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class TreeWalker
extends AbstractFileSetCheck {
    private static final int DEFAULT_TAB_WIDTH = 8;
    private final Map mTokenToChecks = new HashMap();
    private final Set mAllChecks = new HashSet();
    private int mTabWidth = 8;
    private PropertyCacheFile mCache = new PropertyCacheFile(null, null);
    private ClassLoader mClassLoader;
    private Context mChildContext;
    private ModuleFactory mModuleFactory;
    static /* synthetic */ Class class$com$puppycrawl$tools$checkstyle$api$DetailAST;

    public TreeWalker() {
        this.setFileExtensions(new String[]{"java"});
    }

    public void setTabWidth(int aTabWidth) {
        this.mTabWidth = aTabWidth;
    }

    public void setCacheFile(String aFileName) {
        Configuration configuration = this.getConfiguration();
        this.mCache = new PropertyCacheFile(configuration, aFileName);
    }

    public void setClassLoader(ClassLoader aClassLoader) {
        this.mClassLoader = aClassLoader;
    }

    public void setModuleFactory(ModuleFactory aModuleFactory) {
        this.mModuleFactory = aModuleFactory;
    }

    public void finishLocalSetup() {
        DefaultContext checkContext = new DefaultContext();
        checkContext.add("classLoader", this.mClassLoader);
        checkContext.add("messages", this.getMessageCollector());
        checkContext.add("severity", this.getSeverity());
        checkContext.add("tabWidth", String.valueOf(this.mTabWidth));
        this.mChildContext = checkContext;
    }

    public void setupChild(Configuration aChildConf) throws CheckstyleException {
        String name = aChildConf.getName();
        Object module = this.mModuleFactory.createModule(name);
        if (!(module instanceof Check)) {
            throw new CheckstyleException("TreeWalker is not allowed as a parent of " + name);
        }
        Check c = (Check)module;
        c.contextualize(this.mChildContext);
        c.configure(aChildConf);
        c.init();
        this.registerCheck(c);
    }

    private void process(File aFile) {
        long timestamp;
        String fileName = aFile.getPath();
        if (this.mCache.alreadyChecked(fileName, timestamp = aFile.lastModified())) {
            return;
        }
        try {
            this.getMessageDispatcher().fireFileStarted(fileName);
            String[] lines = Utils.getLines(fileName);
            FileContents contents = new FileContents(fileName, lines);
            DetailAST rootAST = TreeWalker.parse(contents);
            this.walk(rootAST, contents);
        }
        catch (FileNotFoundException fnfe) {
            Utils.getExceptionLogger().debug("FileNotFoundException occured.", fnfe);
            this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.fileNotFound", null, this.getClass()));
        }
        catch (IOException ioe) {
            Utils.getExceptionLogger().debug("IOException occured.", ioe);
            this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{ioe.getMessage()}, this.getClass()));
        }
        catch (RecognitionException re) {
            Utils.getExceptionLogger().debug("RecognitionException occured.", re);
            this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{re.getMessage()}, this.getClass()));
        }
        catch (TokenStreamException te) {
            Utils.getExceptionLogger().debug("TokenStreamException occured.", te);
            this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{te.getMessage()}, this.getClass()));
        }
        catch (Throwable err) {
            Utils.getExceptionLogger().debug("Throwable occured.", err);
            this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{"" + err}, this.getClass()));
        }
        if (this.getMessageCollector().size() == 0) {
            this.mCache.checkedOk(fileName, timestamp);
        } else {
            this.fireErrors(fileName);
        }
        this.getMessageDispatcher().fireFileFinished(fileName);
    }

    private void registerCheck(Check aCheck) throws CheckstyleException {
        int[] tokens = new int[]{};
        Set checkTokens = aCheck.getTokenNames();
        if (!checkTokens.isEmpty()) {
            tokens = aCheck.getRequiredTokens();
            int[] acceptableTokens = aCheck.getAcceptableTokens();
            Arrays.sort(acceptableTokens);
            Iterator it = checkTokens.iterator();
            while (it.hasNext()) {
                String token = (String)it.next();
                try {
                    int tokenId = TokenTypes.getTokenId(token);
                    if (Arrays.binarySearch(acceptableTokens, tokenId) < 0) continue;
                    this.registerCheck(token, aCheck);
                }
                catch (IllegalArgumentException ex) {
                    throw new CheckstyleException("illegal token \"" + token + "\" in check " + aCheck, ex);
                }
            }
        } else {
            tokens = aCheck.getDefaultTokens();
        }
        int i = 0;
        while (i < tokens.length) {
            this.registerCheck(tokens[i], aCheck);
            ++i;
        }
        this.mAllChecks.add(aCheck);
    }

    private void registerCheck(int aTokenID, Check aCheck) {
        this.registerCheck(TokenTypes.getTokenName(aTokenID), aCheck);
    }

    private void registerCheck(String aToken, Check aCheck) {
        ArrayList<Check> visitors = (ArrayList<Check>)this.mTokenToChecks.get(aToken);
        if (visitors == null) {
            visitors = new ArrayList<Check>();
            this.mTokenToChecks.put(aToken, visitors);
        }
        visitors.add(aCheck);
    }

    private void walk(DetailAST aAST, FileContents aContents) {
        this.getMessageCollector().reset();
        this.notifyBegin(aAST, aContents);
        if (aAST != null) {
            this.process(aAST);
        }
        this.notifyEnd(aAST);
    }

    private void notifyBegin(DetailAST aRootAST, FileContents aContents) {
        Iterator it = this.mAllChecks.iterator();
        while (it.hasNext()) {
            Check check = (Check)it.next();
            check.setFileContents(aContents);
            check.beginTree(aRootAST);
        }
    }

    private void notifyEnd(DetailAST aRootAST) {
        Iterator it = this.mAllChecks.iterator();
        while (it.hasNext()) {
            Check check = (Check)it.next();
            check.finishTree(aRootAST);
        }
    }

    private void process(DetailAST aAST) {
        if (aAST == null) {
            return;
        }
        this.notifyVisit(aAST);
        DetailAST child = (DetailAST)aAST.getFirstChild();
        if (child != null) {
            this.process(child);
        }
        this.notifyLeave(aAST);
        DetailAST sibling = (DetailAST)aAST.getNextSibling();
        if (sibling != null) {
            this.process(sibling);
        }
    }

    private void notifyVisit(DetailAST aAST) {
        ArrayList visitors = (ArrayList)this.mTokenToChecks.get(TokenTypes.getTokenName(aAST.getType()));
        if (visitors != null) {
            int i = 0;
            while (i < visitors.size()) {
                Check check = (Check)visitors.get(i);
                check.visitToken(aAST);
                ++i;
            }
        }
    }

    private void notifyLeave(DetailAST aAST) {
        ArrayList visitors = (ArrayList)this.mTokenToChecks.get(TokenTypes.getTokenName(aAST.getType()));
        if (visitors != null) {
            int i = 0;
            while (i < visitors.size()) {
                Check check = (Check)visitors.get(i);
                check.leaveToken(aAST);
                ++i;
            }
        }
    }

    public static DetailAST parse(FileContents aContents) throws TokenStreamException, RecognitionException {
        DetailAST rootAST;
        try {
            StringArrayReader sar = new StringArrayReader(aContents.getLines());
            GeneratedJava14Lexer jl = new GeneratedJava14Lexer(sar);
            jl.setFilename(aContents.getFilename());
            jl.setCommentListener(aContents);
            SilentJava14Recognizer jr = new SilentJava14Recognizer(jl);
            jr.setFilename(aContents.getFilename());
            jr.setASTNodeClass((class$com$puppycrawl$tools$checkstyle$api$DetailAST == null ? (class$com$puppycrawl$tools$checkstyle$api$DetailAST = TreeWalker.class$("com.puppycrawl.tools.checkstyle.api.DetailAST")) : class$com$puppycrawl$tools$checkstyle$api$DetailAST).getName());
            jr.compilationUnit();
            rootAST = (DetailAST)jr.getAST();
        }
        catch (RecognitionException re) {
            StringArrayReader sar = new StringArrayReader(aContents.getLines());
            GeneratedJavaLexer jl = new GeneratedJavaLexer(sar);
            jl.setFilename(aContents.getFilename());
            jl.setCommentListener(aContents);
            GeneratedJavaRecognizer jr = new GeneratedJavaRecognizer(jl);
            jr.setFilename(aContents.getFilename());
            jr.setASTNodeClass((class$com$puppycrawl$tools$checkstyle$api$DetailAST == null ? (class$com$puppycrawl$tools$checkstyle$api$DetailAST = TreeWalker.class$("com.puppycrawl.tools.checkstyle.api.DetailAST")) : class$com$puppycrawl$tools$checkstyle$api$DetailAST).getName());
            jr.compilationUnit();
            rootAST = (DetailAST)jr.getAST();
        }
        return rootAST;
    }

    public void process(File[] aFiles) {
        File[] javaFiles = this.filter(aFiles);
        int i = 0;
        while (i < javaFiles.length) {
            this.process(javaFiles[i]);
            ++i;
        }
    }

    public void destroy() {
        Iterator it = this.mAllChecks.iterator();
        while (it.hasNext()) {
            Check c = (Check)it.next();
            c.destroy();
        }
        this.mCache.destroy();
        super.destroy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class SilentJava14Recognizer
    extends GeneratedJava14Recognizer {
        private SilentJava14Recognizer(GeneratedJava14Lexer aLexer) {
            super(aLexer);
        }

        public void reportError(RecognitionException aRex) {
        }

        public void reportError(String aMsg) {
        }

        public void reportWarning(String aMsg) {
        }
    }
}

