/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

public class XMLLogger
extends AutomaticBean
implements AuditListener {
    private static final int BASE_10 = 10;
    private static final int BASE_16 = 16;
    private boolean mCloseStream;
    private PrintWriter mWriter;
    private static final String[] ENTITIES = new String[]{"gt", "amp", "lt", "apos", "quot"};

    public XMLLogger(OutputStream aOS, boolean aCloseStream) {
        this.setOutputStream(aOS);
        this.mCloseStream = aCloseStream;
    }

    private void setOutputStream(OutputStream aOS) {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(aOS, "UTF8");
            this.mWriter = new PrintWriter(osw);
        }
        catch (UnsupportedEncodingException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public void auditStarted(AuditEvent aEvt) {
        this.mWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.mWriter.println("<checkstyle>");
    }

    public void auditFinished(AuditEvent aEvt) {
        this.mWriter.println("</checkstyle>");
        if (this.mCloseStream) {
            this.mWriter.close();
        } else {
            this.mWriter.flush();
        }
    }

    public void fileStarted(AuditEvent aEvt) {
        this.mWriter.println("<file name=\"" + aEvt.getFileName() + "\">");
    }

    public void fileFinished(AuditEvent aEvt) {
        this.mWriter.println("</file>");
    }

    public void addError(AuditEvent aEvt) {
        if (!SeverityLevel.IGNORE.equals(aEvt.getSeverityLevel())) {
            this.mWriter.print("<error line=\"" + aEvt.getLine() + "\"");
            if (aEvt.getColumn() > 0) {
                this.mWriter.print(" column=\"" + aEvt.getColumn() + "\"");
            }
            this.mWriter.print(" severity=\"" + aEvt.getSeverityLevel().getName() + "\"");
            this.mWriter.print(" message=\"" + this.encode(aEvt.getMessage()) + "\"");
            this.mWriter.println(" source=\"" + this.encode(aEvt.getSourceName()) + "\"/>");
        }
    }

    public void addException(AuditEvent aEvt, Throwable aThrowable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<exception>");
        pw.println("<![CDATA[");
        aThrowable.printStackTrace(pw);
        pw.println("]]>");
        pw.println("</exception>");
        pw.flush();
        this.mWriter.println(this.encode(sw.toString()));
    }

    public String encode(String aValue) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < aValue.length()) {
            char c = aValue.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '&': {
                    int nextSemi = aValue.indexOf(";", i);
                    if (nextSemi < 0 || !this.isReference(aValue.substring(i, nextSemi + 1))) {
                        sb.append("&amp;");
                        break;
                    }
                    sb.append('&');
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean isReference(String aEnt) {
        if (aEnt.charAt(0) != '&' || !aEnt.endsWith(";")) {
            return false;
        }
        if (aEnt.charAt(1) == '#') {
            int prefixLength = 2;
            int radix = 10;
            if (aEnt.charAt(2) == 'x') {
                ++prefixLength;
                radix = 16;
            }
            try {
                Integer.parseInt(aEnt.substring(prefixLength, aEnt.length() - 1), radix);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        String name = aEnt.substring(1, aEnt.length() - 1);
        int i = 0;
        while (i < ENTITIES.length) {
            if (name.equals(ENTITIES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

