/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.Comment;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.grammars.CommentListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.regexp.RE;

public final class FileContents
implements CommentListener {
    private static final String MATCH_SINGLELINE_COMMENT_PAT = "^\\s*//.*$";
    private static final RE MATCH_SINGLELINE_COMMENT = Utils.createRE("^\\s*//.*$");
    private final String mFilename;
    private final String[] mLines;
    private final Map mJavadocComments = new HashMap();
    private final Map mCPlusPlusComments = new HashMap();
    private final Map mCComments = new HashMap();

    public FileContents(String aFilename, String[] aLines) {
        this.mFilename = aFilename;
        this.mLines = aLines;
    }

    public void reportSingleLineComment(String aType, int aStartLineNo, int aStartColNo) {
        this.reportCppComment(aStartLineNo, aStartColNo);
    }

    public void reportBlockComment(String aType, int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        this.reportCComment(aStartLineNo, aStartColNo, aEndLineNo, aEndColNo);
    }

    public void reportCppComment(int aStartLineNo, int aStartColNo) {
        String cmt = this.mLines[aStartLineNo - 1].substring(aStartColNo);
        this.mCPlusPlusComments.put(new Integer(aStartLineNo), cmt);
    }

    public Map getCppComments() {
        return Collections.unmodifiableMap(this.mCPlusPlusComments);
    }

    public void reportCComment(int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        String[] cc = this.extractCComment(aStartLineNo, aStartColNo, aEndLineNo, aEndColNo);
        Integer key = new Integer(aStartLineNo);
        if (this.mCComments.containsKey(key)) {
            List entries = (List)this.mCComments.get(key);
            entries.add(cc);
        } else {
            ArrayList<String[]> entries = new ArrayList<String[]>();
            entries.add(cc);
            this.mCComments.put(key, entries);
        }
        if (this.mLines[aStartLineNo - 1].indexOf("/**", aStartColNo) != -1) {
            this.mJavadocComments.put(new Integer(aEndLineNo - 1), cc);
        }
    }

    public Map getCComments() {
        return Collections.unmodifiableMap(this.mCComments);
    }

    private String[] extractCComment(int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        String[] retVal;
        if (aStartLineNo == aEndLineNo) {
            retVal = new String[]{this.mLines[aStartLineNo - 1].substring(aStartColNo, aEndColNo + 1)};
        } else {
            retVal = new String[aEndLineNo - aStartLineNo + 1];
            retVal[0] = this.mLines[aStartLineNo - 1].substring(aStartColNo);
            int i = aStartLineNo;
            while (i < aEndLineNo) {
                retVal[i - aStartLineNo + 1] = this.mLines[i];
                ++i;
            }
            retVal[retVal.length - 1] = this.mLines[aEndLineNo - 1].substring(0, aEndColNo + 1);
        }
        return retVal;
    }

    public TextBlock getJavadocBefore(int aLineNo) {
        int lineNo = aLineNo - 2;
        while (lineNo > 0 && (this.lineIsBlank(lineNo) || this.lineIsComment(lineNo))) {
            --lineNo;
        }
        String[] text = (String[])this.mJavadocComments.get(new Integer(lineNo));
        return text == null ? null : new Comment(text, lineNo + 1);
    }

    public String[] getLines() {
        return this.mLines;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public boolean lineIsBlank(int aLineNo) {
        return "".equals(this.mLines[aLineNo].trim());
    }

    public boolean lineIsComment(int aLineNo) {
        return MATCH_SINGLELINE_COMMENT.match(this.mLines[aLineNo]);
    }
}

