/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;

public final class ScopeUtils {
    private ScopeUtils() {
    }

    public static Scope getScopeFromMods(DetailAST aMods) {
        Scope retVal = Scope.PACKAGE;
        AST token = aMods.getFirstChild();
        while (token != null) {
            if ("public".equals(token.getText())) {
                retVal = Scope.PUBLIC;
                break;
            }
            if ("protected".equals(token.getText())) {
                retVal = Scope.PROTECTED;
                break;
            }
            if ("private".equals(token.getText())) {
                retVal = Scope.PRIVATE;
                break;
            }
            token = token.getNextSibling();
        }
        return retVal;
    }

    public static Scope getSurroundingScope(DetailAST aAST) {
        Scope retVal = null;
        DetailAST token = aAST.getParent();
        while (token != null) {
            int type = token.getType();
            if (type == 14 || type == 15) {
                DetailAST mods = token.findFirstToken(5);
                Scope modScope = ScopeUtils.getScopeFromMods(mods);
                if (retVal == null || retVal.isIn(modScope)) {
                    retVal = modScope;
                }
            } else if (type == 136) {
                retVal = Scope.ANONINNER;
                break;
            }
            token = token.getParent();
        }
        return retVal;
    }

    public static boolean inInterfaceBlock(DetailAST aAST) {
        boolean retVal = false;
        DetailAST token = aAST.getParent();
        while (token != null) {
            int type = token.getType();
            if (type == 14 || type == 136) break;
            if (type == 15) {
                retVal = true;
                break;
            }
            token = token.getParent();
        }
        return retVal;
    }

    public static boolean inCodeBlock(DetailAST aAST) {
        boolean retVal = false;
        DetailAST token = aAST.getParent();
        while (token != null) {
            int type = token.getType();
            if (type == 9 || type == 8 || type == 11 || type == 12) {
                retVal = true;
                break;
            }
            token = token.getParent();
        }
        return retVal;
    }

    public static boolean isOuterMostType(DetailAST aAST) {
        boolean retVal = true;
        DetailAST parent = aAST.getParent();
        while (parent != null) {
            if (parent.getType() == 14 || parent.getType() == 15) {
                retVal = false;
                break;
            }
            parent = parent.getParent();
        }
        return retVal;
    }

    public static boolean isLocalVariableDef(DetailAST aAST) {
        DetailAST parent;
        if (aAST.getType() == 10) {
            DetailAST parent2 = aAST.getParent();
            if (parent2 != null) {
                int type = parent2.getType();
                return type == 7 || type == 35;
            }
        } else if (aAST.getType() == 21 && (parent = aAST.getParent()) != null) {
            return parent.getType() == 96;
        }
        return false;
    }
}

