/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import org.apache.regexp.RE;

public class GenericIllegalRegexpCheck
extends AbstractFormatCheck {
    private String mMessage = "";
    private boolean mIgnoreCase;

    public void setMessage(String aMessage) {
        if (aMessage == null) {
            aMessage = "";
        }
        this.mMessage = aMessage;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setIgnoreCase(boolean aCaseInsensitive) {
        this.mIgnoreCase = aCaseInsensitive;
    }

    public GenericIllegalRegexpCheck() {
        super("$^");
    }

    public int[] getDefaultTokens() {
        return new int[0];
    }

    public void beginTree(DetailAST aRootAST) {
        String[] lines = this.getLines();
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (this.getRegexp().match(line)) {
                if ("".equals(this.mMessage)) {
                    this.log(i + 1, "illegal.regexp", (Object)this.getFormat());
                } else {
                    this.log(i + 1, this.mMessage);
                }
            }
            ++i;
        }
    }

    public RE getRegexp() {
        RE regexp = super.getRegexp();
        if (this.mIgnoreCase) {
            regexp.setMatchFlags(1);
        } else {
            regexp.setMatchFlags(0);
        }
        return regexp;
    }
}

