/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.HeaderCheck;
import org.apache.commons.beanutils.ConversionException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class RegexpHeaderCheck
extends HeaderCheck {
    private RE[] mHeaderRegexps;

    public void setHeaderFile(String aFileName) throws ConversionException {
        super.setHeaderFile(aFileName);
        String[] headerLines = this.getHeaderLines();
        if (headerLines != null) {
            this.mHeaderRegexps = new RE[headerLines.length];
            int i = 0;
            while (i < headerLines.length) {
                try {
                    this.mHeaderRegexps[i] = Utils.getRE(headerLines[i]);
                }
                catch (RESyntaxException ex) {
                    throw new ConversionException("line " + i + " in header file is not a regexp");
                }
                ++i;
            }
        }
    }

    protected boolean isMatch(int aLineNumber) {
        String[] lines = this.getLines();
        return this.mHeaderRegexps[aLineNumber].match(lines[aLineNumber]);
    }
}

