/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.blocks.BlockOption;

public class EmptyBlockCheck
extends AbstractOptionCheck {
    public EmptyBlockCheck() {
        super(BlockOption.STMT);
    }

    public int[] getDefaultTokens() {
        return new int[]{85, 95, 96, 97, 86, 83, 92, 84, 11, 12};
    }

    public void visitToken(DetailAST aAST) {
        DetailAST slistAST = aAST.findFirstToken(7);
        if (slistAST != null) {
            if (this.getAbstractOption() == BlockOption.STMT) {
                if (slistAST.getChildCount() <= 1) {
                    this.log(slistAST.getLineNo(), slistAST.getColumnNo(), "block.noStmt", (Object)aAST.getText());
                }
            } else if (this.getAbstractOption() == BlockOption.TEXT && !this.hasText(slistAST)) {
                this.log(slistAST.getLineNo(), slistAST.getColumnNo(), "block.empty", (Object)aAST.getText());
            }
        }
    }

    private boolean hasText(DetailAST aSlistAST) {
        boolean retVal = false;
        DetailAST rcurlyAST = aSlistAST.findFirstToken(73);
        if (rcurlyAST != null) {
            int slistLineNo = aSlistAST.getLineNo();
            int slistColNo = aSlistAST.getColumnNo();
            int rcurlyLineNo = rcurlyAST.getLineNo();
            int rcurlyColNo = rcurlyAST.getColumnNo();
            String[] lines = this.getLines();
            if (slistLineNo == rcurlyLineNo) {
                String txt = lines[slistLineNo - 1].substring(slistColNo + 1, rcurlyColNo);
                if (txt.trim().length() != 0) {
                    retVal = true;
                }
            } else if (lines[slistLineNo - 1].substring(slistColNo + 1).trim().length() != 0 || lines[rcurlyLineNo - 1].substring(0, rcurlyColNo).trim().length() != 0) {
                retVal = true;
            } else {
                int i = slistLineNo;
                while (i < rcurlyLineNo - 1) {
                    if (lines[i].trim().length() > 0) {
                        retVal = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return retVal;
    }
}

