/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.duplicates;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StrictDuplicateCodeCheck
extends AbstractFileSetCheck {
    private static final Log LOG = LogFactory.getLog(class$com$puppycrawl$tools$checkstyle$checks$duplicates$StrictDuplicateCodeCheck == null ? (class$com$puppycrawl$tools$checkstyle$checks$duplicates$StrictDuplicateCodeCheck = StrictDuplicateCodeCheck.class$("com.puppycrawl.tools.checkstyle.checks.duplicates.StrictDuplicateCodeCheck")) : class$com$puppycrawl$tools$checkstyle$checks$duplicates$StrictDuplicateCodeCheck);
    private static final long IGNORE = Long.MIN_VALUE;
    private static final int DEFAULT_MIN_DUPLICATE_LINES = 12;
    private int mMin = 12;
    private String mBasedir;
    private long[][] mLineChecksums;
    private long[][] mSortedRelevantChecksums;
    private File[] mFiles;
    private int mDuplicates;
    private int mLoc;
    private long mCacheMisses;
    private long mCacheHits;
    static /* synthetic */ Class class$com$puppycrawl$tools$checkstyle$checks$duplicates$StrictDuplicateCodeCheck;

    public void setMin(int aMin) {
        this.mMin = aMin;
    }

    public void setBasedir(String aBasedir) {
        this.mBasedir = aBasedir;
    }

    public synchronized void process(File[] aFiles) {
        long start = System.currentTimeMillis();
        this.mLoc = 0;
        this.mDuplicates = 0;
        this.mFiles = this.filter(aFiles);
        this.mLineChecksums = new long[this.mFiles.length][];
        this.mSortedRelevantChecksums = new long[this.mFiles.length][];
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading input files");
        }
        int i = 0;
        while (i < this.mFiles.length) {
            try {
                File file = this.mFiles[i];
                String[] lines = Utils.getLines(file.getPath());
                ChecksumGenerator transformer = this.findChecksumGenerator(file);
                this.mLineChecksums[i] = transformer.convertLines(lines);
            }
            catch (IOException ex) {
                LOG.error("Cannot access files to check, giving up: " + ex.getMessage(), ex);
                this.mLineChecksums = new long[0][0];
            }
            ++i;
        }
        this.fillSortedRelevantChecksums();
        long endReading = System.currentTimeMillis();
        this.findDuplicates();
        long endSearching = System.currentTimeMillis();
        this.dumpStats(start, endReading, endSearching);
        this.mLineChecksums = null;
        this.mSortedRelevantChecksums = null;
    }

    private ChecksumGenerator findChecksumGenerator(File aFile) {
        if (aFile.getName().endsWith(".java")) {
            return new JavaChecksumGenerator();
        }
        return new TextfileChecksumGenerator();
    }

    private void dumpStats(long aStart, long aEndReading, long aEndSearching) {
        if (LOG.isDebugEnabled()) {
            long cacheLookups = this.mCacheHits + this.mCacheMisses;
            long initTime = aEndReading - aStart;
            long workTime = aEndSearching - aEndReading;
            LOG.debug("cache hits = " + this.mCacheHits + "/" + cacheLookups);
            LOG.debug("files = " + this.mFiles.length);
            LOG.debug("loc = " + this.mLoc);
            LOG.debug("duplicates = " + this.mDuplicates);
            LOG.debug("Runtime = " + initTime + " + " + workTime);
        }
    }

    private void fillSortedRelevantChecksums() {
        int i = 0;
        while (i < this.mLineChecksums.length) {
            int count = 0;
            long[] checksums = this.mLineChecksums[i];
            long[] relevant = new long[checksums.length];
            int j = 0;
            while (j < checksums.length) {
                long checksum = checksums[j];
                if (checksum != Long.MIN_VALUE) {
                    relevant[count++] = checksum;
                }
                ++j;
            }
            Arrays.sort(relevant, 0, count);
            long[] result = new long[count];
            System.arraycopy(relevant, 0, result, 0, count);
            this.mSortedRelevantChecksums[i] = result;
            ++i;
        }
    }

    private void findDuplicates() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Analysis phase");
        }
        int i = 0;
        while (i < this.mFiles.length) {
            String path = this.mFiles[i].getPath();
            this.getMessageCollector().reset();
            MessageDispatcher dispatcher = this.getMessageDispatcher();
            dispatcher.fireFileStarted(path);
            this.mLoc += this.mLineChecksums[i].length;
            int j = 0;
            while (j < i) {
                this.findDuplicatesInFiles(i, j);
                ++j;
            }
            this.fireErrors(path);
            dispatcher.fireFileFinished(path);
            ++i;
        }
    }

    private void findDuplicatesInFiles(int aI, int aJ) {
        int iFileLength = this.mLineChecksums[aI].length;
        boolean[] iLineOccurInJ = new boolean[iFileLength];
        int iLine = 0;
        while (iLine < iFileLength) {
            iLineOccurInJ[iLine] = Arrays.binarySearch(this.mSortedRelevantChecksums[aJ], this.mLineChecksums[aI][iLine]) >= 0;
            ++iLine;
        }
        int iLine2 = 0;
        while (iLine2 < iFileLength - this.mMin) {
            boolean fastExit = false;
            int kLimit = iFileLength - iLine2;
            int k = 0;
            while (k < Math.min(this.mMin, kLimit)) {
                if (!iLineOccurInJ[iLine2 + k]) {
                    fastExit = true;
                    break;
                }
                ++k;
            }
            if (!fastExit) {
                ++this.mCacheMisses;
                iLine2 = this.findDuplicateFromLine(aI, aJ, iLine2);
            } else {
                ++this.mCacheHits;
            }
            ++iLine2;
        }
    }

    private int findDuplicateFromLine(int aI, int aJ, int aILine) {
        int iFileLength = this.mLineChecksums[aI].length;
        int jFileLength = this.mLineChecksums[aJ].length;
        int jLine = 0;
        while (jLine < jFileLength - this.mMin) {
            int equivalent = 0;
            while (aILine + equivalent < iFileLength && jLine + equivalent < jFileLength && this.mLineChecksums[aI][aILine + equivalent] != Long.MIN_VALUE && this.mLineChecksums[aI][aILine + equivalent] == this.mLineChecksums[aJ][jLine + equivalent]) {
                ++equivalent;
            }
            if ((aI != aJ || aILine != jLine) && equivalent >= this.mMin) {
                this.reportDuplicate(equivalent, aILine, this.mFiles[aJ], jLine);
                aILine += equivalent;
            }
            ++jLine;
        }
        return aILine;
    }

    private void reportDuplicate(int aEquivalent, int aILine, File aJFile, int aJLine) {
        Integer dupLines = new Integer(aEquivalent);
        Integer startLine = new Integer(aJLine + 1);
        String fileName = Utils.getStrippedFileName(this.mBasedir, aJFile.getPath());
        this.log(aILine + 1, "duplicates.lines", new Object[]{dupLines, fileName, startLine});
        ++this.mDuplicates;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class JavaChecksumGenerator
    extends TextfileChecksumGenerator {
        private JavaChecksumGenerator() {
        }

        protected long calcChecksum(String aLine) {
            if (aLine.startsWith("import ")) {
                return Long.MIN_VALUE;
            }
            return super.calcChecksum(aLine);
        }
    }

    private class TextfileChecksumGenerator
    implements ChecksumGenerator {
        private TextfileChecksumGenerator() {
        }

        public long[] convertLines(String[] aOriginalLines) {
            long[] checkSums = new long[aOriginalLines.length];
            int i = 0;
            while (i < aOriginalLines.length) {
                String line = aOriginalLines[i].trim();
                checkSums[i] = this.calcChecksum(line);
                ++i;
            }
            return checkSums;
        }

        protected long calcChecksum(String aLine) {
            int bigPrime = 317;
            long result = 0L;
            int i = 0;
            while (i < aLine.length()) {
                long c = aLine.charAt(i);
                long idx = i;
                result += 317L * idx + c;
                ++i;
            }
            return result;
        }
    }

    private static interface ChecksumGenerator {
        public long[] convertLines(String[] var1);
    }
}

