/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public class ImportOrderCheck
extends Check {
    private String[] mGroups = new String[0];
    private boolean mOrdered = true;
    private boolean mSeparated;
    private boolean mCaseSensitive = true;
    private int mLastGroup;
    private int mLastImportLine;
    private String mLastImport;
    private boolean mBeforeFirstImport;

    public void setGroups(String[] aGroups) {
        this.mGroups = new String[aGroups.length];
        int i = 0;
        while (i < aGroups.length) {
            String pkg = aGroups[i];
            if (!pkg.endsWith(".")) {
                pkg = pkg + ".";
            }
            this.mGroups[i] = pkg;
            ++i;
        }
    }

    public void setOrdered(boolean aOrdered) {
        this.mOrdered = aOrdered;
    }

    public void setSeparated(boolean aSeparated) {
        this.mSeparated = aSeparated;
    }

    public void setCaseSensitive(boolean aCaseSensitive) {
        this.mCaseSensitive = aCaseSensitive;
    }

    public int[] getDefaultTokens() {
        return new int[]{30};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    private int getGroupNumber(String aName) {
        int i = 0;
        while (i < this.mGroups.length) {
            if (aName.startsWith(this.mGroups[i])) break;
            ++i;
        }
        return i;
    }

    public void beginTree(DetailAST aRootAST) {
        this.mLastGroup = Integer.MIN_VALUE;
        this.mLastImportLine = Integer.MIN_VALUE;
        this.mLastImport = "";
        this.mBeforeFirstImport = true;
    }

    public void visitToken(DetailAST aAST) {
        FullIdent ident = FullIdent.createFullIdentBelow(aAST);
        if (ident != null) {
            String name = ident.getText();
            int groupIdx = this.getGroupNumber(name);
            int line = ident.getLineNo();
            if (groupIdx > this.mLastGroup) {
                if (!this.mBeforeFirstImport && this.mSeparated && line - this.mLastImportLine < 2) {
                    this.log(line, "import.separation", (Object)name);
                }
            } else if (groupIdx == this.mLastGroup) {
                if (this.mOrdered) {
                    boolean shouldFireError = false;
                    if (this.mCaseSensitive) {
                        shouldFireError = this.mLastImport.compareTo(name) >= 0;
                    } else {
                        boolean bl = shouldFireError = this.mLastImport.compareToIgnoreCase(name) >= 0;
                    }
                    if (shouldFireError) {
                        this.log(line, "import.ordering", (Object)name);
                    }
                }
            } else {
                this.log(line, "import.ordering", (Object)name);
            }
            this.mLastGroup = groupIdx;
            this.mLastImport = name;
            this.mLastImportLine = aAST.findFirstToken(45).getLineNo();
            this.mBeforeFirstImport = false;
        }
    }
}

