/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.HtmlTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.TagParser;
import java.util.Stack;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class JavadocStyleCheck
extends Check {
    private static final String UNCLOSED_HTML = "javadoc.unclosedhtml";
    private static final String EXTRA_HTML = "javadoc.extrahtml";
    private static final String[] SINGLE_TAG = new String[]{"p", "br", "li", "dt", "dd", "td", "hr", "img", "tr", "th", "td"};
    private Scope mScope = Scope.PRIVATE;
    private RE mEndOfSentenceRE;
    private boolean mCheckFirstSentence = true;
    private boolean mCheckHtml = true;

    public int[] getDefaultTokens() {
        return new int[]{15, 14, 9, 8, 10};
    }

    public void visitToken(DetailAST aAST) {
        if (!ScopeUtils.inCodeBlock(aAST)) {
            Scope surroundingScope;
            Scope variableScope;
            DetailAST mods = aAST.findFirstToken(5);
            Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
            Scope scope = variableScope = ScopeUtils.inInterfaceBlock(aAST) ? Scope.PUBLIC : declaredScope;
            if (variableScope.isIn(this.mScope) && ((surroundingScope = ScopeUtils.getSurroundingScope(aAST)) == null || surroundingScope.isIn(this.mScope))) {
                FileContents contents = this.getFileContents();
                TextBlock cmt = contents.getJavadocBefore(aAST.getLineNo());
                this.checkComment(cmt);
            }
        }
    }

    private void checkComment(TextBlock aComment) {
        if (aComment == null) {
            return;
        }
        if (this.mCheckFirstSentence) {
            this.checkFirstSentence(aComment);
        }
        if (this.mCheckHtml) {
            this.checkHtml(aComment);
        }
    }

    private void checkFirstSentence(TextBlock aComment) {
        String commentText = this.getCommentText(aComment.getText());
        if (commentText.length() != 0 && !this.getEndOfSentenceRE().match(commentText) && !"{@inheritDoc}".equals(commentText)) {
            this.log(aComment.getStartLineNo(), "javadoc.noperiod");
        }
    }

    private String getCommentText(String[] aComments) {
        StringBuffer buffer = new StringBuffer();
        boolean foundTag = false;
        int i = 0;
        while (i < aComments.length) {
            String line = aComments[i];
            int textStart = this.findTextStart(line);
            if (textStart != -1) {
                int ndx = line.indexOf(64);
                if (ndx != -1 && !line.regionMatches(ndx + 1, "link", 0, "link".length()) && !line.regionMatches(ndx + 1, "inheritDoc", 0, "inheritDoc".length())) {
                    foundTag = true;
                    line = line.substring(0, ndx);
                }
                buffer.append(line.substring(textStart));
                this.trimTail(buffer);
                buffer.append('\n');
                if (foundTag) break;
            }
            ++i;
        }
        return buffer.toString().trim();
    }

    private int findTextStart(String aLine) {
        int textStart = -1;
        int i = 0;
        while (i < aLine.length()) {
            if (!Character.isWhitespace(aLine.charAt(i))) {
                if (aLine.regionMatches(i, "/**", 0, "/**".length())) {
                    i += 2;
                } else if (aLine.regionMatches(i, "*/", 0, 2)) {
                    ++i;
                } else if (aLine.charAt(i) != '*') {
                    textStart = i;
                    break;
                }
            }
            ++i;
        }
        return textStart;
    }

    private void trimTail(StringBuffer aBuffer) {
        int i = aBuffer.length() - 1;
        while (i >= 0) {
            if (Character.isWhitespace(aBuffer.charAt(i))) {
                aBuffer.deleteCharAt(i);
            } else {
                if (i <= 0 || aBuffer.charAt(i - 1) != '*' || aBuffer.charAt(i) != '/') break;
                aBuffer.deleteCharAt(i);
                aBuffer.deleteCharAt(i - 1);
                --i;
            }
            --i;
        }
    }

    private void checkHtml(TextBlock aComment) {
        int lineno = aComment.getStartLineNo();
        Stack<HtmlTag> htmlStack = new Stack<HtmlTag>();
        String[] text = aComment.getText();
        TagParser parser = null;
        parser = new TagParser(text, lineno);
        while (parser.hasNextTag()) {
            HtmlTag tag = parser.nextTag();
            if (tag.isIncompleteTag()) {
                this.log(tag.getLineno(), "javadoc.incompleteTag", new Object[]{text[tag.getLineno() - lineno]});
                return;
            }
            if (tag.isClosedTag()) continue;
            if (!tag.isCloseTag()) {
                htmlStack.push(tag);
                continue;
            }
            if (this.isExtraHtml(tag.getId(), htmlStack)) {
                this.log(tag.getLineno(), tag.getPosition(), EXTRA_HTML, (Object)tag);
                continue;
            }
            this.checkUnclosedTags(htmlStack, tag.getId());
        }
        String lastFound = "";
        int i = 0;
        while (i < htmlStack.size()) {
            HtmlTag htag = (HtmlTag)htmlStack.elementAt(i);
            if (!this.isSingleTag(htag) && !htag.getId().equals(lastFound)) {
                this.log(htag.getLineno(), htag.getPosition(), UNCLOSED_HTML, (Object)htag);
                lastFound = htag.getId();
            }
            ++i;
        }
    }

    private void checkUnclosedTags(Stack aHtmlStack, String aToken) {
        Stack<HtmlTag> unclosedTags = new Stack<HtmlTag>();
        HtmlTag lastOpenTag = (HtmlTag)aHtmlStack.pop();
        while (!aToken.equalsIgnoreCase(lastOpenTag.getId())) {
            if (this.isSingleTag(lastOpenTag)) {
                lastOpenTag = (HtmlTag)aHtmlStack.pop();
                continue;
            }
            unclosedTags.push(lastOpenTag);
            lastOpenTag = (HtmlTag)aHtmlStack.pop();
        }
        String lastFound = "";
        int i = 0;
        while (i < unclosedTags.size()) {
            lastOpenTag = (HtmlTag)unclosedTags.get(i);
            if (!lastOpenTag.getId().equals(lastFound)) {
                lastFound = lastOpenTag.getId();
                this.log(lastOpenTag.getLineno(), lastOpenTag.getPosition(), UNCLOSED_HTML, (Object)lastOpenTag);
            }
            ++i;
        }
    }

    private boolean isSingleTag(HtmlTag aTag) {
        boolean isSingleTag = false;
        int i = 0;
        while (i < SINGLE_TAG.length) {
            if (aTag.getId().equalsIgnoreCase(SINGLE_TAG[i])) {
                isSingleTag = true;
            }
            ++i;
        }
        return isSingleTag;
    }

    private boolean isExtraHtml(String aToken, Stack aHtmlStack) {
        boolean isExtra = true;
        int i = 0;
        while (i < aHtmlStack.size()) {
            HtmlTag td = (HtmlTag)aHtmlStack.elementAt(i);
            if (aToken.equalsIgnoreCase(td.getId())) {
                isExtra = false;
                break;
            }
            ++i;
        }
        return isExtra;
    }

    public void setScope(String aFrom) {
        this.mScope = Scope.getInstance(aFrom);
    }

    private RE getEndOfSentenceRE() {
        block2: {
            if (this.mEndOfSentenceRE != null) break block2;
            try {
                this.mEndOfSentenceRE = new RE("([.?!][ \t\n\r\f<])|([.?!]$)");
            }
            catch (RESyntaxException e) {
                e.printStackTrace();
            }
        }
        return this.mEndOfSentenceRE;
    }

    public void setCheckFirstSentence(boolean aFlag) {
        this.mCheckFirstSentence = aFlag;
    }

    public void setCheckHtml(boolean aFlag) {
        this.mCheckHtml = aFlag;
    }
}

