/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;

public class JavadocVariableCheck
extends Check {
    private Scope mScope = Scope.PRIVATE;

    public void setScope(String aFrom) {
        this.mScope = Scope.getInstance(aFrom);
    }

    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    public void visitToken(DetailAST aAST) {
        if (!ScopeUtils.inCodeBlock(aAST)) {
            FileContents contents;
            TextBlock cmt;
            Scope surroundingScope;
            Scope variableScope;
            DetailAST mods = aAST.findFirstToken(5);
            Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
            Scope scope = variableScope = ScopeUtils.inInterfaceBlock(aAST) ? Scope.PUBLIC : declaredScope;
            if (variableScope.isIn(this.mScope) && (surroundingScope = ScopeUtils.getSurroundingScope(aAST)).isIn(this.mScope) && (cmt = (contents = this.getFileContents()).getJavadocBefore(aAST.getLineNo())) == null) {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "javadoc.missing");
            }
        }
    }
}

