/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim;

import brn.distsim.DistsimManagerMXBean;
import brn.distsim.Main;
import brn.distsim.WrapperData;
import brn.distsim.WrapperManager;
import brn.distsim.client.data.Host;
import brn.distsim.jmx.DescriptionMBean;
import com.sun.jdmk.remote.cascading.CascadingService;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistsimManager
extends DescriptionMBean
implements DistsimManagerMXBean {
    public static final Logger log = Logger.getLogger((String)DistsimManager.class.getName());
    public static final String JMX_NAME = "brn.distsim.jmx:type=Manager,name=Distsim";
    public static final String JMX_DISTSIM = "com.sun.jdmk:type=CascadingService,name=DistsimCascade";
    private CascadingService cascadeDistsim;
    private Map<InetSocketAddress, ObjectName> mapHostUrl = Collections.synchronizedMap(new HashMap());
    private WrapperManager wrapperManager;
    private boolean restart = false;
    private Date startTime;

    public DistsimManager(WrapperManager wrapperManager) {
        super(DistsimManagerMXBean.class, true);
        this.wrapperManager = wrapperManager;
        this.startTime = new Date();
        log.info((Object)"running...");
    }

    private String getMountPrefix(String host) {
        String mountPrefix = "distsim-" + host;
        return mountPrefix;
    }

    private DistsimManagerMXBean getMXBean(ObjectName name) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        DistsimManagerMXBean other = JMX.newMXBeanProxy(server, name, DistsimManagerMXBean.class);
        return other;
    }

    public synchronized boolean run() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            this.cascadeDistsim = new CascadingService();
            server.registerMBean(this.cascadeDistsim, new ObjectName(JMX_DISTSIM));
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.wrapperManager.shutDown();
        this.stopWrapperAll();
        try {
            server.unregisterMBean(new ObjectName(JMX_DISTSIM));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        assert (this.cascadeDistsim.getMountPointIDs().length == 0);
        return this.restart;
    }

    @Override
    public synchronized void shutDown() {
        log.info((Object)"shutting down...");
        this.notify();
    }

    @Override
    public synchronized void restart() {
        log.info((Object)"restarting down...");
        this.restart = true;
        this.notify();
    }

    @Override
    public void restartAll() {
        Iterator<ObjectName> iter = this.mapHostUrl.values().iterator();
        while (iter != null && iter.hasNext()) {
            DistsimManagerMXBean other = this.getMXBean(iter.next());
            other.restartAll();
        }
        this.restart();
    }

    @Override
    public WrapperData[] getActiveWrappers() {
        ArrayList<WrapperData> list = new ArrayList<WrapperData>();
        list.addAll((Collection)Arrays.asList(this.wrapperManager.getActiveWrappers()));
        Iterator<ObjectName> iter = this.mapHostUrl.values().iterator();
        while (iter != null && iter.hasNext()) {
            ObjectName next = iter.next();
            DistsimManagerMXBean other = this.getMXBean(next);
            List<WrapperData> res = null;
            try {
                res = Arrays.asList(other.getActiveWrappers());
            }
            catch (Exception e) {
                log.error((Object)("Unable to query " + next + " (" + e.getMessage() + "), removing"));
                log.debug((Object)e);
                this.removeDistsim(next);
                continue;
            }
            list.addAll(res);
        }
        return list.toArray(new WrapperData[0]);
    }

    private void removeDistsim(ObjectName name) {
        Iterator<Map.Entry<InetSocketAddress, ObjectName>> iter = this.mapHostUrl.entrySet().iterator();
        while (iter != null && iter.hasNext()) {
            Map.Entry<InetSocketAddress, ObjectName> next = iter.next();
            if (!name.equals(next.getValue())) continue;
            this.removeDistsim(next.getKey(), false);
            return;
        }
    }

    @Override
    public void addDistsim(String addressList) {
        List<InetSocketAddress> lstAddr = this.addrListToArray(addressList);
        int i = 0;
        while (i < lstAddr.size()) {
            this.addDistsim(lstAddr.get(i));
            ++i;
        }
    }

    @Override
    public void addDistsimFromDb(String dbHost, String dbName, String dbUser, String dbPasswd) {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            String dbUrl = "jdbc:mysql://" + dbHost.trim() + "/" + dbName.trim();
            Connection db = DriverManager.getConnection(dbUrl, dbUser, dbPasswd);
            Map mapHosts = Host.getHosts((Connection)db);
            db.close();
            Iterator iter = mapHosts.values().iterator();
            while (iter != null && iter.hasNext()) {
                String host = (String)iter.next();
                try {
                    this.addDistsim(host);
                }
                catch (Exception e) {
                    log.debug((Object)("Unable to add " + host + " from db"), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to fetch hosts from db", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void addDistsim(InetSocketAddress addr) {
        if (this.wrapperManager.getSocketAddr().equals(addr) || this.mapHostUrl.containsKey(addr) || addr.getHostName().equals("test")) {
            log.debug((Object)("Skip distsim at " + addr));
            return;
        }
        log.info((Object)("Adding distsim at " + addr));
        String host = addr.getHostName();
        int port = addr.getPort();
        try {
            String mountPrefix = this.getMountPrefix(host);
            String mountPoint = String.valueOf(Main.getJmxUrlPrefix(host, port)) + "/" + "jmxrmi";
            this.unmount(mountPoint);
            this.cascadeDistsim.mount(new JMXServiceURL(mountPoint), null, new ObjectName("*distsim.*:*"), mountPrefix);
            InetSocketAddress address = new InetSocketAddress(host, port);
            ObjectName name = new ObjectName(String.valueOf(mountPrefix) + "/" + JMX_NAME);
            this.mapHostUrl.put(address, name);
        }
        catch (Exception e) {
            log.debug((Object)("Unable to add distsim at " + addr), (Throwable)e);
            throw new RuntimeException("Unable to add distsim at " + addr, e);
        }
    }

    private void unmount(String url) throws IOException {
        String[] ids = this.cascadeDistsim.getMountPointIDs();
        int i = 0;
        while (i < ids.length) {
            if (ids[i].contains(url)) {
                this.cascadeDistsim.unmount(ids[i]);
            }
            ++i;
        }
    }

    private void removeDistsim(InetSocketAddress address, boolean stop) {
        ObjectName name = this.mapHostUrl.remove(address);
        if (stop && name != null) {
            DistsimManagerMXBean other = this.getMXBean(name);
            other.shutDown();
        }
        try {
            this.unmount(this.getMountPrefix(address.getHostName()));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to remove distsim at " + address, e);
        }
        if (name == null) {
            log.error((Object)("Distsim on " + address + " not attached."));
            throw new IllegalArgumentException("Distsim on " + address + " not attached.");
        }
    }

    private void removeDistsim(String addressList, boolean stop) {
        List<InetSocketAddress> lstAddr = this.addrListToArray(addressList);
        int i = 0;
        while (i < lstAddr.size()) {
            this.removeDistsim(lstAddr.get(i), stop);
            ++i;
        }
    }

    private List<InetSocketAddress> addrListToArray(String addressList) {
        StringTokenizer toki = new StringTokenizer(addressList);
        ArrayList<InetSocketAddress> ret = new ArrayList<InetSocketAddress>(toki.countTokens());
        while (toki.hasMoreTokens()) {
            String token = toki.nextToken();
            String[] s = token.split(":", 2);
            String hostName = s[0];
            int port = 0;
            port = s.length > 1 ? Integer.parseInt(s[1]) : Main.getRmiRegistryPort();
            ret.add(new InetSocketAddress(hostName, port));
        }
        return ret;
    }

    @Override
    public void removeDistsim(String host) {
        this.removeDistsim(host, false);
    }

    @Override
    public void removeDistsimAll() {
        while (!this.mapHostUrl.isEmpty()) {
            InetSocketAddress host = this.mapHostUrl.keySet().iterator().next();
            this.removeDistsim(host, false);
        }
    }

    @Override
    public void stopDistsim(String host) {
        this.removeDistsim(host, true);
    }

    @Override
    public void stopDistsimAll() {
        while (!this.mapHostUrl.isEmpty()) {
            InetSocketAddress addr = this.mapHostUrl.keySet().iterator().next();
            this.removeDistsim(addr, true);
        }
    }

    @Override
    public String[] getActiveDistsims() {
        Set<InetSocketAddress> hosts = this.mapHostUrl.keySet();
        String[] ret = new String[hosts.size()];
        Iterator<InetSocketAddress> iter = hosts.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ret[i] = iter.next().toString();
            ++i;
        }
        return ret;
    }

    @Override
    public void startWrapper(String host, int idStart, int number, String dbHost, String dbName, String dbUser, String dbPasswd) {
        InetSocketAddress addr = this.addrListToArray(host).get(0);
        this.startWrapper(addr, idStart, number, dbHost, dbName, dbUser, dbPasswd);
    }

    public void startWrapper(InetSocketAddress addr, int idStart, int number, String dbHost, String dbName, String dbUser, String dbPasswd) {
        if (this.wrapperManager.getSocketAddr().equals(addr)) {
            if (dbName == null || dbName.length() == 0) {
                dbName = System.getProperty("brn.distsim.db.name");
            }
            if (dbUser == null || dbUser.length() == 0) {
                dbUser = System.getProperty("brn.distsim.db.user");
            }
            if (dbPasswd == null || dbPasswd.length() == 0) {
                dbPasswd = System.getProperty("brn.distsim.db.password");
            }
            this.wrapperManager.startWrapper(idStart, number, dbHost, dbName, dbUser, dbPasswd, dbHost, dbName, dbUser, dbPasswd);
            return;
        }
        ObjectName name = this.mapHostUrl.get(addr);
        if (name == null) {
            log.error((Object)("Distsim on host " + addr + " not attached."));
            throw new IllegalArgumentException("Distsim on host " + addr + " not attached.");
        }
        DistsimManagerMXBean other = this.getMXBean(name);
        other.startWrapper(addr.getHostName(), idStart, number, dbHost, dbName, dbUser, dbPasswd);
    }

    @Override
    public void startWrapperAll(String startString, String dbHost, String dbName, String dbUser, String dbPasswd) {
        StringTokenizer toki = new StringTokenizer(startString);
        while (toki.hasMoreTokens()) {
            InetSocketAddress socketAddr = this.addrListToArray(toki.nextToken()).get(0);
            String[] idNumber = toki.nextToken().split(":");
            int idStart = Integer.parseInt(idNumber[0]);
            int number = 1;
            if (idNumber.length > 1) {
                number = Integer.parseInt(idNumber[1]);
            }
            this.startWrapper(socketAddr, idStart, number, dbHost, dbName, dbUser, dbPasswd);
        }
    }

    @Override
    public void stopWrapper(String host) {
        InetSocketAddress addr = this.addrListToArray(host).get(0);
        if (this.wrapperManager.getSocketAddr().equals(addr)) {
            this.wrapperManager.stopWrapperAll();
            return;
        }
        ObjectName name = this.mapHostUrl.remove(addr);
        if (name == null) {
            log.error((Object)("Distsim on " + addr + " not attached."));
            throw new IllegalArgumentException("Distsim on " + addr + " not attached.");
        }
        DistsimManagerMXBean other = this.getMXBean(name);
        other.stopWrapper(host);
    }

    @Override
    public void stopWrapperAll() {
        this.wrapperManager.stopWrapperAll();
        Iterator<ObjectName> iter = this.mapHostUrl.values().iterator();
        while (iter != null && iter.hasNext()) {
            DistsimManagerMXBean other = this.getMXBean(iter.next());
            other.stopWrapperAll();
        }
    }

    @Override
    public void continueWrapperAll() {
        this.wrapperManager.continueWrapperAll();
        Iterator<ObjectName> iter = this.mapHostUrl.values().iterator();
        while (iter != null && iter.hasNext()) {
            DistsimManagerMXBean other = this.getMXBean(iter.next());
            other.continueWrapperAll();
        }
    }

    @Override
    public void pauseWrapperAll() {
        this.wrapperManager.continueWrapperAll();
        Iterator<ObjectName> iter = this.mapHostUrl.values().iterator();
        while (iter != null && iter.hasNext()) {
            DistsimManagerMXBean other = this.getMXBean(iter.next());
            other.pauseWrapperAll();
        }
    }

    @Override
    public void changeDatabaseAll(String dbHost, String dbName, String dbUser, String dbPasswd, String dbResHost, String dbResName, String dbResUser, String dbResPasswd) {
        this.wrapperManager.changeDatabaseAll(dbHost, dbName, dbUser, dbPasswd, dbResHost, dbResName, dbResUser, dbResPasswd);
        Iterator<ObjectName> iter = this.mapHostUrl.values().iterator();
        while (iter != null && iter.hasNext()) {
            DistsimManagerMXBean other = this.getMXBean(iter.next());
            other.changeDatabaseAll(dbHost, dbName, dbUser, dbPasswd, dbResHost, dbResName, dbResUser, dbResPasswd);
        }
    }

    @Override
    public String getStartTime() {
        return this.startTime.toString();
    }
}

