/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim;

import brn.distsim.WrapperData;
import brn.distsim.jmx.Description;
import brn.distsim.jmx.Name;

@Description(value="MXBean for the federated management of Distsim server instances")
public interface DistsimManagerMXBean {
    @Description(value="Shut down the local server process")
    public void shutDown();

    @Description(value="Currently running wrappers")
    public WrapperData[] getActiveWrappers();

    @Description(value="Currently running distsim servers")
    public String[] getActiveDistsims();

    @Description(value="Point in time the wrapper was started")
    public String getStartTime();

    @Description(value="Manage another distsim server on the specified host using the default port")
    public void addDistsim(@Name(value="hostList") @Description(value="List of socket addresses of the servers") String var1);

    @Description(value="Manages all distsim servers specified in the database")
    public void addDistsimFromDb(@Name(value="dbHost") @Description(value="Host name of the database server") String var1, @Name(value="dbName") @Description(value="Definitions database name") String var2, @Name(value="dbUser") @Description(value="Definitions database user name") String var3, @Name(value="dbPasswd") @Description(value="Definitions database password") String var4);

    @Description(value="Exclude the specified server from management")
    public void removeDistsim(@Name(value="host") @Description(value="Socket address of the server") String var1);

    @Description(value="Exclude all connected servers from management")
    public void removeDistsimAll();

    @Description(value="Stop the specififed distsim server and associated wrappers")
    public void stopDistsim(@Name(value="host") @Description(value="Host name of the server") String var1);

    @Description(value="Stop all distsim servers and wrappers")
    public void stopDistsimAll();

    @Description(value="Restart the local server process and refresh sources")
    public void restart();

    @Description(value="Restart all server process and refresh sources")
    public void restartAll();

    @Description(value="Start the given number of wrappers on the given host")
    public void startWrapper(@Name(value="host") @Description(value="Host name of the server") String var1, @Name(value="idStart") @Description(value="Start if of the wrapper") int var2, @Name(value="number") @Description(value="Number of wrappers to start") int var3, @Name(value="dbHost") @Description(value="Host name of the database server") String var4, @Name(value="dbName") @Description(value="Definitions database name") String var5, @Name(value="dbUser") @Description(value="Definitions database user name") String var6, @Name(value="dbPasswd") @Description(value="Definitions database password") String var7);

    @Description(value="Start the given number of wrappers on the given host")
    public void startWrapperAll(@Name(value="startString") @Description(value="Start string") String var1, @Name(value="dbHost") @Description(value="Host name of the database server") String var2, @Name(value="dbName") @Description(value="Definitions database name") String var3, @Name(value="dbUser") @Description(value="Definitions database user name") String var4, @Name(value="dbPasswd") @Description(value="Definitions database password") String var5);

    @Description(value="Stop the wrappers on the given host")
    public void stopWrapper(@Name(value="host") @Description(value="Host name of the server") String var1);

    @Description(value="Stop all wrappers on all hosts")
    public void stopWrapperAll();

    @Description(value="Pause all wrappers on all hosts")
    public void pauseWrapperAll();

    @Description(value="Continue all wrappers on all hosts")
    public void continueWrapperAll();

    @Description(value="Change the database on all wrappers.")
    public void changeDatabaseAll(@Name(value="dbHost") @Description(value="Definitions database host name") String var1, @Name(value="dbName") @Description(value="Definitions database name") String var2, @Name(value="dbUser") @Description(value="Definitions database user name") String var3, @Name(value="dbPasswd") @Description(value="Definitions database password") String var4, @Name(value="dbResHost") @Description(value="Result database host name") String var5, @Name(value="dbResName") @Description(value="Result database name") String var6, @Name(value="dbResUser") @Description(value="Result database user name") String var7, @Name(value="dbResPasswd") @Description(value="Result database password") String var8);
}

