/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim;

import brn.distsim.DistsimManager;
import brn.distsim.WrapperManager;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.jmx.HierarchyDynamicMBean;
import org.apache.log4j.spi.LoggerRepository;

public class Main {
    public static final String RMI_NAME = "jmxrmi";

    public static final int getRmiRegistryPort() {
        int port = 51180;
        String portString = System.getProperties().getProperty("brn.distsim.jmxremote.port");
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return port;
    }

    public static final String getJmxUrlLocalPrefix() {
        return Main.getJmxUrlPrefix("localhost", Main.getRmiRegistryPort());
    }

    public static final String getJmxUrlLocalPrefix2() {
        return Main.getJmxUrlPrefix2("localhost", Main.getRmiRegistryPort());
    }

    public static final String getJmxUrlPrefix(String host, int port) {
        return "service:jmx:rmi:///jndi/rmi://" + host + ":" + port;
    }

    public static final String getJmxUrlPrefix2(String host, int port) {
        return "service:jmx:rmi://" + host + ":" + (port + 1) + "/jndi/rmi://" + host + ":" + port;
    }

    public static void main(String[] args) {
        Registry registry;
        boolean restart = false;
        if (System.getProperty("java.rmi.server.hostname") == null || System.getProperty("java.rmi.server.hostname").trim().length() == 0) {
            try {
                String s = InetAddress.getLocalHost().getHostName();
                System.setProperty("java.rmi.server.hostname", s);
            }
            catch (UnknownHostException e3) {
                e3.printStackTrace();
            }
        }
        try {
            File f = new File("log4j.properties");
            FileInputStream fin = new FileInputStream(f);
            Properties properties = new Properties();
            properties.load(fin);
            fin.close();
            PropertyConfigurator.configure((Properties)properties);
        }
        catch (IOException e) {
            BasicConfigurator.configure();
        }
        try {
            registry = LocateRegistry.createRegistry(Main.getRmiRegistryPort());
        }
        catch (RemoteException e) {
            try {
                registry = LocateRegistry.getRegistry(Main.getRmiRegistryPort());
            }
            catch (RemoteException e1) {
                System.err.println("couldn't create registry");
                return;
            }
        }
        try {
            registry.unbind(RMI_NAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            String url = String.valueOf(Main.getJmxUrlLocalPrefix2()) + "/" + RMI_NAME;
            JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(url), null, server);
            connectorServer.start();
            int httpPort = 0;
            HtmlAdaptorServer adaptor = null;
            try {
                httpPort = Integer.parseInt(System.getProperty("brn.distsim.jmxremote.http.port"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (httpPort > 0) {
                adaptor = new HtmlAdaptorServer(httpPort);
                ObjectName adaptorName = new ObjectName("adaptor:proptocol=HTTP");
                server.registerMBean(adaptor, adaptorName);
                adaptor.start();
            }
            HierarchyDynamicMBean hdm = new HierarchyDynamicMBean();
            ObjectName mbo = new ObjectName("log4j:hiearchy=default");
            server.registerMBean(hdm, mbo);
            Logger rootLogger = Logger.getRootLogger();
            hdm.addLoggerMBean(rootLogger.getName());
            LoggerRepository r = LogManager.getLoggerRepository();
            Enumeration currentLoggers = r.getCurrentLoggers();
            while (currentLoggers.hasMoreElements()) {
                Logger logger = (Logger)currentLoggers.nextElement();
                hdm.addLoggerMBean(logger.getName());
            }
            ObjectName nameWrapper = new ObjectName("brn.distsim.jmx:type=Manager,name=Wrapper");
            WrapperManager manager = new WrapperManager();
            server.registerMBean(manager, nameWrapper);
            ObjectName name = new ObjectName("brn.distsim.jmx:type=Manager,name=Distsim");
            DistsimManager distsim = new DistsimManager(manager);
            server.registerMBean(distsim, name);
            restart = distsim.run();
            server.unregisterMBean(nameWrapper);
            server.unregisterMBean(name);
            connectorServer.stop();
            if (adaptor != null) {
                adaptor.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (restart) {
            System.exit(2);
        }
        System.exit(0);
    }
}

