/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim;

import brn.distsim.Main;
import brn.distsim.WrapperData;
import brn.distsim.WrapperManagerMXBean;
import brn.distsim.jmx.DescriptionMBean;
import brn.distsim.wrapper.MainMXBean;
import com.sun.jdmk.remote.cascading.CascadingService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class WrapperManager
extends DescriptionMBean
implements WrapperManagerMXBean {
    public static final Logger log = Logger.getLogger((String)WrapperManager.class.getName());
    public static final String JMX_NAME = "brn.distsim.jmx:type=Manager,name=Wrapper";
    public static final String JMX_WRAPPER = "com.sun.jdmk:type=CascadingService,name=WrapperCascade";
    private Map antThreads = Collections.synchronizedMap(new HashMap());
    private CascadingService cascadeWrapper;
    private InetSocketAddress socketAddr;

    public WrapperManager() {
        super(WrapperManagerMXBean.class, true);
        try {
            this.socketAddr = new InetSocketAddress(InetAddress.getLocalHost(), Main.getRmiRegistryPort());
        }
        catch (UnknownHostException e) {
            log.error((Object)"Unable to determine name of localhost", (Throwable)e);
            throw new RuntimeException(e);
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            this.cascadeWrapper = new CascadingService();
            server.registerMBean(this.cascadeWrapper, new ObjectName(JMX_WRAPPER));
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
        log.info((Object)"running...");
    }

    private String getMountPrefix(int id) {
        return "wrapper-" + id;
    }

    private MainMXBean getMXBean(int id) throws MalformedObjectNameException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = new ObjectName(String.valueOf(this.getMountPrefix(id)) + "/" + "brn.distsim.jmx:type=Wrapper");
        MainMXBean other = JMX.newMBeanProxy(server, name, MainMXBean.class);
        return other;
    }

    public InetSocketAddress getSocketAddr() {
        return this.socketAddr;
    }

    public synchronized void shutDown() {
        log.info((Object)"shutting down...");
        this.stopWrapperAll();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(JMX_WRAPPER));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        assert (this.cascadeWrapper.getMountPointIDs().length == 0);
    }

    public void startWrapper(int idStart, int number, String dbHost, String dbName, String dbUser, String dbPasswd, String dbResHost, String dbResName, String dbResUser, String dbResPasswd) {
        if (number <= 0) {
            throw new IllegalArgumentException("number must be non-negative");
        }
        int i = 0;
        while (i < number) {
            this.startWrapper(idStart + i, dbHost, dbName, dbUser, dbPasswd, dbResHost, dbResName, dbResUser, dbResPasswd);
            ++i;
        }
    }

    private void startWrapper(int id, String dbHost, String dbName, String dbUser, String dbPasswd, String dbResHost, String dbResName, String dbResUser, String dbResPasswd) {
        if (this.antThreads.get(id) != null) {
            log.error((Object)("Wrapper with id " + id + " already running"));
            throw new IllegalArgumentException("Wrapper with id " + id + " already running");
        }
        this.checkStringParams(dbHost, "dbName");
        this.checkStringParams(dbName, "dbName");
        this.checkStringParams(dbUser, "dbUser");
        this.checkStringParams(dbPasswd, "dbPasswd");
        this.checkStringParams(dbResHost, "dbResHost");
        this.checkStringParams(dbResName, "dbResName");
        this.checkStringParams(dbResUser, "dbResUser");
        this.checkStringParams(dbResPasswd, "dbResPasswd");
        log.info((Object)("Starting wrapper " + id));
        try {
            LocateRegistry.getRegistry(Main.getRmiRegistryPort()).unbind("wrapper" + id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Properties wrapperProp = new Properties();
        wrapperProp.setProperty("definitions.host", dbHost);
        wrapperProp.setProperty("definitions.database", dbName);
        wrapperProp.setProperty("definitions.username", dbUser);
        wrapperProp.setProperty("definitions.password", dbPasswd);
        wrapperProp.setProperty("results.host", dbResHost);
        wrapperProp.setProperty("results.database", dbResName);
        wrapperProp.setProperty("results.username", dbResUser);
        wrapperProp.setProperty("results.password", dbResPasswd);
        String arch = String.valueOf(System.getProperties().getProperty("os.arch")) + "-" + System.getProperties().getProperty("os.name");
        wrapperProp.setProperty("host.id", String.valueOf(id));
        wrapperProp.setProperty("host.description", "gurkenhannes");
        wrapperProp.setProperty("host.architecture", arch);
        wrapperProp.setProperty("host.name", this.socketAddr.getHostName());
        StringWriter writer = new StringWriter();
        try {
            wrapperProp.store(writer, null);
        }
        catch (IOException e) {
            log.error((Object)"Unable to store properties", (Throwable)e);
            throw new RuntimeException(e);
        }
        String config = writer.toString();
        final Project p = new Project();
        File buildFile = new File("build.xml");
        p.setUserProperty("ant.file", buildFile.getAbsolutePath());
        p.init();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        p.addReference("ant.projectHelper", (Object)helper);
        helper.parse(p, (Object)buildFile);
        DefaultLogger consoleLogger = new DefaultLogger();
        consoleLogger.setErrorPrintStream(System.err);
        consoleLogger.setOutputPrintStream(System.out);
        consoleLogger.setMessageOutputLevel(2);
        p.addBuildListener((BuildListener)consoleLogger);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(config.getBytes());
        p.setDefaultInputStream((InputStream)byteArrayInputStream);
        String wrapperJmxServiceUrl = String.valueOf(Main.getJmxUrlLocalPrefix()) + "/wrapper" + id;
        p.setProperty("brn.distsim.wrapper.jmxurl", wrapperJmxServiceUrl);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                p.executeTarget("run");
            }
        }, "AntWrapperThread");
        thread.setDaemon(true);
        this.antThreads.put(id, thread);
        thread.start();
        Thread.yield();
        try {
            Registry registry = LocateRegistry.getRegistry(Main.getRmiRegistryPort());
            int i = 0;
            while (i < 100) {
                try {
                    Thread.sleep(100L);
                    registry.lookup("wrapper" + id);
                    break;
                }
                catch (NotBoundException notBoundException) {
                    ++i;
                }
            }
        }
        catch (Exception registry) {
            // empty catch block
        }
        try {
            this.unmount(this.getMountPrefix(id));
        }
        catch (Exception registry) {
            // empty catch block
        }
        try {
            this.cascadeWrapper.mount(new JMXServiceURL(wrapperJmxServiceUrl), null, new ObjectName("brn.*:*"), this.getMountPrefix(id));
        }
        catch (Exception e) {
            this.stopWrapper(id);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        log.info((Object)("Wrapper " + id + " started"));
    }

    private void checkStringParams(String params, String name) {
        if (params == null || params.length() == 0) {
            throw new IllegalArgumentException("Parameter <" + name + "> not set");
        }
    }

    public void stopWrapper(int id) {
        Thread thread = (Thread)this.antThreads.remove(id);
        if (thread == null) {
            log.error((Object)("Wrapper with id " + id + " not found"));
            throw new IllegalArgumentException("Wrapper with id " + id + " not found");
        }
        try {
            this.unmount(this.getMountPrefix(id));
        }
        catch (Exception e) {
            log.error((Object)("Unable to unmount wrapper " + id), (Throwable)e);
        }
        try {
            JMXConnector connector = JMXConnectorFactory.connect(new JMXServiceURL(String.valueOf(Main.getJmxUrlLocalPrefix()) + "/wrapper" + id));
            ObjectName name = new ObjectName("brn.distsim.jmx:type=Wrapper");
            connector.getMBeanServerConnection().invoke(name, "stop", null, null);
            connector.close();
        }
        catch (Exception e) {
            log.error((Object)"Unable to stop wrapper via JMX", (Throwable)e);
        }
        try {
            int i = 0;
            while (i < 100) {
                Thread.sleep(100L);
                if (thread.isAlive()) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (thread.isAlive()) {
            thread.interrupt();
        }
    }

    private void checkDeadAnt() {
        Iterator iter = this.antThreads.keySet().iterator();
        while (iter != null && iter.hasNext()) {
            Integer id = (Integer)iter.next();
            Thread thread = (Thread)this.antThreads.get(id);
            if (thread != null && thread.isAlive()) continue;
            try {
                this.stopWrapper(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public WrapperData[] getActiveWrappers() {
        this.checkDeadAnt();
        ArrayList<WrapperData> list = new ArrayList<WrapperData>();
        Set keys = this.antThreads.keySet();
        Iterator iter = keys.iterator();
        int i = 0;
        while (i < keys.size()) {
            int id = (Integer)iter.next();
            String simulation = null;
            try {
                MainMXBean other = this.getMXBean(id);
                simulation = other.getCurrentSimulation();
            }
            catch (Exception e) {
                log.error((Object)"Unable to get simuliation", (Throwable)e);
                throw new RuntimeException("Unable to query wrapper " + id, e);
            }
            list.add(new WrapperData(id, simulation, this.socketAddr.toString()));
            ++i;
        }
        return list.toArray(new WrapperData[0]);
    }

    public void stopWrapperAll() {
        while (!this.antThreads.isEmpty()) {
            Integer id = (Integer)this.antThreads.keySet().iterator().next();
            this.stopWrapper(id);
        }
    }

    public void continueWrapperAll() {
        Iterator iter = this.antThreads.keySet().iterator();
        while (iter != null && iter.hasNext()) {
            int id = (Integer)iter.next();
            try {
                MainMXBean other = this.getMXBean(id);
                other.continueSim();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Unable to call wrapper " + id, e);
            }
        }
    }

    public void pauseWrapperAll() {
        Iterator iter = this.antThreads.keySet().iterator();
        while (iter != null && iter.hasNext()) {
            int id = (Integer)iter.next();
            try {
                MainMXBean other = this.getMXBean(id);
                other.pauseSim();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Unable to call wrapper " + id, e);
            }
        }
    }

    public void changeDatabaseAll(String dbHost, String dbName, String dbUser, String dbPasswd, String dbResHost, String dbResName, String dbResUser, String dbResPasswd) {
        Iterator iter = this.antThreads.keySet().iterator();
        while (iter != null && iter.hasNext()) {
            int id = (Integer)iter.next();
            try {
                MainMXBean other = this.getMXBean(id);
                other.changeDatabase(dbHost, dbName, dbUser, dbPasswd, dbResHost, dbResName, dbResUser, dbResPasswd);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Unable to call wrapper " + id, e);
            }
        }
    }

    private void unmount(String url) throws IOException {
        String[] ids = this.cascadeWrapper.getMountPointIDs();
        int i = 0;
        while (i < ids.length) {
            if (ids[i].contains(url)) {
                this.cascadeWrapper.unmount(ids[i]);
            }
            ++i;
        }
    }

    public void startWrapper(int idStart, int number, String dbHost, String dbName, String dbUser, String dbPasswd) {
        this.startWrapper(idStart, number, dbHost, dbName, dbUser, dbPasswd, dbHost, dbName, dbUser, dbPasswd);
    }
}

