/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.jmx;

import brn.distsim.jmx.Description;
import brn.distsim.jmx.Name;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionMBean
extends StandardMBean {
    private boolean isLowercaseAttributeNames = true;
    private static Map nameToPrimitiveClass = new HashMap();

    static {
        nameToPrimitiveClass.put("boolean", Boolean.TYPE);
        nameToPrimitiveClass.put("byte", Byte.TYPE);
        nameToPrimitiveClass.put("char", Character.TYPE);
        nameToPrimitiveClass.put("short", Short.TYPE);
        nameToPrimitiveClass.put("int", Integer.TYPE);
        nameToPrimitiveClass.put("long", Long.TYPE);
        nameToPrimitiveClass.put("float", Float.TYPE);
        nameToPrimitiveClass.put("double", Double.TYPE);
    }

    public DescriptionMBean(Class<?> mbeanInterface, boolean isMXBean) {
        super(mbeanInterface, isMXBean);
    }

    public DescriptionMBean(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        super(mbeanInterface);
    }

    public <T> DescriptionMBean(T implementation, Class<T> mbeanInterface, boolean isMXBean) {
        super(implementation, mbeanInterface, isMXBean);
    }

    public <T> DescriptionMBean(T implementation, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(implementation, mbeanInterface);
    }

    private Class findClass(String name) {
        Class c = (Class)nameToPrimitiveClass.get(name);
        if (c != null) {
            return c;
        }
        try {
            return Class.forName(name);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private String getDescription(Class cl) {
        if (cl == null) {
            return null;
        }
        try {
            Description desc = cl.getAnnotation(Description.class);
            if (desc != null) {
                return desc.value();
            }
        }
        finally {
            return "";
        }
    }

    private String getDescription(Method method, int i) {
        if (method == null) {
            return null;
        }
        try {
            Annotation[] annotationArray = method.getParameterAnnotations()[i];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation ann = annotationArray[n2];
                if (ann instanceof Description) {
                    return ((Description)ann).value();
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return "";
    }

    private String getName(Method method, int i) {
        if (method == null) {
            return null;
        }
        try {
            Annotation[] annotationArray = method.getParameterAnnotations()[i];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation ann = annotationArray[n2];
                if (ann instanceof Name) {
                    return ((Name)ann).value();
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return "";
    }

    private String getDescription(Method method) {
        if (method == null) {
            return null;
        }
        try {
            Description desc = method.getAnnotation(Description.class);
            if (desc != null) {
                return desc.value();
            }
        }
        finally {
            return "";
        }
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        if (info == null) {
            return null;
        }
        String ret = this.getDescription(this.getMBeanInterface());
        if (ret != null && ret.length() > 0) {
            return ret;
        }
        return super.getDescription(info);
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        if (info == null) {
            return null;
        }
        String attributeName = info.getName();
        if (this.isLowercaseAttributeNames) {
            StringBuilder builder = new StringBuilder(attributeName);
            builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
            attributeName = builder.toString();
        }
        try {
            BeanInfo binfo = Introspector.getBeanInfo(this.getMBeanInterface());
            PropertyDescriptor[] desc = binfo.getPropertyDescriptors();
            int i = 0;
            while (i < desc.length) {
                if (desc[i].getName().equals(attributeName)) {
                    String ret = this.getDescription(desc[i].getReadMethod());
                    if (ret != null && ret.length() > 0) {
                        return ret;
                    }
                    ret = this.getDescription(desc[i].getWriteMethod());
                    if (ret != null && ret.length() > 0) {
                        return ret;
                    }
                }
                ++i;
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        return super.getDescription(info);
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        if (info == null) {
            return null;
        }
        Class<?> clazz = this.getMBeanInterface();
        MBeanParameterInfo[] pinfo = info.getSignature();
        Class[] parameterClazz = new Class[pinfo.length];
        int i = 0;
        while (i < pinfo.length) {
            parameterClazz[i] = this.findClass(pinfo[i].getType());
            ++i;
        }
        Method method = null;
        try {
            method = clazz.getMethod(info.getName(), parameterClazz);
            String ret = this.getDescription(method);
            if (ret != null && ret.length() > 0) {
                return ret;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return super.getDescription(info);
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (param == null) {
            return null;
        }
        Class<?> clazz = this.getMBeanInterface();
        MBeanParameterInfo[] pinfo = op.getSignature();
        Class[] parameterClazz = new Class[pinfo.length];
        int i = 0;
        while (i < pinfo.length) {
            parameterClazz[i] = this.findClass(pinfo[i].getType());
            ++i;
        }
        Method method = null;
        try {
            method = clazz.getMethod(op.getName(), parameterClazz);
            String ret = this.getName(method, sequence);
            if (ret != null && ret.length() > 0) {
                return ret;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return super.getDescription(op, param, sequence);
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (param == null) {
            return null;
        }
        Class<?> clazz = this.getMBeanInterface();
        MBeanParameterInfo[] pinfo = op.getSignature();
        Class[] parameterClazz = new Class[pinfo.length];
        int i = 0;
        while (i < pinfo.length) {
            parameterClazz[i] = this.findClass(pinfo[i].getType());
            ++i;
        }
        Method method = null;
        try {
            method = clazz.getMethod(op.getName(), parameterClazz);
            String ret = this.getDescription(method, sequence);
            if (ret != null && ret.length() > 0) {
                return ret;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return super.getDescription(op, param, sequence);
    }
}

