/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.wrapper;

import brn.distsim.wrapper.Main;
import brn.distsim.wrapper.Package;
import brn.distsim.wrapper.Simulation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class DBConnector {
    private Connection serializedConnection;
    private Connection relaxedConnection;
    private Connection resultsConnection;
    private PreparedStatement getSimulations;
    private PreparedStatement assignSimulation;
    private PreparedStatement writeFile;
    private PreparedStatement writeStdOut;
    private PreparedStatement updateHosts;
    private int numStdOutChunks;
    private int groupId;
    private List inFiles;
    private List packages;
    private int currentSimulationId = 0;
    private Set blackList;
    private PreparedStatement writeStdErr;
    Main.ConfigData configuration;

    public DBConnector(Main.ConfigData config) throws SQLException {
        this.configuration = config;
        this.inFiles = new LinkedList();
        this.packages = new LinkedList();
        this.blackList = new HashSet();
        this.initConnections();
    }

    void initConnections() throws SQLException {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            String dbUrl = "jdbc:mysql://" + this.configuration.getDefinitionsHost() + "/" + this.configuration.getDefinitionsDatabase();
            String dbUser = this.configuration.getDefinitionsUsername();
            String dbPassword = this.configuration.getDefinitionsPassword();
            this.serializedConnection = DriverManager.getConnection(dbUrl, dbUser, dbPassword);
            this.serializedConnection.createStatement().execute("SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE;");
            this.serializedConnection.createStatement().execute("SET AUTOCOMMIT=0;");
            this.relaxedConnection = DriverManager.getConnection(dbUrl, dbUser, dbPassword);
            this.getSimulations = this.serializedConnection.prepareStatement("SELECT * FROM simulations WHERE assigned<=>NULL FOR UPDATE;");
            this.assignSimulation = this.serializedConnection.prepareStatement("UPDATE simulations SET assigned = " + this.configuration.getHostIdJ() + " WHERE id = ?;");
            String resUrl = "jdbc:mysql://" + this.configuration.getResultsHost() + "/" + this.configuration.getResultsDatabase();
            this.resultsConnection = DriverManager.getConnection(resUrl, this.configuration.getResultsUsername(), this.configuration.getResultsPassword());
            this.writeFile = this.resultsConnection.prepareStatement("INSERT IGNORE INTO out_files VALUES (?, ?, ?);");
            this.writeStdOut = this.resultsConnection.prepareStatement("INSERT INTO stdout VALUES (?, ?, ?);");
            this.writeStdErr = this.resultsConnection.prepareStatement("INSERT INTO stderr VALUES (?, ?, ?);");
            String description = this.configuration.getHostDescription();
            this.updateHosts = this.relaxedConnection.prepareStatement("INSERT INTO hosts VALUES('" + this.configuration.getHostIdJ() + "', '" + this.configuration.getHostName() + "', '" + this.configuration.getHostArchitecture() + "', '" + description + "') ON DUPLICATE KEY UPDATE description='" + description + "';");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void readFilesFromDB() {
        try {
            ResultSet files = this.relaxedConnection.createStatement().executeQuery("SELECT * FROM group_in_files WHERE groupId = '" + this.groupId + "';");
            while (files.next()) {
                String path = files.getString("remotePath");
                FileOutputStream writer = new FileOutputStream(path, false);
                ResultSet file = this.relaxedConnection.createStatement().executeQuery("SELECT * FROM in_files WHERE id = '" + files.getInt("fileId") + "';");
                file.next();
                InputStream stream = file.getBinaryStream("content");
                int read = 0;
                byte[] data = new byte[1024];
                while ((read = stream.read(data)) > 0) {
                    writer.write(data, 0, read);
                }
                this.inFiles.add(path);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deleteResultFiles() {
        try {
            ResultSet files = this.relaxedConnection.createStatement().executeQuery("SELECT * FROM group_out_files WHERE groupId = '" + this.groupId + "';");
            while (files.next()) {
                String path = files.getString("remotePath");
                File file = new File(path);
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void deleteDirectory(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                this.deleteDirectory(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    private void writeFilesToDB() {
        try {
            ResultSet files = this.relaxedConnection.createStatement().executeQuery("SELECT * FROM group_out_files WHERE groupId = '" + this.groupId + "';");
            while (files.next()) {
                String path = files.getString("remotePath");
                File file = new File(path);
                if (file.isDirectory()) {
                    this.writeDirectoryToDB(file);
                    continue;
                }
                this.writeFileToDB(file);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void writeFileToDB(File file) {
        try {
            String path = file.getPath();
            this.writeFile.setInt(1, this.currentSimulationId);
            this.writeFile.setString(2, path);
            this.writeFile.setBinaryStream(3, (InputStream)new FileInputStream(file), (int)file.length());
            this.writeFile.executeUpdate();
            file.delete();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void writeStdOutToDB(InputStream out) {
        this.writeChunksToDB(out, this.writeStdOut);
    }

    public void writeStdErrToDB(InputStream err) {
        this.writeChunksToDB(err, this.writeStdErr);
    }

    private void writeChunksToDB(InputStream in, PreparedStatement sttmt) {
        try {
            sttmt.setInt(1, this.currentSimulationId);
            byte[] out = new byte[1024];
            int read = 0;
            while ((read = in.read(out)) > 0) {
                sttmt.setInt(2, this.numStdOutChunks++);
                if (read < 1024) {
                    byte[] truncated = new byte[read];
                    System.arraycopy(out, 0, truncated, 0, read);
                    sttmt.setBytes(3, truncated);
                } else {
                    sttmt.setBytes(3, out);
                }
                sttmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeDirectoryToDB(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                this.writeDirectoryToDB(file);
                continue;
            }
            this.writeFileToDB(file);
        }
    }

    public boolean readPackages() {
        try {
            int numPkgs = 0;
            ResultSet studyPkgs = this.relaxedConnection.createStatement().executeQuery("SELECT * FROM study_packages WHERE studyId=(SELECT studyId FROM groups WHERE id = " + this.groupId + ");");
            while (studyPkgs.next()) {
                ++numPkgs;
            }
            ResultSet pkgs = this.relaxedConnection.createStatement().executeQuery("SELECT DISTINCT url, localPath FROM packages INNER JOIN study_packages ON (packages.name = study_packages.packageName AND packages.version=study_packages.packageVersion) WHERE (architecture='all' OR architecture='" + this.configuration.getHostArchitecture() + "') " + "AND studyId=(SELECT studyId FROM groups WHERE id = " + this.groupId + ");");
            while (pkgs.next()) {
                Package pkg = new Package(pkgs.getString("url"), pkgs.getString("localPath"));
                --numPkgs;
                this.packages.add(pkg);
            }
            if (numPkgs != 0) {
                this.packages.clear();
                return false;
            }
            for (Package pkg : this.packages) {
                pkg.download();
                pkg.unzip();
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Simulation query(Properties p) throws SQLException {
        this.checkConnection(this.serializedConnection);
        this.checkConnection(this.relaxedConnection);
        this.checkConnection(this.resultsConnection);
        ResultSet newSimulations = null;
        try {
            this.updateHosts.execute();
            this.serializedConnection.createStatement().execute("START TRANSACTION;");
            newSimulations = this.getSimulations.executeQuery();
            do {
                if (!newSimulations.next()) {
                    this.serializedConnection.createStatement().execute("COMMIT;");
                    return null;
                }
                this.currentSimulationId = newSimulations.getInt("id");
            } while (this.blackList.contains(new Integer(this.currentSimulationId)));
            this.assignSimulation.setInt(1, this.currentSimulationId);
            this.assignSimulation.execute();
            this.serializedConnection.createStatement().execute("COMMIT;");
        }
        catch (SQLException e) {
            try {
                this.serializedConnection.createStatement().execute("ROLLBACK;");
            }
            catch (SQLException e1) {
                e1.printStackTrace();
                throw e1;
            }
            e.printStackTrace();
            throw e;
        }
        try {
            this.groupId = newSimulations.getInt("groupId");
            ResultSet group = this.relaxedConnection.createStatement().executeQuery("SELECT studyId FROM groups WHERE id = '" + this.groupId + "';");
            group.next();
            int studyId = group.getInt("studyId");
            ResultSet template = this.relaxedConnection.createStatement().executeQuery("SELECT * FROM studies WHERE id = '" + studyId + "';");
            if (!this.readPackages()) {
                int oldId = this.currentSimulationId;
                this.blackList.add(new Integer(oldId));
                System.out.println("rejected simulation " + this.currentSimulationId + ": undefined packages");
                Simulation sim = this.query(p);
                this.relaxedConnection.createStatement().executeUpdate("UPDATE simulations SET assigned = NULL WHERE id = " + oldId + ";");
                return sim;
            }
            this.readFilesFromDB();
            this.numStdOutChunks = 0;
            ResultSet params = this.relaxedConnection.createStatement().executeQuery("SELECT * FROM params WHERE simulationId = '" + this.currentSimulationId + "';");
            this.resultsConnection.createStatement().execute("INSERT IGNORE INTO progress VALUES ('" + this.currentSimulationId + "', 'RUNNING', NOW(), NULL, '0');");
            return new Simulation(template, params, p, this.currentSimulationId, this);
        }
        catch (SQLException e) {
            try {
                this.relaxedConnection.createStatement().execute("UPDATE simulations SET assigned = NULL WHERE id = " + this.currentSimulationId + ";");
            }
            catch (SQLException e1) {
                e1.printStackTrace();
                throw e1;
            }
            e.printStackTrace();
            throw e;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void jobFinished() throws SQLException {
        this.checkConnection(this.resultsConnection);
        this.resultsConnection.createStatement().execute("UPDATE progress SET state='FINISHED', expectedEnd=NOW(), percentageDone='100' WHERE simulationId=" + this.currentSimulationId + ";");
        this.writeFilesToDB();
        this.cleanup();
    }

    private void checkConnection(Connection c) throws SQLException {
        try {
            c.createStatement().execute("SHOW STATUS;");
        }
        catch (SQLException e) {
            this.initConnections();
        }
    }

    public void jobCanceled() throws SQLException {
        this.checkConnection(this.resultsConnection);
        this.resultsConnection.createStatement().execute("UPDATE progress SET state='CANCELED', expectedEnd=NULL WHERE simulationId=" + this.currentSimulationId + ";");
        this.writeFilesToDB();
        this.cleanup();
    }

    public void jobRepeated() throws SQLException {
        this.checkConnection(this.resultsConnection);
        this.resultsConnection.createStatement().execute("UPDATE progress SET started=NOW(), percentageDone='0', expectedEnd=NULL WHERE simulationId=" + this.currentSimulationId + ";");
        this.deleteStdOutFromDB();
        this.deleteStdErrFromDB();
        this.cleanup();
        this.deleteResultFiles();
        this.checkConnection(this.relaxedConnection);
        this.readFilesFromDB();
        this.readPackages();
    }

    private void cleanup() {
        Iterator i = this.inFiles.iterator();
        while (i.hasNext()) {
            new File((String)i.next()).delete();
        }
        this.inFiles.clear();
        i = this.packages.iterator();
        while (i.hasNext()) {
            ((Package)i.next()).delete();
        }
        this.packages.clear();
    }

    private void deleteStdOutFromDB() throws SQLException {
        this.resultsConnection.createStatement().execute("DELETE FROM stdout WHERE simulationId=" + this.currentSimulationId + ";");
    }

    private void deleteStdErrFromDB() throws SQLException {
        this.resultsConnection.createStatement().execute("DELETE FROM stderr WHERE simulationId=" + this.currentSimulationId + ";");
    }
}

