/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.wrapper;

import brn.distsim.wrapper.DBConnector;
import brn.distsim.wrapper.MainMXBean;
import brn.distsim.wrapper.RemoteSimulation;
import brn.distsim.wrapper.Simulation;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class Main
extends UnicastRemoteObject
implements RemoteSimulation,
MainMXBean {
    private static final long serialVersionUID = -6135718335012679320L;
    public static final String JMX_NAME = "brn.distsim.jmx:type=Wrapper";
    private static JMXConnectorServer connectorServer = null;
    private DBConnector connector;
    private Properties configuration = new Properties();
    private Random random;
    private final int delay = 10000;
    private Simulation simulation;
    private boolean stop;
    private boolean pause;
    private Thread runThread;

    protected Main() throws IOException {
        this.configuration.load(System.in);
        this.random = new Random();
        this.stop = false;
        this.pause = false;
    }

    private void prepareConnector() {
        while (!this.stop) {
            try {
                this.connector = new DBConnector(this.getConfig());
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    Thread.sleep(this.random.nextInt(10000));
                    continue;
                }
                catch (InterruptedException e2) {
                    if (!this.stop) continue;
                }
            }
            break;
        }
    }

    public static void main(String[] args) throws IOException {
        Main main = new Main();
        if (!Main.registerJmx(main, args.length == 0 ? null : args[0])) {
            System.exit(1);
        }
        main.run();
        Main.unregisterJmx();
        System.exit(0);
    }

    private static boolean registerJmx(Main main, String url) {
        if (url == null || !url.trim().startsWith("service:jmx:")) {
            return true;
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(url), null, server);
            connectorServer.start();
            ObjectName name = new ObjectName(JMX_NAME);
            server.registerMBean(main, name);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
        return true;
    }

    private static void unregisterJmx() {
        if (null == connectorServer) {
            return;
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName(JMX_NAME);
            if (server.isRegistered(name)) {
                server.unregisterMBean(name);
            }
            connectorServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static boolean registerRmiRegistry(Main main) {
        Registry registry;
        try {
            registry = LocateRegistry.createRegistry(1099);
        }
        catch (RemoteException e) {
            try {
                registry = LocateRegistry.getRegistry(1099);
            }
            catch (RemoteException e1) {
                System.err.println("couldn't create registry");
                return false;
            }
        }
        try {
            registry.rebind("host" + main.getId(), main);
        }
        catch (RemoteException e) {
            System.err.println("could not bind rmi name (" + e.getMessage() + ")");
        }
        return true;
    }

    protected static void unregisterRmiRegistry(Main main) {
        try {
            Registry registry = LocateRegistry.getRegistry(1099);
            registry.unbind("host" + main.getId());
        }
        catch (RemoteException e) {
        }
        catch (NotBoundException notBoundException) {
            // empty catch block
        }
    }

    public void run() throws IOException {
        this.runThread = Thread.currentThread();
        Properties jobConfig = new Properties();
        while (!this.stop) {
            try {
                try {
                    Thread.sleep(this.random.nextInt(10000));
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.stop) {
                    return;
                }
                if (null == this.connector) {
                    this.prepareConnector();
                }
                if (this.pause) continue;
                if (this.stop) {
                    return;
                }
                this.simulation = this.connector.query(jobConfig);
                if (this.simulation == null) continue;
                jobConfig.putAll((Map<?, ?>)this.configuration);
                if (this.simulation.execute(jobConfig)) {
                    System.out.println("simulation finished");
                    this.connector.jobFinished();
                } else {
                    System.out.println("simulation canceled");
                    this.connector.jobCanceled();
                }
                jobConfig.clear();
                this.simulation = null;
            }
            catch (SQLException e) {
                this.prepareConnector();
            }
        }
    }

    public int getId() {
        return Integer.parseInt(this.configuration.getProperty("host.id").trim());
    }

    public String getDescription() {
        return this.configuration.getProperty("host.description").trim();
    }

    public String getArchitecture() {
        return this.configuration.getProperty("host.architecture").trim();
    }

    public boolean cancel() {
        if (this.simulation != null) {
            this.simulation.destroy();
        }
        return true;
    }

    public boolean stop() {
        this.stop = true;
        if (this.simulation != null) {
            this.simulation.destroy();
        }
        System.out.println("stopping");
        this.runThread.interrupt();
        return true;
    }

    public boolean stopLater() {
        this.stop = true;
        return true;
    }

    public String getName() {
        return this.configuration.getProperty("host.name").trim();
    }

    public boolean cancelSim() {
        return this.cancel();
    }

    public void continueSim() {
        this.pause = false;
    }

    public void pauseSim() {
        this.pause = true;
    }

    public String getCurrentSimulation() {
        return this.simulation == null ? "None" : this.simulation.toString();
    }

    public void changeDatabase(String dbHost, String dbName, String dbUser, String dbPasswd, String dbResHost, String dbResName, String dbResUser, String dbResPasswd) {
        this.configuration.setProperty("definitions.host", dbHost);
        this.configuration.setProperty("definitions.database", dbName);
        this.configuration.setProperty("definitions.username", dbUser);
        this.configuration.setProperty("definitions.password", dbPasswd);
        this.configuration.setProperty("results.host", dbResHost);
        this.configuration.setProperty("results.database", dbResName);
        this.configuration.setProperty("results.username", dbResUser);
        this.configuration.setProperty("results.password", dbResPasswd);
        this.connector = null;
    }

    public ConfigData getConfig() {
        return new ConfigData(this.configuration.getProperty("definitions.host").trim(), this.configuration.getProperty("definitions.database").trim(), this.configuration.getProperty("definitions.username").trim(), this.configuration.getProperty("definitions.password").trim(), this.configuration.getProperty("results.host").trim(), this.configuration.getProperty("results.database").trim(), this.configuration.getProperty("results.username").trim(), this.configuration.getProperty("results.password").trim(), Integer.parseInt(this.configuration.getProperty("host.id")), this.configuration.getProperty("host.description").trim(), this.configuration.getProperty("host.architecture").trim(), this.configuration.getProperty("host.name").trim());
    }

    public static class ConfigData {
        private String definitionsHost;
        private String definitionsDatabase;
        private String definitionsUsername;
        private String definitionsPassword;
        private String resultsHost;
        private String resultsDatabase;
        private String resultsUsername;
        private String resultsPassword;
        private int hostIdJ;
        private String hostDescription;
        private String hostArchitecture;
        private String hostName;

        public ConfigData() {
        }

        public ConfigData(String definitionsHost, String definitionsDatabase, String definitionsUsername, String definitionsPassword, String resultsHost, String resultsDatabase, String resultsUsername, String resultsPassword, int hostIdJ, String hostDescription, String hostArchitecture, String hostName) {
            this.definitionsHost = definitionsHost;
            this.definitionsDatabase = definitionsDatabase;
            this.definitionsUsername = definitionsUsername;
            this.definitionsPassword = definitionsPassword;
            this.resultsHost = resultsHost;
            this.resultsDatabase = resultsDatabase;
            this.resultsUsername = resultsUsername;
            this.resultsPassword = resultsPassword;
            this.hostIdJ = hostIdJ;
            this.hostDescription = hostDescription;
            this.hostArchitecture = hostArchitecture;
            this.hostName = hostName;
        }

        public String getDefinitionsHost() {
            return this.definitionsHost;
        }

        public String getDefinitionsDatabase() {
            return this.definitionsDatabase;
        }

        public String getDefinitionsUsername() {
            return this.definitionsUsername;
        }

        public String getDefinitionsPassword() {
            return this.definitionsPassword;
        }

        public String getResultsHost() {
            return this.resultsHost;
        }

        public String getResultsDatabase() {
            return this.resultsDatabase;
        }

        public String getResultsUsername() {
            return this.resultsUsername;
        }

        public String getResultsPassword() {
            return this.resultsPassword;
        }

        public int getHostIdJ() {
            return this.hostIdJ;
        }

        public String getHostDescription() {
            return this.hostDescription;
        }

        public String getHostArchitecture() {
            return this.hostArchitecture;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setDefinitionsHost(String definitionsHost) {
            this.definitionsHost = definitionsHost;
        }

        public void setDefinitionsDatabase(String definitionsDatabase) {
            this.definitionsDatabase = definitionsDatabase;
        }

        public void setDefinitionsUsername(String definitionsUsername) {
            this.definitionsUsername = definitionsUsername;
        }

        public void setDefinitionsPassword(String definitionsPassword) {
            this.definitionsPassword = definitionsPassword;
        }

        public void setResultsHost(String resultsHost) {
            this.resultsHost = resultsHost;
        }

        public void setResultsDatabase(String resultsDatabase) {
            this.resultsDatabase = resultsDatabase;
        }

        public void setResultsUsername(String resultsUsername) {
            this.resultsUsername = resultsUsername;
        }

        public void setResultsPassword(String resultsPassword) {
            this.resultsPassword = resultsPassword;
        }

        public void setHostIdJ(int hostIdJ) {
            this.hostIdJ = hostIdJ;
        }

        public void setHostDescription(String hostDescription) {
            this.hostDescription = hostDescription;
        }

        public void setHostArchitecture(String hostArchitecture) {
            this.hostArchitecture = hostArchitecture;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }
    }
}

