/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.wrapper;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Package {
    private String url;
    private String localPath;
    private File outFile;

    public Package(String url, String localPath) {
        this.url = url;
        this.localPath = localPath;
    }

    public void download() {
        try {
            File dir = new File(this.localPath);
            dir.mkdirs();
            URL inUrl = new URL(this.url);
            String fileName = new File(inUrl.getFile()).getName();
            this.outFile = new File(String.valueOf(this.localPath) + "/" + fileName);
            FileOutputStream out = new FileOutputStream(this.outFile);
            InputStream in = inUrl.openStream();
            int read = 0;
            byte[] data = new byte[1024];
            while ((read = in.read(data)) > 0) {
                ((OutputStream)out).write(data, 0, read);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void unzip() {
        try {
            System.out.println("unzipping package " + this.url + " at " + this.localPath);
            ZipFile zipFile = new ZipFile(this.outFile, 1);
            Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
            while (zipFileEntries.hasMoreElements()) {
                int currentByte;
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(this.localPath, currentEntry);
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] data = new byte[1024];
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 1024);
                while ((currentByte = is.read(data, 0, 1024)) != -1) {
                    dest.write(data, 0, currentByte);
                }
                dest.flush();
                dest.close();
                is.close();
            }
            zipFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void delete() {
        File dir = new File(this.localPath);
        this.deleteDir(dir);
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }
}

