/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.wrapper;

import brn.distsim.wrapper.DBConnector;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class Simulation {
    private static final long serialVersionUID = 4941091157101209595L;
    private static final int REPEAT_SIMULATION = 42;
    private String commandLine;
    private boolean success = true;
    private Process simulation;
    private DBConnector db;
    private int id;

    public Simulation(ResultSet template, ResultSet params, Properties p, int id, DBConnector db) throws RemoteException {
        try {
            this.db = db;
            this.id = id;
            p.put("simulationId", "" + id);
            if (template.next()) {
                this.commandLine = template.getString("command");
                while (params.next()) {
                    String name = params.getString("name");
                    String val = params.getString("value");
                    this.commandLine = this.commandLine.replaceAll("\\$" + name + "\\$", val);
                    p.put(name, val);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean execute(Properties input) throws SQLException {
        try {
            int returnValue;
            while (true) {
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    this.commandLine = this.commandLine.replaceAll("ant", "ant.bat");
                }
                System.out.println("new simulation " + this.id + ": " + this.commandLine);
                this.simulation = Runtime.getRuntime().exec(this.commandLine);
                input.store(this.simulation.getOutputStream(), null);
                this.simulation.getOutputStream().close();
                this.db.writeStdOutToDB(this.simulation.getInputStream());
                this.db.writeStdErrToDB(this.simulation.getErrorStream());
                returnValue = this.simulation.waitFor();
                if (returnValue != 42) break;
                System.out.println("repeating simulation");
                this.db.jobRepeated();
            }
            if (returnValue == 0) {
                System.out.println("simulation successful");
            } else {
                this.success = false;
                System.out.println("simulation failed. return value: " + returnValue);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.success = false;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.success = false;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            this.success = false;
        }
        return this.success;
    }

    public void destroy() {
        this.success = false;
        if (this.simulation != null) {
            this.simulation.destroy();
        }
    }

    public String toString() {
        return "Simulation(id=" + this.id + ",db=" + this.db.toString() + ")";
    }
}

