/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.MysqlParameterMetadata;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.ResultSetMetaData;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.TimeUtil;
import com.mysql.jdbc.profiler.ProfileEventSink;
import com.mysql.jdbc.profiler.ProfilerEvent;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ServerPreparedStatement
extends PreparedStatement {
    protected static final int BLOB_STREAM_READ_BUF_SIZE = 8192;
    private static final byte MAX_DATE_REP_LENGTH = 5;
    private static final byte MAX_DATETIME_REP_LENGTH = 12;
    private static final byte MAX_TIME_REP_LENGTH = 13;
    private Calendar dateTimeBindingCal;
    private boolean detectedLongParameterSwitch;
    private int fieldCount;
    private boolean invalid;
    private SQLException invalidationException;
    private boolean isSelectQuery;
    private Buffer outByteBuffer;
    private BindValue[] parameterBindings;
    private Field[] parameterFields;
    private Field[] resultFields;
    private boolean sendTypesToServer;
    private long serverStatementId;
    private int stringTypeCode;
    private boolean serverNeedsResetBeforeEachExecution;
    protected boolean isCached;

    private static final void storeTime(Buffer intoBuf, Time tm) throws SQLException {
        intoBuf.ensureCapacity(9);
        intoBuf.writeByte((byte)8);
        intoBuf.writeByte((byte)0);
        intoBuf.writeLong(0L);
        Calendar cal = Calendar.getInstance();
        cal.setTime(tm);
        intoBuf.writeByte((byte)cal.get(11));
        intoBuf.writeByte((byte)cal.get(12));
        intoBuf.writeByte((byte)cal.get(13));
    }

    public synchronized void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        this.batchedArgs.add(new BatchedBindValues(this.parameterBindings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String asSql(boolean quoteStreamsAndUnknowns) throws SQLException {
        String string;
        block17: {
            PreparedStatement pStmtForSub = null;
            try {
                pStmtForSub = new PreparedStatement(this.connection, this.originalSql, this.currentCatalog);
                int numParameters = pStmtForSub.parameterCount;
                int ourNumParameters = this.parameterCount;
                int i = 0;
                while (i < numParameters && i < ourNumParameters) {
                    if (this.parameterBindings[i] != null) {
                        if (this.parameterBindings[i].isNull) {
                            pStmtForSub.setNull(i + 1, 0);
                        } else {
                            BindValue bindValue = this.parameterBindings[i];
                            switch (bindValue.bufferType) {
                                case 1: {
                                    pStmtForSub.setByte(i + 1, bindValue.byteBinding);
                                    break;
                                }
                                case 2: {
                                    pStmtForSub.setShort(i + 1, bindValue.shortBinding);
                                    break;
                                }
                                case 3: {
                                    pStmtForSub.setInt(i + 1, bindValue.intBinding);
                                    break;
                                }
                                case 8: {
                                    pStmtForSub.setLong(i + 1, bindValue.longBinding);
                                    break;
                                }
                                case 4: {
                                    pStmtForSub.setFloat(i + 1, bindValue.floatBinding);
                                    break;
                                }
                                case 5: {
                                    pStmtForSub.setDouble(i + 1, bindValue.doubleBinding);
                                    break;
                                }
                                default: {
                                    pStmtForSub.setObject(i + 1, this.parameterBindings[i].value);
                                    break;
                                }
                            }
                        }
                    }
                    ++i;
                }
                string = pStmtForSub.asSql(quoteStreamsAndUnknowns);
                Object var4_8 = null;
                if (pStmtForSub == null) break block17;
            }
            catch (Throwable throwable) {
                block18: {
                    Object var4_9 = null;
                    if (pStmtForSub == null) break block18;
                    try {
                        pStmtForSub.close();
                    }
                    catch (SQLException sqlEx) {}
                }
                throw throwable;
            }
            try {
                pStmtForSub.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        return string;
    }

    protected void checkClosed() throws SQLException {
        if (this.invalid) {
            throw this.invalidationException;
        }
        super.checkClosed();
    }

    public void clearParameters() throws SQLException {
        this.clearParametersInternal(true);
    }

    private final void clearParametersInternal(boolean clearServerParameters) throws SQLException {
        boolean hadLongData = false;
        if (this.parameterBindings != null) {
            int i = 0;
            while (i < this.parameterCount) {
                if (this.parameterBindings[i] != null && this.parameterBindings[i].isLongData) {
                    hadLongData = true;
                }
                this.parameterBindings[i].reset();
                ++i;
            }
        }
        if (clearServerParameters && hadLongData) {
            this.serverResetStatement();
            this.detectedLongParameterSwitch = false;
        }
    }

    protected void setClosed(boolean flag) {
        this.isClosed = flag;
    }

    public void close() throws SQLException {
        if (this.isCached) {
            this.isClosed = true;
            this.connection.recachePreparedStatement(this);
            return;
        }
        this.realClose(true);
    }

    private final void dumpCloseForTestcase() {
        StringBuffer buf = new StringBuffer();
        this.connection.generateConnectionCommentBlock(buf);
        buf.append("DEALLOCATE PREPARE debug_stmt_");
        buf.append(this.statementId);
        buf.append(";\n");
        this.connection.dumpTestcaseQuery(buf.toString());
    }

    private final void dumpExecuteForTestcase() throws SQLException {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.parameterCount) {
            this.connection.generateConnectionCommentBlock(buf);
            buf.append("SET @debug_stmt_param");
            buf.append(this.statementId);
            buf.append("_");
            buf.append(i);
            buf.append("=");
            if (this.parameterBindings[i].isNull) {
                buf.append("NULL");
            } else {
                buf.append(this.parameterBindings[i].toString(true));
            }
            buf.append(";\n");
            ++i;
        }
        this.connection.generateConnectionCommentBlock(buf);
        buf.append("EXECUTE debug_stmt_");
        buf.append(this.statementId);
        if (this.parameterCount > 0) {
            buf.append(" USING ");
            i = 0;
            while (i < this.parameterCount) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append("@debug_stmt_param");
                buf.append(this.statementId);
                buf.append("_");
                buf.append(i);
                ++i;
            }
        }
        buf.append(";\n");
        this.connection.dumpTestcaseQuery(buf.toString());
    }

    private final void dumpPrepareForTestcase() throws SQLException {
        StringBuffer buf = new StringBuffer(this.originalSql.length() + 64);
        this.connection.generateConnectionCommentBlock(buf);
        buf.append("PREPARE debug_stmt_");
        buf.append(this.statementId);
        buf.append(" FROM \"");
        buf.append(this.originalSql);
        buf.append("\";\n");
        this.connection.dumpTestcaseQuery(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int[] executeBatch() throws SQLException {
        if (this.connection.isReadOnly()) {
            throw new SQLException(Messages.getString("ServerPreparedStatement.2") + Messages.getString("ServerPreparedStatement.3"), "S1009");
        }
        this.checkClosed();
        Object object = this.connection.getMutex();
        synchronized (object) {
            this.clearWarnings();
            BindValue[] oldBindValues = this.parameterBindings;
            try {
                int[] updateCounts = null;
                if (this.batchedArgs != null) {
                    int nbrCommands = this.batchedArgs.size();
                    updateCounts = new int[nbrCommands];
                    if (this.retrieveGeneratedKeys) {
                        this.batchedGeneratedKeys = new ArrayList(nbrCommands);
                    }
                    int i = 0;
                    while (true) {
                        if (i >= nbrCommands) break;
                        updateCounts[i] = -3;
                        ++i;
                    }
                    Throwable sqlEx = null;
                    int commandIndex = 0;
                    BindValue[] previousBindValuesForBatch = null;
                    commandIndex = 0;
                    while (true) {
                        block27: {
                            if (commandIndex >= nbrCommands) {
                                if (sqlEx == null) break;
                                throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                            }
                            Object arg = this.batchedArgs.get(commandIndex);
                            if (arg instanceof String) {
                                updateCounts[commandIndex] = this.executeUpdate((String)arg);
                            } else {
                                this.parameterBindings = ((BatchedBindValues)arg).batchedParameterValues;
                                try {
                                    Object var19_15;
                                    java.sql.ResultSet rs;
                                    Object var15_13;
                                    if (previousBindValuesForBatch != null) {
                                        int j = 0;
                                        while (j < this.parameterBindings.length) {
                                            if (this.parameterBindings[j].bufferType != previousBindValuesForBatch[j].bufferType) {
                                                this.sendTypesToServer = true;
                                                break;
                                            }
                                            ++j;
                                        }
                                    }
                                    try {
                                        updateCounts[commandIndex] = this.executeUpdate(false);
                                    }
                                    catch (Throwable j) {
                                        var15_13 = null;
                                        previousBindValuesForBatch = this.parameterBindings;
                                        throw j;
                                    }
                                    {
                                        var15_13 = null;
                                        previousBindValuesForBatch = this.parameterBindings;
                                        if (!this.retrieveGeneratedKeys) break block27;
                                        rs = null;
                                    }
                                    try {
                                        rs = this.getGeneratedKeysInternal();
                                        while (rs.next()) {
                                            this.batchedGeneratedKeys.add(new byte[][]{rs.getBytes(1)});
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var19_15 = null;
                                        if (rs == null) throw throwable;
                                        rs.close();
                                        throw throwable;
                                    }
                                    {
                                        var19_15 = null;
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                }
                                catch (SQLException ex) {
                                    updateCounts[commandIndex] = -3;
                                    if (!this.connection.getContinueBatchOnError()) {
                                        int[] newUpdateCounts = new int[commandIndex];
                                        System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                                        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                                    }
                                    sqlEx = ex;
                                }
                            }
                        }
                        ++commandIndex;
                    }
                }
                int[] nArray = updateCounts != null ? updateCounts : new int[]{};
                Object var6_18 = null;
                this.parameterBindings = oldBindValues;
                this.sendTypesToServer = true;
                this.clearBatch();
                return nArray;
            }
            catch (Throwable throwable) {
                Object var6_19 = null;
                this.parameterBindings = oldBindValues;
                this.sendTypesToServer = true;
                this.clearBatch();
                throw throwable;
            }
        }
    }

    protected ResultSet executeInternal(int maxRowsToRetrieve, Buffer sendPacket, boolean createStreamingResultSet, boolean queryIsSelectOnly, boolean unpackFields) throws SQLException {
        ++this.numberOfExecutions;
        try {
            return this.serverExecute(maxRowsToRetrieve, createStreamingResultSet);
        }
        catch (SQLException sqlEx) {
            if (this.connection.getEnablePacketDebug()) {
                this.connection.getIO().dumpPacketRingBuffer();
            }
            if (this.connection.getDumpQueriesOnException()) {
                String extractedSql = this.toString();
                StringBuffer messageBuf = new StringBuffer(extractedSql.length() + 32);
                messageBuf.append("\n\nQuery being executed when exception was thrown:\n\n");
                messageBuf.append(extractedSql);
                sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
            }
            throw sqlEx;
        }
        catch (Exception ex) {
            if (this.connection.getEnablePacketDebug()) {
                this.connection.getIO().dumpPacketRingBuffer();
            }
            SQLException sqlEx = new SQLException(ex.toString(), "S1000");
            if (this.connection.getDumpQueriesOnException()) {
                String extractedSql = this.toString();
                StringBuffer messageBuf = new StringBuffer(extractedSql.length() + 32);
                messageBuf.append("\n\nQuery being executed when exception was thrown:\n\n");
                messageBuf.append(extractedSql);
                sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
            }
            throw sqlEx;
        }
    }

    protected Buffer fillSendPacket() throws SQLException {
        return null;
    }

    protected Buffer fillSendPacket(byte[][] batchedParameterStrings, InputStream[] batchedParameterStreams, boolean[] batchedIsStream, int[] batchedStreamLengths) throws SQLException {
        return null;
    }

    private final BindValue getBinding(int parameterIndex, boolean forLongData) throws SQLException {
        this.checkClosed();
        if (this.parameterBindings.length == 0) {
            throw new SQLException(Messages.getString("ServerPreparedStatement.8"), "S1009");
        }
        if (--parameterIndex < 0 || parameterIndex >= this.parameterBindings.length) {
            throw new SQLException(Messages.getString("ServerPreparedStatement.9") + (parameterIndex + 1) + Messages.getString("ServerPreparedStatement.10") + this.parameterBindings.length, "S1009");
        }
        if (this.parameterBindings[parameterIndex] == null) {
            this.parameterBindings[parameterIndex] = new BindValue();
        } else if (this.parameterBindings[parameterIndex].isLongData && !forLongData) {
            this.detectedLongParameterSwitch = true;
        }
        this.parameterBindings[parameterIndex].isSet = true;
        this.parameterBindings[parameterIndex].boundBeforeExecutionNum = this.numberOfExecutions;
        return this.parameterBindings[parameterIndex];
    }

    synchronized byte[] getBytes(int parameterIndex) throws SQLException {
        BindValue bindValue = this.getBinding(parameterIndex, false);
        if (bindValue.isNull) {
            return null;
        }
        if (bindValue.isLongData) {
            throw new NotImplemented();
        }
        if (this.outByteBuffer == null) {
            this.outByteBuffer = Buffer.allocateNew(this.connection.getNetBufferLength(), false);
        }
        this.outByteBuffer.clear();
        int originalPosition = this.outByteBuffer.getPosition();
        this.storeBinding(this.outByteBuffer, bindValue, this.connection.getIO());
        int newPosition = this.outByteBuffer.getPosition();
        int length = newPosition - originalPosition;
        byte[] valueAsBytes = new byte[length];
        System.arraycopy(this.outByteBuffer.getByteBuffer(), originalPosition, valueAsBytes, 0, length);
        return valueAsBytes;
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.resultFields == null) {
            return null;
        }
        return new ResultSetMetaData(this.resultFields);
    }

    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.parameterMetaData == null) {
            this.parameterMetaData = new MysqlParameterMetadata(this.parameterFields, this.parameterCount);
        }
        return this.parameterMetaData;
    }

    boolean isNull(int paramIndex) {
        throw new IllegalArgumentException(Messages.getString("ServerPreparedStatement.7"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void realClose(boolean calledExplicitly) throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.connection != null && this.connection.getAutoGenerateTestcaseScript()) {
            this.dumpCloseForTestcase();
        }
        Object object = this.connection.getMutex();
        synchronized (object) {
            SQLException exceptionDuringClose = null;
            if (calledExplicitly) {
                try {
                    MysqlIO mysql = this.connection.getIO();
                    Buffer packet = mysql.getSharedSendPacket();
                    packet.writeByte((byte)25);
                    packet.writeLong(this.serverStatementId);
                    mysql.sendCommand(25, null, packet, true, null);
                }
                catch (SQLException sqlEx) {
                    exceptionDuringClose = sqlEx;
                }
            }
            super.realClose(calledExplicitly);
            this.clearParametersInternal(false);
            this.parameterBindings = null;
            this.parameterFields = null;
            this.resultFields = null;
            if (exceptionDuringClose != null) {
                throw exceptionDuringClose;
            }
            return;
        }
    }

    protected void rePrepare() throws SQLException {
        this.invalidationException = null;
        try {
            this.serverPrepare(this.originalSql);
        }
        catch (SQLException sqlEx) {
            this.invalidationException = sqlEx;
        }
        catch (Exception ex) {
            this.invalidationException = new SQLException(ex.toString(), "S1000");
        }
        if (this.invalidationException != null) {
            this.invalid = true;
            this.parameterBindings = null;
            this.parameterFields = null;
            this.resultFields = null;
            if (this.results != null) {
                try {
                    this.results.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.connection != null) {
                if (this.maxRowsChanged) {
                    this.connection.unsetMaxRows(this);
                }
                if (!this.connection.getDontTrackOpenResources()) {
                    this.connection.unregisterStatement(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ResultSet serverExecute(int maxRowsToRetrieve, boolean createStreamingResultSet) throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            int i;
            block27: {
                if (!this.detectedLongParameterSwitch) break block27;
                boolean firstFound = false;
                long boundTimeToCheck = 0L;
                int i2 = 0;
                while (true) {
                    if (i2 >= this.parameterCount - 1) {
                        this.serverResetStatement();
                        break;
                    }
                    if (this.parameterBindings[i2].isLongData) {
                        if (firstFound && boundTimeToCheck != this.parameterBindings[i2].boundBeforeExecutionNum) {
                            throw new SQLException(Messages.getString("ServerPreparedStatement.11") + Messages.getString("ServerPreparedStatement.12"), "S1C00");
                        }
                        firstFound = true;
                        boundTimeToCheck = this.parameterBindings[i2].boundBeforeExecutionNum;
                    }
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < this.parameterCount) {
                if (!this.parameterBindings[i3].isSet) {
                    throw new SQLException(Messages.getString("ServerPreparedStatement.13") + (i3 + 1) + Messages.getString("ServerPreparedStatement.14"), "S1009");
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < this.parameterCount) {
                if (this.parameterBindings[i3].isLongData) {
                    this.serverLongData(i3, this.parameterBindings[i3]);
                }
                ++i3;
            }
            if (this.connection.getAutoGenerateTestcaseScript()) {
                this.dumpExecuteForTestcase();
            }
            MysqlIO mysql = this.connection.getIO();
            Buffer packet = mysql.getSharedSendPacket();
            packet.clear();
            packet.writeByte((byte)23);
            packet.writeLong(this.serverStatementId);
            if (this.connection.versionMeetsMinimum(4, 1, 2)) {
                packet.writeByte((byte)0);
                packet.writeLong(1L);
            }
            int nullCount = (this.parameterCount + 7) / 8;
            int nullBitsPosition = packet.getPosition();
            int i4 = 0;
            while (i4 < nullCount) {
                packet.writeByte((byte)0);
                ++i4;
            }
            byte[] nullBitsBuffer = new byte[nullCount];
            packet.writeByte((byte)(this.sendTypesToServer ? 1 : 0));
            if (this.sendTypesToServer) {
                i = 0;
                while (i < this.parameterCount) {
                    packet.writeInt(this.parameterBindings[i].bufferType);
                    ++i;
                }
            }
            i = 0;
            while (i < this.parameterCount) {
                if (!this.parameterBindings[i].isLongData) {
                    if (!this.parameterBindings[i].isNull) {
                        this.storeBinding(packet, this.parameterBindings[i], mysql);
                    } else {
                        int n = i / 8;
                        nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << (i & 7));
                    }
                }
                ++i;
            }
            int endPosition = packet.getPosition();
            packet.setPosition(nullBitsPosition);
            packet.writeBytesNoNull(nullBitsBuffer);
            packet.setPosition(endPosition);
            long begin = 0L;
            if (this.connection.getProfileSql() || this.connection.getLogSlowQueries() || this.connection.getGatherPerformanceMetrics()) {
                begin = System.currentTimeMillis();
            }
            Buffer resultPacket = mysql.sendCommand(23, null, packet, false, null);
            this.connection.incrementNumberOfPreparedExecutes();
            if (this.connection.getProfileSql()) {
                this.eventSink = ProfileEventSink.getInstance(this.connection);
                this.eventSink.consumeEvent(new ProfilerEvent(4, "", this.currentCatalog, this.connection.getId(), this.statementId, -1, System.currentTimeMillis(), (int)(System.currentTimeMillis() - begin), null, new Throwable(), null));
            }
            ResultSet rs = mysql.readAllResults(this, maxRowsToRetrieve, this.resultSetType, this.resultSetConcurrency, createStreamingResultSet, this.currentCatalog, resultPacket, true, this.fieldCount, true);
            if (!createStreamingResultSet && this.serverNeedsResetBeforeEachExecution) {
                this.serverResetStatement();
            }
            this.sendTypesToServer = false;
            this.results = rs;
            if (this.connection.getLogSlowQueries() || this.connection.getGatherPerformanceMetrics()) {
                long elapsedTime = System.currentTimeMillis() - begin;
                if (this.connection.getLogSlowQueries() && elapsedTime > (long)this.connection.getSlowQueryThresholdMillis()) {
                    StringBuffer mesgBuf = new StringBuffer(48 + this.originalSql.length());
                    mesgBuf.append(Messages.getString("ServerPreparedStatement.15"));
                    mesgBuf.append(this.connection.getSlowQueryThresholdMillis());
                    mesgBuf.append(Messages.getString("ServerPreparedStatement.16"));
                    mesgBuf.append(this.originalSql);
                    this.connection.getLog().logWarn(mesgBuf.toString());
                    if (this.connection.getExplainSlowQueries()) {
                        String queryAsString = this.asSql(true);
                        mysql.explainSlowQuery(queryAsString.getBytes(), queryAsString);
                    }
                }
                if (this.connection.getGatherPerformanceMetrics()) {
                    this.connection.registerQueryExecutionTime(elapsedTime);
                }
            }
            return rs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void serverLongData(int parameterIndex, BindValue longData) throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            block9: {
                Object value;
                Buffer packet;
                MysqlIO mysql;
                block8: {
                    mysql = this.connection.getIO();
                    packet = mysql.getSharedSendPacket();
                    value = longData.value;
                    if (!(value instanceof byte[])) break block8;
                    packet.clear();
                    packet.writeByte((byte)24);
                    packet.writeLong(this.serverStatementId);
                    packet.writeInt(parameterIndex);
                    packet.writeBytesNoNull((byte[])longData.value);
                    mysql.sendCommand(24, null, packet, true, null);
                    break block9;
                }
                if (value instanceof InputStream) {
                    this.storeStream(mysql, parameterIndex, packet, (InputStream)value);
                } else if (value instanceof Blob) {
                    this.storeStream(mysql, parameterIndex, packet, ((Blob)value).getBinaryStream());
                } else {
                    if (!(value instanceof Reader)) {
                        throw new SQLException(Messages.getString("ServerPreparedStatement.18") + value.getClass().getName() + '\'', "S1009");
                    }
                    this.storeReader(mysql, parameterIndex, packet, (Reader)value);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void serverPrepare(String sql) throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            MysqlIO mysql = this.connection.getIO();
            if (this.connection.getAutoGenerateTestcaseScript()) {
                this.dumpPrepareForTestcase();
            }
            try {
                try {
                    int i;
                    block21: {
                        Buffer metaDataPacket;
                        long begin = 0L;
                        this.isLoadDataQuery = StringUtils.startsWithIgnoreCaseAndWs(sql, "LOAD DATA");
                        if (this.connection.getProfileSql()) {
                            begin = System.currentTimeMillis();
                        }
                        String characterEncoding = null;
                        String connectionEncoding = this.connection.getEncoding();
                        if (!this.isLoadDataQuery && this.connection.getUseUnicode() && connectionEncoding != null) {
                            characterEncoding = connectionEncoding;
                        }
                        Buffer prepareResultPacket = mysql.sendCommand(22, sql, null, false, characterEncoding);
                        if (this.connection.versionMeetsMinimum(4, 1, 1)) {
                            prepareResultPacket.setPosition(1);
                        } else {
                            prepareResultPacket.setPosition(0);
                        }
                        this.serverStatementId = prepareResultPacket.readLong();
                        this.fieldCount = prepareResultPacket.readInt();
                        this.parameterCount = prepareResultPacket.readInt();
                        this.parameterBindings = new BindValue[this.parameterCount];
                        int i2 = 0;
                        while (true) {
                            if (i2 >= this.parameterCount) {
                                this.connection.incrementNumberOfPrepares();
                                if (this.connection.getProfileSql()) {
                                    this.eventSink = ProfileEventSink.getInstance(this.connection);
                                    this.eventSink.consumeEvent(new ProfilerEvent(2, "", this.currentCatalog, this.connection.getId(), this.statementId, -1, System.currentTimeMillis(), (int)(System.currentTimeMillis() - begin), null, new Throwable(), sql));
                                }
                                if (this.parameterCount > 0 && this.connection.versionMeetsMinimum(4, 1, 2) && !mysql.isVersion(5, 0, 0)) {
                                    this.parameterFields = new Field[this.parameterCount];
                                    metaDataPacket = mysql.readPacket();
                                    i = 0;
                                    break;
                                }
                                break block21;
                            }
                            this.parameterBindings[i2] = new BindValue();
                            ++i2;
                        }
                        while (!metaDataPacket.isLastDataPacket() && i < this.parameterCount) {
                            this.parameterFields[i++] = mysql.unpackField(metaDataPacket, false);
                            metaDataPacket = mysql.readPacket();
                        }
                    }
                    if (this.fieldCount > 0) {
                        this.resultFields = new Field[this.fieldCount];
                        Buffer fieldPacket = mysql.readPacket();
                        i = 0;
                        while (!fieldPacket.isLastDataPacket() && i < this.fieldCount) {
                            this.resultFields[i++] = mysql.unpackField(fieldPacket, false);
                            fieldPacket = mysql.readPacket();
                        }
                    }
                }
                catch (SQLException sqlEx) {
                    if (this.connection.getDumpQueriesOnException()) {
                        StringBuffer messageBuf = new StringBuffer(this.originalSql.length() + 32);
                        messageBuf.append("\n\nQuery being prepared when exception was thrown:\n\n");
                        messageBuf.append(this.originalSql);
                        sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
                    }
                    throw sqlEx;
                }
            }
            catch (Throwable throwable) {
                Object var6_16 = null;
                this.connection.getIO().clearInputStream();
                throw throwable;
            }
            {
                Object var6_17 = null;
                this.connection.getIO().clearInputStream();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void serverResetStatement() throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            MysqlIO mysql = this.connection.getIO();
            Buffer packet = mysql.getSharedSendPacket();
            packet.clear();
            packet.writeByte((byte)26);
            packet.writeLong(this.serverStatementId);
            try {
                try {
                    mysql.sendCommand(26, null, packet, this.connection.versionMeetsMinimum(4, 1, 2) ^ true, null);
                }
                catch (SQLException sqlEx) {
                    throw sqlEx;
                }
                catch (Exception ex) {
                    throw new SQLException(ex.toString(), "S1000");
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                mysql.clearInputStream();
                throw throwable;
            }
            {
                Object var6_8 = null;
                mysql.clearInputStream();
            }
            return;
        }
    }

    public void setArray(int i, Array x) throws SQLException {
        throw new NotImplemented();
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : (long)-1;
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.setString(parameterIndex, StringUtils.fixDecimalExponent(x.toString()));
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : (long)-1;
        }
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? x.length() : (long)-1;
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setByte(parameterIndex, (byte)(x ? 1 : 0));
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 1);
        binding.value = null;
        binding.byteBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 253);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkClosed();
        if (reader == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = reader;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : (long)-1;
        }
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x.getCharacterStream();
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? x.length() : (long)-1;
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 10);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        if (!this.connection.getAllowNanAndInf() && (x == Double.POSITIVE_INFINITY || x == Double.NEGATIVE_INFINITY || Double.isNaN(x))) {
            throw new SQLException("'" + x + "' is not a valid numeric or approximate numeric value", "S1009");
        }
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 5);
        binding.value = null;
        binding.doubleBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 4);
        binding.value = null;
        binding.floatBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 3);
        binding.value = null;
        binding.intBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 8);
        binding.value = null;
        binding.longBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        if (binding.bufferType == 0) {
            this.setType(binding, 6);
        }
        binding.value = null;
        binding.isNull = true;
        binding.isLongData = false;
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        if (binding.bufferType == 0) {
            this.setType(binding, 6);
        }
        binding.value = null;
        binding.isNull = true;
        binding.isLongData = false;
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw new NotImplemented();
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 2);
        binding.value = null;
        binding.shortBinding = x;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 1);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, this.stringTypeCode);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTimeInternal(parameterIndex, x, TimeZone.getDefault(), false);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTimeInternal(parameterIndex, x, cal.getTimeZone(), true);
    }

    public void setTimeInternal(int parameterIndex, Time x, TimeZone tz, boolean rollForward) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 92);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 11);
            binding.value = TimeUtil.changeTimezone(this.connection, x, tz, this.connection.getServerTimezoneTZ(), rollForward);
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestampInternal(parameterIndex, x, TimeZone.getDefault(), false);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestampInternal(parameterIndex, x, cal.getTimeZone(), true);
    }

    protected void setTimestampInternal(int parameterIndex, Timestamp x, TimeZone tz, boolean rollForward) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 12);
            binding.value = TimeUtil.changeTimezone(this.connection, x, tz, this.connection.getServerTimezoneTZ(), rollForward);
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    private final void setType(BindValue oldValue, int bufferType) {
        if (oldValue.bufferType != bufferType) {
            this.sendTypesToServer = true;
        }
        oldValue.bufferType = bufferType;
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        throw new NotImplemented();
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkClosed();
        this.setString(parameterIndex, x.toString());
    }

    private final void storeBinding(Buffer packet, BindValue bindValue, MysqlIO mysql) throws SQLException {
        try {
            Object value = bindValue.value;
            switch (bindValue.bufferType) {
                case 1: {
                    packet.writeByte(bindValue.byteBinding);
                    return;
                }
                case 2: {
                    packet.ensureCapacity(2);
                    packet.writeInt(bindValue.shortBinding);
                    return;
                }
                case 3: {
                    packet.ensureCapacity(4);
                    packet.writeLong(bindValue.intBinding);
                    return;
                }
                case 8: {
                    packet.ensureCapacity(8);
                    packet.writeLongLong(bindValue.longBinding);
                    return;
                }
                case 4: {
                    packet.ensureCapacity(4);
                    packet.writeFloat(bindValue.floatBinding);
                    return;
                }
                case 5: {
                    packet.ensureCapacity(8);
                    packet.writeDouble(bindValue.doubleBinding);
                    return;
                }
                case 11: {
                    ServerPreparedStatement.storeTime(packet, (Time)value);
                    return;
                }
                case 7: 
                case 10: 
                case 12: {
                    this.storeDateTime(packet, (java.util.Date)value, mysql);
                    return;
                }
                case 15: 
                case 253: 
                case 254: {
                    if (value instanceof byte[]) {
                        packet.writeLenBytes((byte[])value);
                    } else if (!this.isLoadDataQuery) {
                        packet.writeLenString((String)value, this.charEncoding, this.connection.getServerCharacterEncoding(), this.charConverter, this.connection.parserKnowsUnicode());
                    } else {
                        packet.writeLenBytes(((String)value).getBytes());
                    }
                    return;
                }
            }
        }
        catch (UnsupportedEncodingException uEE) {
            throw new SQLException(Messages.getString("ServerPreparedStatement.22") + this.connection.getEncoding() + '\'', "S1000");
        }
    }

    private final void storeDataTime412AndOlder(Buffer intoBuf, java.util.Date dt) throws SQLException {
        if (this.dateTimeBindingCal == null) {
            this.dateTimeBindingCal = Calendar.getInstance();
        }
        this.dateTimeBindingCal.setTime(dt);
        intoBuf.ensureCapacity(8);
        intoBuf.writeByte((byte)7);
        int year = this.dateTimeBindingCal.get(1);
        int month = this.dateTimeBindingCal.get(2) + 1;
        int date = this.dateTimeBindingCal.get(5);
        intoBuf.writeInt(year);
        intoBuf.writeByte((byte)month);
        intoBuf.writeByte((byte)date);
        if (dt instanceof Date) {
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
        } else {
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(11));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(12));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(13));
        }
    }

    private final void storeDateTime(Buffer intoBuf, java.util.Date dt, MysqlIO mysql) throws SQLException {
        if (this.connection.versionMeetsMinimum(4, 1, 3)) {
            this.storeDateTime413AndNewer(intoBuf, dt);
        } else {
            this.storeDataTime412AndOlder(intoBuf, dt);
        }
    }

    private final void storeDateTime413AndNewer(Buffer intoBuf, java.util.Date dt) throws SQLException {
        if (this.dateTimeBindingCal == null) {
            this.dateTimeBindingCal = Calendar.getInstance();
        }
        this.dateTimeBindingCal.setTime(dt);
        byte length = 7;
        intoBuf.ensureCapacity(length);
        if (dt instanceof Timestamp) {
            length = 11;
        }
        intoBuf.writeByte(length);
        int year = this.dateTimeBindingCal.get(1);
        int month = this.dateTimeBindingCal.get(2) + 1;
        int date = this.dateTimeBindingCal.get(5);
        intoBuf.writeInt(year);
        intoBuf.writeByte((byte)month);
        intoBuf.writeByte((byte)date);
        if (dt instanceof Date) {
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
        } else {
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(11));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(12));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(13));
        }
        if (length == 11) {
            intoBuf.writeLong(((Timestamp)dt).getNanos());
        }
    }

    /*
     * Exception decompiling
     */
    private final void storeReader(MysqlIO mysql, int parameterIndex, Buffer packet, Reader inStream) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 324->328)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final void storeStream(MysqlIO mysql, int parameterIndex, Buffer packet, InputStream inStream) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 248->252)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        StringBuffer toStringBuf = new StringBuffer();
        toStringBuf.append("com.mysql.jdbc.ServerPreparedStatement[");
        toStringBuf.append(this.serverStatementId);
        toStringBuf.append("] - ");
        try {
            toStringBuf.append(this.asSql());
        }
        catch (SQLException sqlEx) {
            toStringBuf.append(Messages.getString("ServerPreparedStatement.6"));
            toStringBuf.append(sqlEx);
        }
        return toStringBuf.toString();
    }

    private final /* synthetic */ void this() {
        this.dateTimeBindingCal = null;
        this.detectedLongParameterSwitch = false;
        this.invalid = false;
        this.sendTypesToServer = false;
        this.stringTypeCode = 254;
        this.isCached = false;
    }

    public ServerPreparedStatement(Connection conn, String sql, String catalog) throws SQLException {
        super(conn, catalog);
        this.this();
        this.checkNullOrEmptyQuery(sql);
        this.isSelectQuery = StringUtils.startsWithIgnoreCaseAndWs(sql, "SELECT");
        this.serverNeedsResetBeforeEachExecution = this.connection.versionMeetsMinimum(5, 0, 0) ? this.connection.versionMeetsMinimum(5, 0, 3) ^ true : this.connection.versionMeetsMinimum(4, 1, 10) ^ true;
        this.useTrueBoolean = this.connection.versionMeetsMinimum(3, 21, 23);
        boolean bl = false;
        if (StringUtils.indexOfIgnoreCase(sql, "LIMIT") != -1) {
            bl = true;
        }
        this.hasLimitClause = bl;
        this.firstCharOfStmt = StringUtils.firstNonWsCharUc(sql);
        this.originalSql = sql;
        this.stringTypeCode = this.connection.versionMeetsMinimum(4, 1, 2) ? 253 : 254;
        try {
            this.serverPrepare(sql);
        }
        catch (SQLException sqlEx) {
            this.realClose(false);
            throw sqlEx;
        }
        catch (Exception ex) {
            this.realClose(false);
            throw new SQLException(ex.toString(), "S1000");
        }
    }

    static class BatchedBindValues {
        BindValue[] batchedParameterValues;

        BatchedBindValues(BindValue[] paramVals) {
            int numParams = paramVals.length;
            this.batchedParameterValues = new BindValue[numParams];
            int i = 0;
            while (i < numParams) {
                this.batchedParameterValues[i] = new BindValue(paramVals[i]);
                ++i;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class BindValue {
        long boundBeforeExecutionNum;
        long bindLength;
        int bufferType;
        byte byteBinding;
        double doubleBinding;
        float floatBinding;
        int intBinding;
        boolean isLongData;
        boolean isNull;
        boolean isSet;
        long longBinding;
        short shortBinding;
        Object value;

        void reset() {
            this.isSet = false;
            this.value = null;
            this.isLongData = false;
            this.byteBinding = 0;
            this.shortBinding = 0;
            this.intBinding = 0;
            this.longBinding = 0L;
            this.floatBinding = 0.0f;
            this.doubleBinding = 0.0;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean quoteIfNeeded) {
            if (this.isLongData) {
                return "' STREAM DATA '";
            }
            switch (this.bufferType) {
                case 1: {
                    return String.valueOf(this.byteBinding);
                }
                case 2: {
                    return String.valueOf(this.shortBinding);
                }
                case 3: {
                    return String.valueOf(this.intBinding);
                }
                case 8: {
                    return String.valueOf(this.longBinding);
                }
                case 4: {
                    return String.valueOf(this.floatBinding);
                }
                case 5: {
                    return String.valueOf(this.doubleBinding);
                }
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 253: 
                case 254: {
                    if (quoteIfNeeded) {
                        return "'" + String.valueOf(this.value) + '\'';
                    }
                    return String.valueOf(this.value);
                }
            }
            if (this.value instanceof byte[]) {
                return "byte data";
            }
            if (quoteIfNeeded) {
                return "'" + String.valueOf(this.value) + '\'';
            }
            return String.valueOf(this.value);
        }

        private final /* synthetic */ void this() {
            this.boundBeforeExecutionNum = 0L;
            this.isSet = false;
        }

        BindValue() {
            this.this();
        }

        BindValue(BindValue copyMe) {
            this.this();
            this.value = copyMe.value;
            this.isSet = copyMe.isSet;
            this.isLongData = copyMe.isLongData;
            this.isNull = copyMe.isNull;
            this.bufferType = copyMe.bufferType;
            this.bindLength = copyMe.bindLength;
            this.byteBinding = copyMe.byteBinding;
            this.shortBinding = copyMe.shortBinding;
            this.intBinding = copyMe.intBinding;
            this.longBinding = copyMe.longBinding;
            this.floatBinding = copyMe.floatBinding;
            this.doubleBinding = copyMe.doubleBinding;
        }
    }
}

