/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.PyCursor;
import com.ziclix.python.sql.zxJDBC;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.python.core.Py;
import org.python.core.PyFile;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.util.StringUtil;

public class DataHandler {
    private static final int INITIAL_SIZE = 4096;
    private static final String[] SYSTEM_DATAHANDLERS = new String[]{"com.ziclix.python.sql.JDBC20DataHandler"};

    public String getMetaDataName(PyObject name) {
        return name == Py.None ? null : name.__str__().toString();
    }

    public Procedure getProcedure(PyCursor cursor, PyObject name) throws SQLException {
        return new Procedure(cursor, name);
    }

    public PyObject getRowId(Statement stmt) throws SQLException {
        return Py.None;
    }

    public void preExecute(Statement stmt) throws SQLException {
    }

    public void postExecute(Statement stmt) throws SQLException {
    }

    public void setJDBCObject(PreparedStatement stmt, int index, PyObject object) throws SQLException {
        try {
            stmt.setObject(index, object.__tojava__(Object.class));
        }
        catch (Exception e) {
            SQLException cause = null;
            SQLException ex = new SQLException("error setting index [" + index + "]");
            cause = e instanceof SQLException ? (SQLException)e : new SQLException(e.getMessage());
            ex.setNextException(cause);
            throw ex;
        }
    }

    public void setJDBCObject(PreparedStatement stmt, int index, PyObject object, int type) throws SQLException {
        try {
            if (DataHandler.checkNull(stmt, index, object, type)) {
                return;
            }
            switch (type) {
                case 91: {
                    Date date = (Date)object.__tojava__(Date.class);
                    stmt.setDate(index, date);
                    break;
                }
                case 92: {
                    Time time = (Time)object.__tojava__(Time.class);
                    stmt.setTime(index, time);
                    break;
                }
                case 93: {
                    Timestamp timestamp = (Timestamp)object.__tojava__(Timestamp.class);
                    stmt.setTimestamp(index, timestamp);
                    break;
                }
                case -1: {
                    if (object instanceof PyFile) {
                        object = new PyString(((PyFile)object).read());
                    }
                    String varchar = (String)object.__tojava__(String.class);
                    BufferedReader reader = new BufferedReader(new StringReader(varchar));
                    stmt.setCharacterStream(index, (Reader)reader, varchar.length());
                    break;
                }
                case -7: {
                    stmt.setBoolean(index, object.__nonzero__());
                    break;
                }
                default: {
                    if (object instanceof PyFile) {
                        object = new PyString(((PyFile)object).read());
                    }
                    stmt.setObject(index, object.__tojava__(Object.class), type);
                    break;
                }
            }
        }
        catch (Exception e) {
            SQLException cause = null;
            SQLException ex = new SQLException("error setting index [" + index + "], type [" + type + "]");
            cause = e instanceof SQLException ? (SQLException)e : new SQLException(e.getMessage());
            ex.setNextException(cause);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PyObject getPyObject(ResultSet set, int col, int type) throws SQLException {
        PyObject pyObject;
        PyObject obj = Py.None;
        switch (type) {
            case 1: 
            case 12: {
                String string = set.getString(col);
                obj = string == null ? Py.None : Py.newString(string);
                break;
            }
            case -1: {
                InputStream longvarchar = set.getAsciiStream(col);
                if (longvarchar == null) {
                    obj = Py.None;
                    break;
                }
                try {
                    longvarchar = new BufferedInputStream(longvarchar);
                    byte[] bytes = DataHandler.read(longvarchar);
                    if (bytes != null) {
                        obj = Py.newString(StringUtil.fromBytes(bytes));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        longvarchar.close();
                        throw throwable;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    longvarchar.close();
                }
                catch (Throwable t) {}
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bd = null;
                try {
                    bd = set.getBigDecimal(col, set.getMetaData().getPrecision(col));
                }
                catch (Throwable t) {
                    bd = set.getBigDecimal(col, 10);
                }
                obj = bd == null ? Py.None : Py.newFloat(bd.doubleValue());
                break;
            }
            case -7: {
                obj = set.getBoolean(col) ? Py.One : Py.Zero;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                obj = Py.newInteger(set.getInt(col));
                break;
            }
            case -5: {
                obj = new PyLong(set.getLong(col));
                break;
            }
            case 6: 
            case 7: {
                obj = Py.newFloat(set.getFloat(col));
                break;
            }
            case 8: {
                obj = Py.newFloat(set.getDouble(col));
                break;
            }
            case 92: {
                obj = Py.java2py(set.getTime(col));
                break;
            }
            case 93: {
                obj = Py.java2py(set.getTimestamp(col));
                break;
            }
            case 91: {
                obj = Py.java2py(set.getDate(col));
                break;
            }
            case 0: {
                obj = Py.None;
                break;
            }
            case 1111: {
                obj = Py.java2py(set.getObject(col));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                obj = Py.java2py(set.getBytes(col));
                break;
            }
            default: {
                Object[] vals = new Integer[]{new Integer(col), new Integer(type)};
                String msg = zxJDBC.getString("errorGettingIndex", vals);
                throw new SQLException(msg);
            }
        }
        if (!set.wasNull() && obj != null) {
            pyObject = obj;
            return pyObject;
        }
        pyObject = Py.None;
        return pyObject;
    }

    public PyObject getPyObject(CallableStatement stmt, int col, int type) throws SQLException {
        PyObject obj = Py.None;
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                String string = stmt.getString(col);
                obj = string == null ? Py.None : Py.newString(string);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bd = stmt.getBigDecimal(col, 10);
                obj = bd == null ? Py.None : Py.newFloat(bd.doubleValue());
                break;
            }
            case -7: {
                obj = stmt.getBoolean(col) ? Py.One : Py.Zero;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                obj = Py.newInteger(stmt.getInt(col));
                break;
            }
            case -5: {
                obj = new PyLong(stmt.getLong(col));
                break;
            }
            case 6: 
            case 7: {
                obj = Py.newFloat(stmt.getFloat(col));
                break;
            }
            case 8: {
                obj = Py.newFloat(stmt.getDouble(col));
                break;
            }
            case 92: {
                obj = Py.java2py(stmt.getTime(col));
                break;
            }
            case 93: {
                obj = Py.java2py(stmt.getTimestamp(col));
                break;
            }
            case 91: {
                obj = Py.java2py(stmt.getDate(col));
                break;
            }
            case 0: {
                obj = Py.None;
                break;
            }
            case 1111: {
                obj = Py.java2py(stmt.getObject(col));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                obj = Py.java2py(stmt.getBytes(col));
                break;
            }
            default: {
                Object[] vals = new Integer[]{new Integer(col), new Integer(type)};
                String msg = zxJDBC.getString("errorGettingIndex", vals);
                throw new SQLException(msg);
            }
        }
        return stmt.wasNull() || obj == null ? Py.None : obj;
    }

    public void registerOut(CallableStatement statement, int index, int colType, int dataType, String dataTypeName) throws SQLException {
        try {
            statement.registerOutParameter(index, dataType);
        }
        catch (Throwable t) {
            SQLException cause = null;
            SQLException ex = new SQLException("error setting index [" + index + "], coltype [" + colType + "], datatype [" + dataType + "], datatypename [" + dataTypeName + "]");
            cause = t instanceof SQLException ? (SQLException)t : new SQLException(t.getMessage());
            ex.setNextException(cause);
            throw ex;
        }
    }

    public static final boolean checkNull(PreparedStatement stmt, int index, PyObject object, int type) throws SQLException {
        if (object == null || Py.None == object) {
            stmt.setNull(index, type);
            return true;
        }
        return false;
    }

    public static final byte[] read(InputStream stream) {
        byte[] tmp;
        int b = -1;
        int read = 0;
        byte[] results = new byte[4096];
        try {
            while ((b = stream.read()) != -1) {
                if (results.length < read + 1) {
                    tmp = results;
                    results = new byte[results.length * 2];
                    System.arraycopy(tmp, 0, results, 0, tmp.length);
                }
                results[read++] = (byte)b;
            }
        }
        catch (IOException e) {
            throw zxJDBC.makeException(e);
        }
        tmp = results;
        results = new byte[read];
        System.arraycopy(tmp, 0, results, 0, read);
        return results;
    }

    public static final String read(Reader reader) {
        int c = 0;
        StringBuffer buffer = new StringBuffer(4096);
        try {
            while ((c = reader.read()) != -1) {
                buffer.append((char)c);
            }
        }
        catch (IOException e) {
            throw zxJDBC.makeException(e);
        }
        return buffer.toString();
    }

    public static final DataHandler getSystemDataHandler() {
        DataHandler dh = new DataHandler();
        for (int i = 0; i < SYSTEM_DATAHANDLERS.length; ++i) {
            try {
                Class<?> c = Class.forName(SYSTEM_DATAHANDLERS[i]);
                Constructor<?> cons = c.getConstructor(DataHandler.class);
                dh = (DataHandler)cons.newInstance(dh);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return dh;
    }

    public PyObject __chain__() {
        return new PyList(new PyObject[]{Py.java2py(this)});
    }

    public String toString() {
        return this.getClass().getName();
    }
}

