/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyRunnable;
import org.python.core.imp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeLoader {
    public static Class makeClass(String name, byte[] data, Class ... referents) {
        Loader loader = new Loader();
        for (int i = 0; i < referents.length; ++i) {
            try {
                ClassLoader cur = referents[i].getClassLoader();
                if (cur == null) continue;
                loader.addParent(cur);
                continue;
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        return loader.loadClassFromBytes(name, data);
    }

    public static Class makeClass(String name, Vector<Class> referents, byte[] data) {
        if (referents != null) {
            return BytecodeLoader.makeClass(name, data, referents.toArray(new Class[0]));
        }
        return BytecodeLoader.makeClass(name, data, new Class[0]);
    }

    public static PyCode makeCode(String name, byte[] data, String filename) {
        try {
            Class c = BytecodeLoader.makeClass(name, data, new Class[0]);
            Object o = c.getConstructor(String.class).newInstance(filename);
            return ((PyRunnable)o).getMain();
        }
        catch (Exception e) {
            throw Py.JavaError(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Loader
    extends SecureClassLoader {
        private List<ClassLoader> parents = new ArrayList<ClassLoader>();

        public Loader() {
            this.parents.add(imp.getSyspathJavaLoader());
        }

        public void addParent(ClassLoader referent) {
            if (!this.parents.contains(referent)) {
                this.parents.add(0, referent);
            }
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            for (ClassLoader loader : this.parents) {
                try {
                    return loader.loadClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                }
            }
            throw new ClassNotFoundException(name);
        }

        public Class loadClassFromBytes(String name, byte[] data) {
            Class<?> c = this.defineClass(name, data, 0, data.length, this.getClass().getProtectionDomain());
            this.resolveClass(c);
            Compiler.compileClass(c);
            return c;
        }
    }
}

