/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.imp;
import org.python.expose.ExposedGet;

class ImportFunction
extends PyObject {
    ImportFunction() {
    }

    @ExposedGet(name="__doc__")
    public PyObject getDoc() {
        return new PyString("__import__(name, globals={}, locals={}, fromlist=[], level=-1) -> module\n\nImport a module.  The globals are only used to determine the context;\nthey are not modified.  The locals are currently unused.  The fromlist\nshould be a list of names to emulate ``from name import ...'', or an\nempty list to emulate ``import name''.\nWhen importing a module from a package, note that __import__('A.B', ...)\nreturns package A when fromlist is empty, but its submodule B when\nfromlist is not empty.  Level is used to determine whether to perform \nabsolute or relative imports.  -1 is the original strategy of attempting\nboth absolute and relative imports, 0 is absolute, a positive number\nis the number of parent directories to search relative to the current module.");
    }

    public PyObject __call__(PyObject[] args, String[] keywords) {
        if (args.length >= 1 && !(args[0] instanceof PyString)) {
            throw Py.TypeError("first argument must be a string");
        }
        if (keywords.length > 0) {
            throw Py.TypeError("__import__() takes no keyword arguments");
        }
        int argc = args.length;
        String module = args[0].__str__().toString();
        PyObject globals = argc > 1 && args[1] != null ? args[1] : null;
        PyTuple fromlist = argc > 3 && args[3] != null ? args[3] : Py.EmptyTuple;
        return this.load(module, globals, fromlist);
    }

    private PyObject load(String module, PyObject globals, PyObject fromlist) {
        PyObject mod = imp.importName(module.intern(), fromlist.__len__() == 0, globals, fromlist);
        return mod;
    }

    public String toString() {
        return "<built-in function __import__>";
    }
}

