/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Constructor;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyFrame;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaPackage;
import org.python.core.PyMetaClass;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;

public class NewCompilerResources {
    private static Class[] pyClassCtrSignature = new Class[]{String.class, PyTuple.class, PyObject.class, Class.class};
    private static final PyType CLASS_TYPE = PyType.fromClass(PyClass.class);

    public static PyObject makeClass(String name, PyObject[] bases, PyObject dict) {
        return NewCompilerResources.makeClass(name, bases, dict, null);
    }

    public static PyObject makeClass(String name, PyObject[] bases, PyObject dict, Class proxyClass) {
        PyFrame frame = Py.getFrame();
        PyObject globals = frame.f_globals;
        PyObject metaclass = dict.__finditem__("__metaclass__");
        if (metaclass == null) {
            if (bases.length != 0) {
                PyObject base = bases[0];
                if (base instanceof PyMetaClass) {
                    try {
                        Constructor<?> ctor = base.getClass().getConstructor(pyClassCtrSignature);
                        return (PyObject)ctor.newInstance(name, new PyTuple(bases), dict, proxyClass);
                    }
                    catch (Exception e) {
                        throw Py.TypeError("meta-class fails to supply proper ctr: " + base.getType().fastGetName());
                    }
                }
                metaclass = base.__findattr__("__class__");
                if (metaclass == null) {
                    metaclass = base.getType();
                }
            } else if (globals != null) {
                metaclass = globals.__finditem__("__metaclass__");
            }
        }
        if (metaclass == null || metaclass == CLASS_TYPE || metaclass instanceof PyJavaClass && ((PyJavaClass)metaclass).proxyClass == Class.class) {
            boolean more_general = false;
            for (int i = 0; i < bases.length; ++i) {
                if (bases[i] instanceof PyClass) continue;
                metaclass = bases[i].getType();
                more_general = true;
                break;
            }
            if (!more_general) {
                return new PyClass(name, new PyTuple(bases), dict, proxyClass);
            }
        }
        if (proxyClass != null) {
            throw Py.TypeError("the meta-class cannot handle java subclassing");
        }
        return metaclass.__call__((PyObject)new PyString(name), new PyTuple(bases), dict);
    }

    public static void importAll(PyObject module, PyFrame frame) {
        PyObject names;
        boolean filter = true;
        if (module instanceof PyJavaPackage) {
            names = ((PyJavaPackage)module).fillDir();
        } else {
            PyObject __all__ = module.__findattr__("__all__");
            if (__all__ != null) {
                names = __all__;
                filter = false;
            } else {
                names = module.__dir__();
            }
        }
        NewCompilerResources.loadNames(names, module, frame.getf_locals(), filter);
    }

    private static void loadNames(PyObject names, PyObject module, PyObject locals, boolean filter) {
        PyObject name;
        PyObject iter = names.__iter__();
        while ((name = iter.__iternext__()) != null) {
            String sname = ((PyString)name).internedString();
            if (filter && sname.startsWith("_")) continue;
            try {
                locals.__setitem__(sname, module.__getattr__(sname));
            }
            catch (Exception exc) {}
        }
    }
}

