/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import org.python.core.AbstractArray;
import org.python.core.ArgParser;
import org.python.core.ByteSwapper;
import org.python.core.Py;
import org.python.core.PyArrayDerived;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyOverridableNew;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.util.StringUtil;
import org.python.expose.ExposedNew;
import org.python.expose.generate.TypeExposer;

public class PyArray
extends PySequence
implements Cloneable {
    public static final PyType TYPE;
    private Object data;
    private Class type;
    private String typecode;
    private ArrayDelegate delegate;

    public PyArray(PyType pyType) {
        super(pyType);
    }

    public PyArray(PyArray pyArray) {
        this.data = pyArray.delegate.copyArray();
        this.delegate = new ArrayDelegate();
        this.type = pyArray.type;
    }

    public PyArray(Class clazz, Object object) {
        this.type = clazz;
        this.data = object;
        this.delegate = new ArrayDelegate();
    }

    public PyArray(Class clazz, int n) {
        this(clazz, Array.newInstance(clazz, n));
    }

    @ExposedNew
    final void array_init(PyObject[] pyObjectArray, String[] stringArray) {
        Object object;
        ArgParser argParser = new ArgParser("array", pyObjectArray, stringArray, new String[]{"typecode", "seq"}, 1);
        PyObject pyObject = argParser.getPyObject(0);
        if (pyObject instanceof PyString) {
            object = pyObject.toString();
            if (((String)object).length() != 1) {
                throw Py.ValueError("typecode must be in [zcbhilfd]");
            }
            this.type = PyArray.char2class(((String)object).charAt(0));
            this.typecode = object;
        } else if (pyObject instanceof PyJavaClass) {
            this.type = ((PyJavaClass)pyObject).proxyClass;
            this.typecode = this.type.getName();
        }
        this.data = Array.newInstance(this.type, 0);
        this.delegate = new ArrayDelegate();
        object = argParser.getPyObject(1, null);
        if (object == null) {
            return;
        }
        this.extendInternal((PyObject)object);
    }

    public static PyArray zeros(int n, char c) {
        PyArray pyArray = PyArray.zeros(n, PyArray.char2class(c));
        pyArray.typecode = Character.toString(c);
        return pyArray;
    }

    public static PyArray zeros(int n, Class clazz) {
        PyArray pyArray = new PyArray(clazz, n);
        pyArray.typecode = clazz.getName();
        return pyArray;
    }

    public static PyArray array(PyObject pyObject, char c) {
        PyArray pyArray = PyArray.array(pyObject, PyArray.char2class(c));
        pyArray.typecode = Character.toString(c);
        return pyArray;
    }

    public static PyArray array(PyObject pyObject, Class clazz) {
        PyArray pyArray = new PyArray(clazz, 0);
        pyArray.typecode = clazz.getName();
        pyArray.extendInternal(pyObject);
        return pyArray;
    }

    final PyObject array___ne__(PyObject pyObject) {
        return this.seq___ne__(pyObject);
    }

    final PyObject array___eq__(PyObject pyObject) {
        return this.seq___eq__(pyObject);
    }

    final PyObject array___lt__(PyObject pyObject) {
        return this.seq___lt__(pyObject);
    }

    final PyObject array___le__(PyObject pyObject) {
        return this.seq___le__(pyObject);
    }

    final PyObject array___gt__(PyObject pyObject) {
        return this.seq___gt__(pyObject);
    }

    final PyObject array___ge__(PyObject pyObject) {
        return this.seq___ge__(pyObject);
    }

    final boolean array___contains__(PyObject pyObject) {
        return this.object___contains__(pyObject);
    }

    final void array___delitem__(PyObject pyObject) {
        this.seq___delitem__(pyObject);
    }

    final void array___setitem__(PyObject pyObject, PyObject pyObject2) {
        this.seq___setitem__(pyObject, pyObject2);
    }

    final PyObject array___getitem__(PyObject pyObject) {
        PyObject pyObject2 = this.seq___finditem__(pyObject);
        if (pyObject2 == null) {
            throw Py.IndexError("index out of range: " + pyObject);
        }
        return pyObject2;
    }

    final boolean array___nonzero__() {
        return this.seq___nonzero__();
    }

    final PyObject array___getslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        return this.seq___getslice__(pyObject, pyObject2, pyObject3);
    }

    final void array___setslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
        if (pyObject4 == null) {
            pyObject4 = pyObject3;
            pyObject3 = null;
        }
        this.seq___setslice__(pyObject, pyObject2, pyObject3, pyObject4);
    }

    final void array___delslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        this.seq___delslice__(pyObject, pyObject2, pyObject3);
    }

    public PyObject __add__(PyObject pyObject) {
        PyArray pyArray = null;
        if (!(pyObject instanceof PyArray)) {
            throw Py.TypeError("can only append another array to an array");
        }
        pyArray = (PyArray)pyObject;
        if (!pyArray.type.equals(this.type)) {
            throw Py.TypeError("can only append arrays of the same type, expected '" + this.type + ", found " + pyArray.type);
        }
        PyArray pyArray2 = new PyArray(this);
        pyArray2.delegate.appendArray(pyArray.delegate.copyArray());
        return pyArray2;
    }

    public PyObject __findattr__(String string) {
        if ("typecode".equals(string)) {
            return new PyString(this.getTypecode());
        }
        return super.__findattr__(string);
    }

    public int __len__() {
        return this.delegate.getSize();
    }

    public PyString __repr__() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("array(").append(PyArray.class2char(this.type)).append(",[");
        for (int i = 0; i < this.__len__() - 1; ++i) {
            stringBuffer.append(this.pyget(i).__repr__().toString());
            stringBuffer.append(", ");
        }
        if (this.__len__() > 0) {
            stringBuffer.append(this.pyget(this.__len__() - 1).__repr__().toString());
        }
        stringBuffer.append("]) ");
        return new PyString(stringBuffer.toString());
    }

    public Object __tojava__(Class clazz) {
        if (clazz == Object.class || clazz.isArray() && clazz.getComponentType().isAssignableFrom(this.type)) {
            return this.data;
        }
        if (clazz.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    public final void array_append(PyObject pyObject) {
        this.append(pyObject);
    }

    public void append(PyObject pyObject) {
        int n = this.delegate.getSize();
        this.delegate.makeInsertSpace(n);
        try {
            this.set(n, pyObject);
        }
        catch (PyException pyException) {
            this.delegate.setSize(n);
            throw new PyException(pyException.type, pyException.value);
        }
    }

    public void array_byteswap() {
        this.byteswap();
    }

    public void byteswap() {
        if (this.getItemsize() == 0) {
            throw Py.RuntimeError("don't know how to byteswap this array type");
        }
        ByteSwapper.swap(this.data);
    }

    public Object clone() {
        return new PyArray(this);
    }

    public static Class char2class(char c) throws PyIgnoreMethodTag {
        switch (c) {
            case 'z': {
                return Boolean.TYPE;
            }
            case 'c': {
                return Character.TYPE;
            }
            case 'b': {
                return Byte.TYPE;
            }
            case 'h': {
                return Short.TYPE;
            }
            case 'H': {
                return Integer.TYPE;
            }
            case 'i': {
                return Integer.TYPE;
            }
            case 'I': {
                return Long.TYPE;
            }
            case 'l': {
                return Long.TYPE;
            }
            case 'f': {
                return Float.TYPE;
            }
            case 'd': {
                return Double.TYPE;
            }
        }
        throw Py.ValueError("typecode must be in [zcbhilfd]");
    }

    private static String class2char(Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            return "'z'";
        }
        if (clazz.equals(Character.TYPE)) {
            return "'c'";
        }
        if (clazz.equals(Byte.TYPE)) {
            return "'b'";
        }
        if (clazz.equals(Short.TYPE)) {
            return "'h'";
        }
        if (clazz.equals(Integer.TYPE)) {
            return "'i'";
        }
        if (clazz.equals(Long.TYPE)) {
            return "'l'";
        }
        if (clazz.equals(Float.TYPE)) {
            return "'f'";
        }
        if (clazz.equals(Double.TYPE)) {
            return "'d'";
        }
        return clazz.getName();
    }

    public final int array_count(PyObject pyObject) {
        int n = 0;
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            if (!pyObject.equals(Py.java2py(Array.get(this.data, i)))) continue;
            ++n;
        }
        return n;
    }

    public PyInteger count(PyObject pyObject) {
        return Py.newInteger(this.array_count(pyObject));
    }

    protected void del(int n) {
        this.delegate.remove(n);
    }

    protected void delRange(int n, int n2, int n3) {
        if (n3 > 0 && n2 < n) {
            n2 = n;
        }
        if (n3 == 1) {
            this.delegate.remove(n, n2);
        } else {
            int n4 = PyArray.sliceLength(n, n2, n3);
            int n5 = n;
            for (int i = 0; i < n4; ++i) {
                this.delegate.remove(n5);
                n5 += n3;
            }
        }
    }

    public final void array_extend(PyObject pyObject) {
        this.extendInternal(pyObject);
    }

    public void extend(PyObject pyObject) {
        this.extendInternal(pyObject);
    }

    private void extendInternal(PyObject pyObject) {
        if (pyObject instanceof PyString) {
            this.fromstring(((PyString)pyObject).toString());
        } else if (pyObject instanceof PyArray) {
            PyArray pyArray = (PyArray)pyObject;
            if (!pyArray.type.equals(this.type)) {
                throw Py.TypeError("can only extend with an array of the same kind");
            }
            this.delegate.appendArray(pyArray.delegate.copyArray());
        } else {
            this.extendInternalIter(pyObject);
        }
    }

    private void extendInternalIter(PyObject pyObject) {
        if (pyObject.__findattr__("__len__") == null) {
            for (PyObject pyObject2 : pyObject.asIterable()) {
                this.append(pyObject2);
            }
        } else {
            int n = this.delegate.getSize();
            this.delegate.ensureCapacity(n + pyObject.__len__());
            for (PyObject pyObject3 : pyObject.asIterable()) {
                this.set(n++, pyObject3);
                ++this.delegate.size;
            }
        }
    }

    public final void array_fromfile(PyObject pyObject, int n) {
        this.fromfile(pyObject, n);
    }

    public void fromfile(PyObject pyObject, int n) {
        if (!(pyObject instanceof PyFile)) {
            throw Py.TypeError("arg1 must be open file");
        }
        PyFile pyFile = (PyFile)pyObject;
        if (pyFile.mode.indexOf("r") == -1) {
            throw Py.TypeError("file needs to be in read mode");
        }
        int n2 = n * this.getItemsize();
        String string = pyFile.read(n2).toString();
        this.fromstring(string);
        if (string.length() < n2) {
            int n3 = string.length() / this.getItemsize();
            throw Py.EOFError("not enough items in file. " + Integer.toString(n) + " requested, " + Integer.toString(n3) + " actually read");
        }
    }

    public final void array_fromlist(PyObject pyObject) {
        this.fromlist(pyObject);
    }

    public void fromlist(PyObject pyObject) {
        if (!(pyObject instanceof PyList)) {
            throw Py.TypeError("expected list argument");
        }
        int n = this.delegate.getSize();
        try {
            this.extendInternalIter(pyObject);
        }
        catch (PyException pyException) {
            this.delegate.setSize(n);
            throw new PyException(pyException.type, pyException.value);
        }
    }

    private int fromStream(InputStream inputStream) throws IOException, EOFException {
        return this.fromStream(inputStream, inputStream.available() / this.getItemsize());
    }

    private int fromStream(InputStream inputStream, int n) throws IOException, EOFException {
        int n2;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n3 = n2 = this.delegate.getSize();
        this.delegate.ensureCapacity(n3 + n);
        if (this.type.isPrimitive()) {
            if (this.type == Boolean.TYPE) {
                int n4 = 0;
                while (n4 < n) {
                    Array.setBoolean(this.data, n3, dataInputStream.readBoolean());
                    ++this.delegate.size;
                    ++n4;
                    ++n3;
                }
            } else if (this.type == Byte.TYPE) {
                int n5 = 0;
                while (n5 < n) {
                    Array.setByte(this.data, n3, dataInputStream.readByte());
                    ++this.delegate.size;
                    ++n5;
                    ++n3;
                }
            } else if (this.type == Character.TYPE) {
                int n6 = 0;
                while (n6 < n) {
                    Array.setChar(this.data, n3, (char)dataInputStream.readByte());
                    ++this.delegate.size;
                    ++n6;
                    ++n3;
                }
            } else if (this.type == Integer.TYPE) {
                int n7 = 0;
                while (n7 < n) {
                    Array.setInt(this.data, n3, dataInputStream.readInt());
                    ++this.delegate.size;
                    ++n7;
                    ++n3;
                }
            } else if (this.type == Short.TYPE) {
                int n8 = 0;
                while (n8 < n) {
                    Array.setShort(this.data, n3, dataInputStream.readShort());
                    ++this.delegate.size;
                    ++n8;
                    ++n3;
                }
            } else if (this.type == Long.TYPE) {
                int n9 = 0;
                while (n9 < n) {
                    Array.setLong(this.data, n3, dataInputStream.readLong());
                    ++this.delegate.size;
                    ++n9;
                    ++n3;
                }
            } else if (this.type == Float.TYPE) {
                int n10 = 0;
                while (n10 < n) {
                    Array.setFloat(this.data, n3, dataInputStream.readFloat());
                    ++this.delegate.size;
                    ++n10;
                    ++n3;
                }
            } else if (this.type == Double.TYPE) {
                int n11 = 0;
                while (n11 < n) {
                    Array.setDouble(this.data, n3, dataInputStream.readDouble());
                    ++this.delegate.size;
                    ++n11;
                    ++n3;
                }
            }
        }
        dataInputStream.close();
        return n3 - n2;
    }

    public void fromstring(String string) {
        int n = this.getItemsize();
        int n2 = string.length();
        if (n2 % n != 0) {
            throw Py.ValueError("string length not a multiple of item size");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(StringUtil.toBytes(string));
        int n3 = this.delegate.getSize();
        try {
            this.fromStream(byteArrayInputStream);
        }
        catch (EOFException eOFException) {
            throw Py.EOFError("not enough items in string");
        }
        catch (IOException iOException) {
            this.delegate.setSize(n3);
            throw Py.IOError(iOException);
        }
    }

    protected PyObject pyget(int n) {
        return Py.java2py(Array.get(this.data, n));
    }

    public Object getArray() throws PyIgnoreMethodTag {
        return this.delegate.copyArray();
    }

    public int getItemsize() {
        if (this.type.isPrimitive()) {
            if (this.type == Boolean.TYPE) {
                return 1;
            }
            if (this.type == Byte.TYPE) {
                return 1;
            }
            if (this.type == Character.TYPE) {
                return 1;
            }
            if (this.type == Short.TYPE) {
                return 2;
            }
            if (this.type == Integer.TYPE) {
                return 4;
            }
            if (this.type == Long.TYPE) {
                return 8;
            }
            if (this.type == Float.TYPE) {
                return 4;
            }
            if (this.type == Double.TYPE) {
                return 8;
            }
        }
        return 0;
    }

    protected PyObject getslice(int n, int n2, int n3) {
        if (n3 > 0 && n2 < n) {
            n2 = n;
        }
        int n4 = PyArray.sliceLength(n, n2, n3);
        PyArray pyArray = new PyArray(this.type, n4);
        if (n3 == 1) {
            System.arraycopy(this.data, n, pyArray.data, 0, n4);
            return pyArray;
        }
        int n5 = n;
        for (int i = 0; i < n4; ++i) {
            Array.set(pyArray.data, i, Array.get(this.data, n5));
            n5 += n3;
        }
        return pyArray;
    }

    public String getTypecode() {
        return this.typecode;
    }

    public final int array_index(PyObject pyObject) {
        int n = this.indexInternal(pyObject);
        if (n != -1) {
            return n;
        }
        throw Py.ValueError("array.index(" + pyObject + "): " + pyObject + " not found in array");
    }

    public PyObject index(PyObject pyObject) {
        return Py.newInteger(this.array_index(pyObject));
    }

    private int indexInternal(PyObject pyObject) {
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            if (!pyObject.equals(Py.java2py(Array.get(this.data, i)))) continue;
            return i;
        }
        return -1;
    }

    public final void array_insert(int n, PyObject pyObject) {
        this.insert(n, pyObject);
    }

    public void insert(int n, PyObject pyObject) {
        this.delegate.makeInsertSpace(n);
        Array.set(this.data, n, Py.tojava(pyObject, this.type));
    }

    public final PyObject array_pop(int n) {
        return this.pop(n);
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int n) {
        n = n < 0 ? this.delegate.getSize() + n : n;
        PyObject pyObject = Py.java2py(Array.get(this.data, n));
        this.delegate.remove(n);
        return pyObject;
    }

    public final void array_remove(PyObject pyObject) {
        this.remove(pyObject);
    }

    public void remove(PyObject pyObject) {
        int n = this.indexInternal(pyObject);
        if (n != -1) {
            this.delegate.remove(n);
            return;
        }
        throw Py.ValueError("array.remove(" + pyObject + "): " + pyObject + " not found in array");
    }

    protected PyObject repeat(int n) {
        Object object = this.delegate.copyArray();
        PyArray pyArray = new PyArray(this.type, 0);
        for (int i = 0; i < n; ++i) {
            pyArray.delegate.appendArray(object);
        }
        return pyArray;
    }

    public final void array_reverse() {
        this.reverse();
    }

    public void reverse() {
        Object object = Array.newInstance(this.type, Array.getLength(this.data));
        int n = this.delegate.getSize() - 1;
        for (int i = 0; i <= n; ++i) {
            Array.set(object, n - i, Array.get(this.data, i));
        }
        this.data = object;
    }

    public void set(int n, PyObject pyObject) {
        Object object;
        if (this.type == Byte.TYPE) {
            long l;
            try {
                l = (Long)pyObject.__tojava__(Long.TYPE);
            }
            catch (ClassCastException classCastException) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (l < -128L) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (l > 127L) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Short.TYPE) {
            long l;
            try {
                l = (Long)pyObject.__tojava__(Long.TYPE);
            }
            catch (ClassCastException classCastException) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (l < -32768L) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (l > 32767L) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Integer.TYPE) {
            long l;
            try {
                l = (Long)pyObject.__tojava__(Long.TYPE);
            }
            catch (ClassCastException classCastException) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (l < Integer.MIN_VALUE) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (l > Integer.MAX_VALUE) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Long.TYPE) {
            Object object2;
            try {
                object2 = pyObject.__tojava__(Long.TYPE);
            }
            catch (ClassCastException classCastException) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (object2 == Py.NoConversion) {
                throw Py.OverflowError("value out of range for long");
            }
        }
        if ((object = Py.tojava(pyObject, this.type)) == Py.NoConversion) {
            throw Py.TypeError("Type not compatible with array type");
        }
        Array.set(this.data, n, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setslice(int n, int n2, int n3, PyObject pyObject) {
        if (this.type == Character.TYPE && pyObject instanceof PyString) {
            char[] cArray = null;
            if (n3 != 1) {
                throw Py.ValueError("invalid bounds for setting from string");
            }
            cArray = pyObject.toString().toCharArray();
            int n4 = cArray.length - (n2 - n);
            if (n4 > 0) {
                this.delegate.makeInsertSpace(n, n4);
            } else if (n4 < 0) {
                this.delegate.remove(n, -n4 + n - 1);
            }
            this.delegate.replaceSubArray(cArray, n);
            return;
        }
        if (pyObject instanceof PyString && this.type == Byte.TYPE) {
            byte[] byArray = ((PyString)pyObject).toBytes();
            if (byArray.length != n2 - n || n3 != 1) throw Py.ValueError("invalid bounds for setting from string");
            System.arraycopy(byArray, 0, this.data, n, byArray.length);
            return;
        }
        if (!(pyObject instanceof PyArray)) return;
        PyArray pyArray = (PyArray)pyObject;
        int n5 = pyArray.delegate.getSize() - (n2 - n);
        Object object = pyArray.delegate.copyArray();
        if (n5 > 0) {
            this.delegate.makeInsertSpace(n, n5);
        } else if (n5 < 0) {
            this.delegate.remove(n, -n5 + n - 1);
        }
        try {
            this.delegate.replaceSubArray(object, n);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Py.TypeError("Slice typecode '" + pyArray.typecode + "' is not compatible with this array (typecode '" + this.typecode + "')");
        }
    }

    public final void array_tofile(PyObject pyObject) {
        this.tofile(pyObject);
    }

    public void array_write(PyObject pyObject) {
        this.tofile(pyObject);
    }

    public void tofile(PyObject pyObject) {
        if (!(pyObject instanceof PyFile)) {
            throw Py.TypeError("arg must be open file");
        }
        PyFile pyFile = (PyFile)pyObject;
        if (pyFile.mode.indexOf("w") == -1 && pyFile.mode.indexOf("a") == -1) {
            throw Py.TypeError("file needs to be in write or append mode");
        }
        pyFile.write(this.tostring());
    }

    public final PyObject array_tolist() {
        return this.tolist();
    }

    public PyObject tolist() {
        PyList pyList = new PyList();
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            pyList.append(Py.java2py(Array.get(this.data, i)));
        }
        return pyList;
    }

    private int toStream(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream;
        block8: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        dataOutputStream = new DataOutputStream(outputStream);
                                        if (!this.type.isPrimitive()) break block8;
                                        if (this.type != Boolean.TYPE) break block9;
                                        for (int i = 0; i < this.delegate.getSize(); ++i) {
                                            dataOutputStream.writeBoolean(Array.getBoolean(this.data, i));
                                        }
                                        break block8;
                                    }
                                    if (this.type != Byte.TYPE) break block10;
                                    for (int i = 0; i < this.delegate.getSize(); ++i) {
                                        dataOutputStream.writeByte(Array.getByte(this.data, i));
                                    }
                                    break block8;
                                }
                                if (this.type != Character.TYPE) break block11;
                                for (int i = 0; i < this.delegate.getSize(); ++i) {
                                    dataOutputStream.writeByte((byte)Array.getChar(this.data, i));
                                }
                                break block8;
                            }
                            if (this.type != Integer.TYPE) break block12;
                            for (int i = 0; i < this.delegate.getSize(); ++i) {
                                dataOutputStream.writeInt(Array.getInt(this.data, i));
                            }
                            break block8;
                        }
                        if (this.type != Short.TYPE) break block13;
                        for (int i = 0; i < this.delegate.getSize(); ++i) {
                            dataOutputStream.writeShort(Array.getShort(this.data, i));
                        }
                        break block8;
                    }
                    if (this.type != Long.TYPE) break block14;
                    for (int i = 0; i < this.delegate.getSize(); ++i) {
                        dataOutputStream.writeLong(Array.getLong(this.data, i));
                    }
                    break block8;
                }
                if (this.type != Float.TYPE) break block15;
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dataOutputStream.writeFloat(Array.getFloat(this.data, i));
                }
                break block8;
            }
            if (this.type != Double.TYPE) break block8;
            for (int i = 0; i < this.delegate.getSize(); ++i) {
                dataOutputStream.writeDouble(Array.getDouble(this.data, i));
            }
        }
        return dataOutputStream.size();
    }

    public final PyObject array_tostring() {
        return new PyString(this.tostring());
    }

    public String tostring() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.toStream(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        return StringUtil.fromBytes(byteArrayOutputStream.toByteArray());
    }

    static {
        PyType.addBuilder(PyArray.class, new PyArray$PyExposer());
        TYPE = PyType.fromClass(PyArray.class);
    }

    private class ArrayDelegate
    extends AbstractArray {
        private ArrayDelegate() {
            super(PyArray.this.data == null ? 0 : Array.getLength(PyArray.this.data));
        }

        protected Object getArray() {
            return PyArray.this.data;
        }

        protected void setArray(Object array) {
            PyArray.this.data = array;
        }

        protected Object createArray(int size) {
            Class<?> baseType = PyArray.this.data.getClass().getComponentType();
            return Array.newInstance(baseType, size);
        }
    }

    public class PyArray$array_init_exposer
    extends PyBuiltinMethod {
        public PyArray$array_init_exposer(String string) {
            super(string);
        }

        public PyArray$array_init_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_init_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyArray)this.self).array_init(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyArray$array___ne___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___ne___exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array___ne___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array___ne___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyArray)this.self).array___ne__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyArray$array___eq___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___eq___exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array___eq___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array___eq___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyArray)this.self).array___eq__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyArray$array___lt___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___lt___exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array___lt___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array___lt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyArray)this.self).array___lt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyArray$array___le___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___le___exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array___le___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array___le___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyArray)this.self).array___le__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyArray$array___gt___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___gt___exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array___gt___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array___gt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyArray)this.self).array___gt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyArray$array___ge___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___ge___exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array___ge___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array___ge___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyArray)this.self).array___ge__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyArray$array___contains___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___contains___exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array___contains___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array___contains___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyArray)this.self).array___contains__(pyObject));
        }
    }

    public class PyArray$array___delitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___delitem___exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array___delitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array___delitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyArray)this.self).array___delitem__(pyObject);
            return Py.None;
        }
    }

    public class PyArray$array___setitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___setitem___exposer(String string) {
            super(string, 3, 3);
        }

        public PyArray$array___setitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array___setitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyArray)this.self).array___setitem__(pyObject, pyObject2);
            return Py.None;
        }
    }

    public class PyArray$array___getitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___getitem___exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array___getitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array___getitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyArray)this.self).array___getitem__(pyObject);
        }
    }

    public class PyArray$array___nonzero___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___nonzero___exposer(String string) {
            super(string, 1, 1);
        }

        public PyArray$array___nonzero___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array___nonzero___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyArray)this.self).array___nonzero__());
        }
    }

    public class PyArray$array___getslice___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___getslice___exposer(String string) {
            super(string, 3, 4);
        }

        public PyArray$array___getslice___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array___getslice___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return ((PyArray)this.self).array___getslice__(pyObject, pyObject2, pyObject3);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyArray)this.self).array___getslice__(pyObject, pyObject2, null);
        }
    }

    public class PyArray$array___setslice___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___setslice___exposer(String string) {
            super(string, 4, 5);
        }

        public PyArray$array___setslice___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array___setslice___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
            ((PyArray)this.self).array___setslice__(pyObject, pyObject2, pyObject3, pyObject4);
            return Py.None;
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            ((PyArray)this.self).array___setslice__(pyObject, pyObject2, pyObject3, null);
            return Py.None;
        }
    }

    public class PyArray$array___delslice___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___delslice___exposer(String string) {
            super(string, 4, 4);
        }

        public PyArray$array___delslice___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array___delslice___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            ((PyArray)this.self).array___delslice__(pyObject, pyObject2, pyObject3);
            return Py.None;
        }
    }

    public class PyArray$array_append_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_append_exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array_append_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_append_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyArray)this.self).array_append(pyObject);
            return Py.None;
        }
    }

    public class PyArray$array_byteswap_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_byteswap_exposer(String string) {
            super(string, 1, 1);
        }

        public PyArray$array_byteswap_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_byteswap_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            ((PyArray)this.self).array_byteswap();
            return Py.None;
        }
    }

    public class PyArray$array_count_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_count_exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array_count_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_count_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyArray)this.self).array_count(pyObject));
        }
    }

    public class PyArray$array_extend_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_extend_exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array_extend_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_extend_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyArray)this.self).array_extend(pyObject);
            return Py.None;
        }
    }

    public class PyArray$array_fromfile_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_fromfile_exposer(String string) {
            super(string, 3, 3);
        }

        public PyArray$array_fromfile_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_fromfile_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyArray)this.self).array_fromfile(pyObject, Py.py2int(pyObject2));
            return Py.None;
        }
    }

    public class PyArray$array_fromlist_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_fromlist_exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array_fromlist_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_fromlist_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyArray)this.self).array_fromlist(pyObject);
            return Py.None;
        }
    }

    public class PyArray$array_index_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_index_exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array_index_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_index_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyArray)this.self).array_index(pyObject));
        }
    }

    public class PyArray$array_insert_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_insert_exposer(String string) {
            super(string, 3, 3);
        }

        public PyArray$array_insert_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_insert_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyArray)this.self).array_insert(Py.py2int(pyObject), pyObject2);
            return Py.None;
        }
    }

    public class PyArray$array_pop_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_pop_exposer(String string) {
            super(string, 1, 2);
        }

        public PyArray$array_pop_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_pop_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyArray)this.self).array_pop(Py.py2int(pyObject));
        }

        public PyObject __call__() {
            return ((PyArray)this.self).array_pop(-1);
        }
    }

    public class PyArray$array_remove_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_remove_exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array_remove_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_remove_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyArray)this.self).array_remove(pyObject);
            return Py.None;
        }
    }

    public class PyArray$array_reverse_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_reverse_exposer(String string) {
            super(string, 1, 1);
        }

        public PyArray$array_reverse_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_reverse_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            ((PyArray)this.self).array_reverse();
            return Py.None;
        }
    }

    public class PyArray$array_tofile_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_tofile_exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array_tofile_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_tofile_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyArray)this.self).array_tofile(pyObject);
            return Py.None;
        }
    }

    public class PyArray$array_write_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_write_exposer(String string) {
            super(string, 2, 2);
        }

        public PyArray$array_write_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_write_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyArray)this.self).array_write(pyObject);
            return Py.None;
        }
    }

    public class PyArray$array_tolist_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_tolist_exposer(String string) {
            super(string, 1, 1);
        }

        public PyArray$array_tolist_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_tolist_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyArray)this.self).array_tolist();
        }
    }

    public class PyArray$array_tostring_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_tostring_exposer(String string) {
            super(string, 1, 1);
        }

        public PyArray$array_tostring_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyArray$array_tostring_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyArray)this.self).array_tostring();
        }
    }

    public class PyArray$typecode_descriptor
    extends PyDataDescr {
        public PyArray$typecode_descriptor() {
            super(PyArray.class, "typecode", String.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyArray)pyObject).getTypecode();
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyArray$itemsize_descriptor
    extends PyDataDescr {
        public PyArray$itemsize_descriptor() {
            super(PyArray.class, "itemsize", Integer.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return Py.newInteger(((PyArray)pyObject).getItemsize());
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyArray$exposed___new__
    extends PyOverridableNew {
        public PyObject createOfType(boolean bl, PyObject[] pyObjectArray, String[] stringArray) {
            PyArray pyArray = new PyArray(this.for_type);
            if (bl) {
                pyArray.array_init(pyObjectArray, stringArray);
            }
            return pyArray;
        }

        public PyObject createOfSubtype(PyType pyType) {
            return new PyArrayDerived(pyType);
        }
    }

    public class PyArray$PyExposer
    extends TypeExposer.BaseTypeBuilder {
        public PyArray$PyExposer() {
            PyBuiltinFunction[] pyBuiltinFunctionArray = new PyBuiltinFunction[]{new PyArray$array_init_exposer("init"), new PyArray$array___ne___exposer("__ne__"), new PyArray$array___eq___exposer("__eq__"), new PyArray$array___lt___exposer("__lt__"), new PyArray$array___le___exposer("__le__"), new PyArray$array___gt___exposer("__gt__"), new PyArray$array___ge___exposer("__ge__"), new PyArray$array___contains___exposer("__contains__"), new PyArray$array___delitem___exposer("__delitem__"), new PyArray$array___setitem___exposer("__setitem__"), new PyArray$array___getitem___exposer("__getitem__"), new PyArray$array___nonzero___exposer("__nonzero__"), new PyArray$array___getslice___exposer("__getslice__"), new PyArray$array___setslice___exposer("__setslice__"), new PyArray$array___delslice___exposer("__delslice__"), new PyArray$array_append_exposer("append"), new PyArray$array_byteswap_exposer("byteswap"), new PyArray$array_count_exposer("count"), new PyArray$array_extend_exposer("extend"), new PyArray$array_fromfile_exposer("fromfile"), new PyArray$array_fromlist_exposer("fromlist"), new PyArray$array_index_exposer("index"), new PyArray$array_insert_exposer("insert"), new PyArray$array_pop_exposer("pop"), new PyArray$array_remove_exposer("remove"), new PyArray$array_reverse_exposer("reverse"), new PyArray$array_tofile_exposer("tofile"), new PyArray$array_write_exposer("write"), new PyArray$array_tolist_exposer("tolist"), new PyArray$array_tostring_exposer("tostring")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyArray$typecode_descriptor(), new PyArray$itemsize_descriptor()};
            super("array", PyArray.class, PyObject.class, pyBuiltinFunctionArray, pyDataDescrArray, new PyArray$exposed___new__());
        }
    }
}

