/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.generate.TypeExposer;

public abstract class PyBuiltinFunction
extends PyObject {
    protected Info info;

    protected PyBuiltinFunction(PyType pyType, Info info) {
        super(pyType);
        this.info = info;
    }

    protected PyBuiltinFunction(Info info) {
        this.info = info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public abstract PyBuiltinFunction bind(PyObject var1);

    public PyObject getSelf() {
        return Py.None;
    }

    public String toString() {
        PyObject pyObject = this.getSelf();
        if (pyObject == null) {
            return "<built-in function " + this.info.getName() + ">";
        }
        String string = pyObject.getType().fastGetName();
        return "<built-in method " + this.info.getName() + " of " + string + " object>";
    }

    public PyObject fastGetName() {
        return Py.newString(this.info.getName());
    }

    public PyObject fastGetDoc() {
        return Py.None;
    }

    public PyObject makeCall() {
        return this;
    }

    static {
        PyType.addBuilder(PyBuiltinFunction.class, new PyBuiltinFunction$PyExposer());
    }

    public static class DefaultInfo
    implements Info {
        private String name;
        private int maxargs;
        private int minargs;

        public DefaultInfo(String name, int minargs, int maxargs) {
            this.name = name;
            this.minargs = minargs;
            this.maxargs = maxargs;
        }

        public DefaultInfo(String name) {
            this(name, -1, -1);
        }

        public String getName() {
            return this.name;
        }

        public int getMaxargs() {
            return this.maxargs;
        }

        public int getMinargs() {
            return this.minargs;
        }

        public static boolean check(int nargs, int minargs, int maxargs) {
            if (nargs < minargs) {
                return false;
            }
            return maxargs == -1 || nargs <= maxargs;
        }

        public static PyException unexpectedCall(int nargs, boolean keywords, String name, int minargs, int maxargs) {
            String argsblurb;
            if (keywords) {
                return Py.TypeError(name + "() takes no keyword arguments");
            }
            if (minargs == maxargs) {
                argsblurb = minargs == 0 ? "no arguments" : (minargs == 1 ? "exactly one argument" : minargs + " arguments");
            } else {
                if (maxargs == -1) {
                    return Py.TypeError(name + "() requires at least " + minargs + " (" + nargs + " given)");
                }
                argsblurb = minargs <= 0 ? "at most " + maxargs + " arguments" : minargs + "-" + maxargs + " arguments";
            }
            return Py.TypeError(name + "() takes " + argsblurb + " (" + nargs + " given)");
        }

        public PyException unexpectedCall(int nargs, boolean keywords) {
            return DefaultInfo.unexpectedCall(nargs, keywords, this.name, this.minargs, this.maxargs);
        }
    }

    public static interface Info {
        public String getName();

        public int getMaxargs();

        public int getMinargs();

        public PyException unexpectedCall(int var1, boolean var2);
    }

    public class PyBuiltinFunction$__self___descriptor
    extends PyDataDescr {
        public PyBuiltinFunction$__self___descriptor() {
            super(PyBuiltinFunction.class, "__self__", PyObject.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyBuiltinFunction)pyObject).getSelf();
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyBuiltinFunction$__doc___descriptor
    extends PyDataDescr {
        public PyBuiltinFunction$__doc___descriptor() {
            super(PyBuiltinFunction.class, "__doc__", PyObject.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyBuiltinFunction)pyObject).fastGetDoc();
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyBuiltinFunction$__name___descriptor
    extends PyDataDescr {
        public PyBuiltinFunction$__name___descriptor() {
            super(PyBuiltinFunction.class, "__name__", PyObject.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyBuiltinFunction)pyObject).fastGetName();
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyBuiltinFunction$__call___descriptor
    extends PyDataDescr {
        public PyBuiltinFunction$__call___descriptor() {
            super(PyBuiltinFunction.class, "__call__", PyObject.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyBuiltinFunction)pyObject).makeCall();
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyBuiltinFunction$PyExposer
    extends TypeExposer.BaseTypeBuilder {
        public PyBuiltinFunction$PyExposer() {
            PyBuiltinFunction[] pyBuiltinFunctionArray = new PyBuiltinFunction[]{};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyBuiltinFunction$__self___descriptor(), new PyBuiltinFunction$__doc___descriptor(), new PyBuiltinFunction$__name___descriptor(), new PyBuiltinFunction$__call___descriptor()};
            super("builtin_function_or_method", PyBuiltinFunction.class, Object.class, pyBuiltinFunctionArray, pyDataDescrArray, null);
        }
    }
}

