/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.ExtraMath;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyComplexDerived;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.generate.TypeExposer;

public class PyComplex
extends PyObject {
    public double real;
    public double imag;
    static PyComplex J;
    public static final PyType TYPE;

    @ExposedNew
    public static PyObject complex_new(PyNewWrapper pyNewWrapper, boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
        PyComplex pyComplex;
        PyObject pyObject;
        PyObject pyObject2;
        block18: {
            if (pyObjectArray.length == 0) {
                if (pyNewWrapper.for_type == pyType) {
                    return new PyComplex(0.0, 0.0);
                }
                return new PyComplexDerived(pyType, 0.0, 0.0);
            }
            if (pyObjectArray.length > 2) {
                throw Py.TypeError("complex() takes at most 2 arguments (" + pyObjectArray.length + " given)");
            }
            ArgParser argParser = new ArgParser("complex", pyObjectArray, stringArray, "real", "imag");
            pyObject2 = argParser.getPyObject(0, Py.Zero);
            pyObject = argParser.getPyObject(1, null);
            if (pyObject != null) {
                if (pyObject2 instanceof PyString) {
                    throw Py.TypeError("complex() can't take second arg if first is a string");
                }
                if (pyObject instanceof PyString) {
                    throw Py.TypeError("complex() second arg can't be a string");
                }
            }
            pyComplex = null;
            try {
                pyComplex = pyObject2.__complex__();
            }
            catch (PyException pyException) {
                if (Py.matchException(pyException, Py.AttributeError)) break block18;
                throw pyException;
            }
        }
        try {
            if (pyComplex == null) {
                pyComplex = new PyComplex(pyObject2.__float__().getValue(), 0.0);
            }
            if (pyObject != null) {
                if (pyComplex == pyObject2) {
                    pyComplex = new PyComplex(pyComplex.real, pyComplex.imag);
                }
                if (pyObject instanceof PyComplex) {
                    PyComplex pyComplex2 = (PyComplex)pyObject;
                    pyComplex.real -= pyComplex2.imag;
                    pyComplex.imag += pyComplex2.real;
                } else {
                    pyComplex.imag += pyObject.__float__().getValue();
                }
            }
            if (pyNewWrapper.for_type == pyType) {
                return pyComplex;
            }
            return new PyComplexDerived(pyType, pyComplex.real, pyComplex.imag);
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, Py.AttributeError)) {
                PyObject pyObject3;
                PyObject pyObject4 = pyObject3 = pyComplex == null ? pyObject2 : pyObject;
                if (!(pyObject3 instanceof PyInstance)) {
                    throw Py.TypeError("complex() argument must be a string or a number");
                }
            }
            throw pyException;
        }
    }

    public PyComplex(PyType pyType, double d, double d2) {
        super(pyType);
        this.real = d;
        this.imag = d2;
    }

    public PyComplex(double d, double d2) {
        this(TYPE, d, d2);
    }

    public final PyFloat getReal() {
        return Py.newFloat(this.real);
    }

    public final PyFloat getImag() {
        return Py.newFloat(this.imag);
    }

    public static String toString(double d) {
        if (d == Math.floor(d) && d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
            return Long.toString((long)d);
        }
        return Double.toString(d);
    }

    public String toString() {
        return this.complex_toString();
    }

    final String complex_toString() {
        if (this.real == 0.0) {
            return PyComplex.toString(this.imag) + "j";
        }
        if (this.imag >= 0.0) {
            return "(" + PyComplex.toString(this.real) + "+" + PyComplex.toString(this.imag) + "j)";
        }
        return "(" + PyComplex.toString(this.real) + "-" + PyComplex.toString(-this.imag) + "j)";
    }

    public int hashCode() {
        return this.complex___hash__();
    }

    final int complex___hash__() {
        if (this.imag == 0.0) {
            return new PyFloat(this.real).hashCode();
        }
        long l = Double.doubleToLongBits(this.real) ^ Double.doubleToLongBits(this.imag);
        return (int)l ^ (int)(l >> 32);
    }

    public boolean __nonzero__() {
        return this.complex___nonzero__();
    }

    final boolean complex___nonzero__() {
        return this.real != 0.0 && this.imag != 0.0;
    }

    public int __cmp__(PyObject pyObject) {
        return this.complex___cmp__(pyObject);
    }

    final int complex___cmp__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return -2;
        }
        PyComplex pyComplex = this.coerce(pyObject);
        double d = pyComplex.real;
        double d2 = pyComplex.imag;
        if (this.real == d && this.imag == d2) {
            return 0;
        }
        if (this.real != d) {
            return this.real < d ? -1 : 1;
        }
        return this.imag < d2 ? -1 : 1;
    }

    public PyObject __eq__(PyObject pyObject) {
        return this.complex___eq__(pyObject);
    }

    final PyObject complex___eq__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        PyComplex pyComplex = this.coerce(pyObject);
        return Py.newBoolean(this.real == pyComplex.real && this.imag == pyComplex.imag);
    }

    public PyObject __ne__(PyObject pyObject) {
        return this.complex___ne__(pyObject);
    }

    final PyObject complex___ne__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        PyComplex pyComplex = this.coerce(pyObject);
        return Py.newBoolean(this.real != pyComplex.real || this.imag != pyComplex.imag);
    }

    private PyObject unsupported_comparison(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        throw Py.TypeError("cannot compare complex numbers using <, <=, >, >=");
    }

    public PyObject __ge__(PyObject pyObject) {
        return this.complex___ge__(pyObject);
    }

    final PyObject complex___ge__(PyObject pyObject) {
        return this.unsupported_comparison(pyObject);
    }

    public PyObject __gt__(PyObject pyObject) {
        return this.complex___gt__(pyObject);
    }

    final PyObject complex___gt__(PyObject pyObject) {
        return this.unsupported_comparison(pyObject);
    }

    public PyObject __le__(PyObject pyObject) {
        return this.complex___le__(pyObject);
    }

    final PyObject complex___le__(PyObject pyObject) {
        return this.unsupported_comparison(pyObject);
    }

    public PyObject __lt__(PyObject pyObject) {
        return this.complex___lt__(pyObject);
    }

    final PyObject complex___lt__(PyObject pyObject) {
        return this.unsupported_comparison(pyObject);
    }

    public Object __coerce_ex__(PyObject pyObject) {
        if (pyObject instanceof PyComplex) {
            return pyObject;
        }
        if (pyObject instanceof PyFloat) {
            return new PyComplex(((PyFloat)pyObject).getValue(), 0.0);
        }
        if (pyObject instanceof PyInteger) {
            return new PyComplex(((PyInteger)pyObject).getValue(), 0.0);
        }
        if (pyObject instanceof PyLong) {
            return new PyComplex(((PyLong)pyObject).doubleValue(), 0.0);
        }
        return Py.None;
    }

    private final boolean canCoerce(PyObject pyObject) {
        return pyObject instanceof PyComplex || pyObject instanceof PyFloat || pyObject instanceof PyInteger || pyObject instanceof PyLong;
    }

    private final PyComplex coerce(PyObject pyObject) {
        if (pyObject instanceof PyComplex) {
            return (PyComplex)pyObject;
        }
        if (pyObject instanceof PyFloat) {
            return new PyComplex(((PyFloat)pyObject).getValue(), 0.0);
        }
        if (pyObject instanceof PyInteger) {
            return new PyComplex(((PyInteger)pyObject).getValue(), 0.0);
        }
        if (pyObject instanceof PyLong) {
            return new PyComplex(((PyLong)pyObject).doubleValue(), 0.0);
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject pyObject) {
        return this.complex___add__(pyObject);
    }

    final PyObject complex___add__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        PyComplex pyComplex = this.coerce(pyObject);
        return new PyComplex(this.real + pyComplex.real, this.imag + pyComplex.imag);
    }

    public PyObject __radd__(PyObject pyObject) {
        return this.complex___radd__(pyObject);
    }

    final PyObject complex___radd__(PyObject pyObject) {
        return this.__add__(pyObject);
    }

    private static final PyObject _sub(PyComplex pyComplex, PyComplex pyComplex2) {
        return new PyComplex(pyComplex.real - pyComplex2.real, pyComplex.imag - pyComplex2.imag);
    }

    public PyObject __sub__(PyObject pyObject) {
        return this.complex___sub__(pyObject);
    }

    final PyObject complex___sub__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._sub(this, this.coerce(pyObject));
    }

    public PyObject __rsub__(PyObject pyObject) {
        return this.complex___rsub__(pyObject);
    }

    final PyObject complex___rsub__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._sub(this.coerce(pyObject), this);
    }

    private static final PyObject _mul(PyComplex pyComplex, PyComplex pyComplex2) {
        return new PyComplex(pyComplex.real * pyComplex2.real - pyComplex.imag * pyComplex2.imag, pyComplex.real * pyComplex2.imag + pyComplex.imag * pyComplex2.real);
    }

    public PyObject __mul__(PyObject pyObject) {
        return this.complex___mul__(pyObject);
    }

    final PyObject complex___mul__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._mul(this, this.coerce(pyObject));
    }

    public PyObject __rmul__(PyObject pyObject) {
        return this.complex___rmul__(pyObject);
    }

    final PyObject complex___rmul__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._mul(this.coerce(pyObject), this);
    }

    private static final PyObject _div(PyComplex pyComplex, PyComplex pyComplex2) {
        double d;
        double d2 = pyComplex2.real < 0.0 ? -pyComplex2.real : pyComplex2.real;
        double d3 = d = pyComplex2.imag < 0.0 ? -pyComplex2.imag : pyComplex2.imag;
        if (d2 >= d) {
            if (d2 == 0.0) {
                throw Py.ZeroDivisionError("complex division");
            }
            double d4 = pyComplex2.imag / pyComplex2.real;
            double d5 = pyComplex2.real + pyComplex2.imag * d4;
            return new PyComplex((pyComplex.real + pyComplex.imag * d4) / d5, (pyComplex.imag - pyComplex.real * d4) / d5);
        }
        double d6 = pyComplex2.real / pyComplex2.imag;
        double d7 = pyComplex2.real * d6 + pyComplex2.imag;
        return new PyComplex((pyComplex.real * d6 + pyComplex.imag) / d7, (pyComplex.imag * d6 - pyComplex.real) / d7);
    }

    public PyObject __div__(PyObject pyObject) {
        return this.complex___div__(pyObject);
    }

    final PyObject complex___div__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic complex division");
        }
        return PyComplex._div(this, this.coerce(pyObject));
    }

    public PyObject __rdiv__(PyObject pyObject) {
        return this.complex___rdiv__(pyObject);
    }

    final PyObject complex___rdiv__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic complex division");
        }
        return PyComplex._div(this.coerce(pyObject), this);
    }

    public PyObject __floordiv__(PyObject pyObject) {
        return this.complex___floordiv__(pyObject);
    }

    final PyObject complex___floordiv__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._divmod(this, this.coerce(pyObject)).__finditem__(0);
    }

    public PyObject __rfloordiv__(PyObject pyObject) {
        return this.complex___floordiv__(pyObject);
    }

    final PyObject complex___rfloordiv__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._divmod(this.coerce(pyObject), this).__finditem__(0);
    }

    public PyObject __truediv__(PyObject pyObject) {
        return this.complex___truediv__(pyObject);
    }

    final PyObject complex___truediv__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._div(this, this.coerce(pyObject));
    }

    public PyObject __rtruediv__(PyObject pyObject) {
        return this.complex___rtruediv__(pyObject);
    }

    final PyObject complex___rtruediv__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._div(this.coerce(pyObject), this);
    }

    public PyObject __mod__(PyObject pyObject) {
        return this.complex___mod__(pyObject);
    }

    final PyObject complex___mod__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._mod(this, this.coerce(pyObject));
    }

    public PyObject __rmod__(PyObject pyObject) {
        return this.complex___rmod__(pyObject);
    }

    final PyObject complex___rmod__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._mod(this.coerce(pyObject), this);
    }

    private static PyObject _mod(PyComplex pyComplex, PyComplex pyComplex2) {
        PyComplex pyComplex3 = (PyComplex)PyComplex._div(pyComplex, pyComplex2);
        pyComplex3.real = Math.floor(pyComplex3.real);
        pyComplex3.imag = 0.0;
        return pyComplex.__sub__(pyComplex3.__mul__(pyComplex2));
    }

    public PyObject __divmod__(PyObject pyObject) {
        return this.complex___divmod__(pyObject);
    }

    final PyObject complex___divmod__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._divmod(this, this.coerce(pyObject));
    }

    public PyObject __rdivmod__(PyObject pyObject) {
        return this.complex___rdivmod__(pyObject);
    }

    final PyObject complex___rdivmod__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._divmod(this.coerce(pyObject), this);
    }

    private static PyObject _divmod(PyComplex pyComplex, PyComplex pyComplex2) {
        PyComplex pyComplex3 = (PyComplex)PyComplex._div(pyComplex, pyComplex2);
        pyComplex3.real = Math.floor(pyComplex3.real);
        pyComplex3.imag = 0.0;
        return new PyTuple(pyComplex3, pyComplex.__sub__(pyComplex3.__mul__(pyComplex2)));
    }

    private static PyObject ipow(PyComplex pyComplex, int n) {
        int n2 = n;
        if (n2 < 0) {
            n2 = -n2;
        }
        double d = pyComplex.real;
        double d2 = pyComplex.imag;
        double d3 = 1.0;
        double d4 = 0.0;
        while (n2 > 0) {
            double d5;
            if ((n2 & 1) != 0) {
                d5 = d3 * d - d4 * d2;
                d4 = d4 * d + d3 * d2;
                d3 = d5;
            }
            if ((n2 >>= 1) == 0) break;
            d5 = d * d - d2 * d2;
            d2 = d * d2 * 2.0;
            d = d5;
        }
        PyComplex pyComplex2 = new PyComplex(d3, d4);
        if (n < 0) {
            return new PyComplex(1.0, 0.0).__div__(pyComplex2);
        }
        return pyComplex2;
    }

    public PyObject __pow__(PyObject pyObject, PyObject pyObject2) {
        return this.complex___pow__(pyObject, pyObject2);
    }

    final PyObject complex___pow__(PyObject pyObject, PyObject pyObject2) {
        if (pyObject2 != null) {
            throw Py.ValueError("complex modulo");
        }
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._pow(this, this.coerce(pyObject));
    }

    public PyObject __rpow__(PyObject pyObject) {
        return this.complex___rpow__(pyObject);
    }

    final PyObject complex___rpow__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._pow(this.coerce(pyObject), this);
    }

    public static PyObject _pow(PyComplex pyComplex, PyComplex pyComplex2) {
        double d = pyComplex.real;
        double d2 = pyComplex.imag;
        double d3 = pyComplex2.real;
        double d4 = pyComplex2.imag;
        if (d3 == 0.0 && d4 == 0.0) {
            return new PyComplex(1.0, 0.0);
        }
        if (d == 0.0 && d2 == 0.0 && (d4 != 0.0 || d3 < 0.0)) {
            throw Py.ZeroDivisionError("0.0 to a negative or complex power");
        }
        int n = (int)d3;
        if (d4 == 0.0 && d3 == (double)n && n >= -128 && n <= 128) {
            return PyComplex.ipow(pyComplex, n);
        }
        double d5 = ExtraMath.hypot(d, d2);
        double d6 = Math.pow(d5, d3);
        double d7 = Math.atan2(d2, d);
        double d8 = d7 * d3;
        if (d4 != 0.0) {
            d6 /= Math.exp(d7 * d4);
            d8 += d4 * Math.log(d5);
        }
        return new PyComplex(d6 * Math.cos(d8), d6 * Math.sin(d8));
    }

    public PyObject __neg__() {
        return this.complex___neg__();
    }

    final PyObject complex___neg__() {
        return new PyComplex(-this.real, -this.imag);
    }

    public PyObject __pos__() {
        return this.complex___pos__();
    }

    final PyObject complex___pos__() {
        return new PyComplex(this.real, this.imag);
    }

    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    public PyObject __abs__() {
        return this.complex___abs__();
    }

    final PyObject complex___abs__() {
        return new PyFloat(ExtraMath.hypot(this.real, this.imag));
    }

    public PyObject __int__() {
        return this.complex___int__();
    }

    final PyInteger complex___int__() {
        throw Py.TypeError("can't convert complex to int; use e.g. int(abs(z))");
    }

    public PyLong __long__() {
        return this.complex___long__();
    }

    final PyLong complex___long__() {
        throw Py.TypeError("can't convert complex to long; use e.g. long(abs(z))");
    }

    public PyFloat __float__() {
        return this.complex___float__();
    }

    final PyFloat complex___float__() {
        throw Py.TypeError("can't convert complex to float; use e.g. abs(z)");
    }

    public PyComplex __complex__() {
        return new PyComplex(this.real, this.imag);
    }

    public PyComplex conjugate() {
        return this.complex_conjugate();
    }

    final PyComplex complex_conjugate() {
        return new PyComplex(this.real, -this.imag);
    }

    final PyTuple complex___getnewargs__() {
        return new PyTuple(new PyComplex(this.real, this.imag));
    }

    public PyTuple __getnewargs__() {
        return this.complex___getnewargs__();
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    static {
        PyType.addBuilder(PyComplex.class, new PyComplex$PyExposer());
        J = new PyComplex(0.0, 1.0);
        TYPE = PyType.fromClass(PyComplex.class);
    }

    public class PyComplex$complex_toString_exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex_toString_exposer(String string) {
            super(string, 1, 1);
        }

        public PyComplex$complex_toString_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex_toString_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newString(((PyComplex)this.self).complex_toString());
        }
    }

    public class PyComplex$complex___hash___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___hash___exposer(String string) {
            super(string, 1, 1);
        }

        public PyComplex$complex___hash___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___hash___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyComplex)this.self).complex___hash__());
        }
    }

    public class PyComplex$complex___nonzero___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___nonzero___exposer(String string) {
            super(string, 1, 1);
        }

        public PyComplex$complex___nonzero___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___nonzero___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyComplex)this.self).complex___nonzero__());
        }
    }

    public class PyComplex$complex___cmp___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___cmp___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___cmp___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___cmp___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            int n = ((PyComplex)this.self).complex___cmp__(pyObject);
            if (n == -2) {
                throw Py.TypeError("complex.__cmp__(x,y) requires y to be 'complex', not a '" + pyObject.getType().fastGetName() + "'");
            }
            return Py.newInteger(n);
        }
    }

    public class PyComplex$complex___eq___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___eq___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___eq___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___eq___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___eq__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___ne___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___ne___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___ne___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___ne___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___ne__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___ge___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___ge___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___ge___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___ge___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___ge__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___gt___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___gt___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___gt___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___gt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___gt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___le___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___le___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___le___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___le___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___le__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___lt___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___lt___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___lt___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___lt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___lt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___add___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___add___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___add___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___add___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___add__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___radd___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___radd___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___radd___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___radd___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___radd__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___sub___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___sub___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___sub___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___sub___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___sub__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rsub___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rsub___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___rsub___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___rsub___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rsub__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___mul___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___mul___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___mul___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___mul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___mul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rmul___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rmul___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___rmul___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___rmul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rmul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___div___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___div___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___div___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___div___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___div__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rdiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rdiv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___rdiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___rdiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rdiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___floordiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___floordiv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___floordiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___floordiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___floordiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rfloordiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rfloordiv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___rfloordiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___rfloordiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rfloordiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___truediv___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___truediv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___truediv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___truediv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___truediv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rtruediv___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rtruediv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___rtruediv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___rtruediv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rtruediv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___mod___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___mod___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___mod___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___mod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___mod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rmod___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___rmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___rmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___divmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___divmod___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___divmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___divmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___divmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___rdivmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rdivmod___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___rdivmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___rdivmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rdivmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___pow___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___pow___exposer(String string) {
            super(string, 2, 3);
        }

        public PyComplex$complex___pow___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___pow___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyComplex)this.self).complex___pow__(pyObject, pyObject2);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyComplex)this.self).complex___pow__(pyObject, null);
        }
    }

    public class PyComplex$complex___rpow___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___rpow___exposer(String string) {
            super(string, 2, 2);
        }

        public PyComplex$complex___rpow___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___rpow___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyComplex)this.self).complex___rpow__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyComplex$complex___neg___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___neg___exposer(String string) {
            super(string, 1, 1);
        }

        public PyComplex$complex___neg___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___neg___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___neg__();
        }
    }

    public class PyComplex$complex___pos___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___pos___exposer(String string) {
            super(string, 1, 1);
        }

        public PyComplex$complex___pos___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___pos___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___pos__();
        }
    }

    public class PyComplex$complex___abs___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___abs___exposer(String string) {
            super(string, 1, 1);
        }

        public PyComplex$complex___abs___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___abs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___abs__();
        }
    }

    public class PyComplex$complex___int___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___int___exposer(String string) {
            super(string, 1, 1);
        }

        public PyComplex$complex___int___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___int___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___int__();
        }
    }

    public class PyComplex$complex___long___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___long___exposer(String string) {
            super(string, 1, 1);
        }

        public PyComplex$complex___long___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___long___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___long__();
        }
    }

    public class PyComplex$complex___float___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___float___exposer(String string) {
            super(string, 1, 1);
        }

        public PyComplex$complex___float___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___float___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___float__();
        }
    }

    public class PyComplex$complex_conjugate_exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex_conjugate_exposer(String string) {
            super(string, 1, 1);
        }

        public PyComplex$complex_conjugate_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex_conjugate_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex_conjugate();
        }
    }

    public class PyComplex$complex___getnewargs___exposer
    extends PyBuiltinMethodNarrow {
        public PyComplex$complex___getnewargs___exposer(String string) {
            super(string, 1, 1);
        }

        public PyComplex$complex___getnewargs___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyComplex$complex___getnewargs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyComplex)this.self).complex___getnewargs__();
        }
    }

    public class PyComplex$imag_descriptor
    extends PyDataDescr {
        public PyComplex$imag_descriptor() {
            super(PyComplex.class, "imag", Double.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return Py.newFloat(((PyComplex)pyObject).imag);
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyComplex$real_descriptor
    extends PyDataDescr {
        public PyComplex$real_descriptor() {
            super(PyComplex.class, "real", Double.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return Py.newFloat(((PyComplex)pyObject).real);
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyComplex$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return PyComplex.complex_new(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class PyComplex$PyExposer
    extends TypeExposer.BaseTypeBuilder {
        public PyComplex$PyExposer() {
            PyBuiltinFunction[] pyBuiltinFunctionArray = new PyBuiltinFunction[]{new PyComplex$complex_toString_exposer("__repr__"), new PyComplex$complex_toString_exposer("__str__"), new PyComplex$complex___hash___exposer("__hash__"), new PyComplex$complex___nonzero___exposer("__nonzero__"), new PyComplex$complex___cmp___exposer("__cmp__"), new PyComplex$complex___eq___exposer("__eq__"), new PyComplex$complex___ne___exposer("__ne__"), new PyComplex$complex___ge___exposer("__ge__"), new PyComplex$complex___gt___exposer("__gt__"), new PyComplex$complex___le___exposer("__le__"), new PyComplex$complex___lt___exposer("__lt__"), new PyComplex$complex___add___exposer("__add__"), new PyComplex$complex___radd___exposer("__radd__"), new PyComplex$complex___sub___exposer("__sub__"), new PyComplex$complex___rsub___exposer("__rsub__"), new PyComplex$complex___mul___exposer("__mul__"), new PyComplex$complex___rmul___exposer("__rmul__"), new PyComplex$complex___div___exposer("__div__"), new PyComplex$complex___rdiv___exposer("__rdiv__"), new PyComplex$complex___floordiv___exposer("__floordiv__"), new PyComplex$complex___rfloordiv___exposer("__rfloordiv__"), new PyComplex$complex___truediv___exposer("__truediv__"), new PyComplex$complex___rtruediv___exposer("__rtruediv__"), new PyComplex$complex___mod___exposer("__mod__"), new PyComplex$complex___rmod___exposer("__rmod__"), new PyComplex$complex___divmod___exposer("__divmod__"), new PyComplex$complex___rdivmod___exposer("__rdivmod__"), new PyComplex$complex___pow___exposer("__pow__"), new PyComplex$complex___rpow___exposer("__rpow__"), new PyComplex$complex___neg___exposer("__neg__"), new PyComplex$complex___pos___exposer("__pos__"), new PyComplex$complex___abs___exposer("__abs__"), new PyComplex$complex___int___exposer("__int__"), new PyComplex$complex___long___exposer("__long__"), new PyComplex$complex___float___exposer("__float__"), new PyComplex$complex_conjugate_exposer("conjugate"), new PyComplex$complex___getnewargs___exposer("__getnewargs__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyComplex$imag_descriptor(), new PyComplex$real_descriptor()};
            super("complex", PyComplex.class, Object.class, pyBuiltinFunctionArray, pyDataDescrArray, new PyComplex$exposed___new__());
        }
    }
}

