/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyDescriptor;
import org.python.core.PyObject;
import org.python.core.PyType;

public class PyDataDescr
extends PyDescriptor {
    protected Class ofType;

    public PyDataDescr(Class onType, String name, Class ofType) {
        this(PyType.fromClass(onType), name, ofType);
    }

    public PyDataDescr(PyType onType, String name, Class ofType) {
        this.dtype = onType;
        this.name = name;
        this.ofType = ofType;
    }

    public String getName() {
        return this.name;
    }

    public PyObject __get__(PyObject obj, PyObject type) {
        if (obj != null) {
            PyType objtype = obj.getType();
            if (objtype != this.dtype && !objtype.isSubType(this.dtype)) {
                throw this.get_wrongtype(objtype);
            }
            Object v = this.invokeGet(obj);
            if (v == null) {
                obj.noAttributeError(this.name);
            }
            return Py.java2py(v);
        }
        return this;
    }

    public Object invokeGet(PyObject obj) {
        throw new UnsupportedOperationException("Must be overriden by a subclass");
    }

    public void __set__(PyObject obj, PyObject value) {
        PyType objtype = obj.getType();
        if (objtype != this.dtype && !objtype.isSubType(this.dtype)) {
            throw this.get_wrongtype(objtype);
        }
        Object converted = value.__tojava__(this.ofType);
        if (converted == Py.NoConversion) {
            throw Py.TypeError("");
        }
        this.invokeSet(obj, converted);
    }

    public void invokeSet(PyObject obj, Object converted) {
        throw new UnsupportedOperationException("Must be overriden by a subclass");
    }

    public void __delete__(PyObject obj) {
        if (obj != null) {
            PyType objtype = obj.getType();
            if (objtype != this.dtype && !objtype.isSubType(this.dtype)) {
                throw this.get_wrongtype(objtype);
            }
            this.invokeDelete(obj);
        }
    }

    public void invokeDelete(PyObject obj) {
        throw new UnsupportedOperationException("Must be overriden by a subclass");
    }

    public boolean isDataDescr() {
        return true;
    }

    public String toString() {
        return "<member '" + this.name + "' of '" + this.dtype.fastGetName() + "' objects>";
    }
}

