/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.python.core.Py;
import org.python.core.PyDataDescr;
import org.python.core.PyObject;
import org.python.core.PyType;

public class PyFieldDescr
extends PyDataDescr {
    private Field field;
    private boolean readonly;

    public PyFieldDescr(String name, Class c, String field_name) {
        this(name, c, field_name, false);
    }

    public PyFieldDescr(String name, Class c, String field_name, boolean readonly) {
        super(PyType.fromClass(c), name, PyFieldDescr.get(c, field_name).getType());
        this.field = PyFieldDescr.get(c, field_name);
        this.readonly = readonly || Modifier.isFinal(this.field.getModifiers());
    }

    private static Field get(Class onClass, String name) {
        Field f;
        try {
            f = onClass.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw Py.SystemError("bogus attribute spec");
        }
        if (Modifier.isStatic(f.getModifiers())) {
            throw Py.SystemError("static attributes not supported");
        }
        return f;
    }

    public Object invokeGet(PyObject obj) {
        try {
            return this.field.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw Py.JavaError(e);
        }
        catch (IllegalAccessException e) {
            throw Py.JavaError(e);
        }
    }

    public void invokeSet(PyObject obj, Object converted) {
        try {
            this.field.set(obj, converted);
        }
        catch (IllegalArgumentException e) {
            throw Py.JavaError(e);
        }
        catch (IllegalAccessException e) {
            throw Py.JavaError(e);
        }
    }

    public boolean implementsDescrSet() {
        return !this.readonly;
    }
}

