/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFileDerived;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.io.BinaryIOWrapper;
import org.python.core.io.BufferedIOBase;
import org.python.core.io.BufferedIOMixin;
import org.python.core.io.BufferedRandom;
import org.python.core.io.BufferedReader;
import org.python.core.io.BufferedWriter;
import org.python.core.io.FileIO;
import org.python.core.io.LineBufferedRandom;
import org.python.core.io.LineBufferedWriter;
import org.python.core.io.RawIOBase;
import org.python.core.io.StreamIO;
import org.python.core.io.TextIOBase;
import org.python.core.io.TextIOWrapper;
import org.python.core.io.UniversalIOWrapper;
import org.python.expose.ExposedNew;
import org.python.expose.generate.TypeExposer;

public class PyFile
extends PyObject {
    public static final PyType TYPE;
    public PyObject name;
    public String mode;
    public boolean softspace = false;
    private boolean reading = false;
    private boolean writing = false;
    private boolean appending = false;
    private boolean updating = false;
    private boolean binary = false;
    private boolean universal = false;
    private TextIOBase file;
    private Closer closer;
    private static LinkedList closers;

    public PyFile() {
    }

    public PyFile(PyType pyType) {
        super(pyType);
    }

    public PyFile(RawIOBase rawIOBase, String string, String string2, int n) {
        this.parseMode(string2);
        this.file___init__(rawIOBase, string, string2, n);
    }

    public PyFile(InputStream inputStream, String string, String string2, int n, boolean bl) {
        this.parseMode(string2);
        this.file___init__((RawIOBase)new StreamIO(inputStream, bl), string, string2, n);
    }

    public PyFile(InputStream inputStream, String string, String string2, int n) {
        this(inputStream, string, string2, -1, true);
    }

    public PyFile(InputStream inputStream, String string, String string2) {
        this(inputStream, string, string2, -1);
    }

    public PyFile(InputStream inputStream, String string) {
        this(inputStream, string, "r");
    }

    public PyFile(InputStream inputStream) {
        this(inputStream, "<???>", "r");
    }

    public PyFile(OutputStream outputStream, String string, String string2, int n, boolean bl) {
        this.parseMode(string2);
        this.file___init__((RawIOBase)new StreamIO(outputStream, bl), string, string2, n);
    }

    public PyFile(OutputStream outputStream, String string, String string2, int n) {
        this(outputStream, string, string2, -1, true);
    }

    public PyFile(OutputStream outputStream, String string, String string2) {
        this(outputStream, string, string2, -1);
    }

    public PyFile(OutputStream outputStream, String string) {
        this(outputStream, string, "w");
    }

    public PyFile(OutputStream outputStream) {
        this(outputStream, "<???>", "w");
    }

    public PyFile(RandomAccessFile randomAccessFile, String string, String string2, int n) {
        this.file___init__((RawIOBase)new FileIO(randomAccessFile.getChannel(), this.parseMode(string2)), string, string2, n);
    }

    public PyFile(RandomAccessFile randomAccessFile, String string, String string2) {
        this(randomAccessFile, string, string2, -1);
    }

    public PyFile(RandomAccessFile randomAccessFile, String string) {
        this(randomAccessFile, string, "r+");
    }

    public PyFile(RandomAccessFile randomAccessFile) {
        this(randomAccessFile, "<???>", "r+");
    }

    public PyFile(String string, String string2, int n) {
        this.file___init__((RawIOBase)new FileIO(string, this.parseMode(string2)), string, string2, n);
    }

    @ExposedNew
    static final PyObject file_new(PyNewWrapper pyNewWrapper, boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
        PyFile pyFile;
        if (pyNewWrapper.for_type == pyType) {
            if (bl) {
                if (pyObjectArray.length == 0) {
                    pyFile = new PyFile();
                    pyFile.file___init__(pyObjectArray, stringArray);
                } else if (pyObjectArray[0] instanceof PyString || pyObjectArray[0] instanceof PyJavaInstance && ((PyJavaInstance)pyObjectArray[0]).javaProxy == String.class) {
                    pyFile = new PyFile();
                    pyFile.file___init__(pyObjectArray, stringArray);
                    pyFile.closer = new Closer(pyFile.file);
                } else {
                    PyJavaClass pyJavaClass = new PyJavaClass(PyFile.class);
                    pyFile = (PyFile)pyJavaClass.__call__(pyObjectArray, stringArray);
                }
            } else {
                pyFile = new PyFile();
            }
        } else {
            pyFile = new PyFileDerived(pyType);
        }
        return pyFile;
    }

    final void file___init__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("file", pyObjectArray, stringArray, new String[]{"name", "mode", "bufsize"}, 1);
        PyObject pyObject = argParser.getPyObject(0);
        if (!(pyObject instanceof PyString)) {
            throw Py.TypeError("coercing to Unicode: need string, '" + pyObject.getType().fastGetName() + "' type found");
        }
        String string = argParser.getString(1, "r");
        int n = argParser.getInt(2, -1);
        this.file___init__((RawIOBase)new FileIO(pyObject.toString(), this.parseMode(string)), pyObject, string, n);
    }

    private void file___init__(RawIOBase rawIOBase, String string, String string2, int n) {
        this.file___init__(rawIOBase, new PyString(string), string2, n);
    }

    private void file___init__(RawIOBase rawIOBase, PyObject pyObject, String string, int n) {
        this.name = pyObject;
        this.mode = string;
        BufferedIOBase bufferedIOBase = this.createBuffer(rawIOBase, n);
        this.file = this.universal ? new UniversalIOWrapper(bufferedIOBase) : (!this.binary ? new TextIOWrapper(bufferedIOBase) : new BinaryIOWrapper(bufferedIOBase));
    }

    private BufferedIOBase createBuffer(RawIOBase rawIOBase, int n) {
        BufferedIOMixin bufferedIOMixin;
        boolean bl;
        if (n < 0) {
            n = 8192;
        }
        boolean bl2 = bl = n == 1;
        if (this.updating) {
            bufferedIOMixin = bl ? new LineBufferedRandom(rawIOBase) : new BufferedRandom(rawIOBase, n);
        } else if (this.writing || this.appending) {
            bufferedIOMixin = bl ? new LineBufferedWriter(rawIOBase) : new BufferedWriter(rawIOBase, n);
        } else if (this.reading) {
            bufferedIOMixin = new BufferedReader(rawIOBase, bl ? 0 : n);
        } else {
            throw Py.ValueError("unknown mode: '" + this.mode + "'");
        }
        return bufferedIOMixin;
    }

    private String parseMode(String string) {
        if (string.length() == 0) {
            throw Py.ValueError("empty mode string");
        }
        String string2 = string;
        if (string.contains("U")) {
            this.universal = true;
            if ((string = string.replace("U", "")).length() == 0) {
                string = "r";
            } else if ("wa+".indexOf(string.charAt(0)) > -1) {
                throw Py.ValueError("universal newline mode can only be used with modes starting with 'r'");
            }
        }
        if ("rwa".indexOf(string.charAt(0)) == -1) {
            throw Py.ValueError("mode string must begin with one of 'r', 'w', 'a' or 'U', not '" + string2 + "'");
        }
        this.binary = string.contains("b");
        this.reading = string.contains("r");
        this.writing = string.contains("w");
        this.appending = string.contains("a");
        this.updating = string.contains("+");
        return (this.reading ? "r" : "") + (this.writing ? "w" : "") + (this.appending ? "a" : "") + (this.updating ? "+" : "");
    }

    final synchronized String file_read(int n) {
        this.checkClosed();
        return this.file.read(n);
    }

    public String read(int n) {
        return this.file_read(n);
    }

    public String read() {
        return this.file_read(-1);
    }

    final synchronized int file_readinto(PyObject pyObject) {
        this.checkClosed();
        return this.file.readinto(pyObject);
    }

    public int readinto(PyObject pyObject) {
        return this.file_readinto(pyObject);
    }

    final synchronized String file_readline(int n) {
        this.checkClosed();
        return this.file.readline(n);
    }

    public String readline(int n) {
        return this.file_readline(n);
    }

    public String readline() {
        return this.file_readline(-1);
    }

    final synchronized PyObject file_readlines(int n) {
        String string;
        int n2;
        this.checkClosed();
        PyList pyList = new PyList();
        int n3 = 0;
        while ((n2 = (string = this.file.readline(-1)).length()) != 0) {
            pyList.append(new PyString(string));
            if (n <= 0 || (n3 += n2) < n) continue;
        }
        return pyList;
    }

    public PyObject readlines(int n) {
        return this.file_readlines(n);
    }

    public PyObject readlines() {
        return this.file_readlines(0);
    }

    public PyObject __iter__() {
        return this.file___iter__();
    }

    final PyObject file___iter__() {
        this.checkClosed();
        return this;
    }

    public PyObject __iternext__() {
        return this.file___iternext__();
    }

    final synchronized PyObject file___iternext__() {
        this.checkClosed();
        String string = this.file.readline(-1);
        if (string.length() == 0) {
            return null;
        }
        return new PyString(string);
    }

    final PyObject file_next() {
        PyObject pyObject = this.__iternext__();
        if (pyObject == null) {
            throw Py.StopIteration("");
        }
        return pyObject;
    }

    public PyObject next() {
        return this.file_next();
    }

    final PyObject file_xreadlines() {
        this.checkClosed();
        return this;
    }

    public PyObject xreadlines() {
        return this.file_xreadlines();
    }

    final void file_write(PyObject pyObject) {
        if (pyObject instanceof PyUnicode) {
            this.file_write(pyObject.__str__().string);
        } else if (pyObject instanceof PyString) {
            this.file_write(((PyString)pyObject).string);
        } else {
            throw Py.TypeError("write requires a string as its argument");
        }
    }

    final synchronized void file_write(String string) {
        this.checkClosed();
        this.softspace = false;
        this.file.write(string);
    }

    public void write(String string) {
        this.file_write(string);
    }

    final synchronized void file_writelines(PyObject pyObject) {
        this.checkClosed();
        PyObject pyObject2 = Py.iter(pyObject, "writelines() requires an iterable argument");
        PyObject pyObject3 = null;
        while ((pyObject3 = pyObject2.__iternext__()) != null) {
            if (!(pyObject3 instanceof PyString)) {
                throw Py.TypeError("writelines() argument must be a sequence of strings");
            }
            this.file.write(pyObject3.toString());
        }
    }

    public void writelines(PyObject pyObject) {
        this.file_writelines(pyObject);
    }

    final synchronized long file_tell() {
        this.checkClosed();
        return this.file.tell();
    }

    public long tell() {
        return this.file_tell();
    }

    final synchronized void file_seek(long l, int n) {
        this.checkClosed();
        this.file.seek(l, n);
    }

    public void seek(long l, int n) {
        this.file_seek(l, n);
    }

    public void seek(long l) {
        this.file_seek(l, 0);
    }

    final synchronized void file_flush() {
        this.checkClosed();
        this.file.flush();
    }

    public void flush() {
        this.file_flush();
    }

    final synchronized void file_close() {
        if (this.closer != null) {
            this.closer.close();
            this.closer = null;
        } else {
            this.file.close();
        }
    }

    public void close() {
        this.file_close();
    }

    final void file_truncate(PyObject pyObject) {
        if (pyObject == null) {
            this.file_truncate();
            return;
        }
        try {
            this.file_truncate(pyObject.asLong(0));
        }
        catch (PyObject.ConversionException conversionException) {
            throw Py.TypeError("an integer is required");
        }
    }

    final synchronized void file_truncate(long l) {
        this.file.truncate(l);
    }

    public void truncate(long l) {
        this.file_truncate(l);
    }

    final synchronized void file_truncate() {
        this.file.truncate(this.file.tell());
    }

    public void truncate() {
        this.file_truncate();
    }

    public boolean isatty() {
        return this.file_isatty();
    }

    final boolean file_isatty() {
        return this.file.isatty();
    }

    public PyObject fileno() {
        return this.file_fileno();
    }

    final PyObject file_fileno() {
        return new PyJavaInstance(this.file.fileno());
    }

    final String file_toString() {
        StringBuffer stringBuffer = new StringBuffer("<");
        if (this.file.closed()) {
            stringBuffer.append("closed ");
        } else {
            stringBuffer.append("open ");
        }
        stringBuffer.append("file ");
        stringBuffer.append(this.name.__repr__());
        stringBuffer.append(", mode '");
        stringBuffer.append(this.mode);
        stringBuffer.append("' ");
        stringBuffer.append(Py.idstr(this));
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.file_toString();
    }

    final int file___cmp__(PyObject pyObject) {
        return super.__cmp__(pyObject);
    }

    final boolean file___nonzero__() {
        return super.__nonzero__();
    }

    private void checkClosed() {
        this.file.checkClosed();
    }

    public boolean getClosed() {
        return this.file.closed();
    }

    public PyObject getNewlines() {
        return this.file.getNewlines();
    }

    public PyObject getSoftspace() {
        return this.softspace ? Py.One : Py.Zero;
    }

    public void setSoftspace(PyObject pyObject) {
        this.softspace = pyObject.__nonzero__();
    }

    public void delSoftspace() {
        throw Py.TypeError("can't delete numeric/char attribute");
    }

    public Object __tojava__(Class clazz) {
        Object object = this.file.__tojava__(clazz);
        if (object == null) {
            object = super.__tojava__(clazz);
        }
        return object;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.closer != null) {
            this.closer.close();
        }
    }

    private static void initCloser() {
        try {
            Runtime.getRuntime().addShutdownHook(new PyFileCloser());
        }
        catch (SecurityException securityException) {
            Py.writeDebug("PyFile", "Can't register file closer hook");
        }
    }

    static {
        PyType.addBuilder(PyFile.class, new PyFile$PyExposer());
        TYPE = PyType.fromClass(PyFile.class);
        closers = new LinkedList();
        PyFile.initCloser();
    }

    private static class PyFileCloser
    extends Thread {
        public PyFileCloser() {
            super("Jython Shutdown File Closer");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (closers == null) {
                return;
            }
            LinkedList linkedList = closers;
            synchronized (linkedList) {
                while (closers.size() > 0) {
                    try {
                        ((Closer)closers.removeFirst()).doClose();
                    }
                    catch (PyException pyException) {}
                }
            }
        }
    }

    private static class Closer {
        private TextIOBase file;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Closer(TextIOBase file) {
            this.file = file;
            LinkedList linkedList = closers;
            synchronized (linkedList) {
                closers.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            LinkedList linkedList = closers;
            synchronized (linkedList) {
                if (!closers.remove(this)) {
                    return;
                }
            }
            this.doClose();
        }

        public void doClose() {
            this.file.close();
        }
    }

    public class PyFile$file___init___exposer
    extends PyBuiltinMethod {
        public PyFile$file___init___exposer(String string) {
            super(string);
        }

        public PyFile$file___init___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file___init___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyFile)this.self).file___init__(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyFile$file_read_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_read_exposer(String string) {
            super(string, 1, 2);
        }

        public PyFile$file_read_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_read_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newString(((PyFile)this.self).file_read(Py.py2int(pyObject)));
        }

        public PyObject __call__() {
            return Py.newString(((PyFile)this.self).file_read(-1));
        }
    }

    public class PyFile$file_readinto_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_readinto_exposer(String string) {
            super(string, 2, 2);
        }

        public PyFile$file_readinto_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_readinto_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyFile)this.self).file_readinto(pyObject));
        }
    }

    public class PyFile$file_readline_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_readline_exposer(String string) {
            super(string, 1, 2);
        }

        public PyFile$file_readline_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_readline_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newString(((PyFile)this.self).file_readline(Py.py2int(pyObject)));
        }

        public PyObject __call__() {
            return Py.newString(((PyFile)this.self).file_readline(-1));
        }
    }

    public class PyFile$file_readlines_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_readlines_exposer(String string) {
            super(string, 1, 2);
        }

        public PyFile$file_readlines_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_readlines_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyFile)this.self).file_readlines(Py.py2int(pyObject));
        }

        public PyObject __call__() {
            return ((PyFile)this.self).file_readlines(0);
        }
    }

    public class PyFile$file___iter___exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file___iter___exposer(String string) {
            super(string, 1, 1);
        }

        public PyFile$file___iter___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file___iter___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFile)this.self).file___iter__();
        }
    }

    public class PyFile$file___iternext___exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file___iternext___exposer(String string) {
            super(string, 1, 1);
        }

        public PyFile$file___iternext___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file___iternext___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFile)this.self).file___iternext__();
        }
    }

    public class PyFile$file_next_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_next_exposer(String string) {
            super(string, 1, 1);
        }

        public PyFile$file_next_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_next_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFile)this.self).file_next();
        }
    }

    public class PyFile$file_xreadlines_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_xreadlines_exposer(String string) {
            super(string, 1, 1);
        }

        public PyFile$file_xreadlines_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_xreadlines_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFile)this.self).file_xreadlines();
        }
    }

    public class PyFile$file_write_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_write_exposer(String string) {
            super(string, 2, 2);
        }

        public PyFile$file_write_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_write_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyFile)this.self).file_write(pyObject);
            return Py.None;
        }
    }

    public class PyFile$file_writelines_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_writelines_exposer(String string) {
            super(string, 2, 2);
        }

        public PyFile$file_writelines_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_writelines_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyFile)this.self).file_writelines(pyObject);
            return Py.None;
        }
    }

    public class PyFile$file_tell_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_tell_exposer(String string) {
            super(string, 1, 1);
        }

        public PyFile$file_tell_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_tell_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newLong(((PyFile)this.self).file_tell());
        }
    }

    public class PyFile$file_seek_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_seek_exposer(String string) {
            super(string, 2, 3);
        }

        public PyFile$file_seek_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_seek_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyFile)this.self).file_seek(Py.py2long(pyObject), Py.py2int(pyObject2));
            return Py.None;
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyFile)this.self).file_seek(Py.py2long(pyObject), 0);
            return Py.None;
        }
    }

    public class PyFile$file_flush_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_flush_exposer(String string) {
            super(string, 1, 1);
        }

        public PyFile$file_flush_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_flush_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            ((PyFile)this.self).file_flush();
            return Py.None;
        }
    }

    public class PyFile$file_close_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_close_exposer(String string) {
            super(string, 1, 1);
        }

        public PyFile$file_close_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_close_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            ((PyFile)this.self).file_close();
            return Py.None;
        }
    }

    public class PyFile$file_truncate_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_truncate_exposer(String string) {
            super(string, 1, 2);
        }

        public PyFile$file_truncate_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_truncate_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyFile)this.self).file_truncate(pyObject);
            return Py.None;
        }

        public PyObject __call__() {
            ((PyFile)this.self).file_truncate(null);
            return Py.None;
        }
    }

    public class PyFile$file_isatty_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_isatty_exposer(String string) {
            super(string, 1, 1);
        }

        public PyFile$file_isatty_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_isatty_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyFile)this.self).file_isatty());
        }
    }

    public class PyFile$file_fileno_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_fileno_exposer(String string) {
            super(string, 1, 1);
        }

        public PyFile$file_fileno_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_fileno_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFile)this.self).file_fileno();
        }
    }

    public class PyFile$file_toString_exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file_toString_exposer(String string) {
            super(string, 1, 1);
        }

        public PyFile$file_toString_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file_toString_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newString(((PyFile)this.self).file_toString());
        }
    }

    public class PyFile$file___cmp___exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file___cmp___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFile$file___cmp___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file___cmp___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            int n = ((PyFile)this.self).file___cmp__(pyObject);
            if (n == -2) {
                throw Py.TypeError("file.__cmp__(x,y) requires y to be 'file', not a '" + pyObject.getType().fastGetName() + "'");
            }
            return Py.newInteger(n);
        }
    }

    public class PyFile$file___nonzero___exposer
    extends PyBuiltinMethodNarrow {
        public PyFile$file___nonzero___exposer(String string) {
            super(string, 1, 1);
        }

        public PyFile$file___nonzero___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFile$file___nonzero___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyFile)this.self).file___nonzero__());
        }
    }

    public class PyFile$mode_descriptor
    extends PyDataDescr {
        public PyFile$mode_descriptor() {
            super(PyFile.class, "mode", String.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyFile)pyObject).mode;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyFile$closed_descriptor
    extends PyDataDescr {
        public PyFile$closed_descriptor() {
            super(PyFile.class, "closed", Boolean.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return Py.newBoolean(((PyFile)pyObject).getClosed());
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyFile$name_descriptor
    extends PyDataDescr {
        public PyFile$name_descriptor() {
            super(PyFile.class, "name", PyObject.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyFile)pyObject).name;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyFile$softspace_descriptor
    extends PyDataDescr {
        public PyFile$softspace_descriptor() {
            super(PyFile.class, "softspace", PyObject.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyFile)pyObject).getSoftspace();
        }

        public void invokeSet(PyObject pyObject, Object object) {
            ((PyFile)pyObject).setSoftspace((PyObject)object);
        }

        public void invokeDelete(PyObject pyObject) {
            ((PyFile)pyObject).delSoftspace();
        }
    }

    public class PyFile$newlines_descriptor
    extends PyDataDescr {
        public PyFile$newlines_descriptor() {
            super(PyFile.class, "newlines", PyObject.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyFile)pyObject).getNewlines();
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyFile$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return PyFile.file_new(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class PyFile$PyExposer
    extends TypeExposer.BaseTypeBuilder {
        public PyFile$PyExposer() {
            PyBuiltinFunction[] pyBuiltinFunctionArray = new PyBuiltinFunction[]{new PyFile$file___init___exposer("__init__"), new PyFile$file_read_exposer("read"), new PyFile$file_readinto_exposer("readinto"), new PyFile$file_readline_exposer("readline"), new PyFile$file_readlines_exposer("readlines"), new PyFile$file___iter___exposer("__iter__"), new PyFile$file___iternext___exposer("__iternext__"), new PyFile$file_next_exposer("next"), new PyFile$file_xreadlines_exposer("xreadlines"), new PyFile$file_write_exposer("write"), new PyFile$file_writelines_exposer("writelines"), new PyFile$file_tell_exposer("tell"), new PyFile$file_seek_exposer("seek"), new PyFile$file_flush_exposer("flush"), new PyFile$file_close_exposer("close"), new PyFile$file_truncate_exposer("truncate"), new PyFile$file_isatty_exposer("isatty"), new PyFile$file_fileno_exposer("fileno"), new PyFile$file_toString_exposer("__str__"), new PyFile$file_toString_exposer("__repr__"), new PyFile$file___cmp___exposer("__cmp__"), new PyFile$file___nonzero___exposer("__nonzero__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyFile$mode_descriptor(), new PyFile$closed_descriptor(), new PyFile$name_descriptor(), new PyFile$softspace_descriptor(), new PyFile$newlines_descriptor()};
            super("file", PyFile.class, Object.class, pyBuiltinFunctionArray, pyDataDescrArray, new PyFile$exposed___new__());
        }
    }
}

