/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyComplex;
import org.python.core.PyDataDescr;
import org.python.core.PyFloatDerived;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.generate.TypeExposer;

public class PyFloat
extends PyObject {
    public static final PyType TYPE;
    private double value;

    @ExposedNew
    public static PyObject float_new(PyNewWrapper pyNewWrapper, boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("float", pyObjectArray, stringArray, new String[]{"x"}, 0);
        PyObject pyObject = argParser.getPyObject(0, null);
        if (pyNewWrapper.for_type == pyType) {
            if (pyObject == null) {
                return new PyFloat(0.0);
            }
            return pyObject.__float__();
        }
        if (pyObject == null) {
            return new PyFloatDerived(pyType, 0.0);
        }
        return new PyFloatDerived(pyType, pyObject.__float__().getValue());
    }

    public PyFloat(PyType pyType, double d) {
        super(pyType);
        this.value = d;
    }

    public PyFloat(double d) {
        this(TYPE, d);
    }

    public PyFloat(float f) {
        this((double)f);
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return this.float_toString();
    }

    final String float_toString() {
        String string = Double.toString(this.value);
        if (string.indexOf(69) == -1) {
            int n;
            while ((n = string.length()) > 2 && string.charAt(n - 1) == '0' && string.charAt(n - 2) != '.') {
                string = string.substring(0, n - 1);
            }
        }
        return string;
    }

    public int hashCode() {
        return this.float___hash__();
    }

    final int float___hash__() {
        double d = Math.floor(this.value);
        double d2 = this.value - d;
        if (d2 == 0.0) {
            if (d <= 2.147483647E9 && d >= -2.147483648E9) {
                return (int)this.value;
            }
            return this.__long__().hashCode();
        }
        long l = Double.doubleToLongBits(this.value);
        return (int)l ^ (int)(l >> 32);
    }

    public boolean __nonzero__() {
        return this.float___nonzero__();
    }

    final boolean float___nonzero__() {
        return this.value != 0.0;
    }

    public Object __tojava__(Class clazz) {
        if (clazz == Double.TYPE || clazz == Number.class || clazz == Double.class || clazz == Object.class || clazz == Serializable.class) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return new Float(this.value);
        }
        return super.__tojava__(clazz);
    }

    public int __cmp__(PyObject pyObject) {
        return this.float___cmp__(pyObject);
    }

    final int float___cmp__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return -2;
        }
        double d = PyFloat.coerce(pyObject);
        return this.value < d ? -1 : (this.value > d ? 1 : 0);
    }

    public Object __coerce_ex__(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return pyObject;
        }
        if (pyObject instanceof PyInteger) {
            return new PyFloat((double)((PyInteger)pyObject).getValue());
        }
        if (pyObject instanceof PyLong) {
            return new PyFloat(((PyLong)pyObject).doubleValue());
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject pyObject) {
        return pyObject instanceof PyFloat || pyObject instanceof PyInteger || pyObject instanceof PyLong;
    }

    private static final double coerce(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return ((PyFloat)pyObject).value;
        }
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        if (pyObject instanceof PyLong) {
            return ((PyLong)pyObject).doubleValue();
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject pyObject) {
        return this.float___add__(pyObject);
    }

    final PyObject float___add__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(this.value + d);
    }

    public PyObject __radd__(PyObject pyObject) {
        return this.float___radd__(pyObject);
    }

    final PyObject float___radd__(PyObject pyObject) {
        return this.__add__(pyObject);
    }

    public PyObject __sub__(PyObject pyObject) {
        return this.float___sub__(pyObject);
    }

    final PyObject float___sub__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(this.value - d);
    }

    public PyObject __rsub__(PyObject pyObject) {
        return this.float___rsub__(pyObject);
    }

    final PyObject float___rsub__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(d - this.value);
    }

    public PyObject __mul__(PyObject pyObject) {
        return this.float___mul__(pyObject);
    }

    final PyObject float___mul__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(this.value * d);
    }

    public PyObject __rmul__(PyObject pyObject) {
        return this.float___rmul__(pyObject);
    }

    final PyObject float___rmul__(PyObject pyObject) {
        return this.__mul__(pyObject);
    }

    public PyObject __div__(PyObject pyObject) {
        return this.float___div__(pyObject);
    }

    final PyObject float___div__(PyObject pyObject) {
        double d;
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic float division");
        }
        if ((d = PyFloat.coerce(pyObject)) == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.value / d);
    }

    public PyObject __rdiv__(PyObject pyObject) {
        return this.float___rdiv__(pyObject);
    }

    final PyObject float___rdiv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic float division");
        }
        double d = PyFloat.coerce(pyObject);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(d / this.value);
    }

    public PyObject __floordiv__(PyObject pyObject) {
        return this.float___floordiv__(pyObject);
    }

    final PyObject float___floordiv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (d == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(Math.floor(this.value / d));
    }

    public PyObject __rfloordiv__(PyObject pyObject) {
        return this.float___rfloordiv__(pyObject);
    }

    final PyObject float___rfloordiv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(Math.floor(d / this.value));
    }

    public PyObject __truediv__(PyObject pyObject) {
        return this.float___truediv__(pyObject);
    }

    final PyObject float___truediv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (d == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.value / d);
    }

    public PyObject __rtruediv__(PyObject pyObject) {
        return this.float___rtruediv__(pyObject);
    }

    final PyObject float___rtruediv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(d / this.value);
    }

    private static double modulo(double d, double d2) {
        if (d2 == 0.0) {
            throw Py.ZeroDivisionError("float modulo");
        }
        double d3 = Math.IEEEremainder(d, d2);
        if (d3 * d2 < 0.0) {
            d3 += d2;
        }
        return d3;
    }

    public PyObject __mod__(PyObject pyObject) {
        return this.float___mod__(pyObject);
    }

    final PyObject float___mod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(PyFloat.modulo(this.value, d));
    }

    public PyObject __rmod__(PyObject pyObject) {
        return this.float___rmod__(pyObject);
    }

    final PyObject float___rmod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(PyFloat.modulo(d, this.value));
    }

    public PyObject __divmod__(PyObject pyObject) {
        return this.float___divmod__(pyObject);
    }

    final PyObject float___divmod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (d == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double d2 = Math.floor(this.value / d);
        return new PyTuple(new PyFloat(d2), new PyFloat(this.value - d2 * d));
    }

    public PyObject __rdivmod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double d2 = Math.floor(d / this.value);
        return new PyTuple(new PyFloat(d2), new PyFloat(d - d2 * this.value));
    }

    final PyObject float___rdivmod__(PyObject pyObject) {
        return this.__rdivmod__(pyObject);
    }

    public PyObject __pow__(PyObject pyObject, PyObject pyObject2) {
        return this.float___pow__(pyObject, pyObject2);
    }

    final PyObject float___pow__(PyObject pyObject, PyObject pyObject2) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        if (pyObject2 != null) {
            throw Py.TypeError("pow() 3rd argument not allowed unless all arguments are integers");
        }
        return PyFloat._pow(this.value, PyFloat.coerce(pyObject), pyObject2);
    }

    final PyObject float___rpow__(PyObject pyObject) {
        return this.__rpow__(pyObject);
    }

    public PyObject __rpow__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        return PyFloat._pow(PyFloat.coerce(pyObject), this.value, null);
    }

    private static PyFloat _pow(double d, double d2, PyObject pyObject) {
        if (d2 == 0.0) {
            if (pyObject != null) {
                return new PyFloat(PyFloat.modulo(1.0, PyFloat.coerce(pyObject)));
            }
            return new PyFloat(1.0);
        }
        if (d == 0.0) {
            if (d2 < 0.0) {
                throw Py.ZeroDivisionError("0.0 cannot be raised to a negative power");
            }
            return new PyFloat(0.0f);
        }
        if (d < 0.0 && d2 != Math.floor(d2)) {
            throw Py.ValueError("negative number cannot be raised to a fractional power");
        }
        double d3 = Math.pow(d, d2);
        if (pyObject == null) {
            return new PyFloat(d3);
        }
        return new PyFloat(PyFloat.modulo(d3, PyFloat.coerce(pyObject)));
    }

    public PyObject __neg__() {
        return this.float___neg__();
    }

    final PyObject float___neg__() {
        return new PyFloat(-this.value);
    }

    public PyObject __pos__() {
        return this.float___pos__();
    }

    final PyObject float___pos__() {
        return Py.newFloat(this.value);
    }

    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    public PyObject __abs__() {
        return this.float___abs__();
    }

    final PyObject float___abs__() {
        if (this.value >= 0.0) {
            return Py.newFloat(this.value);
        }
        return this.__neg__();
    }

    public PyObject __int__() {
        return this.float___int__();
    }

    final PyObject float___int__() {
        if (this.value <= 2.147483647E9 && this.value >= -2.147483648E9) {
            return new PyInteger((int)this.value);
        }
        return this.__long__();
    }

    public PyLong __long__() {
        return this.float___long__();
    }

    final PyLong float___long__() {
        return new PyLong(this.value);
    }

    public PyFloat __float__() {
        return this.float___float__();
    }

    final PyFloat float___float__() {
        return Py.newFloat(this.value);
    }

    public PyComplex __complex__() {
        return new PyComplex(this.value, 0.0);
    }

    final PyTuple float___getnewargs__() {
        return new PyTuple(new PyFloat(this.getValue()));
    }

    public PyTuple __getnewargs__() {
        return this.float___getnewargs__();
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    static {
        PyType.addBuilder(PyFloat.class, new PyFloat$PyExposer());
        TYPE = PyType.fromClass(PyFloat.class);
    }

    public class PyFloat$float_toString_exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float_toString_exposer(String string) {
            super(string, 1, 1);
        }

        public PyFloat$float_toString_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float_toString_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newString(((PyFloat)this.self).float_toString());
        }
    }

    public class PyFloat$float___hash___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___hash___exposer(String string) {
            super(string, 1, 1);
        }

        public PyFloat$float___hash___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___hash___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyFloat)this.self).float___hash__());
        }
    }

    public class PyFloat$float___nonzero___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___nonzero___exposer(String string) {
            super(string, 1, 1);
        }

        public PyFloat$float___nonzero___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___nonzero___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyFloat)this.self).float___nonzero__());
        }
    }

    public class PyFloat$float___cmp___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___cmp___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___cmp___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___cmp___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            int n = ((PyFloat)this.self).float___cmp__(pyObject);
            if (n == -2) {
                throw Py.TypeError("float.__cmp__(x,y) requires y to be 'float', not a '" + pyObject.getType().fastGetName() + "'");
            }
            return Py.newInteger(n);
        }
    }

    public class PyFloat$float___add___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___add___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___add___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___add___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___add__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___radd___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___radd___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___radd___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___radd___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___radd__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___sub___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___sub___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___sub___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___sub___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___sub__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rsub___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rsub___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___rsub___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___rsub___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rsub__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___mul___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___mul___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___mul___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___mul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___mul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rmul___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rmul___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___rmul___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___rmul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rmul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___div___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___div___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___div___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___div___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___div__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rdiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rdiv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___rdiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___rdiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rdiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___floordiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___floordiv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___floordiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___floordiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___floordiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rfloordiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rfloordiv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___rfloordiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___rfloordiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rfloordiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___truediv___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___truediv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___truediv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___truediv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___truediv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rtruediv___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rtruediv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___rtruediv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___rtruediv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rtruediv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___mod___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___mod___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___mod___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___mod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___mod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rmod___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___rmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___rmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___divmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___divmod___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___divmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___divmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___divmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rdivmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rdivmod___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___rdivmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___rdivmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rdivmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___pow___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___pow___exposer(String string) {
            super(string, 2, 3);
        }

        public PyFloat$float___pow___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___pow___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyFloat)this.self).float___pow__(pyObject, pyObject2);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyFloat)this.self).float___pow__(pyObject, null);
        }
    }

    public class PyFloat$float___rpow___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rpow___exposer(String string) {
            super(string, 2, 2);
        }

        public PyFloat$float___rpow___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___rpow___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rpow__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___neg___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___neg___exposer(String string) {
            super(string, 1, 1);
        }

        public PyFloat$float___neg___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___neg___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___neg__();
        }
    }

    public class PyFloat$float___pos___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___pos___exposer(String string) {
            super(string, 1, 1);
        }

        public PyFloat$float___pos___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___pos___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___pos__();
        }
    }

    public class PyFloat$float___abs___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___abs___exposer(String string) {
            super(string, 1, 1);
        }

        public PyFloat$float___abs___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___abs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___abs__();
        }
    }

    public class PyFloat$float___int___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___int___exposer(String string) {
            super(string, 1, 1);
        }

        public PyFloat$float___int___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___int___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___int__();
        }
    }

    public class PyFloat$float___long___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___long___exposer(String string) {
            super(string, 1, 1);
        }

        public PyFloat$float___long___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___long___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___long__();
        }
    }

    public class PyFloat$float___float___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___float___exposer(String string) {
            super(string, 1, 1);
        }

        public PyFloat$float___float___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___float___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___float__();
        }
    }

    public class PyFloat$float___getnewargs___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___getnewargs___exposer(String string) {
            super(string, 1, 1);
        }

        public PyFloat$float___getnewargs___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyFloat$float___getnewargs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___getnewargs__();
        }
    }

    public class PyFloat$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return PyFloat.float_new(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class PyFloat$PyExposer
    extends TypeExposer.BaseTypeBuilder {
        public PyFloat$PyExposer() {
            PyBuiltinFunction[] pyBuiltinFunctionArray = new PyBuiltinFunction[]{new PyFloat$float_toString_exposer("__repr__"), new PyFloat$float_toString_exposer("__str__"), new PyFloat$float___hash___exposer("__hash__"), new PyFloat$float___nonzero___exposer("__nonzero__"), new PyFloat$float___cmp___exposer("__cmp__"), new PyFloat$float___add___exposer("__add__"), new PyFloat$float___radd___exposer("__radd__"), new PyFloat$float___sub___exposer("__sub__"), new PyFloat$float___rsub___exposer("__rsub__"), new PyFloat$float___mul___exposer("__mul__"), new PyFloat$float___rmul___exposer("__rmul__"), new PyFloat$float___div___exposer("__div__"), new PyFloat$float___rdiv___exposer("__rdiv__"), new PyFloat$float___floordiv___exposer("__floordiv__"), new PyFloat$float___rfloordiv___exposer("__rfloordiv__"), new PyFloat$float___truediv___exposer("__truediv__"), new PyFloat$float___rtruediv___exposer("__rtruediv__"), new PyFloat$float___mod___exposer("__mod__"), new PyFloat$float___rmod___exposer("__rmod__"), new PyFloat$float___divmod___exposer("__divmod__"), new PyFloat$float___rdivmod___exposer("__rdivmod__"), new PyFloat$float___pow___exposer("__pow__"), new PyFloat$float___rpow___exposer("__rpow__"), new PyFloat$float___neg___exposer("__neg__"), new PyFloat$float___pos___exposer("__pos__"), new PyFloat$float___abs___exposer("__abs__"), new PyFloat$float___int___exposer("__int__"), new PyFloat$float___long___exposer("__long__"), new PyFloat$float___float___exposer("__float__"), new PyFloat$float___getnewargs___exposer("__getnewargs__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("float", PyFloat.class, Object.class, pyBuiltinFunctionArray, pyDataDescrArray, new PyFloat$exposed___new__());
        }
    }
}

