/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTraceback;

public class PyGenerator
extends PyIterator {
    public PyFrame gi_frame;
    PyObject closure;
    public boolean gi_running;
    private PyException generatorExit;
    private static final String[] __members__ = new String[]{"gi_frame", "gi_running", "next"};

    public PyGenerator(PyFrame frame, PyObject closure) {
        this.gi_frame = frame;
        this.closure = closure;
        this.gi_running = false;
        this.generatorExit = Py.makeException(Py.GeneratorExit);
    }

    public PyObject __dir__() {
        PyObject[] members = new PyString[__members__.length];
        for (int i = 0; i < __members__.length; ++i) {
            members[i] = new PyString(__members__[i]);
        }
        PyList ret = new PyList(members);
        PyDictionary accum = new PyDictionary();
        this.addKeys(accum, "__dict__");
        ret.extend(accum.keys());
        ret.sort();
        return ret;
    }

    public PyObject send(PyObject value) {
        if (this.gi_frame.f_lasti == 0 && value != Py.None) {
            throw Py.TypeError("can't send non-None value to a just-started generator");
        }
        this.gi_frame.setGeneratorInput(value);
        return this.next();
    }

    private PyObject raiseException(PyException ex) {
        this.gi_frame.setGeneratorInput(ex);
        return this.next();
    }

    public PyObject throw$(PyObject type) {
        return this.raiseException(Py.makeException(type));
    }

    public PyObject throw$(PyObject type, PyObject value) {
        return this.raiseException(Py.makeException(type, value));
    }

    public PyObject throw$(PyObject type, PyObject value, PyTraceback tb) {
        return this.raiseException(Py.makeException(type, value, tb));
    }

    public PyObject close() {
        try {
            this.raiseException(this.generatorExit);
            throw Py.RuntimeError("generator ignored GeneratorExit");
        }
        catch (PyException e) {
            if (e.type != Py.StopIteration && e.type != Py.GeneratorExit) {
                throw e;
            }
            return Py.None;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyObject __iternext__() {
        if (this.gi_running) {
            throw Py.ValueError("generator already executing");
        }
        if (this.gi_frame.f_lasti == -1) {
            return null;
        }
        this.gi_running = true;
        PyObject result = null;
        try {
            result = this.gi_frame.f_code.call(this.gi_frame, this.closure);
        }
        catch (PyException e) {
            if (!e.type.equals(Py.StopIteration)) {
                throw e;
            }
            this.stopException = e;
            PyObject pyObject = null;
            return pyObject;
        }
        finally {
            this.gi_running = false;
        }
        if (result == Py.None && this.gi_frame.f_lasti == -1) {
            return null;
        }
        return result;
    }
}

