/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.python.core.Py;
import org.python.core.PyDataDescr;
import org.python.core.PyObject;
import org.python.core.PyType;

public class PyGetSetDescr
extends PyDataDescr {
    private Method getMeth;
    private Method setMeth;
    private Method delMeth;

    public PyGetSetDescr(String name, Class c, String get, String set) {
        this(PyType.fromClass(c), name, c, get, set, null);
    }

    public PyGetSetDescr(String name, Class c, String get, String set, String del) {
        this(PyType.fromClass(c), name, c, get, set, del);
    }

    public PyGetSetDescr(PyType dtype, String name, Class c, String get, String set) {
        this(dtype, name, c, get, set, null);
    }

    public PyGetSetDescr(PyType dtype, String name, Class c, String get, String set, String del) {
        super(dtype, name, PyGetSetDescr.getMethod(c, get, new Class[0]).getReturnType());
        this.name = name;
        this.dtype = dtype;
        this.getMeth = PyGetSetDescr.getMethod(c, get, new Class[0]);
        if (set != null) {
            this.setMeth = PyGetSetDescr.getMethod(c, set, this.ofType);
        }
        if (del != null) {
            this.delMeth = PyGetSetDescr.getMethod(c, del, new Class[0]);
        }
    }

    private static Method getMethod(Class onClass, String name, Class ... params) {
        Method meth;
        try {
            meth = onClass.getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            throw Py.SystemError("method '" + name + "' doesn't exist on '" + onClass.getName() + "'");
        }
        if (Modifier.isStatic(meth.getModifiers())) {
            throw Py.SystemError("static '" + name + "' not supported on '" + onClass.getName() + "'");
        }
        return meth;
    }

    public Object invokeGet(PyObject obj) {
        try {
            return this.getMeth.invoke((Object)obj, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw Py.JavaError(e);
        }
        catch (IllegalAccessException e) {
            throw Py.JavaError(e);
        }
        catch (InvocationTargetException e) {
            throw Py.JavaError(e);
        }
    }

    public void invokeSet(PyObject obj, Object converted) {
        try {
            this.setMeth.invoke((Object)obj, converted);
        }
        catch (IllegalArgumentException e) {
            throw Py.JavaError(e);
        }
        catch (IllegalAccessException e) {
            throw Py.JavaError(e);
        }
        catch (InvocationTargetException e) {
            throw Py.JavaError(e);
        }
    }

    public void invokeDelete(PyObject obj) {
        try {
            this.delMeth.invoke((Object)obj, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw Py.JavaError(e);
        }
        catch (IllegalAccessException e) {
            throw Py.JavaError(e);
        }
        catch (InvocationTargetException e) {
            throw Py.JavaError(e);
        }
    }

    public boolean implementsDescrSet() {
        return this.setMeth != null;
    }

    public boolean implementsDescrDelete() {
        return this.delMeth != null;
    }
}

