/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyComplex;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyIntegerDerived;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.generate.TypeExposer;

public class PyInteger
extends PyObject {
    public static final PyType TYPE;
    private int value;

    @ExposedNew
    public static PyObject int_new(PyNewWrapper pyNewWrapper, boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("int", pyObjectArray, stringArray, new String[]{"x", "base"}, 0);
        PyObject pyObject = argParser.getPyObject(0, null);
        int n = argParser.getInt(1, -909);
        if (pyNewWrapper.for_type == pyType) {
            if (pyObject == null) {
                return Py.Zero;
            }
            if (n == -909) {
                if (pyObject instanceof PyBoolean) {
                    return PyInteger.coerce(pyObject) == 0 ? Py.Zero : Py.One;
                }
                return PyInteger.asPyInteger(pyObject);
            }
            if (!(pyObject instanceof PyString)) {
                throw Py.TypeError("int: can't convert non-string with explicit base");
            }
            return Py.newInteger(((PyString)pyObject).atoi(n));
        }
        if (pyObject == null) {
            return new PyIntegerDerived(pyType, 0);
        }
        if (n == -909) {
            PyObject pyObject2 = PyInteger.asPyInteger(pyObject);
            if (pyObject2 instanceof PyInteger) {
                return new PyIntegerDerived(pyType, ((PyInteger)pyObject2).getValue());
            }
            throw Py.OverflowError("long int too large to convert to int");
        }
        if (!(pyObject instanceof PyString)) {
            throw Py.TypeError("int: can't convert non-string with explicit base");
        }
        return new PyIntegerDerived(pyType, ((PyString)pyObject).atoi(n));
    }

    private static PyObject asPyInteger(PyObject pyObject) {
        try {
            return pyObject.__int__();
        }
        catch (PyException pyException) {
            if (!Py.matchException(pyException, Py.AttributeError)) {
                throw pyException;
            }
            throw Py.TypeError("int() argument must be a string or a number");
        }
    }

    public PyInteger(PyType pyType, int n) {
        super(pyType);
        this.value = n;
    }

    public PyInteger(int n) {
        this(TYPE, n);
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.int_toString();
    }

    final String int_toString() {
        return Integer.toString(this.getValue());
    }

    public int hashCode() {
        return this.int_hashCode();
    }

    final int int_hashCode() {
        return this.getValue();
    }

    private static void err_ovf(String string) {
        block2: {
            try {
                Py.OverflowWarning(string);
            }
            catch (PyException pyException) {
                if (!Py.matchException(pyException, Py.OverflowWarning)) break block2;
                throw Py.OverflowError(string);
            }
        }
    }

    public boolean __nonzero__() {
        return this.int___nonzero__();
    }

    final boolean int___nonzero__() {
        return this.getValue() != 0;
    }

    public Object __tojava__(Class clazz) {
        if (clazz == Integer.TYPE || clazz == Number.class || clazz == Object.class || clazz == Integer.class || clazz == Serializable.class) {
            return new Integer(this.getValue());
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return new Boolean(this.getValue() != 0);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return new Byte((byte)this.getValue());
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return new Short((short)this.getValue());
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return new Long(this.getValue());
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return new Float(this.getValue());
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return new Double(this.getValue());
        }
        return super.__tojava__(clazz);
    }

    public int __cmp__(PyObject pyObject) {
        return this.int___cmp__(pyObject);
    }

    final int int___cmp__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return -2;
        }
        int n = PyInteger.coerce(pyObject);
        return this.getValue() < n ? -1 : (this.getValue() > n ? 1 : 0);
    }

    public Object __coerce_ex__(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return pyObject;
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject pyObject) {
        return pyObject instanceof PyInteger;
    }

    private static final int coerce(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject pyObject) {
        return this.int___add__(pyObject);
    }

    final PyObject int___add__(PyObject pyObject) {
        int n;
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n2 = PyInteger.coerce(pyObject);
        int n3 = this.getValue();
        int n4 = n3 + (n = n2);
        if ((n4 ^ n3) >= 0 || (n4 ^ n) >= 0) {
            return Py.newInteger(n4);
        }
        PyInteger.err_ovf("integer addition");
        return new PyLong((long)n3 + (long)n);
    }

    public PyObject __radd__(PyObject pyObject) {
        return this.int___radd__(pyObject);
    }

    final PyObject int___radd__(PyObject pyObject) {
        return this.__add__(pyObject);
    }

    private static PyObject _sub(int n, int n2) {
        int n3 = n - n2;
        if ((n3 ^ n) >= 0 || (n3 ^ ~n2) >= 0) {
            return Py.newInteger(n3);
        }
        PyInteger.err_ovf("integer subtraction");
        return new PyLong((long)n - (long)n2);
    }

    public PyObject __sub__(PyObject pyObject) {
        return this.int___sub__(pyObject);
    }

    final PyObject int___sub__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        return PyInteger._sub(this.getValue(), PyInteger.coerce(pyObject));
    }

    public PyObject __rsub__(PyObject pyObject) {
        return this.int___rsub__(pyObject);
    }

    final PyObject int___rsub__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        return PyInteger._sub(PyInteger.coerce(pyObject), this.getValue());
    }

    public PyObject __mul__(PyObject pyObject) {
        return this.int___mul__(pyObject);
    }

    final PyObject int___mul__(PyObject pyObject) {
        if (pyObject instanceof PySequence) {
            return ((PySequence)pyObject).repeat(this.getValue());
        }
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = PyInteger.coerce(pyObject);
        double d = this.getValue();
        if ((d *= (double)n) <= 2.147483647E9 && d >= -2.147483648E9) {
            return Py.newInteger((int)d);
        }
        PyInteger.err_ovf("integer multiplication");
        return this.__long__().__mul__(pyObject);
    }

    public PyObject __rmul__(PyObject pyObject) {
        return this.int___rmul__(pyObject);
    }

    final PyObject int___rmul__(PyObject pyObject) {
        return this.__mul__(pyObject);
    }

    private static int divide(int n, int n2) {
        int n3;
        int n4;
        if (n2 == 0) {
            throw Py.ZeroDivisionError("integer division or modulo by zero");
        }
        if (n2 == -1 && n < 0 && n == -n) {
            PyInteger.err_ovf("integer division: " + n + " + " + n2);
        }
        if ((n4 = n - (n3 = n / n2) * n2) != 0 && (n2 ^ n4) < 0) {
            n4 += n2;
            --n3;
        }
        return n3;
    }

    public PyObject __div__(PyObject pyObject) {
        return this.int___div__(pyObject);
    }

    final PyObject int___div__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning > 0) {
            Py.warning(Py.DeprecationWarning, "classic int division");
        }
        return Py.newInteger(PyInteger.divide(this.getValue(), PyInteger.coerce(pyObject)));
    }

    public PyObject __rdiv__(PyObject pyObject) {
        return this.int___rdiv__(pyObject);
    }

    final PyObject int___rdiv__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning > 0) {
            Py.warning(Py.DeprecationWarning, "classic int division");
        }
        return Py.newInteger(PyInteger.divide(PyInteger.coerce(pyObject), this.getValue()));
    }

    public PyObject __floordiv__(PyObject pyObject) {
        return this.int___floordiv__(pyObject);
    }

    final PyObject int___floordiv__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(this.getValue(), PyInteger.coerce(pyObject)));
    }

    public PyObject __rfloordiv__(PyObject pyObject) {
        return this.int___rfloordiv__(pyObject);
    }

    final PyObject int___rfloordiv__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(PyInteger.coerce(pyObject), this.getValue()));
    }

    public PyObject __truediv__(PyObject pyObject) {
        return this.int___truediv__(pyObject);
    }

    final PyObject int___truediv__(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return this.__float__().__truediv__(pyObject);
        }
        if (pyObject instanceof PyLong) {
            return this.int___long__().__truediv__(pyObject);
        }
        return null;
    }

    public PyObject __rtruediv__(PyObject pyObject) {
        return this.int___rtruediv__(pyObject);
    }

    final PyObject int___rtruediv__(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return pyObject.__float__().__truediv__(this);
        }
        if (pyObject instanceof PyLong) {
            return pyObject.__truediv__(this.int___long__());
        }
        return null;
    }

    private static int modulo(int n, int n2, int n3) {
        return n - n3 * n2;
    }

    public PyObject __mod__(PyObject pyObject) {
        return this.int___mod__(pyObject);
    }

    final PyObject int___mod__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = PyInteger.coerce(pyObject);
        int n2 = this.getValue();
        return Py.newInteger(PyInteger.modulo(n2, n, PyInteger.divide(n2, n)));
    }

    public PyObject __rmod__(PyObject pyObject) {
        return this.int___rmod__(pyObject);
    }

    final PyObject int___rmod__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = PyInteger.coerce(pyObject);
        int n2 = this.getValue();
        return Py.newInteger(PyInteger.modulo(n, n2, PyInteger.divide(n, n2)));
    }

    public PyObject __divmod__(PyObject pyObject) {
        return this.int___divmod__(pyObject);
    }

    final PyObject int___divmod__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = PyInteger.coerce(pyObject);
        int n2 = this.getValue();
        int n3 = PyInteger.divide(n2, n);
        return new PyTuple(Py.newInteger(n3), Py.newInteger(PyInteger.modulo(n2, n, n3)));
    }

    final PyObject int___rdivmod__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = PyInteger.coerce(pyObject);
        int n2 = this.getValue();
        int n3 = PyInteger.divide(n, n2);
        return new PyTuple(Py.newInteger(n3), Py.newInteger(PyInteger.modulo(n, n2, n3)));
    }

    public PyObject __pow__(PyObject pyObject, PyObject pyObject2) {
        return this.int___pow__(pyObject, pyObject2);
    }

    final PyObject int___pow__(PyObject pyObject, PyObject pyObject2) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        if (pyObject2 != null && !PyInteger.canCoerce(pyObject2)) {
            return null;
        }
        return PyInteger._pow(this.getValue(), PyInteger.coerce(pyObject), pyObject2, this, pyObject);
    }

    public PyObject __rpow__(PyObject pyObject, PyObject pyObject2) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        if (pyObject2 != null && !PyInteger.canCoerce(pyObject2)) {
            return null;
        }
        return PyInteger._pow(PyInteger.coerce(pyObject), this.getValue(), pyObject2, pyObject, this);
    }

    final PyObject int___rpow__(PyObject pyObject) {
        return this.__rpow__(pyObject, null);
    }

    private static PyObject _pow(int n, int n2, PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        int n3 = 0;
        long l = n;
        boolean bl = false;
        if (l < 0L) {
            l = -l;
            bl = (n2 & 1) != 0;
        }
        long l2 = 1L;
        if (n2 < 0) {
            if (n != 0) {
                return pyObject2.__float__().__pow__(pyObject3, pyObject);
            }
            throw Py.ZeroDivisionError("cannot raise 0 to a negative power");
        }
        if (pyObject != null && (n3 = PyInteger.coerce(pyObject)) == 0) {
            throw Py.ValueError("pow(x, y, z) with z==0");
        }
        while (n2 > 0) {
            if ((n2 & 1) != 0) {
                l2 *= l;
                if (n3 != 0) {
                    l2 %= (long)n3;
                }
                if (l2 > Integer.MAX_VALUE) {
                    PyInteger.err_ovf("integer exponentiation");
                    return pyObject2.__long__().__pow__(pyObject3, pyObject);
                }
            }
            if ((n2 >>= 1) == 0) break;
            l *= l;
            if (n3 != 0) {
                l %= (long)n3;
            }
            if (l <= Integer.MAX_VALUE) continue;
            PyInteger.err_ovf("integer exponentiation");
            return pyObject2.__long__().__pow__(pyObject3, pyObject);
        }
        int n4 = (int)l2;
        if (bl) {
            n4 = -n4;
        }
        if (n3 != 0) {
            n4 = PyInteger.modulo(n4, n3, PyInteger.divide(n4, n3));
        }
        return Py.newInteger(n4);
    }

    public PyObject __lshift__(PyObject pyObject) {
        return this.int___lshift__(pyObject);
    }

    final PyObject int___lshift__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return this.int___long__().__lshift__(pyObject);
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        if (n > 31) {
            return Py.newInteger(0);
        }
        if (n < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newInteger(this.getValue() << n);
    }

    final PyObject int___rlshift__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return pyObject.__rlshift__(this.int___long__());
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        if (this.getValue() > 31) {
            return Py.newInteger(0);
        }
        if (this.getValue() < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newInteger(n << this.getValue());
    }

    public PyObject __rshift__(PyObject pyObject) {
        return this.int___rshift__(pyObject);
    }

    final PyObject int___rshift__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return this.int___long__().__rshift__(pyObject);
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        if (n < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newInteger(this.getValue() >> n);
    }

    final PyObject int___rrshift__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return pyObject.__rshift__(this.int___long__());
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        if (this.getValue() < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newInteger(n >> this.getValue());
    }

    public PyObject __and__(PyObject pyObject) {
        return this.int___and__(pyObject);
    }

    final PyObject int___and__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return this.int___long__().__and__(pyObject);
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        return Py.newInteger(this.getValue() & n);
    }

    final PyObject int___rand__(PyObject pyObject) {
        return this.int___and__(pyObject);
    }

    public PyObject __xor__(PyObject pyObject) {
        return this.int___xor__(pyObject);
    }

    final PyObject int___xor__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return this.int___long__().__xor__(pyObject);
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        return Py.newInteger(this.getValue() ^ n);
    }

    final PyObject int___rxor__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return pyObject.__rxor__(this.int___long__());
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        return Py.newInteger(n ^ this.getValue());
    }

    public PyObject __or__(PyObject pyObject) {
        return this.int___or__(pyObject);
    }

    final PyObject int___or__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return this.int___long__().__or__(pyObject);
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        return Py.newInteger(this.getValue() | n);
    }

    final PyObject int___ror__(PyObject pyObject) {
        return this.int___or__(pyObject);
    }

    public PyObject __neg__() {
        return this.int___neg__();
    }

    final PyObject int___neg__() {
        int n = -this.getValue();
        if (this.getValue() < 0 && n < 0) {
            PyInteger.err_ovf("integer negation");
        }
        return Py.newInteger(n);
    }

    public PyObject __pos__() {
        return this.int___pos__();
    }

    final PyObject int___pos__() {
        return Py.newInteger(this.getValue());
    }

    public PyObject __abs__() {
        return this.int___abs__();
    }

    final PyObject int___abs__() {
        if (this.getValue() >= 0) {
            return Py.newInteger(this.getValue());
        }
        return this.__neg__();
    }

    public PyObject __invert__() {
        return this.int___invert__();
    }

    final PyObject int___invert__() {
        return Py.newInteger(~this.getValue());
    }

    public PyObject __int__() {
        return this.int___int__();
    }

    final PyInteger int___int__() {
        return Py.newInteger(this.getValue());
    }

    public PyLong __long__() {
        return this.int___long__();
    }

    final PyLong int___long__() {
        return new PyLong(this.getValue());
    }

    public PyFloat __float__() {
        return this.int___float__();
    }

    final PyFloat int___float__() {
        return new PyFloat((double)this.getValue());
    }

    public PyComplex __complex__() {
        return new PyComplex(this.getValue(), 0.0);
    }

    public PyString __oct__() {
        return this.int___oct__();
    }

    final PyString int___oct__() {
        if (this.getValue() < 0) {
            return new PyString("0" + Long.toString(0x100000000L + (long)this.getValue(), 8));
        }
        if (this.getValue() > 0) {
            return new PyString("0" + Integer.toString(this.getValue(), 8));
        }
        return new PyString("0");
    }

    public PyString __hex__() {
        return this.int___hex__();
    }

    final PyString int___hex__() {
        if (this.getValue() < 0) {
            return new PyString("0x" + Long.toString(0x100000000L + (long)this.getValue(), 16));
        }
        return new PyString("0x" + Integer.toString(this.getValue(), 16));
    }

    final PyTuple int___getnewargs__() {
        return new PyTuple(new PyInteger(this.getValue()));
    }

    public PyTuple __getnewargs__() {
        return this.int___getnewargs__();
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    public long asLong(int n) {
        return this.getValue();
    }

    public int asInt(int n) {
        return this.getValue();
    }

    public int asInt() {
        return this.getValue();
    }

    static {
        PyType.addBuilder(PyInteger.class, new PyInteger$PyExposer());
        TYPE = PyType.fromClass(PyInteger.class);
    }

    public class PyInteger$int_toString_exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int_toString_exposer(String string) {
            super(string, 1, 1);
        }

        public PyInteger$int_toString_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int_toString_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newString(((PyInteger)this.self).int_toString());
        }
    }

    public class PyInteger$int_hashCode_exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int_hashCode_exposer(String string) {
            super(string, 1, 1);
        }

        public PyInteger$int_hashCode_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int_hashCode_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyInteger)this.self).int_hashCode());
        }
    }

    public class PyInteger$int___nonzero___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___nonzero___exposer(String string) {
            super(string, 1, 1);
        }

        public PyInteger$int___nonzero___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___nonzero___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyInteger)this.self).int___nonzero__());
        }
    }

    public class PyInteger$int___cmp___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___cmp___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___cmp___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___cmp___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            int n = ((PyInteger)this.self).int___cmp__(pyObject);
            if (n == -2) {
                throw Py.TypeError("int.__cmp__(x,y) requires y to be 'int', not a '" + pyObject.getType().fastGetName() + "'");
            }
            return Py.newInteger(n);
        }
    }

    public class PyInteger$int___add___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___add___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___add___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___add___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___add__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___radd___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___radd___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___radd___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___radd___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___radd__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___sub___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___sub___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___sub___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___sub___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___sub__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rsub___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rsub___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___rsub___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___rsub___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rsub__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___mul___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___mul___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___mul___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___mul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___mul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rmul___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rmul___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___rmul___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___rmul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rmul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___div___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___div___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___div___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___div___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___div__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rdiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rdiv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___rdiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___rdiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rdiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___floordiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___floordiv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___floordiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___floordiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___floordiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rfloordiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rfloordiv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___rfloordiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___rfloordiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rfloordiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___truediv___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___truediv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___truediv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___truediv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___truediv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rtruediv___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rtruediv___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___rtruediv___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___rtruediv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rtruediv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___mod___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___mod___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___mod___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___mod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___mod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rmod___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___rmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___rmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___divmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___divmod___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___divmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___divmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___divmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rdivmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rdivmod___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___rdivmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___rdivmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rdivmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___pow___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___pow___exposer(String string) {
            super(string, 2, 3);
        }

        public PyInteger$int___pow___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___pow___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            PyObject pyObject3 = ((PyInteger)this.self).int___pow__(pyObject, pyObject2);
            if (pyObject3 == null) {
                return Py.NotImplemented;
            }
            return pyObject3;
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___pow__(pyObject, null);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rpow___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rpow___exposer(String string) {
            super(string, 1, 2);
        }

        public PyInteger$int___rpow___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___rpow___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rpow__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }

        public PyObject __call__() {
            PyObject pyObject = ((PyInteger)this.self).int___rpow__(null);
            if (pyObject == null) {
                return Py.NotImplemented;
            }
            return pyObject;
        }
    }

    public class PyInteger$int___lshift___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___lshift___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___lshift___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___lshift___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___lshift__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rlshift___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rlshift___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___rlshift___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___rlshift___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rlshift__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rshift___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rshift___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___rshift___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___rshift___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rshift__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rrshift___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rrshift___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___rrshift___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___rrshift___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rrshift__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___and___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___and___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___and___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___and___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___and__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rand___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rand___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___rand___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___rand___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rand__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___xor___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___xor___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___xor___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___xor___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___xor__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rxor___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rxor___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___rxor___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___rxor___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rxor__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___or___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___or___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___or___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___or___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___or__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___ror___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___ror___exposer(String string) {
            super(string, 2, 2);
        }

        public PyInteger$int___ror___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___ror___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___ror__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___neg___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___neg___exposer(String string) {
            super(string, 1, 1);
        }

        public PyInteger$int___neg___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___neg___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___neg__();
        }
    }

    public class PyInteger$int___pos___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___pos___exposer(String string) {
            super(string, 1, 1);
        }

        public PyInteger$int___pos___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___pos___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___pos__();
        }
    }

    public class PyInteger$int___abs___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___abs___exposer(String string) {
            super(string, 1, 1);
        }

        public PyInteger$int___abs___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___abs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___abs__();
        }
    }

    public class PyInteger$int___invert___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___invert___exposer(String string) {
            super(string, 1, 1);
        }

        public PyInteger$int___invert___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___invert___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___invert__();
        }
    }

    public class PyInteger$int___int___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___int___exposer(String string) {
            super(string, 1, 1);
        }

        public PyInteger$int___int___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___int___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___int__();
        }
    }

    public class PyInteger$int___long___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___long___exposer(String string) {
            super(string, 1, 1);
        }

        public PyInteger$int___long___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___long___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___long__();
        }
    }

    public class PyInteger$int___float___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___float___exposer(String string) {
            super(string, 1, 1);
        }

        public PyInteger$int___float___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___float___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___float__();
        }
    }

    public class PyInteger$int___oct___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___oct___exposer(String string) {
            super(string, 1, 1);
        }

        public PyInteger$int___oct___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___oct___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___oct__();
        }
    }

    public class PyInteger$int___hex___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___hex___exposer(String string) {
            super(string, 1, 1);
        }

        public PyInteger$int___hex___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___hex___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___hex__();
        }
    }

    public class PyInteger$int___getnewargs___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___getnewargs___exposer(String string) {
            super(string, 1, 1);
        }

        public PyInteger$int___getnewargs___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyInteger$int___getnewargs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___getnewargs__();
        }
    }

    public class PyInteger$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return PyInteger.int_new(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class PyInteger$PyExposer
    extends TypeExposer.BaseTypeBuilder {
        public PyInteger$PyExposer() {
            PyBuiltinFunction[] pyBuiltinFunctionArray = new PyBuiltinFunction[]{new PyInteger$int_toString_exposer("__str__"), new PyInteger$int_toString_exposer("__repr__"), new PyInteger$int_hashCode_exposer("__hash__"), new PyInteger$int___nonzero___exposer("__nonzero__"), new PyInteger$int___cmp___exposer("__cmp__"), new PyInteger$int___add___exposer("__add__"), new PyInteger$int___radd___exposer("__radd__"), new PyInteger$int___sub___exposer("__sub__"), new PyInteger$int___rsub___exposer("__rsub__"), new PyInteger$int___mul___exposer("__mul__"), new PyInteger$int___rmul___exposer("__rmul__"), new PyInteger$int___div___exposer("__div__"), new PyInteger$int___rdiv___exposer("__rdiv__"), new PyInteger$int___floordiv___exposer("__floordiv__"), new PyInteger$int___rfloordiv___exposer("__rfloordiv__"), new PyInteger$int___truediv___exposer("__truediv__"), new PyInteger$int___rtruediv___exposer("__rtruediv__"), new PyInteger$int___mod___exposer("__mod__"), new PyInteger$int___rmod___exposer("__rmod__"), new PyInteger$int___divmod___exposer("__divmod__"), new PyInteger$int___rdivmod___exposer("__rdivmod__"), new PyInteger$int___pow___exposer("__pow__"), new PyInteger$int___rpow___exposer("__rpow__"), new PyInteger$int___lshift___exposer("__lshift__"), new PyInteger$int___rlshift___exposer("__rlshift__"), new PyInteger$int___rshift___exposer("__rshift__"), new PyInteger$int___rrshift___exposer("__rrshift__"), new PyInteger$int___and___exposer("__and__"), new PyInteger$int___rand___exposer("__rand__"), new PyInteger$int___xor___exposer("__xor__"), new PyInteger$int___rxor___exposer("__rxor__"), new PyInteger$int___or___exposer("__or__"), new PyInteger$int___ror___exposer("__ror__"), new PyInteger$int___neg___exposer("__neg__"), new PyInteger$int___pos___exposer("__pos__"), new PyInteger$int___abs___exposer("__abs__"), new PyInteger$int___invert___exposer("__invert__"), new PyInteger$int___int___exposer("__int__"), new PyInteger$int___long___exposer("__long__"), new PyInteger$int___float___exposer("__float__"), new PyInteger$int___oct___exposer("__oct__"), new PyInteger$int___hex___exposer("__hex__"), new PyInteger$int___getnewargs___exposer("__getnewargs__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("int", PyInteger.class, Object.class, pyBuiltinFunctionArray, pyDataDescrArray, new PyInteger$exposed___new__());
        }
    }
}

