/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.python.core.ArgParser;
import org.python.core.MergeState;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyListDerived;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyOverridableNew;
import org.python.core.PySequence;
import org.python.core.PySequenceList;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.expose.ExposedNew;
import org.python.expose.generate.TypeExposer;

public class PyList
extends PySequenceList {
    public static final PyType TYPE;

    public PyList() {
        this(TYPE, Py.EmptyObjects);
    }

    public PyList(PyType pyType) {
        super(pyType);
    }

    public PyList(PyType pyType, PyObject[] pyObjectArray) {
        super(pyType, pyObjectArray);
    }

    public PyList(PyType pyType, Collection collection) {
        super(pyType, collection);
    }

    public PyList(PyObject[] pyObjectArray) {
        this(TYPE, pyObjectArray);
    }

    public PyList(Collection collection) {
        super(TYPE, collection);
    }

    public PyList(PyObject pyObject) {
        this(TYPE);
        for (PyObject pyObject2 : pyObject.asIterable()) {
            this.append(pyObject2);
        }
    }

    @ExposedNew
    final void list___init__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("list", pyObjectArray, stringArray, new String[]{"sequence"}, 0);
        PyObject pyObject = argParser.getPyObject(0, null);
        this.clear();
        if (pyObject == null) {
            return;
        }
        if (pyObject instanceof PySequenceList) {
            PySequenceList pySequenceList = (PySequenceList)pyObject.__getslice__(Py.None, Py.None, Py.One);
            this.list = pySequenceList.list;
        } else {
            for (PyObject pyObject2 : pyObject.asIterable()) {
                this.append(pyObject2);
            }
        }
    }

    public int __len__() {
        return this.list___len__();
    }

    final int list___len__() {
        return this.size();
    }

    protected PyObject getslice(int n, int n2, int n3) {
        if (n3 > 0 && n2 < n) {
            n2 = n;
        }
        int n4 = PyList.sliceLength(n, n2, n3);
        PyObject[] pyObjectArray = new PyObject[n4];
        PyObject[] pyObjectArray2 = this.getArray();
        if (n3 == 1) {
            System.arraycopy(pyObjectArray2, n, pyObjectArray, 0, n2 - n);
            return new PyList(pyObjectArray);
        }
        int n5 = 0;
        int n6 = n;
        while (n5 < n4) {
            pyObjectArray[n5] = pyObjectArray2[n6];
            ++n5;
            n6 += n3;
        }
        return new PyList(pyObjectArray);
    }

    protected void del(int n) {
        this.remove(n);
    }

    protected void delRange(int n, int n2, int n3) {
        block3: {
            block4: {
                block2: {
                    if (n3 != 1) break block2;
                    this.remove(n, n2);
                    break block3;
                }
                if (n3 <= 1) break block4;
                for (int i = n; i < n2; --n2, i += n3) {
                    this.remove(i);
                    --i;
                }
                break block3;
            }
            if (n3 >= 0) break block3;
            for (int i = n; i >= 0 && i >= n2; i += n3) {
                this.remove(i);
            }
        }
    }

    protected void set(int n, PyObject pyObject) {
        this.list.pyset(n, pyObject);
    }

    protected void setslice(int n, int n2, int n3, PyObject pyObject) {
        if (n2 < n) {
            n2 = n;
        }
        if (pyObject instanceof PySequence) {
            PySequence pySequence = (PySequence)pyObject;
            this.setslicePySequence(n, n2, n3, pySequence);
        } else if (pyObject instanceof List) {
            List list = (List)pyObject.__tojava__(List.class);
            if (list != null && list != Py.NoConversion) {
                this.setsliceList(n, n2, n3, list);
            }
        } else {
            this.setsliceIterable(n, n2, n3, pyObject);
        }
    }

    protected void setslicePySequence(int n, int n2, int n3, PySequence pySequence) {
        block9: {
            block10: {
                block8: {
                    if (n3 != 1) break block8;
                    PyObject[] pyObjectArray = this.getArray();
                    if (pySequence instanceof PySequenceList) {
                        PySequenceList pySequenceList = (PySequenceList)pySequence;
                        PyObject[] pyObjectArray2 = pySequenceList.getArray();
                        if (pyObjectArray2 == pyObjectArray) {
                            pyObjectArray2 = (PyObject[])pyObjectArray2.clone();
                        }
                        this.list.replaceSubArray(n, n2, pyObjectArray2, 0, pySequenceList.size());
                    } else {
                        int n4 = pySequence.__len__();
                        this.list.ensureCapacity(n + n4);
                        for (int i = 0; i < n4; ++i) {
                            this.list.add(i + n, pySequence.pyget(i));
                        }
                    }
                    break block9;
                }
                if (n3 <= 1) break block10;
                int n5 = pySequence.__len__();
                int n6 = 0;
                int n7 = 0;
                while (n6 < n5) {
                    this.list.pyset(n7 + n, pySequence.pyget(n6));
                    ++n6;
                    n7 += n3;
                }
                break block9;
            }
            if (n3 >= 0) break block9;
            int n8 = pySequence.__len__();
            if (pySequence == this) {
                PyList pyList = new PyList();
                PyObject pyObject = pySequence.__iter__();
                PyObject pyObject2 = null;
                while ((pyObject2 = pyObject.__iternext__()) != null) {
                    pyList.append(pyObject2);
                }
                pySequence = pyList;
            }
            int n9 = 0;
            int n10 = this.list.size() - 1;
            while (n9 < n8) {
                this.list.pyset(n10, pySequence.pyget(n9));
                ++n9;
                n10 += n3;
            }
        }
    }

    protected void setsliceList(int n, int n2, int n3, List list) {
        if (n3 != 1) {
            throw Py.TypeError("setslice with java.util.List and step != 1 not supported yet");
        }
        int n4 = list.size();
        this.list.ensureCapacity(n + n4);
        for (int i = 0; i < n4; ++i) {
            this.list.add(i + n, list.get(i));
        }
    }

    protected void setsliceIterable(int n, int n2, int n3, PyObject pyObject) {
        PyObject pyObject2;
        PyObject pyObject3;
        try {
            pyObject3 = pyObject.__iter__();
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, Py.TypeError)) {
                throw Py.TypeError("can only assign an iterable");
            }
            throw pyException;
        }
        int n4 = 0;
        while ((pyObject2 = pyObject3.__iternext__()) != null) {
            if (n3 < 0) {
                this.list.pyset(n + n4, pyObject2);
            } else {
                this.list.add(n + n4, pyObject2);
            }
            n4 += n3;
        }
    }

    protected PyObject repeat(int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.size();
        PyObject[] pyObjectArray = new PyObject[n2 * n];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(this.getArray(), 0, pyObjectArray, i * n2, n2);
        }
        return new PyList(pyObjectArray);
    }

    final PyObject list___ne__(PyObject pyObject) {
        return this.seq___ne__(pyObject);
    }

    final PyObject list___eq__(PyObject pyObject) {
        return this.seq___eq__(pyObject);
    }

    final PyObject list___lt__(PyObject pyObject) {
        return this.seq___lt__(pyObject);
    }

    final PyObject list___le__(PyObject pyObject) {
        return this.seq___le__(pyObject);
    }

    final PyObject list___gt__(PyObject pyObject) {
        return this.seq___gt__(pyObject);
    }

    final PyObject list___ge__(PyObject pyObject) {
        return this.seq___ge__(pyObject);
    }

    public PyObject __imul__(PyObject pyObject) {
        PyObject pyObject2 = this.list___imul__(pyObject);
        if (pyObject2 == null && (pyObject2 = pyObject.__rmul__(this)) == null) {
            throw Py.TypeError(this._unsupportedop("*", pyObject));
        }
        return pyObject2;
    }

    final PyObject list___imul__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger) && !(pyObject instanceof PyLong)) {
            return null;
        }
        int n = this.size();
        int n2 = ((PyInteger)pyObject.__int__()).getValue();
        int n3 = n * n2;
        this.list.setSize(n3);
        PyObject[] pyObjectArray = this.getArray();
        for (int i = 1; i < n2; ++i) {
            System.arraycopy(pyObjectArray, 0, pyObjectArray, i * n, n);
        }
        this.gListAllocatedStatus = this.__len__();
        return this;
    }

    final PyObject list___mul__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger) && !(pyObject instanceof PyLong)) {
            return null;
        }
        int n = ((PyInteger)pyObject.__int__()).getValue();
        return this.repeat(n);
    }

    final PyObject list___rmul__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger) && !(pyObject instanceof PyLong)) {
            return null;
        }
        int n = ((PyInteger)pyObject.__int__()).getValue();
        return this.repeat(n);
    }

    public PyObject __add__(PyObject pyObject) {
        return this.list___add__(pyObject);
    }

    final PyObject list___add__(PyObject pyObject) {
        Object object;
        PyList pyList = null;
        if (pyObject instanceof PyList) {
            PyList pyList2 = (PyList)pyObject;
            int n = this.size();
            int n2 = pyList2.size();
            PyObject[] pyObjectArray = new PyObject[n + n2];
            System.arraycopy(this.getArray(), 0, pyObjectArray, 0, n);
            System.arraycopy(pyList2.getArray(), 0, pyObjectArray, n, n2);
            pyList = new PyList(pyObjectArray);
        } else if (!(pyObject instanceof PySequenceList) && (object = pyObject.__tojava__(List.class)) != Py.NoConversion && object != null) {
            List list = (List)object;
            pyList = new PyList();
            pyList.list_extend(this);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                pyList.add(iterator.next());
            }
        }
        return pyList;
    }

    public PyObject __radd__(PyObject pyObject) {
        return this.list___radd__(pyObject);
    }

    final PyObject list___radd__(PyObject pyObject) {
        PyList pyList = null;
        if (pyObject instanceof PySequence) {
            return null;
        }
        Object object = pyObject.__tojava__(List.class);
        if (object != Py.NoConversion && object != null) {
            pyList = new PyList();
            pyList.addAll((Collection)((List)object));
            pyList.extend(this);
        }
        return pyList;
    }

    final boolean list___contains__(PyObject pyObject) {
        return this.object___contains__(pyObject);
    }

    final void list___delitem__(PyObject pyObject) {
        this.seq___delitem__(pyObject);
    }

    final void list___setitem__(PyObject pyObject, PyObject pyObject2) {
        this.seq___setitem__(pyObject, pyObject2);
    }

    final PyObject list___getitem__(PyObject pyObject) {
        PyObject pyObject2 = this.seq___finditem__(pyObject);
        if (pyObject2 == null) {
            throw Py.IndexError("index out of range: " + pyObject);
        }
        return pyObject2;
    }

    final boolean list___nonzero__() {
        return this.seq___nonzero__();
    }

    final PyObject list___getslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        return this.seq___getslice__(pyObject, pyObject2, pyObject3);
    }

    final void list___setslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
        if (pyObject4 == null) {
            pyObject4 = pyObject3;
            pyObject3 = null;
        }
        this.seq___setslice__(pyObject, pyObject2, pyObject3, pyObject4);
    }

    final void list___delslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        this.seq___delslice__(pyObject, pyObject2, pyObject3);
    }

    protected String unsupportedopMessage(String string, PyObject pyObject) {
        if (string.equals("+")) {
            return "can only concatenate list (not \"{2}\") to list";
        }
        return super.unsupportedopMessage(string, pyObject);
    }

    public String toString() {
        return this.list_toString();
    }

    final String list_toString() {
        ThreadState threadState = Py.getThreadState();
        if (!threadState.enterRepr(this)) {
            return "[...]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = this.size();
        PyObject[] pyObjectArray = this.getArray();
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(pyObjectArray[i].__repr__().toString());
            stringBuffer.append(", ");
        }
        if (n > 0) {
            stringBuffer.append(pyObjectArray[n - 1].__repr__().toString());
        }
        stringBuffer.append("]");
        threadState.exitRepr(this);
        return stringBuffer.toString();
    }

    public void append(PyObject pyObject) {
        this.list_append(pyObject);
    }

    final void list_append(PyObject pyObject) {
        this.pyadd(pyObject);
        this.gListAllocatedStatus = this.__len__();
    }

    public int count(PyObject pyObject) {
        return this.list_count(pyObject);
    }

    final int list_count(PyObject pyObject) {
        int n = 0;
        PyObject[] pyObjectArray = this.getArray();
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (!pyObjectArray[i].equals(pyObject)) continue;
            ++n;
        }
        return n;
    }

    public int index(PyObject pyObject) {
        return this.index(pyObject, 0);
    }

    public int index(PyObject pyObject, int n) {
        return this.list_index(pyObject, n, null);
    }

    public int index(PyObject pyObject, int n, int n2) {
        return this.list_index(pyObject, n, Py.newInteger(n2));
    }

    final int list_index(PyObject pyObject, int n, PyObject pyObject2) {
        int n2 = pyObject2 == null ? this.size() : pyObject2.asInt();
        return this._index(pyObject, "list.index(x): x not in list", n, n2);
    }

    final int list_index(PyObject pyObject, int n) {
        return this._index(pyObject, "list.index(x): x not in list", n, this.size());
    }

    final int list_index(PyObject pyObject) {
        return this._index(pyObject, "list.index(x): x not in list", 0, this.size());
    }

    private int _index(PyObject pyObject, String string, int n, int n2) {
        int n3 = this.calculateIndex(n2);
        int n4 = this.calculateIndex(n);
        PyObject[] pyObjectArray = this.getArray();
        for (int i = n4; i < n3 && i < this.size(); ++i) {
            if (!pyObjectArray[i].equals(pyObject)) continue;
            return i;
        }
        throw Py.ValueError(string);
    }

    private int calculateIndex(int n) {
        int n2 = this.size();
        if (n < 0) {
            n += n2;
            if (n < 0) {
                n = 0;
            }
        } else if (n > n2) {
            n = n2;
        }
        return n;
    }

    public void insert(int n, PyObject pyObject) {
        this.list_insert(n, pyObject);
    }

    final void list_insert(int n, PyObject pyObject) {
        if (n < 0) {
            n = Math.max(0, this.size() + n);
        }
        if (n > this.size()) {
            n = this.size();
        }
        this.list.pyadd(n, pyObject);
        this.gListAllocatedStatus = this.__len__();
    }

    public void remove(PyObject pyObject) {
        this.list_remove(pyObject);
    }

    final void list_remove(PyObject pyObject) {
        this.del(this._index(pyObject, "list.remove(x): x not in list", 0, this.size()));
        this.gListAllocatedStatus = this.__len__();
    }

    public void reverse() {
        this.list_reverse();
    }

    final void list_reverse() {
        int n = this.size();
        PyObject[] pyObjectArray = this.getArray();
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n / 2) {
            PyObject pyObject = pyObjectArray[n3];
            pyObjectArray[n3] = pyObjectArray[n2];
            pyObjectArray[n2] = pyObject;
            ++n3;
            --n2;
        }
        this.gListAllocatedStatus = this.__len__();
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int n) {
        return this.list_pop(n);
    }

    final PyObject list_pop(int n) {
        int n2 = this.size();
        if (n2 == 0) {
            throw Py.IndexError("pop from empty list");
        }
        if (n < 0) {
            n += n2;
        }
        if (n < 0 || n >= n2) {
            throw Py.IndexError("pop index out of range");
        }
        PyObject pyObject = this.pyget(n);
        this.setslice(n, n + 1, 1, Py.EmptyTuple);
        return pyObject;
    }

    public void extend(PyObject pyObject) {
        this.list_extend(pyObject);
    }

    final void list_extend(PyObject pyObject) {
        int n = this.size();
        this.setslice(n, n, 1, pyObject);
        this.gListAllocatedStatus = this.__len__();
    }

    public PyObject __iadd__(PyObject pyObject) {
        return this.list___iadd__(pyObject);
    }

    final PyObject list___iadd__(PyObject pyObject) {
        this.extend(PyList.fastSequence(pyObject, "argument to += must be a sequence"));
        return this;
    }

    final void list_sort(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("list", pyObjectArray, stringArray, new String[]{"cmp", "key", "reverse"}, 0);
        PyObject pyObject = argParser.getPyObject(0, Py.None);
        PyObject pyObject2 = argParser.getPyObject(1, Py.None);
        PyObject pyObject3 = argParser.getPyObject(2, Py.False);
        this.sort(pyObject, pyObject2, pyObject3);
    }

    public void sort(PyObject pyObject) {
        this.sort(pyObject, Py.None, Py.False);
    }

    public void sort() {
        this.sort(Py.None, Py.None, Py.False);
    }

    public void sort(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        MergeState mergeState = new MergeState(this, pyObject, pyObject2, pyObject3.__nonzero__());
        mergeState.sort();
    }

    public int hashCode() {
        return this.list___hash__();
    }

    final int list___hash__() {
        throw Py.TypeError("unhashable type");
    }

    public PyTuple __getnewargs__() {
        return new PyTuple(new PyTuple(this.list.getArray()));
    }

    static {
        PyType.addBuilder(PyList.class, new PyList$PyExposer());
        TYPE = PyType.fromClass(PyList.class);
    }

    public class PyList$list___init___exposer
    extends PyBuiltinMethod {
        public PyList$list___init___exposer(String string) {
            super(string);
        }

        public PyList$list___init___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___init___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyList)this.self).list___init__(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyList$list___len___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___len___exposer(String string) {
            super(string, 1, 1);
        }

        public PyList$list___len___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___len___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyList)this.self).list___len__());
        }
    }

    public class PyList$list___ne___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___ne___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___ne___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___ne___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyList)this.self).list___ne__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyList$list___eq___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___eq___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___eq___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___eq___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyList)this.self).list___eq__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyList$list___lt___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___lt___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___lt___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___lt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyList)this.self).list___lt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyList$list___le___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___le___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___le___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___le___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyList)this.self).list___le__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyList$list___gt___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___gt___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___gt___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___gt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyList)this.self).list___gt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyList$list___ge___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___ge___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___ge___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___ge___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyList)this.self).list___ge__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyList$list___imul___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___imul___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___imul___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___imul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyList)this.self).list___imul__(pyObject);
        }
    }

    public class PyList$list___mul___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___mul___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___mul___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___mul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyList)this.self).list___mul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyList$list___rmul___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___rmul___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___rmul___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___rmul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyList)this.self).list___rmul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyList$list___add___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___add___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___add___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___add___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyList)this.self).list___add__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyList$list___radd___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___radd___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___radd___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___radd___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyList)this.self).list___radd__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyList$list___contains___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___contains___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___contains___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___contains___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyList)this.self).list___contains__(pyObject));
        }
    }

    public class PyList$list___delitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___delitem___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___delitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___delitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyList)this.self).list___delitem__(pyObject);
            return Py.None;
        }
    }

    public class PyList$list___setitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___setitem___exposer(String string) {
            super(string, 3, 3);
        }

        public PyList$list___setitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___setitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyList)this.self).list___setitem__(pyObject, pyObject2);
            return Py.None;
        }
    }

    public class PyList$list___getitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___getitem___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___getitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___getitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyList)this.self).list___getitem__(pyObject);
        }
    }

    public class PyList$list___nonzero___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___nonzero___exposer(String string) {
            super(string, 1, 1);
        }

        public PyList$list___nonzero___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___nonzero___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyList)this.self).list___nonzero__());
        }
    }

    public class PyList$list___getslice___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___getslice___exposer(String string) {
            super(string, 3, 4);
        }

        public PyList$list___getslice___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___getslice___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return ((PyList)this.self).list___getslice__(pyObject, pyObject2, pyObject3);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyList)this.self).list___getslice__(pyObject, pyObject2, null);
        }
    }

    public class PyList$list___setslice___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___setslice___exposer(String string) {
            super(string, 4, 5);
        }

        public PyList$list___setslice___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___setslice___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
            ((PyList)this.self).list___setslice__(pyObject, pyObject2, pyObject3, pyObject4);
            return Py.None;
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            ((PyList)this.self).list___setslice__(pyObject, pyObject2, pyObject3, null);
            return Py.None;
        }
    }

    public class PyList$list___delslice___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___delslice___exposer(String string) {
            super(string, 4, 4);
        }

        public PyList$list___delslice___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___delslice___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            ((PyList)this.self).list___delslice__(pyObject, pyObject2, pyObject3);
            return Py.None;
        }
    }

    public class PyList$list_toString_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_toString_exposer(String string) {
            super(string, 1, 1);
        }

        public PyList$list_toString_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list_toString_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newString(((PyList)this.self).list_toString());
        }
    }

    public class PyList$list_append_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_append_exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list_append_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list_append_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyList)this.self).list_append(pyObject);
            return Py.None;
        }
    }

    public class PyList$list_count_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_count_exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list_count_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list_count_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyList)this.self).list_count(pyObject));
        }
    }

    public class PyList$list_index_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_index_exposer(String string) {
            super(string, 2, 4);
        }

        public PyList$list_index_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list_index_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyList)this.self).list_index(pyObject, Py.py2int(pyObject2), pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyList)this.self).list_index(pyObject, Py.py2int(pyObject2), null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyList)this.self).list_index(pyObject, 0, null));
        }
    }

    public class PyList$list_insert_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_insert_exposer(String string) {
            super(string, 3, 3);
        }

        public PyList$list_insert_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list_insert_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyList)this.self).list_insert(Py.py2int(pyObject), pyObject2);
            return Py.None;
        }
    }

    public class PyList$list_remove_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_remove_exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list_remove_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list_remove_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyList)this.self).list_remove(pyObject);
            return Py.None;
        }
    }

    public class PyList$list_reverse_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_reverse_exposer(String string) {
            super(string, 1, 1);
        }

        public PyList$list_reverse_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list_reverse_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            ((PyList)this.self).list_reverse();
            return Py.None;
        }
    }

    public class PyList$list_pop_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_pop_exposer(String string) {
            super(string, 1, 2);
        }

        public PyList$list_pop_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list_pop_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyList)this.self).list_pop(Py.py2int(pyObject));
        }

        public PyObject __call__() {
            return ((PyList)this.self).list_pop(-1);
        }
    }

    public class PyList$list_extend_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_extend_exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list_extend_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list_extend_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyList)this.self).list_extend(pyObject);
            return Py.None;
        }
    }

    public class PyList$list___iadd___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___iadd___exposer(String string) {
            super(string, 2, 2);
        }

        public PyList$list___iadd___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___iadd___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyList)this.self).list___iadd__(pyObject);
        }
    }

    public class PyList$list_sort_exposer
    extends PyBuiltinMethod {
        public PyList$list_sort_exposer(String string) {
            super(string);
        }

        public PyList$list_sort_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list_sort_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyList)this.self).list_sort(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyList$list___hash___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___hash___exposer(String string) {
            super(string, 1, 1);
        }

        public PyList$list___hash___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyList$list___hash___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyList)this.self).list___hash__());
        }
    }

    public class PyList$exposed___new__
    extends PyOverridableNew {
        public PyObject createOfType(boolean bl, PyObject[] pyObjectArray, String[] stringArray) {
            PyList pyList = new PyList(this.for_type);
            if (bl) {
                pyList.list___init__(pyObjectArray, stringArray);
            }
            return pyList;
        }

        public PyObject createOfSubtype(PyType pyType) {
            return new PyListDerived(pyType);
        }
    }

    public class PyList$PyExposer
    extends TypeExposer.BaseTypeBuilder {
        public PyList$PyExposer() {
            PyBuiltinFunction[] pyBuiltinFunctionArray = new PyBuiltinFunction[]{new PyList$list___init___exposer("__init__"), new PyList$list___len___exposer("__len__"), new PyList$list___ne___exposer("__ne__"), new PyList$list___eq___exposer("__eq__"), new PyList$list___lt___exposer("__lt__"), new PyList$list___le___exposer("__le__"), new PyList$list___gt___exposer("__gt__"), new PyList$list___ge___exposer("__ge__"), new PyList$list___imul___exposer("__imul__"), new PyList$list___mul___exposer("__mul__"), new PyList$list___rmul___exposer("__rmul__"), new PyList$list___add___exposer("__add__"), new PyList$list___radd___exposer("__radd__"), new PyList$list___contains___exposer("__contains__"), new PyList$list___delitem___exposer("__delitem__"), new PyList$list___setitem___exposer("__setitem__"), new PyList$list___getitem___exposer("__getitem__"), new PyList$list___nonzero___exposer("__nonzero__"), new PyList$list___getslice___exposer("__getslice__"), new PyList$list___setslice___exposer("__setslice__"), new PyList$list___delslice___exposer("__delslice__"), new PyList$list_toString_exposer("__repr__"), new PyList$list_append_exposer("append"), new PyList$list_count_exposer("count"), new PyList$list_index_exposer("index"), new PyList$list_insert_exposer("insert"), new PyList$list_remove_exposer("remove"), new PyList$list_reverse_exposer("reverse"), new PyList$list_pop_exposer("pop"), new PyList$list_extend_exposer("extend"), new PyList$list___iadd___exposer("__iadd__"), new PyList$list_sort_exposer("sort"), new PyList$list___hash___exposer("__hash__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("list", PyList.class, PyObject.class, pyBuiltinFunctionArray, pyDataDescrArray, new PyList$exposed___new__());
        }
    }
}

