/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyDescriptor;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyType;

public class PyMethodDescr
extends PyDescriptor
implements PyBuiltinFunction.Info {
    protected int minargs;
    protected int maxargs;
    protected PyBuiltinFunction meth;

    public PyMethodDescr(PyType t, PyBuiltinFunction func) {
        this(func.info.getName(), t, func.info.getMinargs(), func.info.getMaxargs(), func);
    }

    public PyMethodDescr(String name, Class c, int minargs, int maxargs, PyBuiltinFunction func) {
        this(name, PyType.fromClass(c), minargs, maxargs, func);
    }

    public PyMethodDescr(String name, PyType type, int minargs, int maxargs, PyBuiltinFunction func) {
        this.name = name;
        this.dtype = type;
        this.minargs = minargs;
        this.maxargs = maxargs;
        this.meth = func;
        this.meth.setInfo(this);
    }

    public String getName() {
        return this.name;
    }

    public int getMaxargs() {
        return this.maxargs;
    }

    public int getMinargs() {
        return this.minargs;
    }

    public String toString() {
        return "<method '" + this.name + "' of '" + this.dtype.fastGetName() + "' objects>";
    }

    public PyObject __call__(PyObject[] args, String[] kwargs) {
        if (args.length == kwargs.length) {
            throw Py.TypeError(this.name + " requires at least one argument");
        }
        this.checkCallerType(args[0]);
        PyObject[] actualArgs = new PyObject[args.length - 1];
        System.arraycopy(args, 1, actualArgs, 0, actualArgs.length);
        return this.meth.bind(args[0]).__call__(actualArgs, kwargs);
    }

    public PyException unexpectedCall(int nargs, boolean keywords) {
        return PyBuiltinFunction.DefaultInfo.unexpectedCall(nargs, keywords, this.name, this.minargs, this.maxargs);
    }

    public PyObject __get__(PyObject obj, PyObject type) {
        if (obj != null) {
            this.checkCallerType(obj);
            return this.meth.bind(obj);
        }
        return this;
    }

    protected void checkCallerType(PyObject obj) {
        PyType objtype = obj.getType();
        if (objtype != this.dtype && !objtype.isSubType(this.dtype)) {
            throw this.get_wrongtype(objtype);
        }
    }
}

