/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyException;
import org.python.core.PyGetSetDescr;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySliceDerived;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;

public class PySlice
extends PyObject {
    public static final String exposed_name = "slice";
    private static final PyType SLICE_TYPE = PyType.fromClass(PySlice.class);
    private static final int START = 0;
    private static final int STOP = 1;
    private static final int STEP = 2;
    public PyObject start = Py.None;
    public PyObject stop = Py.None;
    public PyObject step = Py.None;

    public static void typeSetup(PyObject dict, PyType.Newstyle marker) {
        dict.__setitem__("start", (PyObject)new PyGetSetDescr("start", PySlice.class, "getStart", null, null));
        dict.__setitem__("stop", (PyObject)new PyGetSetDescr("stop", PySlice.class, "getStop", null, null));
        dict.__setitem__("step", (PyObject)new PyGetSetDescr("step", PySlice.class, "getStep", null, null));
        class Exposed_indices
        extends PyBuiltinMethodNarrow {
            Exposed_indices(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_indices(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                return ((PySlice)this.self).slice_indices(arg0);
            }
        }
        dict.__setitem__("indices", (PyObject)new PyMethodDescr("indices", PySlice.class, 1, 1, (PyBuiltinFunction)new Exposed_indices(null, null)));
        class Exposed___hash__
        extends PyBuiltinMethodNarrow {
            Exposed___hash__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___hash__(self, this.info);
            }

            public PyObject __call__() {
                throw Py.TypeError("unhashable type");
            }
        }
        dict.__setitem__("__hash__", (PyObject)new PyMethodDescr("__hash__", PySlice.class, 0, 0, (PyBuiltinFunction)new Exposed___hash__(null, null)));
        class Exposed___init__
        extends PyBuiltinMethod {
            Exposed___init__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___init__(self, this.info);
            }

            public PyObject __call__(PyObject[] args) {
                return this.__call__(args, Py.NoKeywords);
            }

            public PyObject __call__(PyObject[] args, String[] keywords) {
                ((PySlice)this.self).slice_init(args, keywords);
                return Py.None;
            }
        }
        dict.__setitem__("__init__", (PyObject)new PyMethodDescr("__init__", PySlice.class, -1, -1, (PyBuiltinFunction)new Exposed___init__(null, null)));
        dict.__setitem__("__new__", (PyObject)new PyNewWrapper(PySlice.class, "__new__", -1, -1){

            public PyObject new_impl(boolean init, PyType subtype, PyObject[] args, String[] keywords) {
                PySlice newobj;
                if (this.for_type == subtype) {
                    newobj = new PySlice();
                    if (init) {
                        newobj.slice_init(args, keywords);
                    }
                } else {
                    newobj = new PySliceDerived(subtype);
                }
                return newobj;
            }
        });
    }

    final void slice_init(PyObject[] args, String[] keywords) {
        if (args.length == 0) {
            throw Py.TypeError("slice expected at least 1 arguments, got " + args.length);
        }
        if (args.length > 3) {
            throw Py.TypeError("slice expected at most 3 arguments, got " + args.length);
        }
        ArgParser ap = new ArgParser(exposed_name, args, keywords, "start", "stop", "step");
        if (args.length == 1) {
            this.stop = ap.getPyObject(0);
        } else if (args.length == 2) {
            this.start = ap.getPyObject(0);
            this.stop = ap.getPyObject(1);
        } else if (args.length == 3) {
            this.start = ap.getPyObject(0);
            this.stop = ap.getPyObject(1);
            this.step = ap.getPyObject(2);
        }
    }

    public PySlice(PyObject start, PyObject stop, PyObject step) {
        this(SLICE_TYPE);
        if (start != null) {
            this.start = start;
        }
        if (stop != null) {
            this.stop = stop;
        }
        if (step != null) {
            this.step = step;
        }
    }

    public PySlice(PyType type) {
        super(type);
    }

    public PySlice() {
        this(SLICE_TYPE);
    }

    public final PyObject getStart() {
        return this.start;
    }

    public final PyObject getStop() {
        return this.stop;
    }

    public final PyObject getStep() {
        return this.step;
    }

    public int hashCode() {
        return this.slice_hashCode();
    }

    final int slice_hashCode() {
        throw Py.TypeError("unhashable type");
    }

    public PyString __str__() {
        return new PyString(this.getStart().__repr__() + ":" + this.getStop().__repr__() + ":" + this.getStep().__repr__());
    }

    public PyString __repr__() {
        return new PyString("slice(" + this.getStart().__repr__() + ", " + this.getStop().__repr__() + ", " + this.getStep().__repr__() + ")");
    }

    public PyObject __eq__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        if (this == o) {
            return Py.True;
        }
        PySlice oSlice = (PySlice)o;
        if (PySlice.eq(this.getStart(), oSlice.getStart()) && PySlice.eq(this.getStop(), oSlice.getStop()) && PySlice.eq(this.getStep(), oSlice.getStep())) {
            return Py.True;
        }
        return Py.False;
    }

    private static final boolean eq(PyObject o1, PyObject o2) {
        return o1._cmp(o2) == 0;
    }

    public PyObject __ne__(PyObject o) {
        return this.__eq__(o).__not__();
    }

    public PyObject slice_indices(PyObject len) {
        int ilen;
        try {
            ilen = len.asInt(0);
        }
        catch (PyObject.ConversionException e) {
            throw Py.TypeError("length must be an int");
        }
        int[] slice = this.indices(ilen);
        PyObject[] pyInts = new PyInteger[slice.length];
        for (int i = 0; i < pyInts.length; ++i) {
            pyInts[i] = Py.newInteger(slice[i]);
        }
        return new PyTuple(pyInts);
    }

    private static int calculateSliceIndex(PyObject v) {
        block5: {
            if (v instanceof PyInteger) {
                return ((PyInteger)v).getValue();
            }
            if (v instanceof PyLong) {
                try {
                    return ((PyInteger)v.__int__()).getValue();
                }
                catch (PyException exc) {
                    if (!Py.matchException(exc, Py.OverflowError)) break block5;
                    if (new PyLong(0L).__cmp__(v) < 0) {
                        return Integer.MAX_VALUE;
                    }
                    return 0;
                }
            }
        }
        throw Py.TypeError("slice indices must be integers or None");
    }

    public int[] indices(int len) {
        int[] slice = new int[3];
        if (this.getStep() == Py.None) {
            slice[2] = 1;
        } else {
            slice[2] = PySlice.calculateSliceIndex(this.getStep());
            if (slice[2] == 0) {
                throw Py.ValueError("slice step cannot be zero");
            }
        }
        if (this.getStart() == Py.None) {
            slice[0] = slice[2] < 0 ? len - 1 : 0;
        } else {
            slice[0] = PySlice.calculateSliceIndex(this.getStart());
            if (slice[0] < 0) {
                slice[0] = slice[0] + len;
            }
            if (slice[0] < 0) {
                int n = slice[0] = slice[2] < 0 ? -1 : 0;
            }
            if (slice[0] >= len) {
                int n = slice[0] = slice[2] < 0 ? len - 1 : len;
            }
        }
        if (this.getStop() == Py.None) {
            slice[1] = slice[2] < 0 ? -1 : len;
        } else {
            slice[1] = PySlice.calculateSliceIndex(this.getStop());
            if (slice[1] < 0) {
                slice[1] = slice[1] + len;
            }
            if (slice[1] < 0) {
                slice[1] = -1;
            }
            if (slice[1] > len) {
                slice[1] = len;
            }
        }
        return slice;
    }
}

