/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.math.BigInteger;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyComplex;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyStringDerived;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.StringFormatter;
import org.python.core.codecs;
import org.python.core.imp;
import org.python.core.ucnhashAPI;
import org.python.core.util.StringUtil;
import org.python.expose.ExposedNew;
import org.python.expose.generate.TypeExposer;

public class PyString
extends PyBaseString {
    public static final PyType TYPE;
    protected String string;
    private transient int cached_hashcode = 0;
    protected transient boolean interned = false;
    private static char[] hexdigit;
    private static ucnhashAPI pucnHash;

    public PyString() {
        this(TYPE, "");
    }

    public PyString(PyType pyType, String string) {
        super(pyType);
        if (string == null) {
            throw new IllegalArgumentException("Cannot create PyString from null!");
        }
        this.string = string;
    }

    public PyString(String string) {
        this(TYPE, string);
    }

    public PyString(char c) {
        this(TYPE, String.valueOf(c));
    }

    public static PyString fromInterned(String string) {
        PyString pyString = new PyString(TYPE, string);
        pyString.interned = true;
        return pyString;
    }

    @ExposedNew
    static final PyObject str_new(PyNewWrapper pyNewWrapper, boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("str", pyObjectArray, stringArray, new String[]{"object"}, 0);
        PyObject pyObject = argParser.getPyObject(0, null);
        if (pyNewWrapper.for_type == pyType) {
            if (pyObject == null) {
                return new PyString("");
            }
            return new PyString(pyObject.__str__().toString());
        }
        if (pyObject == null) {
            return new PyStringDerived(pyType, "");
        }
        return new PyStringDerived(pyType, pyObject.__str__().toString());
    }

    public PyString __str__() {
        return this.str___str__();
    }

    final PyString str___str__() {
        return this;
    }

    public PyUnicode __unicode__() {
        return this.str___unicode__();
    }

    final PyUnicode str___unicode__() {
        return new PyUnicode(this);
    }

    public int __len__() {
        return this.str___len__();
    }

    final int str___len__() {
        return this.string.length();
    }

    public String toString() {
        return this.str_toString();
    }

    final String str_toString() {
        return this.string;
    }

    public String internedString() {
        if (this.interned) {
            return this.string;
        }
        this.string = this.string.intern();
        this.interned = true;
        return this.string;
    }

    public PyString __repr__() {
        return new PyString(PyString.encode_UnicodeEscape(this.string, true));
    }

    public static String encode_UnicodeEscape(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char c = '\u0000';
        if (bl) {
            c = string.indexOf(39) >= 0 && string.indexOf(34) == -1 ? (char)'\"' : '\'';
            stringBuffer.append(c);
        }
        int n2 = 0;
        while (n-- > 0) {
            char c2 = string.charAt(n2++);
            if (bl && (c2 == c || c2 == '\\')) {
                stringBuffer.append('\\');
                stringBuffer.append(c2);
                continue;
            }
            if (c2 >= '\ud800' && c2 < '\udc00') {
                char c3 = string.charAt(n2++);
                --n;
                if (c3 >= '\udc00' && c3 <= '\udfff') {
                    int n3 = ((c2 & 0x3FF) << 10 | c3 & 0x3FF) + 65536;
                    stringBuffer.append('\\');
                    stringBuffer.append('U');
                    stringBuffer.append(hexdigit[n3 >> 28 & 0xF]);
                    stringBuffer.append(hexdigit[n3 >> 24 & 0xF]);
                    stringBuffer.append(hexdigit[n3 >> 20 & 0xF]);
                    stringBuffer.append(hexdigit[n3 >> 16 & 0xF]);
                    stringBuffer.append(hexdigit[n3 >> 12 & 0xF]);
                    stringBuffer.append(hexdigit[n3 >> 8 & 0xF]);
                    stringBuffer.append(hexdigit[n3 >> 4 & 0xF]);
                    stringBuffer.append(hexdigit[n3 & 0xF]);
                    continue;
                }
                --n2;
                ++n;
            }
            if (c2 >= '\u0100') {
                stringBuffer.append('\\');
                stringBuffer.append('u');
                stringBuffer.append(hexdigit[c2 >> 12 & 0xF]);
                stringBuffer.append(hexdigit[c2 >> 8 & 0xF]);
                stringBuffer.append(hexdigit[c2 >> 4 & 0xF]);
                stringBuffer.append(hexdigit[c2 & 0xF]);
                continue;
            }
            if (bl && c2 == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            if (bl && c2 == '\t') {
                stringBuffer.append("\\t");
                continue;
            }
            if (bl && c2 == '\b') {
                stringBuffer.append("\\b");
                continue;
            }
            if (bl && c2 == '\f') {
                stringBuffer.append("\\f");
                continue;
            }
            if (bl && c2 == '\r') {
                stringBuffer.append("\\r");
                continue;
            }
            if (c2 < ' ' || c2 >= '\u007f') {
                stringBuffer.append('\\');
                stringBuffer.append('x');
                stringBuffer.append(hexdigit[c2 >> 4 & 0xF]);
                stringBuffer.append(hexdigit[c2 & 0xF]);
                continue;
            }
            stringBuffer.append(c2);
        }
        if (bl) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String decode_UnicodeEscape(String string, int n, int n2, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(n2 - n);
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c != '\\') {
                stringBuffer.append(c);
                ++n3;
                continue;
            }
            int n4 = n3++;
            if (n3 == n2) {
                n3 = codecs.insertReplacementAndGetResume(stringBuffer, string2, "unicodeescape", string, n4, n3 + 1, "\\ at end of string");
                continue;
            }
            c = string.charAt(n3++);
            switch (c) {
                case '\n': {
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    break;
                }
                case '\'': {
                    stringBuffer.append('\'');
                    break;
                }
                case '\"': {
                    stringBuffer.append('\"');
                    break;
                }
                case 'b': {
                    stringBuffer.append('\b');
                    break;
                }
                case 'f': {
                    stringBuffer.append('\f');
                    break;
                }
                case 't': {
                    stringBuffer.append('\t');
                    break;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    break;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    break;
                }
                case 'v': {
                    stringBuffer.append('\u000b');
                    break;
                }
                case 'a': {
                    stringBuffer.append('\u0007');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int n5 = Character.digit(c, 8);
                    for (int i = 0; i < 2 && n3 < n2 && (c = string.charAt(n3)) >= '0' && c <= '7'; ++i, ++n3) {
                        n5 = (n5 << 3) + Character.digit(c, 8);
                    }
                    stringBuffer.append((char)n5);
                    break;
                }
                case 'x': {
                    n3 = PyString.hexescape(stringBuffer, string2, 2, n3, string, n2, "truncated \\xXX");
                    break;
                }
                case 'u': {
                    if (!bl) {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        break;
                    }
                    n3 = PyString.hexescape(stringBuffer, string2, 4, n3, string, n2, "truncated \\uXXXX");
                    break;
                }
                case 'U': {
                    if (!bl) {
                        stringBuffer.append('\\');
                        stringBuffer.append('U');
                        break;
                    }
                    n3 = PyString.hexescape(stringBuffer, string2, 8, n3, string, n2, "truncated \\UXXXXXXXX");
                    break;
                }
                case 'N': {
                    if (!bl) {
                        stringBuffer.append('\\');
                        stringBuffer.append('N');
                        break;
                    }
                    if (pucnHash == null) {
                        PyObject pyObject = imp.importName("ucnhash", true);
                        pucnHash = (ucnhashAPI)(pyObject = pyObject.__call__()).__tojava__(Object.class);
                        if (pucnHash.getCchMax() < 0) {
                            throw Py.UnicodeError("Unicode names not loaded");
                        }
                    }
                    if (string.charAt(n3) == '{') {
                        int n6;
                        int n7;
                        int n8 = pucnHash.getCchMax();
                        for (n7 = n6 = n3 + 1; n7 < n2 && string.charAt(n7) != '}' && n7 - n6 <= n8; ++n7) {
                        }
                        if (n7 != n2 && string.charAt(n7) == '}') {
                            int n9 = pucnHash.getValue(string, n6, n7);
                            if (PyString.storeUnicodeCharacter(n9, stringBuffer)) {
                                n3 = n7 + 1;
                                break;
                            }
                            n3 = codecs.insertReplacementAndGetResume(stringBuffer, string2, "unicodeescape", string, n4, n7 + 1, "illegal Unicode character");
                            break;
                        }
                        n3 = codecs.insertReplacementAndGetResume(stringBuffer, string2, "unicodeescape", string, n4, n7, "malformed \\N character escape");
                        break;
                    }
                    n3 = codecs.insertReplacementAndGetResume(stringBuffer, string2, "unicodeescape", string, n4, n3 + 1, "malformed \\N character escape");
                    break;
                }
                default: {
                    stringBuffer.append('\\');
                    stringBuffer.append(string.charAt(n3 - 1));
                }
            }
        }
        return stringBuffer.toString();
    }

    private static int hexescape(StringBuffer stringBuffer, String string, int n, int n2, String string2, int n3, String string3) {
        int n4;
        if (n2 + n > n3) {
            return codecs.insertReplacementAndGetResume(stringBuffer, string, "unicodeescape", string2, n2 - 2, n3, string3);
        }
        int n5 = 0;
        for (n4 = 0; n4 < n; ++n4) {
            char c = string2.charAt(n2 + n4);
            int n6 = Character.digit(c, 16);
            if (n6 == -1) {
                return codecs.insertReplacementAndGetResume(stringBuffer, string, "unicodeescape", string2, n2 - 2, n2 + n4 + 1, string3);
            }
            n5 = n5 << 4 & 0xFFFFFFF0;
            if (c >= '0' && c <= '9') {
                n5 += c - 48;
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                n5 += 10 + c - 97;
                continue;
            }
            n5 += 10 + c - 65;
        }
        if (PyString.storeUnicodeCharacter(n5, stringBuffer)) {
            return n2 + n4;
        }
        return codecs.insertReplacementAndGetResume(stringBuffer, string, "unicodeescape", string2, n2 - 2, n2 + n4 + 1, "illegal Unicode character");
    }

    private static boolean storeUnicodeCharacter(int n, StringBuffer stringBuffer) {
        if (n < 0) {
            return false;
        }
        if (n < 65536) {
            stringBuffer.append((char)n);
            return true;
        }
        if (n <= 0x10FFFF) {
            stringBuffer.append((char)(55296 + ((n -= 65536) >> 10)));
            stringBuffer.append((char)(56320 + (n & 0xFFFF03FF)));
            return true;
        }
        return false;
    }

    public PyObject str___getitem__(PyObject pyObject) {
        return this.seq___finditem__(pyObject);
    }

    public PyObject str___getslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        return this.seq___getslice__(pyObject, pyObject2, pyObject3);
    }

    public int __cmp__(PyObject pyObject) {
        return this.str___cmp__(pyObject);
    }

    final int str___cmp__(PyObject pyObject) {
        if (!(pyObject instanceof PyString)) {
            return -2;
        }
        int n = this.string.compareTo(((PyString)pyObject).string);
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public PyObject __eq__(PyObject pyObject) {
        return this.str___eq__(pyObject);
    }

    final PyObject str___eq__(PyObject pyObject) {
        String string = PyString.coerce(pyObject);
        if (string == null) {
            return null;
        }
        return this.string.equals(string) ? Py.True : Py.False;
    }

    public PyObject __ne__(PyObject pyObject) {
        return this.str___ne__(pyObject);
    }

    final PyObject str___ne__(PyObject pyObject) {
        String string = PyString.coerce(pyObject);
        if (string == null) {
            return null;
        }
        return this.string.equals(string) ? Py.False : Py.True;
    }

    public PyObject __lt__(PyObject pyObject) {
        return this.str___lt__(pyObject);
    }

    final PyObject str___lt__(PyObject pyObject) {
        String string = PyString.coerce(pyObject);
        if (string == null) {
            return null;
        }
        return this.string.compareTo(string) < 0 ? Py.True : Py.False;
    }

    public PyObject __le__(PyObject pyObject) {
        return this.str___le__(pyObject);
    }

    final PyObject str___le__(PyObject pyObject) {
        String string = PyString.coerce(pyObject);
        if (string == null) {
            return null;
        }
        return this.string.compareTo(string) <= 0 ? Py.True : Py.False;
    }

    public PyObject __gt__(PyObject pyObject) {
        return this.str___gt__(pyObject);
    }

    final PyObject str___gt__(PyObject pyObject) {
        String string = PyString.coerce(pyObject);
        if (string == null) {
            return null;
        }
        return this.string.compareTo(string) > 0 ? Py.True : Py.False;
    }

    public PyObject __ge__(PyObject pyObject) {
        return this.str___ge__(pyObject);
    }

    final PyObject str___ge__(PyObject pyObject) {
        String string = PyString.coerce(pyObject);
        if (string == null) {
            return null;
        }
        return this.string.compareTo(string) >= 0 ? Py.True : Py.False;
    }

    private static String coerce(PyObject pyObject) {
        if (pyObject instanceof PyString) {
            return pyObject.toString();
        }
        return null;
    }

    public int hashCode() {
        return this.str___hash__();
    }

    final int str___hash__() {
        if (this.cached_hashcode == 0) {
            this.cached_hashcode = this.string.hashCode();
        }
        return this.cached_hashcode;
    }

    public byte[] toBytes() {
        return StringUtil.toBytes(this.string);
    }

    public Object __tojava__(Class clazz) {
        if (clazz.isAssignableFrom(String.class)) {
            return this.string;
        }
        if ((clazz == Character.TYPE || clazz == Character.class) && this.string.length() == 1) {
            return new Character(this.string.charAt(0));
        }
        if (clazz.isArray()) {
            if (clazz.getComponentType() == Byte.TYPE) {
                return this.toBytes();
            }
            if (clazz.getComponentType() == Character.TYPE) {
                return this.string.toCharArray();
            }
        }
        if (clazz.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    protected PyObject pyget(int n) {
        return Py.newString(this.string.charAt(n));
    }

    protected PyObject getslice(int n, int n2, int n3) {
        if (n3 > 0 && n2 < n) {
            n2 = n;
        }
        if (n3 == 1) {
            return this.fromSubstring(n, n2);
        }
        int n4 = PyString.sliceLength(n, n2, n3);
        char[] cArray = new char[n4];
        int n5 = 0;
        int n6 = n;
        while (n5 < n4) {
            cArray[n5++] = this.string.charAt(n6);
            n6 += n3;
        }
        return this.createInstance(new String(cArray));
    }

    public PyString createInstance(String string) {
        return new PyString(string);
    }

    public boolean __contains__(PyObject pyObject) {
        return this.str___contains__(pyObject);
    }

    final boolean str___contains__(PyObject pyObject) {
        if (!(pyObject instanceof PyString)) {
            throw Py.TypeError("'in <string>' requires string as left operand");
        }
        PyString pyString = (PyString)pyObject;
        return this.string.indexOf(pyString.string) >= 0;
    }

    protected PyObject repeat(int n) {
        int n2;
        if (n < 0) {
            n = 0;
        }
        if ((long)(n2 = this.string.length()) * (long)n > Integer.MAX_VALUE) {
            throw Py.OverflowError("max str len is 2147483647");
        }
        char[] cArray = new char[n2 * n];
        for (int i = 0; i < n; ++i) {
            this.string.getChars(0, n2, cArray, i * n2);
        }
        return this.createInstance(new String(cArray));
    }

    final PyObject str___mul__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger) && !(pyObject instanceof PyLong)) {
            return null;
        }
        int n = ((PyInteger)pyObject.__int__()).getValue();
        return this.repeat(n);
    }

    final PyObject str___rmul__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger) && !(pyObject instanceof PyLong)) {
            return null;
        }
        int n = ((PyInteger)pyObject.__int__()).getValue();
        return this.repeat(n);
    }

    public PyObject __add__(PyObject pyObject) {
        return this.str___add__(pyObject);
    }

    final PyObject str___add__(PyObject pyObject) {
        if (pyObject.getClass() == PyUnicode.class || pyObject.getClass() == PyString.class) {
            PyString pyString = (PyString)pyObject;
            String string = this.string.concat(pyString.string);
            if (pyObject.getClass() == PyUnicode.class) {
                return new PyUnicode(string);
            }
            return this.createInstance(string);
        }
        return null;
    }

    final PyTuple str___getnewargs__() {
        return new PyTuple(new PyString(this.string));
    }

    public PyTuple __getnewargs__() {
        return this.str___getnewargs__();
    }

    public PyObject __mod__(PyObject pyObject) {
        return this.str___mod__(pyObject);
    }

    public PyObject str___mod__(PyObject pyObject) {
        StringFormatter stringFormatter = new StringFormatter(this.string);
        return stringFormatter.format(pyObject);
    }

    public PyObject __int__() {
        try {
            return Py.newInteger(this.atoi(10));
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, Py.ValueError)) {
                return this.atol(10);
            }
            throw pyException;
        }
    }

    public PyLong __long__() {
        return this.atol(10);
    }

    public PyFloat __float__() {
        return new PyFloat(this.atof());
    }

    public PyObject __pos__() {
        throw Py.TypeError("bad operand type for unary +");
    }

    public PyObject __neg__() {
        throw Py.TypeError("bad operand type for unary -");
    }

    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    public PyComplex __complex__() {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = this.string.length();
        for (n = 0; n < n2 && Character.isSpaceChar(this.string.charAt(n)); ++n) {
        }
        if (n == n2) {
            throw Py.ValueError("empty string for complex()");
        }
        double d = -1.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 1;
        block7: do {
            char c = this.string.charAt(n);
            switch (c) {
                case '-': {
                    n3 = -1;
                }
                case '+': {
                    if (bl3 || n + 1 == n2) {
                        bl4 = true;
                        break;
                    }
                    if (Character.isDigit(c = this.string.charAt(++n)) || c == 'J' || c == 'j') continue block7;
                    bl4 = true;
                    break;
                }
                case 'J': 
                case 'j': {
                    if (bl2 || bl3) {
                        bl4 = true;
                        break;
                    }
                    d3 = d < 0.0 ? (double)n3 : (double)n3 * d;
                    bl2 = true;
                    bl3 = bl;
                    n3 = 1;
                    ++n;
                    break;
                }
                case ' ': {
                    while (n < n2 && Character.isSpaceChar(this.string.charAt(n))) {
                        ++n;
                    }
                    if (n == n2) continue block7;
                    bl4 = true;
                    break;
                }
                default: {
                    boolean bl5;
                    boolean bl6 = bl5 = c == '.' || Character.isDigit(c);
                    if (!bl5) {
                        bl4 = true;
                        break;
                    }
                    int n4 = this.endDouble(this.string, n);
                    d = Double.valueOf(this.string.substring(n, n4));
                    n = n4;
                    if (n < n2 && ((c = this.string.charAt(n)) == 'J' || c == 'j')) continue block7;
                    if (bl) {
                        bl4 = true;
                        break;
                    }
                    d2 = (double)n3 * d;
                    bl = true;
                    bl3 = bl2;
                    d = -1.0;
                    n3 = 1;
                }
            }
        } while (n < n2 && !bl4);
        if (bl4) {
            throw Py.ValueError("malformed string for complex() " + this.string.substring(n));
        }
        return new PyComplex(d2, d3);
    }

    private int endDouble(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            char c;
            if (Character.isDigit(c = string.charAt(n++)) || c == '.') continue;
            if ((c == 'e' || c == 'E') && n < n2) {
                c = string.charAt(n);
                if (c != '+' && c != '-') continue;
                ++n;
                continue;
            }
            return n - 1;
        }
        return n;
    }

    public String lower() {
        return this.str_lower();
    }

    final String str_lower() {
        return this.string.toLowerCase();
    }

    public String upper() {
        return this.str_upper();
    }

    final String str_upper() {
        return this.string.toUpperCase();
    }

    public String title() {
        return this.str_title();
    }

    final String str_title() {
        char[] cArray = this.string.toCharArray();
        int n = cArray.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            cArray[i] = bl ? Character.toLowerCase(c) : Character.toTitleCase(c);
            bl = Character.isLowerCase(c) || Character.isUpperCase(c) || Character.isTitleCase(c);
        }
        return new String(cArray);
    }

    public String swapcase() {
        return this.str_swapcase();
    }

    final String str_swapcase() {
        char[] cArray = this.string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (Character.isUpperCase(c)) {
                cArray[i] = Character.toLowerCase(c);
                continue;
            }
            if (!Character.isLowerCase(c)) continue;
            cArray[i] = Character.toUpperCase(c);
        }
        return new String(cArray);
    }

    public String strip() {
        return this.str_strip(null);
    }

    public String strip(String string) {
        return this.str_strip(string);
    }

    final String str_strip(String string) {
        int n;
        int n2;
        char[] cArray = this.string.toCharArray();
        int n3 = cArray.length;
        if (string == null) {
            for (n2 = 0; n2 < n3 && Character.isWhitespace(cArray[n2]); ++n2) {
            }
        } else {
            while (n2 < n3 && string.indexOf(cArray[n2]) >= 0) {
                ++n2;
            }
        }
        if (string == null) {
            for (n = n3 - 1; n >= 0 && Character.isWhitespace(cArray[n]); --n) {
            }
        } else {
            while (n >= 0 && string.indexOf(cArray[n]) >= 0) {
                --n;
            }
        }
        if (n >= n2) {
            return n < n3 - 1 || n2 > 0 ? this.string.substring(n2, n + 1) : this.string;
        }
        return "";
    }

    public String lstrip() {
        return this.str_lstrip(null);
    }

    public String lstrip(String string) {
        return this.str_lstrip(string);
    }

    final String str_lstrip(String string) {
        int n;
        char[] cArray = this.string.toCharArray();
        int n2 = cArray.length;
        if (string == null) {
            for (n = 0; n < n2 && Character.isWhitespace(cArray[n]); ++n) {
            }
        } else {
            while (n < n2 && string.indexOf(cArray[n]) >= 0) {
                ++n;
            }
        }
        return n > 0 ? this.string.substring(n, n2) : this.string;
    }

    public String rstrip(String string) {
        return this.str_rstrip(string);
    }

    final String str_rstrip(String string) {
        int n;
        char[] cArray = this.string.toCharArray();
        int n2 = cArray.length;
        if (string == null) {
            for (n = n2 - 1; n >= 0 && Character.isWhitespace(cArray[n]); --n) {
            }
        } else {
            while (n >= 0 && string.indexOf(cArray[n]) >= 0) {
                --n;
            }
        }
        return n < n2 - 1 ? this.string.substring(0, n + 1) : this.string;
    }

    public PyList split() {
        return this.str_split(null, -1);
    }

    public PyList split(String string) {
        return this.str_split(string, -1);
    }

    public PyList split(String string, int n) {
        return this.str_split(string, n);
    }

    final PyList str_split(String string, int n) {
        if (string != null) {
            return this.splitfields(string, n);
        }
        PyList pyList = new PyList();
        char[] cArray = this.string.toCharArray();
        int n2 = cArray.length;
        if (n < 0) {
            n = n2;
        }
        int n3 = 0;
        for (int i = 0; n3 < n2 && i < n; ++i) {
            while (n3 < n2 && Character.isWhitespace(cArray[n3])) {
                ++n3;
            }
            if (n3 == n2) break;
            int n4 = n3;
            while (n3 < n2 && !Character.isWhitespace(cArray[n3])) {
                ++n3;
            }
            pyList.append(this.fromSubstring(n4, n3));
        }
        while (n3 < n2 && Character.isWhitespace(cArray[n3])) {
            ++n3;
        }
        if (n3 < n2) {
            pyList.append(this.fromSubstring(n3, n2));
        }
        return pyList;
    }

    private PyList splitfields(String string, int n) {
        int n2;
        PyList pyList = new PyList();
        int n3 = this.string.length();
        if (n < 0) {
            n = n3 + 1;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = string.length();
        if (string.length() == 0 && n != 0) {
            n2 = this.string.indexOf(string, n4);
            pyList.append(this.fromSubstring(n4, n2));
            ++n5;
        }
        while (n5 < n && (n2 = this.string.indexOf(string, n4)) != -1) {
            if (string.length() == 0) {
                ++n2;
            }
            ++n5;
            pyList.append(this.fromSubstring(n4, n2));
            n4 = n2 + n6;
        }
        if (n4 <= n3) {
            pyList.append(this.fromSubstring(n4, n3));
        }
        return pyList;
    }

    public PyList splitlines() {
        return this.str_splitlines(false);
    }

    public PyList splitlines(boolean bl) {
        return this.str_splitlines(bl);
    }

    final PyList str_splitlines(boolean bl) {
        PyList pyList = new PyList();
        char[] cArray = this.string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            while (n3 < n && cArray[n3] != '\n' && cArray[n3] != '\r' && Character.getType(cArray[n3]) != 13) {
                ++n3;
            }
            int n4 = n3;
            if (n3 < n) {
                n3 = cArray[n3] == '\r' && n3 + 1 < n && cArray[n3 + 1] == '\n' ? (n3 += 2) : ++n3;
                if (bl) {
                    n4 = n3;
                }
            }
            pyList.append(this.fromSubstring(n2, n4));
            n2 = n3;
        }
        if (n2 < n) {
            pyList.append(this.fromSubstring(n2, n));
        }
        return pyList;
    }

    protected PyString fromSubstring(int n, int n2) {
        return this.createInstance(this.string.substring(n, n2));
    }

    public int index(String string) {
        return this.str_index(string, 0, null);
    }

    public int index(String string, int n) {
        return this.str_index(string, n, null);
    }

    public int index(String string, int n, int n2) {
        return this.str_index(string, n, Py.newInteger(n2));
    }

    final int str_index(String string, int n, PyObject pyObject) {
        int n2 = this.str_find(string, n, pyObject);
        if (n2 == -1) {
            throw Py.ValueError("substring not found in string.index");
        }
        return n2;
    }

    public int rindex(String string) {
        return this.str_rindex(string, 0, null);
    }

    public int rindex(String string, int n) {
        return this.str_rindex(string, n, null);
    }

    public int rindex(String string, int n, int n2) {
        return this.str_rindex(string, n, Py.newInteger(n2));
    }

    final int str_rindex(String string, int n, PyObject pyObject) {
        int n2 = this.str_rfind(string, n, pyObject);
        if (n2 == -1) {
            throw Py.ValueError("substring not found in string.rindex");
        }
        return n2;
    }

    public int count(String string) {
        return this.str_count(string, 0, null);
    }

    public int count(String string, int n) {
        return this.str_count(string, n, null);
    }

    public int count(String string, int n, int n2) {
        return this.str_count(string, n, Py.newInteger(n2));
    }

    final int str_count(String string, int n, PyObject pyObject) {
        int[] nArray = this.translateIndices(n, pyObject);
        int n2 = string.length();
        if (n2 == 0) {
            return nArray[1] - nArray[0] + 1;
        }
        int n3 = 0;
        while (true) {
            int n4 = this.string.indexOf(string, nArray[0]);
            nArray[0] = n4 + n2;
            if (nArray[0] > nArray[1] || n4 == -1) break;
            ++n3;
        }
        return n3;
    }

    public int find(String string) {
        return this.str_find(string, 0, null);
    }

    public int find(String string, int n) {
        return this.str_find(string, n, null);
    }

    public int find(String string, int n, int n2) {
        return this.str_find(string, n, Py.newInteger(n2));
    }

    final int str_find(String string, int n, PyObject pyObject) {
        int[] nArray = this.translateIndices(n, pyObject);
        int n2 = this.string.indexOf(string, nArray[0]);
        if (n2 > nArray[1]) {
            return -1;
        }
        return n2;
    }

    public int rfind(String string) {
        return this.str_rfind(string, 0, null);
    }

    public int rfind(String string, int n) {
        return this.str_rfind(string, n, null);
    }

    public int rfind(String string, int n, int n2) {
        return this.str_rfind(string, n, Py.newInteger(n2));
    }

    final int str_rfind(String string, int n, PyObject pyObject) {
        int[] nArray = this.translateIndices(n, pyObject);
        int n2 = this.string.lastIndexOf(string, nArray[1] - string.length());
        if (n2 < nArray[0]) {
            return -1;
        }
        return n2;
    }

    public double atof() {
        StringBuffer stringBuffer = null;
        int n = this.string.length();
        for (int i = 0; i < n; ++i) {
            char c = this.string.charAt(i);
            if (c == '\u0000') {
                throw Py.ValueError("null byte in argument for float()");
            }
            if (!Character.isDigit(c)) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(this.string);
            }
            int n2 = Character.digit(c, 10);
            stringBuffer.setCharAt(i, Character.forDigit(n2, 10));
        }
        String string = this.string;
        if (stringBuffer != null) {
            string = stringBuffer.toString();
        }
        try {
            String string2 = string.toLowerCase();
            if (string2.endsWith("d") || string2.endsWith("f")) {
                throw new NumberFormatException("format specifiers not allowed");
            }
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw Py.ValueError("invalid literal for __float__: " + this.string);
        }
    }

    public int atoi() {
        return this.atoi(10);
    }

    public int atoi(int n) {
        int n2;
        if (n != 0 && n < 2 || n > 36) {
            throw Py.ValueError("invalid base for atoi()");
        }
        int n3 = this.string.length();
        for (n2 = 0; n2 < n3 && Character.isWhitespace(this.string.charAt(n2)); ++n2) {
        }
        while (n3 > n2 && Character.isWhitespace(this.string.charAt(n3 - 1))) {
            --n3;
        }
        char c = '\u0000';
        if (n2 < n3) {
            c = this.string.charAt(n2);
            if (c == '-' || c == '+') {
                ++n2;
                while (n2 < n3 && Character.isWhitespace(this.string.charAt(n2))) {
                    ++n2;
                }
            }
            if ((n == 0 || n == 16) && this.string.charAt(n2) == '0') {
                if (n2 < n3 - 1 && Character.toUpperCase(this.string.charAt(n2 + 1)) == 'X') {
                    n = 16;
                    n2 += 2;
                } else if (n == 0) {
                    n = 8;
                }
            }
        }
        if (n == 0) {
            n = 10;
        }
        String string = this.string;
        if (n2 > 0 || n3 < this.string.length()) {
            string = this.string.substring(n2, n3);
        }
        try {
            long l = Long.parseLong(string, n);
            if (l < 0L && (c != '-' || l != -l)) {
                throw Py.ValueError("invalid literal for __int__: " + this.string);
            }
            if (c == '-') {
                l = -l;
            }
            if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                throw Py.ValueError("invalid literal for __int__: " + this.string);
            }
            return (int)l;
        }
        catch (NumberFormatException numberFormatException) {
            throw Py.ValueError("invalid literal for __int__: " + this.string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw Py.ValueError("invalid literal for __int__: " + this.string);
        }
    }

    public PyLong atol() {
        return this.atol(10);
    }

    public PyLong atol(int n) {
        int n2;
        String string = this.string;
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        while (n3 > n2 && Character.isWhitespace(string.charAt(n3 - 1))) {
            --n3;
        }
        if (n3 > n2 && (string.charAt(n3 - 1) == 'L' || string.charAt(n3 - 1) == 'l')) {
            --n3;
        }
        char c = '\u0000';
        if (n2 < n3) {
            c = this.string.charAt(n2);
            if (c == '-' || c == '+') {
                ++n2;
                while (n2 < n3 && Character.isWhitespace(string.charAt(n2))) {
                    ++n2;
                }
            }
            if ((n == 0 || n == 16) && this.string.charAt(n2) == '0') {
                if (n2 < n3 - 1 && Character.toUpperCase(this.string.charAt(n2 + 1)) == 'X') {
                    n = 16;
                    n2 += 2;
                } else if (n == 0) {
                    n = 8;
                }
            }
        }
        if (n == 0) {
            n = 10;
        }
        if (n < 2 || n > 36) {
            throw Py.ValueError("invalid base for long literal:" + n);
        }
        if (n2 > 0 || n3 < string.length()) {
            string = string.substring(n2, n3);
        }
        try {
            BigInteger bigInteger = null;
            bigInteger = c == '-' ? new BigInteger("-" + string, n) : new BigInteger(string, n);
            return new PyLong(bigInteger);
        }
        catch (NumberFormatException numberFormatException) {
            throw Py.ValueError("invalid literal for __long__: " + string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw Py.ValueError("invalid literal for __long__: " + string);
        }
    }

    private static String spaces(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        return new String(cArray);
    }

    public String ljust(int n) {
        return this.str_ljust(n);
    }

    final String str_ljust(int n) {
        int n2 = n - this.string.length();
        if (n2 <= 0) {
            return this.string;
        }
        return this.string + PyString.spaces(n2);
    }

    public String rjust(int n) {
        return this.str_rjust(n);
    }

    final String str_rjust(int n) {
        int n2 = n - this.string.length();
        if (n2 <= 0) {
            return this.string;
        }
        return PyString.spaces(n2) + this.string;
    }

    public String center(int n) {
        return this.str_center(n);
    }

    final String str_center(int n) {
        int n2 = n - this.string.length();
        if (n2 <= 0) {
            return this.string;
        }
        int n3 = n2 / 2;
        if (n2 % 2 > 0 && n % 2 > 0) {
            ++n3;
        }
        return PyString.spaces(n3) + this.string + PyString.spaces(n2 - n3);
    }

    public String zfill(int n) {
        return this.str_zfill(n);
    }

    final String str_zfill(int n) {
        char c;
        String string = this.string;
        int n2 = string.length();
        if (n2 >= n) {
            return string;
        }
        char[] cArray = new char[n];
        int n3 = n - n2;
        int n4 = 0;
        int n5 = 0;
        if (n2 > 0 && ((c = string.charAt(0)) == '+' || c == '-')) {
            cArray[0] = c;
            ++n4;
            ++n3;
            n5 = 1;
        }
        while (n4 < n3) {
            cArray[n4] = 48;
            ++n4;
        }
        string.getChars(n5, string.length(), cArray, n4);
        return new String(cArray);
    }

    public String expandtabs() {
        return this.str_expandtabs(8);
    }

    public String expandtabs(int n) {
        return this.str_expandtabs(n);
    }

    final String str_expandtabs(int n) {
        String string = this.string;
        StringBuffer stringBuffer = new StringBuffer((int)((double)string.length() * 1.5));
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            if (c == '\t') {
                int n4 = n - n3 % n;
                n3 += n4;
                while (n4-- > 0) {
                    stringBuffer.append(' ');
                }
                continue;
            }
            if (c == '\n' || c == '\r') {
                n3 = -1;
            }
            stringBuffer.append(c);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public String capitalize() {
        return this.str_capitalize();
    }

    final String str_capitalize() {
        if (this.string.length() == 0) {
            return this.string;
        }
        String string = this.string.substring(0, 1).toUpperCase();
        return string.concat(this.string.substring(1).toLowerCase());
    }

    final PyString str_replace(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        if (!(pyObject instanceof PyString) || !(pyObject2 instanceof PyString)) {
            throw Py.TypeError("str or unicode required for replace");
        }
        if (this.string.length() == 0) {
            return this.createInstance(this.string);
        }
        int n = pyObject3 == null ? (pyObject.__len__() == 0 ? this.string.length() + 1 : this.string.length()) : pyObject3.asInt();
        return ((PyString)pyObject2).str_join(this.str_split(((PyString)pyObject).string, n));
    }

    public String join(PyObject pyObject) {
        return this.str_join((PyObject)pyObject).string;
    }

    final PyString str_join(PyObject pyObject) {
        StringBuffer stringBuffer = new StringBuffer();
        PyObject pyObject2 = pyObject.__iter__();
        PyObject pyObject3 = null;
        boolean bl = false;
        int n = 0;
        while ((pyObject3 = pyObject2.__iternext__()) != null) {
            if (!(pyObject3 instanceof PyString)) {
                throw Py.TypeError("sequence item " + n + ": expected string, " + pyObject3.getType().fastGetName() + " found");
            }
            if (pyObject3 instanceof PyUnicode) {
                bl = true;
            }
            if (n > 0) {
                stringBuffer.append(this.string);
            }
            stringBuffer.append(((PyString)pyObject3).string);
            ++n;
        }
        if (bl) {
            return new PyUnicode(stringBuffer.toString());
        }
        return this.createInstance(stringBuffer.toString());
    }

    public boolean startswith(String string) {
        return this.str_startswith(string, 0, null);
    }

    public boolean startswith(String string, int n) {
        return this.str_startswith(string, n, null);
    }

    public boolean startswith(String string, int n, int n2) {
        return this.str_startswith(string, n, Py.newInteger(n2));
    }

    final boolean str_startswith(String string, int n, PyObject pyObject) {
        int[] nArray = this.translateIndices(n, pyObject);
        if (nArray[1] - nArray[0] < string.length()) {
            return false;
        }
        return this.string.startsWith(string, nArray[0]);
    }

    public boolean endswith(String string) {
        return this.str_endswith(string, 0, null);
    }

    public boolean endswith(String string, int n) {
        return this.str_endswith(string, n, null);
    }

    public boolean endswith(String string, int n, int n2) {
        return this.str_endswith(string, n, Py.newInteger(n2));
    }

    final boolean str_endswith(String string, int n, PyObject pyObject) {
        int[] nArray = this.translateIndices(n, pyObject);
        String string2 = this.string.substring(nArray[0], nArray[1]);
        return string2.endsWith(string);
    }

    private int[] translateIndices(int n, PyObject pyObject) {
        int n2 = pyObject == null ? this.string.length() : pyObject.asInt();
        int n3 = this.string.length();
        if (n2 < 0) {
            if ((n2 = n3 + n2) < 0) {
                n2 = 0;
            }
        } else if (n2 > n3) {
            n2 = n3;
        }
        if (n < 0 && (n = n3 + n) < 0) {
            n = 0;
        }
        if (n > n2) {
            n = n2;
        }
        return new int[]{n, n2};
    }

    public String translate(String string) {
        return this.str_translate(string, null);
    }

    public String translate(String string, String string2) {
        return this.str_translate(string, string2);
    }

    final String str_translate(String string, String string2) {
        if (string.length() != 256) {
            throw Py.ValueError("translation table must be 256 characters long");
        }
        StringBuffer stringBuffer = new StringBuffer(this.string.length());
        for (int i = 0; i < this.string.length(); ++i) {
            char c = this.string.charAt(i);
            if (string2 != null && string2.indexOf(c) >= 0) continue;
            try {
                stringBuffer.append(string.charAt(c));
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw Py.TypeError("translate() only works for 8-bit character strings");
            }
        }
        return stringBuffer.toString();
    }

    public String translate(PyObject pyObject) {
        StringBuffer stringBuffer = new StringBuffer(this.string.length());
        for (int i = 0; i < this.string.length(); ++i) {
            char c = this.string.charAt(i);
            PyInteger pyInteger = Py.newInteger(c);
            PyObject pyObject2 = pyObject.__finditem__(pyInteger);
            if (pyObject2 == null) {
                stringBuffer.append(c);
                continue;
            }
            if (pyObject2 instanceof PyInteger) {
                int n = ((PyInteger)pyObject2).getValue();
                stringBuffer.append((char)n);
                continue;
            }
            if (pyObject2 == Py.None) continue;
            if (pyObject2 instanceof PyString) {
                if (pyObject2.__len__() != 1) {
                    throw new PyException(Py.NotImplementedError, "1-n mappings are currently not implemented");
                }
                stringBuffer.append(pyObject2.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or unicode");
        }
        return stringBuffer.toString();
    }

    public boolean islower() {
        return this.str_islower();
    }

    final boolean str_islower() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isLowerCase(this.string.charAt(0));
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = this.string.charAt(i);
            if (Character.isUpperCase(c) || Character.isTitleCase(c)) {
                return false;
            }
            if (bl || !Character.isLowerCase(c)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isupper() {
        return this.str_isupper();
    }

    final boolean str_isupper() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isUpperCase(this.string.charAt(0));
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = this.string.charAt(i);
            if (Character.isLowerCase(c) || Character.isTitleCase(c)) {
                return false;
            }
            if (bl || !Character.isUpperCase(c)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isalpha() {
        return this.str_isalpha();
    }

    final boolean str_isalpha() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isLetter(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = this.string.charAt(i);
            if (Character.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    public boolean isalnum() {
        return this.str_isalnum();
    }

    final boolean str_isalnum() {
        int n = this.string.length();
        if (n == 1) {
            return this._isalnum(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = this.string.charAt(i);
            if (this._isalnum(c)) continue;
            return false;
        }
        return true;
    }

    private boolean _isalnum(char c) {
        return Character.isLetterOrDigit(c) || Character.getType(c) == 10;
    }

    public boolean isdecimal() {
        return this.str_isdecimal();
    }

    final boolean str_isdecimal() {
        int n = this.string.length();
        if (n == 1) {
            char c = this.string.charAt(0);
            return this._isdecimal(c);
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = this.string.charAt(i);
            if (this._isdecimal(c)) continue;
            return false;
        }
        return true;
    }

    private boolean _isdecimal(char c) {
        return Character.getType(c) == 9;
    }

    public boolean isdigit() {
        return this.str_isdigit();
    }

    final boolean str_isdigit() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isDigit(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = this.string.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public boolean isnumeric() {
        return this.str_isnumeric();
    }

    final boolean str_isnumeric() {
        int n = this.string.length();
        if (n == 1) {
            return this._isnumeric(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = this.string.charAt(i);
            if (this._isnumeric(c)) continue;
            return false;
        }
        return true;
    }

    private boolean _isnumeric(char c) {
        int n = Character.getType(c);
        return n == 9 || n == 10 || n == 11;
    }

    public boolean istitle() {
        return this.str_istitle();
    }

    final boolean str_istitle() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isTitleCase(this.string.charAt(0)) || Character.isUpperCase(this.string.charAt(0));
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            char c = this.string.charAt(i);
            if (Character.isUpperCase(c) || Character.isTitleCase(c)) {
                if (bl2) {
                    return false;
                }
                bl2 = true;
                bl = true;
                continue;
            }
            if (Character.isLowerCase(c)) {
                if (!bl2) {
                    return false;
                }
                bl2 = true;
                bl = true;
                continue;
            }
            bl2 = false;
        }
        return bl;
    }

    public boolean isspace() {
        return this.str_isspace();
    }

    final boolean str_isspace() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isWhitespace(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = this.string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public boolean isunicode() {
        return this.str_isunicode();
    }

    final boolean str_isunicode() {
        int n = this.string.length();
        for (int i = 0; i < n; ++i) {
            char c = this.string.charAt(i);
            if (c <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public String encode() {
        return this.str_encode(null, null);
    }

    public String encode(String string) {
        return this.str_encode(string, null);
    }

    public String encode(String string, String string2) {
        return this.str_encode(string, string2);
    }

    final String str_encode(String string, String string2) {
        return codecs.encode(this, string, string2);
    }

    public PyObject decode() {
        return this.str_decode(null, null);
    }

    public PyObject decode(String string) {
        return this.str_decode(string, null);
    }

    public PyObject decode(String string, String string2) {
        return this.str_decode(string, string2);
    }

    final PyObject str_decode(String string, String string2) {
        return codecs.decode(this, string, string2);
    }

    public String asString(int n) throws PyObject.ConversionException {
        return this.string;
    }

    public String asString() {
        return this.string;
    }

    public String asName(int n) throws PyObject.ConversionException {
        return this.internedString();
    }

    protected String unsupportedopMessage(String string, PyObject pyObject) {
        if (string.equals("+")) {
            return "cannot concatenate ''{1}'' and ''{2}'' objects";
        }
        return super.unsupportedopMessage(string, pyObject);
    }

    static {
        PyType.addBuilder(PyString.class, new PyString$PyExposer());
        TYPE = PyType.fromClass(PyString.class);
        hexdigit = "0123456789abcdef".toCharArray();
        pucnHash = null;
    }

    public class PyString$str___str___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___str___exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str___str___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___str___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyString)this.self).str___str__();
        }
    }

    public class PyString$str___unicode___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___unicode___exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str___unicode___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___unicode___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyString)this.self).str___unicode__();
        }
    }

    public class PyString$str___len___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___len___exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str___len___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___len___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyString)this.self).str___len__());
        }
    }

    public class PyString$str_toString_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_toString_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_toString_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_toString_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newString(((PyString)this.self).str_toString());
        }
    }

    public class PyString$str___getitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___getitem___exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str___getitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___getitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str___getitem__(pyObject);
        }
    }

    public class PyString$str___getslice___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___getslice___exposer(String string) {
            super(string, 3, 4);
        }

        public PyString$str___getslice___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___getslice___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return ((PyString)this.self).str___getslice__(pyObject, pyObject2, pyObject3);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyString)this.self).str___getslice__(pyObject, pyObject2, null);
        }
    }

    public class PyString$str___cmp___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___cmp___exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str___cmp___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___cmp___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            int n = ((PyString)this.self).str___cmp__(pyObject);
            if (n == -2) {
                throw Py.TypeError("str.__cmp__(x,y) requires y to be 'str', not a '" + pyObject.getType().fastGetName() + "'");
            }
            return Py.newInteger(n);
        }
    }

    public class PyString$str___eq___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___eq___exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str___eq___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___eq___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___eq__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___ne___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___ne___exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str___ne___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___ne___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___ne__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___lt___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___lt___exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str___lt___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___lt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___lt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___le___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___le___exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str___le___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___le___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___le__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___gt___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___gt___exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str___gt___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___gt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___gt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___ge___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___ge___exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str___ge___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___ge___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___ge__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___hash___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___hash___exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str___hash___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___hash___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyString)this.self).str___hash__());
        }
    }

    public class PyString$str___contains___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___contains___exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str___contains___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___contains___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyString)this.self).str___contains__(pyObject));
        }
    }

    public class PyString$str___mul___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___mul___exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str___mul___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___mul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___mul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___rmul___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___rmul___exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str___rmul___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___rmul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___rmul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___add___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___add___exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str___add___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___add___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___add__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___mod___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___mod___exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str___mod___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str___mod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str___mod__(pyObject);
        }
    }

    public class PyString$str_lower_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_lower_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_lower_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_lower_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newString(((PyString)this.self).str_lower());
        }
    }

    public class PyString$str_upper_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_upper_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_upper_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_upper_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newString(((PyString)this.self).str_upper());
        }
    }

    public class PyString$str_title_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_title_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_title_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_title_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newString(((PyString)this.self).str_title());
        }
    }

    public class PyString$str_swapcase_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_swapcase_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_swapcase_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_swapcase_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newString(((PyString)this.self).str_swapcase());
        }
    }

    public class PyString$str_strip_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_strip_exposer(String string) {
            super(string, 1, 2);
        }

        public PyString$str_strip_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_strip_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newString(((PyString)this.self).str_strip(pyObject.asStringOrNull()));
        }

        public PyObject __call__() {
            return Py.newString(((PyString)this.self).str_strip(null));
        }
    }

    public class PyString$str_lstrip_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_lstrip_exposer(String string) {
            super(string, 1, 2);
        }

        public PyString$str_lstrip_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_lstrip_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newString(((PyString)this.self).str_lstrip(pyObject.asStringOrNull()));
        }

        public PyObject __call__() {
            return Py.newString(((PyString)this.self).str_lstrip(null));
        }
    }

    public class PyString$str_rstrip_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_rstrip_exposer(String string) {
            super(string, 1, 2);
        }

        public PyString$str_rstrip_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_rstrip_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newString(((PyString)this.self).str_rstrip(pyObject.asStringOrNull()));
        }

        public PyObject __call__() {
            return Py.newString(((PyString)this.self).str_rstrip(null));
        }
    }

    public class PyString$str_split_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_split_exposer(String string) {
            super(string, 1, 3);
        }

        public PyString$str_split_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_split_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyString)this.self).str_split(pyObject.asStringOrNull(), Py.py2int(pyObject2));
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str_split(pyObject.asStringOrNull(), -1);
        }

        public PyObject __call__() {
            return ((PyString)this.self).str_split(null, -1);
        }
    }

    public class PyString$str_splitlines_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_splitlines_exposer(String string) {
            super(string, 1, 2);
        }

        public PyString$str_splitlines_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_splitlines_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str_splitlines(Py.py2boolean(pyObject));
        }

        public PyObject __call__() {
            return ((PyString)this.self).str_splitlines(false);
        }
    }

    public class PyString$str_index_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_index_exposer(String string) {
            super(string, 2, 4);
        }

        public PyString$str_index_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_index_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyString)this.self).str_index(pyObject.asString(), Py.py2int(pyObject2), pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyString)this.self).str_index(pyObject.asString(), Py.py2int(pyObject2), null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyString)this.self).str_index(pyObject.asString(), 0, null));
        }
    }

    public class PyString$str_rindex_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_rindex_exposer(String string) {
            super(string, 2, 4);
        }

        public PyString$str_rindex_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_rindex_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyString)this.self).str_rindex(pyObject.asString(), Py.py2int(pyObject2), pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyString)this.self).str_rindex(pyObject.asString(), Py.py2int(pyObject2), null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyString)this.self).str_rindex(pyObject.asString(), 0, null));
        }
    }

    public class PyString$str_count_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_count_exposer(String string) {
            super(string, 2, 4);
        }

        public PyString$str_count_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_count_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyString)this.self).str_count(pyObject.asString(), Py.py2int(pyObject2), pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyString)this.self).str_count(pyObject.asString(), Py.py2int(pyObject2), null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyString)this.self).str_count(pyObject.asString(), 0, null));
        }
    }

    public class PyString$str_find_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_find_exposer(String string) {
            super(string, 2, 4);
        }

        public PyString$str_find_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_find_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyString)this.self).str_find(pyObject.asString(), Py.py2int(pyObject2), pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyString)this.self).str_find(pyObject.asString(), Py.py2int(pyObject2), null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyString)this.self).str_find(pyObject.asString(), 0, null));
        }
    }

    public class PyString$str_rfind_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_rfind_exposer(String string) {
            super(string, 2, 4);
        }

        public PyString$str_rfind_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_rfind_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyString)this.self).str_rfind(pyObject.asString(), Py.py2int(pyObject2), pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyString)this.self).str_rfind(pyObject.asString(), Py.py2int(pyObject2), null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyString)this.self).str_rfind(pyObject.asString(), 0, null));
        }
    }

    public class PyString$str_ljust_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_ljust_exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str_ljust_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_ljust_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newString(((PyString)this.self).str_ljust(Py.py2int(pyObject)));
        }
    }

    public class PyString$str_rjust_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_rjust_exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str_rjust_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_rjust_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newString(((PyString)this.self).str_rjust(Py.py2int(pyObject)));
        }
    }

    public class PyString$str_center_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_center_exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str_center_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_center_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newString(((PyString)this.self).str_center(Py.py2int(pyObject)));
        }
    }

    public class PyString$str_zfill_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_zfill_exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str_zfill_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_zfill_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newString(((PyString)this.self).str_zfill(Py.py2int(pyObject)));
        }
    }

    public class PyString$str_expandtabs_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_expandtabs_exposer(String string) {
            super(string, 1, 2);
        }

        public PyString$str_expandtabs_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_expandtabs_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newString(((PyString)this.self).str_expandtabs(Py.py2int(pyObject)));
        }

        public PyObject __call__() {
            return Py.newString(((PyString)this.self).str_expandtabs(8));
        }
    }

    public class PyString$str_capitalize_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_capitalize_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_capitalize_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_capitalize_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newString(((PyString)this.self).str_capitalize());
        }
    }

    public class PyString$str_replace_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_replace_exposer(String string) {
            super(string, 3, 4);
        }

        public PyString$str_replace_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_replace_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return ((PyString)this.self).str_replace(pyObject, pyObject2, pyObject3);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyString)this.self).str_replace(pyObject, pyObject2, null);
        }
    }

    public class PyString$str_join_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_join_exposer(String string) {
            super(string, 2, 2);
        }

        public PyString$str_join_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_join_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str_join(pyObject);
        }
    }

    public class PyString$str_startswith_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_startswith_exposer(String string) {
            super(string, 2, 4);
        }

        public PyString$str_startswith_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_startswith_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newBoolean(((PyString)this.self).str_startswith(pyObject.asString(), Py.py2int(pyObject2), pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newBoolean(((PyString)this.self).str_startswith(pyObject.asString(), Py.py2int(pyObject2), null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyString)this.self).str_startswith(pyObject.asString(), 0, null));
        }
    }

    public class PyString$str_endswith_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_endswith_exposer(String string) {
            super(string, 2, 4);
        }

        public PyString$str_endswith_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_endswith_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newBoolean(((PyString)this.self).str_endswith(pyObject.asString(), Py.py2int(pyObject2), pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newBoolean(((PyString)this.self).str_endswith(pyObject.asString(), Py.py2int(pyObject2), null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyString)this.self).str_endswith(pyObject.asString(), 0, null));
        }
    }

    public class PyString$str_translate_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_translate_exposer(String string) {
            super(string, 2, 3);
        }

        public PyString$str_translate_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_translate_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newString(((PyString)this.self).str_translate(pyObject.asString(), pyObject2.asStringOrNull()));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newString(((PyString)this.self).str_translate(pyObject.asString(), null));
        }
    }

    public class PyString$str_islower_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_islower_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_islower_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_islower_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_islower());
        }
    }

    public class PyString$str_isupper_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_isupper_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_isupper_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_isupper_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_isupper());
        }
    }

    public class PyString$str_isalpha_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_isalpha_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_isalpha_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_isalpha_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_isalpha());
        }
    }

    public class PyString$str_isalnum_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_isalnum_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_isalnum_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_isalnum_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_isalnum());
        }
    }

    public class PyString$str_isdecimal_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_isdecimal_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_isdecimal_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_isdecimal_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_isdecimal());
        }
    }

    public class PyString$str_isdigit_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_isdigit_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_isdigit_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_isdigit_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_isdigit());
        }
    }

    public class PyString$str_isnumeric_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_isnumeric_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_isnumeric_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_isnumeric_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_isnumeric());
        }
    }

    public class PyString$str_istitle_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_istitle_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_istitle_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_istitle_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_istitle());
        }
    }

    public class PyString$str_isspace_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_isspace_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_isspace_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_isspace_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_isspace());
        }
    }

    public class PyString$str_isunicode_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_isunicode_exposer(String string) {
            super(string, 1, 1);
        }

        public PyString$str_isunicode_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_isunicode_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_isunicode());
        }
    }

    public class PyString$str_encode_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_encode_exposer(String string) {
            super(string, 1, 3);
        }

        public PyString$str_encode_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_encode_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newString(((PyString)this.self).str_encode(pyObject.asStringOrNull(), pyObject2.asStringOrNull()));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newString(((PyString)this.self).str_encode(pyObject.asStringOrNull(), null));
        }

        public PyObject __call__() {
            return Py.newString(((PyString)this.self).str_encode(null, null));
        }
    }

    public class PyString$str_decode_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_decode_exposer(String string) {
            super(string, 1, 3);
        }

        public PyString$str_decode_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyString$str_decode_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyString)this.self).str_decode(pyObject.asStringOrNull(), pyObject2.asStringOrNull());
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str_decode(pyObject.asStringOrNull(), null);
        }

        public PyObject __call__() {
            return ((PyString)this.self).str_decode(null, null);
        }
    }

    public class PyString$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return PyString.str_new(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class PyString$PyExposer
    extends TypeExposer.BaseTypeBuilder {
        public PyString$PyExposer() {
            PyBuiltinFunction[] pyBuiltinFunctionArray = new PyBuiltinFunction[]{new PyString$str___str___exposer("__str__"), new PyString$str___unicode___exposer("__unicode__"), new PyString$str___len___exposer("__len__"), new PyString$str_toString_exposer("__repr__"), new PyString$str___getitem___exposer("__getitem__"), new PyString$str___getslice___exposer("__getslice__"), new PyString$str___cmp___exposer("__cmp__"), new PyString$str___eq___exposer("__eq__"), new PyString$str___ne___exposer("__ne__"), new PyString$str___lt___exposer("__lt__"), new PyString$str___le___exposer("__le__"), new PyString$str___gt___exposer("__gt__"), new PyString$str___ge___exposer("__ge__"), new PyString$str___hash___exposer("__hash__"), new PyString$str___contains___exposer("__contains__"), new PyString$str___mul___exposer("__mul__"), new PyString$str___rmul___exposer("__rmul__"), new PyString$str___add___exposer("__add__"), new PyString$str___mod___exposer("__mod__"), new PyString$str_lower_exposer("lower"), new PyString$str_upper_exposer("upper"), new PyString$str_title_exposer("title"), new PyString$str_swapcase_exposer("swapcase"), new PyString$str_strip_exposer("strip"), new PyString$str_lstrip_exposer("lstrip"), new PyString$str_rstrip_exposer("rstrip"), new PyString$str_split_exposer("split"), new PyString$str_splitlines_exposer("splitlines"), new PyString$str_index_exposer("index"), new PyString$str_rindex_exposer("rindex"), new PyString$str_count_exposer("count"), new PyString$str_find_exposer("find"), new PyString$str_rfind_exposer("rfind"), new PyString$str_ljust_exposer("ljust"), new PyString$str_rjust_exposer("rjust"), new PyString$str_center_exposer("center"), new PyString$str_zfill_exposer("zfill"), new PyString$str_expandtabs_exposer("expandtabs"), new PyString$str_capitalize_exposer("capitalize"), new PyString$str_replace_exposer("replace"), new PyString$str_join_exposer("join"), new PyString$str_startswith_exposer("startswith"), new PyString$str_endswith_exposer("endswith"), new PyString$str_translate_exposer("translate"), new PyString$str_islower_exposer("islower"), new PyString$str_isupper_exposer("isupper"), new PyString$str_isalpha_exposer("isalpha"), new PyString$str_isalnum_exposer("isalnum"), new PyString$str_isdecimal_exposer("isdecimal"), new PyString$str_isdigit_exposer("isdigit"), new PyString$str_isnumeric_exposer("isnumeric"), new PyString$str_istitle_exposer("istitle"), new PyString$str_isspace_exposer("isspace"), new PyString$str_isunicode_exposer("isunicode"), new PyString$str_encode_exposer("encode"), new PyString$str_decode_exposer("decode")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("str", PyString.class, Object.class, pyBuiltinFunctionArray, pyDataDescrArray, new PyString$exposed___new__());
        }
    }
}

