/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.ThreadState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyStringMap
extends PyObject {
    private final Map<Object, PyObject> table;

    public PyStringMap() {
        this(4);
    }

    public PyStringMap(int capacity) {
        this.table = new ConcurrentHashMap<Object, PyObject>(capacity);
    }

    public PyStringMap(Map<Object, PyObject> map) {
        this.table = new ConcurrentHashMap<Object, PyObject>(map);
    }

    public PyStringMap(PyObject[] elements) {
        this(elements.length);
        for (int i = 0; i < elements.length; i += 2) {
            this.__setitem__(elements[i], elements[i + 1]);
        }
    }

    @Override
    public int __len__() {
        return this.table.size();
    }

    @Override
    public boolean __nonzero__() {
        return this.table.size() != 0;
    }

    @Override
    public PyObject __finditem__(String key) {
        if (key == null) {
            return null;
        }
        return this.table.get(key);
    }

    @Override
    public PyObject __finditem__(PyObject key) {
        if (key instanceof PyString) {
            return this.__finditem__(((PyString)key).internedString());
        }
        return this.table.get(key);
    }

    public PyObject __getitem__(String key) {
        PyObject o = this.__finditem__(key);
        if (null == o) {
            throw Py.KeyError("'" + key + "'");
        }
        return o;
    }

    @Override
    public PyObject __getitem__(PyObject key) {
        if (key instanceof PyString) {
            return this.__getitem__(((PyString)key).internedString());
        }
        PyObject o = this.__finditem__(key);
        if (null == o) {
            throw Py.KeyError("'" + key.toString() + "'");
        }
        return o;
    }

    @Override
    public PyObject __iter__() {
        return this.iterkeys();
    }

    @Override
    public void __setitem__(String key, PyObject value) {
        if (value == null) {
            this.table.remove(key);
        } else {
            this.table.put(key, value);
        }
    }

    @Override
    public void __setitem__(PyObject key, PyObject value) {
        if (value == null) {
            if (key instanceof PyString) {
                this.table.remove(((PyString)key).internedString());
            } else {
                this.table.remove(key);
            }
        } else if (key instanceof PyString) {
            this.__setitem__(((PyString)key).internedString(), value);
        } else {
            this.table.put(key, value);
        }
    }

    @Override
    public void __delitem__(String key) {
        PyObject ret = this.table.remove(key);
        if (ret == null) {
            throw Py.KeyError(key);
        }
    }

    @Override
    public void __delitem__(PyObject key) {
        if (key instanceof PyString) {
            this.__delitem__(((PyString)key).internedString());
        } else {
            PyObject ret = this.table.remove(key);
            if (ret == null) {
                throw Py.KeyError(key.toString());
            }
        }
    }

    public void clear() {
        this.table.clear();
    }

    @Override
    public String toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "{...}";
        }
        StringBuffer buf = new StringBuffer("{");
        for (Map.Entry<Object, PyObject> entry : this.table.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String) {
                buf.append(key);
            } else {
                buf.append(((PyObject)entry.getKey()).__repr__().toString());
            }
            buf.append(": ");
            buf.append(entry.getValue().__repr__().toString());
            buf.append(", ");
        }
        if (buf.length() > 1) {
            buf.delete(buf.length() - 2, buf.length());
        }
        buf.append("}");
        ts.exitRepr(this);
        return buf.toString();
    }

    @Override
    public int __cmp__(PyObject other) {
        int bn;
        if (!(other instanceof PyStringMap) && !(other instanceof PyDictionary)) {
            return -2;
        }
        int an = this.__len__();
        if (an < (bn = other.__len__())) {
            return -1;
        }
        if (an > bn) {
            return 1;
        }
        PyList akeys = this.keys();
        PyList bkeys = null;
        bkeys = other instanceof PyStringMap ? ((PyStringMap)other).keys() : ((PyDictionary)other).keys();
        akeys.sort();
        bkeys.sort();
        for (int i = 0; i < bn; ++i) {
            PyObject bvalue;
            PyObject bkey;
            PyObject akey = akeys.pyget(i);
            int c = akey._cmp(bkey = bkeys.pyget(i));
            if (c != 0) {
                return c;
            }
            PyObject avalue = this.__finditem__(akey);
            c = avalue._cmp(bvalue = other.__finditem__(bkey));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public boolean has_key(String key) {
        return this.table.containsKey(key);
    }

    public boolean has_key(PyObject key) {
        if (key instanceof PyString) {
            return this.has_key(((PyString)key).internedString());
        }
        return this.table.containsKey(key);
    }

    public PyObject get(PyObject key, PyObject default_object) {
        PyObject o = this.__finditem__(key);
        if (o == null) {
            return default_object;
        }
        return o;
    }

    public PyObject get(PyObject key) {
        return this.get(key, Py.None);
    }

    public PyStringMap copy() {
        return new PyStringMap(this.table);
    }

    public void update(PyStringMap map) {
        this.table.putAll(map.table);
    }

    public void update(PyDictionary dict) {
        for (Map.Entry<PyObject, PyObject> entry : dict.table.entrySet()) {
            this.__setitem__(entry.getKey(), entry.getValue());
        }
    }

    public PyObject setdefault(PyObject key) {
        return this.setdefault(key, Py.None);
    }

    public PyObject setdefault(PyObject key, PyObject failobj) {
        PyObject o = this.__finditem__(key);
        if (o == null) {
            o = failobj;
            this.__setitem__(key, o);
        }
        return o;
    }

    public PyObject popitem() {
        Iterator<Map.Entry<Object, PyObject>> it = this.table.entrySet().iterator();
        if (!it.hasNext()) {
            throw Py.KeyError("popitem(): dictionary is empty");
        }
        Map.Entry<Object, PyObject> entry = it.next();
        Object objKey = entry.getKey();
        PyObject value = entry.getValue();
        PyTuple tuple = objKey instanceof String ? new PyTuple(new PyString((String)objKey), value) : new PyTuple((PyObject)objKey, value);
        it.remove();
        return tuple;
    }

    public PyObject pop(PyObject key) {
        if (this.table.size() == 0) {
            throw Py.KeyError("pop(): dictionary is empty");
        }
        return this.pop(key, null);
    }

    public PyObject pop(PyObject key, PyObject failobj) {
        Object objKey = key instanceof PyString ? ((PyString)key).internedString() : key;
        PyObject value = this.table.remove(objKey);
        if (value == null) {
            if (failobj == null) {
                throw Py.KeyError(key.__repr__().toString());
            }
            return failobj;
        }
        return value;
    }

    public PyList items() {
        ArrayList<PyTuple> list = new ArrayList<PyTuple>(this.table.size());
        for (Map.Entry<Object, PyObject> entry : this.table.entrySet()) {
            list.add(this.itemTuple(entry));
        }
        return new PyList(list);
    }

    private PyTuple itemTuple(Map.Entry<Object, PyObject> entry) {
        Object key = entry.getKey();
        PyObject pyKey = key instanceof String ? PyString.fromInterned((String)key) : (PyObject)key;
        return new PyTuple(pyKey, entry.getValue());
    }

    public PyList keys() {
        ArrayList<PyObject> list = new ArrayList<PyObject>(this.table.size());
        for (Object obj : this.table.keySet()) {
            if (obj instanceof String) {
                list.add(PyString.fromInterned((String)obj));
                continue;
            }
            list.add((PyObject)obj);
        }
        return new PyList(list);
    }

    public PyList values() {
        return new PyList(this.table.values());
    }

    public PyObject iteritems() {
        return new ItemsIter(this.table.entrySet());
    }

    public PyObject iterkeys() {
        return new KeysIter(this.table.keySet());
    }

    public PyObject itervalues() {
        return new ValuesIter(this.table.values());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemsIter
    extends PyIterator {
        private final Iterator<Map.Entry<Object, PyObject>> iterator;

        public ItemsIter(Set<Map.Entry<Object, PyObject>> s) {
            this.iterator = s.iterator();
        }

        @Override
        public PyObject __iternext__() {
            if (!this.iterator.hasNext()) {
                return null;
            }
            return PyStringMap.this.itemTuple(this.iterator.next());
        }
    }

    private class KeysIter
    extends PyIterator {
        private final Iterator iterator;

        public KeysIter(Set s) {
            this.iterator = s.iterator();
        }

        public PyObject __iternext__() {
            if (!this.iterator.hasNext()) {
                return null;
            }
            Object objKey = this.iterator.next();
            PyObject key = null;
            key = objKey instanceof String ? PyString.fromInterned((String)objKey) : (PyObject)objKey;
            return key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesIter
    extends PyIterator {
        private final Iterator<PyObject> iterator;

        public ValuesIter(Collection<PyObject> c) {
            this.iterator = c.iterator();
        }

        @Override
        public PyObject __iternext__() {
            if (!this.iterator.hasNext()) {
                return null;
            }
            return this.iterator.next();
        }
    }
}

