/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.expose.ExposedGet;

class SortedFunction
extends PyObject {
    SortedFunction() {
    }

    @ExposedGet(name="__doc__")
    public PyObject getDoc() {
        return new PyString("sorted(iterable, cmp=None, key=None, reverse=False) --> new sorted list");
    }

    public PyObject __call__(PyObject[] args, String[] kwds) {
        if (args.length == 0) {
            throw Py.TypeError(" sorted() takes at least 1 argument (0 given)");
        }
        if (args.length > 4) {
            throw Py.TypeError(" sorted() takes at most 4 arguments (" + args.length + " given)");
        }
        PyObject iter = args[0].__iter__();
        if (iter == null) {
            throw Py.TypeError("'" + args[0].getType().fastGetName() + "' object is not iterable");
        }
        PyList seq = new PyList(args[0]);
        PyObject[] newargs = new PyObject[args.length - 1];
        System.arraycopy(args, 1, newargs, 0, args.length - 1);
        ArgParser ap = new ArgParser("sorted", newargs, kwds, new String[]{"cmp", "key", "reverse"}, 0);
        PyObject cmp = ap.getPyObject(0, Py.None);
        PyObject key = ap.getPyObject(1, Py.None);
        PyObject reverse = ap.getPyObject(2, Py.None);
        seq.sort(cmp, key, reverse);
        return seq;
    }

    public String toString() {
        return "<built-in function sorted>";
    }
}

