/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import org.python.core.Py;
import org.python.core.io.RawIOBase;
import org.python.core.util.RelativeFile;

public class FileIO
extends RawIOBase {
    private FileChannel fileChannel;
    private boolean readable = false;
    private boolean writable = false;
    private boolean appending = false;

    public FileIO(String name, String mode) {
        this.parseMode(mode);
        RelativeFile fullPath = new RelativeFile(name);
        String rafMode = "r" + (this.writable ? "w" : "");
        try {
            this.fileChannel = new RandomAccessFile(fullPath, rafMode).getChannel();
        }
        catch (FileNotFoundException fnfe) {
            if (fullPath.isDirectory()) {
                throw Py.IOError(21, "Is a directory");
            }
            throw Py.IOError(2, "No such file or directory: '" + name + "'");
        }
        this.initPosition();
    }

    public FileIO(FileChannel fileChannel, String mode) {
        this.parseMode(mode);
        this.fileChannel = fileChannel;
        this.initPosition();
    }

    private void parseMode(String mode) {
        boolean rwa = false;
        boolean plus = false;
        block6: for (int i = 0; i < mode.length(); ++i) {
            switch (mode.charAt(i)) {
                case 'r': {
                    if (rwa) {
                        this.badMode();
                    }
                    rwa = true;
                    this.readable = true;
                    continue block6;
                }
                case 'w': {
                    if (rwa) {
                        this.badMode();
                    }
                    rwa = true;
                    this.writable = true;
                    continue block6;
                }
                case 'a': {
                    if (rwa) {
                        this.badMode();
                    }
                    rwa = true;
                    this.writable = true;
                    this.appending = true;
                    continue block6;
                }
                case '+': {
                    if (plus) {
                        this.badMode();
                    }
                    plus = true;
                    this.writable = true;
                    this.readable = true;
                    continue block6;
                }
                default: {
                    throw Py.ValueError("invalid mode: '" + mode + "'");
                }
            }
        }
        if (!rwa) {
            this.badMode();
        }
    }

    private void badMode() {
        throw Py.ValueError("Must have exactly one of read/write/append mode");
    }

    private void initPosition() {
        if (this.appending) {
            this.seek(0L, 2);
        } else if (this.writable && !this.readable) {
            this.truncate(0L);
        }
    }

    public int readinto(ByteBuffer buf) {
        this.checkClosed();
        this.checkReadable();
        try {
            return this.fileChannel.read(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public long readinto(ByteBuffer[] bufs) {
        this.checkClosed();
        this.checkReadable();
        try {
            return this.fileChannel.read(bufs);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public ByteBuffer readall() {
        long toRead;
        this.checkClosed();
        this.checkReadable();
        try {
            toRead = Math.max(0L, this.fileChannel.size() - this.fileChannel.position());
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        if (toRead > Integer.MAX_VALUE) {
            throw Py.OverflowError("requested number of bytes is more than a Python string can hold");
        }
        ByteBuffer all = ByteBuffer.allocate((int)toRead);
        this.readinto(all);
        all.flip();
        return all;
    }

    public int write(ByteBuffer buf) {
        this.checkClosed();
        this.checkWritable();
        try {
            return this.fileChannel.write(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public long write(ByteBuffer[] bufs) {
        this.checkClosed();
        this.checkWritable();
        try {
            return this.fileChannel.write(bufs);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public long seek(long pos, int whence) {
        this.checkClosed();
        try {
            switch (whence) {
                case 0: {
                    break;
                }
                case 1: {
                    pos += this.fileChannel.position();
                    break;
                }
                case 2: {
                    pos += this.fileChannel.size();
                    break;
                }
                default: {
                    throw Py.IOError(22, "invalid whence value");
                }
            }
            this.fileChannel.position(pos);
            return pos;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public long tell() {
        this.checkClosed();
        try {
            return this.fileChannel.position();
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public long truncate(long size) {
        this.checkClosed();
        this.checkWritable();
        try {
            this.fileChannel.truncate(size);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        return size;
    }

    public void close() {
        if (this.closed()) {
            return;
        }
        try {
            this.fileChannel.close();
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        super.close();
    }

    public Object __tojava__(Class cls) {
        if (OutputStream.class.isAssignableFrom(cls) && this.writable) {
            return Channels.newOutputStream(this.fileChannel);
        }
        if (InputStream.class.isAssignableFrom(cls) && this.readable) {
            return Channels.newInputStream(this.fileChannel);
        }
        return super.__tojava__(cls);
    }

    public boolean readable() {
        return this.readable;
    }

    public boolean writable() {
        return this.writable;
    }

    public Channel getChannel() {
        return this.fileChannel;
    }
}

