/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.ArrayList;
import org.python.core.Py;
import org.python.core.io.IOBase;

public abstract class RawIOBase
extends IOBase {
    public ByteBuffer read(int size) {
        if (size < 0) {
            return this.readall();
        }
        ByteBuffer buf = ByteBuffer.allocate(size);
        this.readinto(buf);
        buf.flip();
        return buf;
    }

    public ByteBuffer readall() {
        ByteBuffer chunk;
        int chunkSize;
        long count = 0L;
        ArrayList<ByteBuffer> chunks = new ArrayList<ByteBuffer>();
        while ((chunkSize = (chunk = this.read(8192)).remaining()) != 0) {
            chunks.add(chunk);
            count += (long)chunkSize;
        }
        if (count > Integer.MAX_VALUE) {
            throw Py.OverflowError("requested number of bytes is more than a Python string can hold");
        }
        ByteBuffer all = ByteBuffer.allocate((int)count);
        for (ByteBuffer chunk2 : chunks) {
            all.put(chunk2);
        }
        all.flip();
        return all;
    }

    public int readinto(ByteBuffer buf) {
        this.unsupported("readinto");
        return -1;
    }

    public long readinto(ByteBuffer[] bufs) {
        long count = 0L;
        for (ByteBuffer buf : bufs) {
            if (!buf.hasRemaining()) continue;
            int bufCount = this.readinto(buf);
            if (bufCount == 0) break;
            count += (long)bufCount;
        }
        return count;
    }

    public int write(ByteBuffer buf) {
        this.unsupported("write");
        return -1;
    }

    public long write(ByteBuffer[] bufs) {
        long count = 0L;
        for (ByteBuffer buf : bufs) {
            if (!buf.hasRemaining()) continue;
            int bufCount = this.write(buf);
            if (bufCount == 0) break;
            count += (long)bufCount;
        }
        return count;
    }

    public RawIOBase fileno() {
        this.checkClosed();
        return this;
    }

    public abstract Channel getChannel();
}

