/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.python.core.Py;
import org.python.core.io.RawIOBase;

public class StreamIO
extends RawIOBase {
    private ReadableByteChannel readChannel;
    private WritableByteChannel writeChannel;
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean closefd;

    public StreamIO(ReadableByteChannel readChannel, boolean closefd) {
        this.readChannel = readChannel;
        this.closefd = closefd;
    }

    public StreamIO(ReadableByteChannel readChannel) {
        this(readChannel, true);
    }

    public StreamIO(WritableByteChannel writeChannel, boolean closefd) {
        this.writeChannel = writeChannel;
        this.closefd = closefd;
    }

    public StreamIO(WritableByteChannel writeChannel) {
        this(writeChannel, true);
    }

    public StreamIO(InputStream inputStream, boolean closefd) {
        this(Channels.newChannel(inputStream), closefd);
    }

    public StreamIO(OutputStream outputStream, boolean closefd) {
        this(Channels.newChannel(outputStream), closefd);
    }

    public int readinto(ByteBuffer buf) {
        this.checkClosed();
        this.checkReadable();
        try {
            return this.readChannel.read(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public int write(ByteBuffer buf) {
        this.checkClosed();
        this.checkWritable();
        try {
            return this.writeChannel.write(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public void close() {
        if (this.closed()) {
            return;
        }
        if (this.closefd) {
            try {
                if (this.readChannel != null) {
                    this.readChannel.close();
                    if (this.writeChannel != null && this.readChannel != this.writeChannel) {
                        this.writeChannel.close();
                    }
                } else {
                    this.writeChannel.close();
                }
            }
            catch (IOException ioe) {
                throw Py.IOError(ioe);
            }
        }
        super.close();
    }

    public boolean readable() {
        return this.readChannel != null;
    }

    public boolean writable() {
        return this.writeChannel != null;
    }

    public Object __tojava__(Class cls) {
        if (OutputStream.class.isAssignableFrom(cls) && this.writable()) {
            if (this.outputStream == null) {
                return Channels.newOutputStream(this.writeChannel);
            }
            return this.outputStream;
        }
        if (InputStream.class.isAssignableFrom(cls) && this.readable()) {
            if (this.inputStream == null) {
                return Channels.newInputStream(this.readChannel);
            }
            return this.inputStream;
        }
        return super.__tojava__(cls);
    }

    public Channel getChannel() {
        return this.readable() ? this.readChannel : this.writeChannel;
    }
}

