/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.python.core.CompilerFlags;
import org.python.core.LiteralMakerForParser;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PySyntaxError;
import org.python.core.util.StringUtil;
import org.python.parser.IParserHost;
import org.python.parser.Node;
import org.python.parser.ParseException;
import org.python.parser.PythonGrammar;
import org.python.parser.ReaderCharStream;
import org.python.parser.Token;
import org.python.parser.TokenMgrError;
import org.python.parser.ast.modType;

public class parser {
    private static IParserHost literalMkrForParser = new LiteralMakerForParser();

    private parser() {
    }

    static String getLine(BufferedReader reader, int line) {
        if (reader == null) {
            return "";
        }
        try {
            String text = null;
            for (int i = 0; i < line; ++i) {
                text = reader.readLine();
            }
            return text;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static PyException fixParseError(BufferedReader reader, Throwable t, String filename) {
        if (reader != null) {
            try {
                reader.reset();
            }
            catch (IOException e) {
                reader = null;
            }
        }
        if (t instanceof ParseException) {
            ParseException e = (ParseException)t;
            Token tok = e.currentToken;
            int col = 0;
            int line = 0;
            if (tok != null && tok.next != null) {
                col = tok.next.beginColumn;
                line = tok.next.beginLine;
            }
            String text = parser.getLine(reader, line);
            return new PySyntaxError(e.getMessage(), line, col, text, filename);
        }
        if (t instanceof TokenMgrError) {
            TokenMgrError e = (TokenMgrError)t;
            boolean eofSeen = e.EOFSeen;
            int col = e.errorColumn;
            int line = e.errorLine;
            String text = parser.getLine(reader, line);
            if (eofSeen) {
                --col;
            }
            return new PySyntaxError(e.getMessage(), line, col, text, filename);
        }
        return Py.JavaError(t);
    }

    public static Node parse(String string, String kind) {
        return parser.parse(new ByteArrayInputStream(StringUtil.toBytes(string)), kind, "<string>", null);
    }

    public static modType parse(InputStream istream, String kind, String filename, CompilerFlags cflags) {
        BufferedReader bufreader = parser.prepBufreader(istream, cflags);
        PythonGrammar g = new PythonGrammar(new ReaderCharStream(bufreader), literalMkrForParser);
        modType node = null;
        try {
            node = parser.doparse(kind, cflags, g);
        }
        catch (Throwable t) {
            throw parser.fixParseError(bufreader, t, filename);
        }
        return node;
    }

    public static modType partialParse(String string, String kind, String filename, CompilerFlags cflags, boolean stdprompt) {
        modType node = null;
        BufferedReader bufreader = parser.prepBufreader(new ByteArrayInputStream(StringUtil.toBytes(string)), cflags);
        PythonGrammar g = new PythonGrammar(new ReaderCharStream(bufreader), literalMkrForParser);
        g.token_source.partial = true;
        g.token_source.stdprompt = stdprompt;
        try {
            node = parser.doparse(kind, cflags, g);
        }
        catch (Throwable t) {
            if (g.partial_valid_sentence(t)) {
                return null;
            }
            throw parser.fixParseError(bufreader, t, filename);
        }
        return node;
    }

    private static modType doparse(String kind, CompilerFlags cflags, PythonGrammar g) throws ParseException {
        modType node = null;
        if (cflags != null) {
            g.token_source.generator_allowed = cflags.generator_allowed;
        }
        if (kind.equals("eval")) {
            node = g.eval_input();
        } else if (kind.equals("exec")) {
            node = g.file_input();
        } else if (kind.equals("single")) {
            node = g.single_input();
        } else {
            throw Py.ValueError("parse kind must be eval, exec, or single");
        }
        return node;
    }

    private static BufferedReader prepBufreader(InputStream istream, CompilerFlags cflags) {
        InputStreamReader reader;
        int nbytes;
        try {
            nbytes = istream.available();
        }
        catch (IOException ioe1) {
            nbytes = 10000;
        }
        if (nbytes <= 0) {
            nbytes = 10000;
        }
        if (nbytes > 100000) {
            nbytes = 100000;
        }
        if (cflags != null && cflags.encoding != null) {
            try {
                reader = new InputStreamReader(istream, cflags.encoding);
            }
            catch (UnsupportedEncodingException exc) {
                throw Py.SystemError("python.console.encoding, " + cflags.encoding + ", isn't supported by this JVM so we can't parse this data.");
            }
        }
        try {
            reader = new InputStreamReader(istream, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw Py.SystemError("Java couldn't find the ISO-8859-1 encoding");
        }
        BufferedReader bufreader = new BufferedReader(reader);
        try {
            bufreader.mark(nbytes);
        }
        catch (IOException exc) {
            // empty catch block
        }
        return bufreader;
    }
}

