/*
 * Decompiled with CFR 0.152.
 */
package org.python.expose.generate;

import org.objectweb.asm.Type;
import org.python.core.BytecodeLoader;
import org.python.core.Py;
import org.python.core.PyDataDescr;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.generate.DescriptorExposer;
import org.python.expose.generate.InterpTestCase;
import org.python.expose.generate.InvalidExposingException;
import org.python.expose.generate.PyTypes;

public class DescriptorExposerTest
extends InterpTestCase
implements PyTypes {
    private static final String RETURN_STRING_DESCRIPTOR = Type.getMethodDescriptor((Type)STRING, (Type[])new Type[0]);
    private static final PyType PY_TYPE = PyType.fromClass(DescExposed.class);
    private static final Type ASM_TYPE = Type.getType(DescExposed.class);
    private DescExposed se = new DescExposed();
    private static final String NEW_VAL = "This is not what was there before";

    public PyDataDescr makeDescriptor(DescSetup setup, String name) throws Exception {
        DescriptorExposer de = new DescriptorExposer(ASM_TYPE, name);
        setup.setup(de);
        Class descriptor = de.load(new BytecodeLoader.Loader());
        return (PyDataDescr)descriptor.newInstance();
    }

    public PyDataDescr makeDescriptor(DescSetup setup) throws Exception {
        return this.makeDescriptor(setup, "desc");
    }

    public void testNoDescriptors() throws Exception {
        DescriptorExposer de = new DescriptorExposer(ASM_TYPE, "desc");
        try {
            de.load(new BytecodeLoader.Loader());
            DescriptorExposerTest.fail((String)"Should not be able to generate a descriptor with no getter");
        }
        catch (InvalidExposingException invalidExposingException) {
            // empty catch block
        }
    }

    public void testMethodGetter() throws Exception {
        PyDataDescr instance = this.makeDescriptor(new DescSetup(){

            public void setup(DescriptorExposer de) {
                de.addMethodGetter("toString", RETURN_STRING_DESCRIPTOR);
            }
        });
        DescriptorExposerTest.assertEquals((String)"A simple test class", (String)instance.__get__(this.se, PY_TYPE).toString());
        DescriptorExposerTest.assertFalse((boolean)instance.implementsDescrSet());
        DescriptorExposerTest.assertFalse((boolean)instance.implementsDescrDelete());
    }

    public void testFieldGetter() throws Exception {
        PyDataDescr instance = this.makeDescriptor(new DescSetup(){

            public void setup(DescriptorExposer de) {
                de.addFieldGetter("toStringVal", PyTypes.STRING);
            }
        });
        DescriptorExposerTest.assertEquals((String)"A simple test class", (String)instance.__get__(new DescExposed(), PY_TYPE).toString());
        DescriptorExposerTest.assertFalse((boolean)instance.implementsDescrSet());
        DescriptorExposerTest.assertFalse((boolean)instance.implementsDescrDelete());
    }

    public void testMethodSetter() throws Exception {
        PyDataDescr instance = this.makeDescriptor(new DescSetup(){

            public void setup(DescriptorExposer de) {
                de.addMethodGetter("toString", RETURN_STRING_DESCRIPTOR);
                de.addMethodSetter("setToString", "(Ljava/lang/String;)V");
            }
        });
        instance.__set__(this.se, Py.newString(NEW_VAL));
        DescriptorExposerTest.assertEquals((String)NEW_VAL, (String)this.se.toString());
        DescriptorExposerTest.assertTrue((boolean)instance.implementsDescrSet());
        DescriptorExposerTest.assertFalse((boolean)instance.implementsDescrDelete());
    }

    public void testFieldSetter() throws Exception {
        PyDataDescr instance = this.makeDescriptor(new DescSetup(){

            public void setup(DescriptorExposer de) {
                de.addFieldGetter("toStringVal", PyTypes.STRING);
                de.addFieldSetter("toStringVal", PyTypes.STRING);
            }
        });
        instance.__set__(this.se, Py.newString(NEW_VAL));
        DescriptorExposerTest.assertEquals((String)NEW_VAL, (String)this.se.toString());
        DescriptorExposerTest.assertTrue((boolean)instance.implementsDescrSet());
        DescriptorExposerTest.assertFalse((boolean)instance.implementsDescrDelete());
    }

    public void testMethodDel() throws Exception {
        PyDataDescr instance = this.makeDescriptor(new DescSetup(){

            public void setup(DescriptorExposer de) {
                de.addMethodGetter("toString", RETURN_STRING_DESCRIPTOR);
                de.addMethodDeleter("deleteToString", "()V");
            }
        });
        instance.__delete__(this.se);
        DescriptorExposerTest.assertNull((Object)this.se.toString());
        DescriptorExposerTest.assertTrue((boolean)instance.implementsDescrDelete());
    }

    public void testInt() throws Exception {
        PyDataDescr instance = this.makeDescriptor(new DescSetup(){

            public void setup(DescriptorExposer de) {
                de.addFieldGetter("i", PyTypes.INT);
                de.addFieldSetter("i", PyTypes.INT);
            }
        }, "i");
        DescriptorExposerTest.assertEquals((int)7, (int)instance.__get__(this.se, PY_TYPE).asInt());
        instance.__set__(this.se, Py.newInteger(12));
        DescriptorExposerTest.assertEquals((int)12, (int)instance.__get__(this.se, PY_TYPE).asInt());
    }

    public void testByte() throws Exception {
        PyDataDescr instance = this.makeDescriptor(new DescSetup(){

            public void setup(DescriptorExposer de) {
                de.addFieldGetter("b", PyTypes.BYTE);
                de.addMethodSetter("setB", "(B)");
            }
        }, "b");
        DescriptorExposerTest.assertEquals((int)0, (int)instance.__get__(this.se, PY_TYPE).asInt());
        instance.__set__(this.se, Py.newInteger(-1));
        DescriptorExposerTest.assertEquals((int)-1, (int)instance.__get__(this.se, PY_TYPE).asInt());
    }

    public void testLong() throws Exception {
        PyDataDescr instance = this.makeDescriptor(new DescSetup(){

            public void setup(DescriptorExposer de) {
                de.addMethodGetter("l", "()J");
                de.addFieldSetter("l", Type.LONG_TYPE);
            }
        }, "l");
        DescriptorExposerTest.assertEquals((int)0, (int)instance.__get__(this.se, PY_TYPE).asInt());
        instance.__set__(this.se, Py.newInteger(12));
        DescriptorExposerTest.assertEquals((int)12, (int)instance.__get__(this.se, PY_TYPE).asInt());
    }

    public void testDouble() throws Exception {
        PyDataDescr instance = this.makeDescriptor(new DescSetup(){

            public void setup(DescriptorExposer de) {
                de.addMethodGetter("getD", "()D");
                de.addMethodSetter("setD", "(D)");
            }
        }, "d");
        DescriptorExposerTest.assertEquals((Object)98.7, (Object)Py.py2double(instance.__get__(this.se, PY_TYPE)));
        instance.__set__(this.se, Py.newInteger(12));
        DescriptorExposerTest.assertEquals((Object)12.0, (Object)Py.py2double(instance.__get__(this.se, PY_TYPE)));
    }

    public void testBool() throws Exception {
        PyDataDescr instance = this.makeDescriptor(new DescSetup(){

            public void setup(DescriptorExposer de) {
                de.addFieldGetter("bool", PyTypes.BOOLEAN);
                de.addFieldSetter("bool", PyTypes.BOOLEAN);
            }
        }, "bool");
        DescriptorExposerTest.assertEquals((boolean)false, (boolean)Py.py2boolean(instance.__get__(this.se, PY_TYPE)));
        instance.__set__(this.se, Py.True);
        DescriptorExposerTest.assertEquals((boolean)true, (boolean)Py.py2boolean(instance.__get__(this.se, PY_TYPE)));
    }

    public class DescExposed
    extends PyObject {
        public double d = 98.7;
        public int i = 7;
        public long l;
        public byte b;
        public boolean bool;
        public String toStringVal = "A simple test class";

        public void setToString(String newVal) {
            this.toStringVal = newVal;
        }

        public void deleteToString() {
            this.toStringVal = null;
        }

        public String toString() {
            return this.toStringVal;
        }

        public long l() {
            return this.l;
        }

        public void setB(byte newB) {
            this.b = newB;
        }

        public void setD(double d) {
            this.d = d;
        }

        public double getD() {
            return this.d;
        }
    }

    static interface DescSetup {
        public void setup(DescriptorExposer var1);
    }
}

