/*
 * Decompiled with CFR 0.152.
 */
package org.python.expose.generate;

import junit.framework.TestCase;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.python.expose.generate.ExposedMethodFinder;
import org.python.expose.generate.Exposer;
import org.python.expose.generate.MethodExposer;
import org.python.expose.generate.NewExposer;
import org.python.expose.generate.PyTypes;
import org.python.expose.generate.SimpleExposed;

public class ExposeMethodFinderTest
extends TestCase
implements Opcodes,
PyTypes {
    private static final String METHOD = "method";
    private static final String NEW = "new";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String DELETE = "del";
    private MethodExposer resultantMethExp;
    private Exposer resultantNewExp;
    private String deleteName;
    private String getName;
    private String setName;

    private ExposedMethodFinder makeFinder(int access, String descriptor, String methodName) {
        return new ExposedMethodFinder("simpleexposed", Type.getType(SimpleExposed.class), access, methodName, descriptor, null, (MethodVisitor)new EmptyVisitor()){

            public void handleResult(MethodExposer exposer) {
                ExposeMethodFinderTest.this.resultantMethExp = exposer;
            }

            public void handleNewExposer(Exposer exposer) {
                ExposeMethodFinderTest.this.resultantNewExp = exposer;
            }

            public void exposeAsDeleteDescriptor(String descName) {
                ExposeMethodFinderTest.this.deleteName = descName;
            }

            public void exposeAsGetDescriptor(String descName) {
                ExposeMethodFinderTest.this.getName = descName;
            }

            public void exposeAsSetDescriptor(String descName) {
                ExposeMethodFinderTest.this.setName = descName;
            }
        };
    }

    private void checkSet(String typeThatShouldBeSet) {
        this.checkSet(METHOD, typeThatShouldBeSet, this.resultantMethExp);
        this.checkSet(NEW, typeThatShouldBeSet, this.resultantNewExp);
        this.checkSet(GET, typeThatShouldBeSet, this.getName);
        this.checkSet(SET, typeThatShouldBeSet, this.setName);
        this.checkSet(DELETE, typeThatShouldBeSet, this.deleteName);
    }

    private void checkSet(String type, String typeThatShouldBeSet, Object actualValue) {
        if (type.equals(typeThatShouldBeSet)) {
            ExposeMethodFinderTest.assertNotNull((String)(type + " should've been set after these operations"), (Object)actualValue);
        } else {
            ExposeMethodFinderTest.assertNull((String)(type + " shouldn't have been set by these operations"), (Object)actualValue);
        }
    }

    public void testExposedNew() {
        ExposedMethodFinder visitor = this.makeFinder(10, NewExposer.NEW_DESCRIPTOR, "new_");
        visitor.visitAnnotation(EXPOSED_NEW.getDescriptor(), true);
        visitor.visitEnd();
        this.checkSet(NEW);
    }

    public void testSimpleExposedMethod() {
        this.makeAndVisit(EXPOSED_METHOD, METHOD, null, new String[0]);
        ExposeMethodFinderTest.assertEquals((int)1, (int)this.resultantMethExp.getNames().length);
        ExposeMethodFinderTest.assertEquals((String)"simpleMethod", (String)this.resultantMethExp.getNames()[0]);
    }

    private void makeAndVisit(Type annotationToVisit, String typeThatShouldBeSet, String arrayToVisit, String ... vals) {
        ExposedMethodFinder visitor = this.makeFinder(2, "()V", "simpleMethod");
        AnnotationVisitor methVisitor = visitor.visitAnnotation(annotationToVisit.getDescriptor(), true);
        if (arrayToVisit != null) {
            AnnotationVisitor arrayVisitor = methVisitor.visitArray(arrayToVisit);
            for (String val : vals) {
                arrayVisitor.visit("doesn't matter in asm", (Object)val);
            }
            arrayVisitor.visitEnd();
            methVisitor.visitEnd();
        }
        visitor.visitEnd();
        this.checkSet(typeThatShouldBeSet);
    }

    public void testNamesExposedMethod() {
        this.makeAndVisit(EXPOSED_METHOD, METHOD, "names", "first", "second");
        ExposeMethodFinderTest.assertEquals((int)0, (int)this.resultantMethExp.getDefaults().length);
        ExposeMethodFinderTest.assertEquals((int)2, (int)this.resultantMethExp.getNames().length);
        ExposeMethodFinderTest.assertEquals((String)"first", (String)this.resultantMethExp.getNames()[0]);
        ExposeMethodFinderTest.assertEquals((String)"second", (String)this.resultantMethExp.getNames()[1]);
    }

    public void testDefaultsExposedMethod() {
        this.makeAndVisit(EXPOSED_METHOD, METHOD, "defaults", "Py.None");
        ExposeMethodFinderTest.assertEquals((int)1, (int)this.resultantMethExp.getDefaults().length);
        ExposeMethodFinderTest.assertEquals((String)"Py.None", (String)this.resultantMethExp.getDefaults()[0]);
    }

    public void testDelDescriptor() {
        this.makeAndVisitDescr("simpleMethod", EXPOSED_DELETE, DELETE);
        ExposeMethodFinderTest.assertEquals((String)"simpleMethod", (String)this.deleteName);
    }

    public void testSetDescriptor() {
        this.makeAndVisitDescr("simpleMethod", EXPOSED_SET, SET);
        ExposeMethodFinderTest.assertEquals((String)"simpleMethod", (String)this.setName);
    }

    public void testGetDescriptor() {
        this.makeAndVisitDescr("getVal", EXPOSED_GET, GET);
        ExposeMethodFinderTest.assertEquals((String)"getVal", (String)this.getName);
    }

    public void testNamedGetDescriptor() {
        this.makeAndVisitDescr("getVal", EXPOSED_GET, GET, "val");
        ExposeMethodFinderTest.assertEquals((String)"val", (String)this.getName);
    }

    public void testNamedSetDescriptor() {
        this.makeAndVisitDescr("setVal", EXPOSED_SET, SET, "val");
        ExposeMethodFinderTest.assertEquals((String)"val", (String)this.setName);
    }

    public void testNamedDelDescriptor() {
        this.makeAndVisitDescr("delVal", EXPOSED_DELETE, DELETE, "val");
        ExposeMethodFinderTest.assertEquals((String)"val", (String)this.deleteName);
    }

    private void makeAndVisitDescr(String methodName, Type annotationToVisit, String typeThatShouldBeSet) {
        this.makeAndVisitDescr(methodName, annotationToVisit, typeThatShouldBeSet, null);
    }

    private void makeAndVisitDescr(String methodName, Type annotationToVisit, String typeThatShouldBeSet, String name) {
        ExposedMethodFinder visitor = this.makeFinder(2, "()V", methodName);
        AnnotationVisitor methVisitor = visitor.visitAnnotation(annotationToVisit.getDescriptor(), true);
        if (name != null) {
            methVisitor.visit("name", (Object)name);
        }
        methVisitor.visitEnd();
        visitor.visitEnd();
        this.checkSet(typeThatShouldBeSet);
    }
}

