/*
 * Decompiled with CFR 0.152.
 */
package org.python.expose.generate;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.python.expose.generate.DescriptorExposer;
import org.python.expose.generate.ExposedFieldFinder;
import org.python.expose.generate.ExposedMethodFinder;
import org.python.expose.generate.ExposedTypeVisitor;
import org.python.expose.generate.Exposer;
import org.python.expose.generate.InvalidExposingException;
import org.python.expose.generate.MethodExposer;
import org.python.expose.generate.PyTypes;
import org.python.expose.generate.TypeExposer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExposedTypeProcessor
implements Opcodes,
PyTypes {
    private List<MethodExposer> methodExposers = new ArrayList<MethodExposer>();
    private Map<String, DescriptorExposer> descExposers = new HashMap<String, DescriptorExposer>();
    private Exposer newExposer;
    private TypeExposer typeExposer;
    private ClassWriter cw;
    private String typeName;
    private Type onType;

    public ExposedTypeProcessor(InputStream in) throws IOException {
        ClassReader cr = new ClassReader(in);
        this.cw = new ClassWriter(cr, 2);
        cr.accept((ClassVisitor)new TypeProcessor((ClassVisitor)this.cw), 2);
    }

    public byte[] getBytecode() {
        return this.cw.toByteArray();
    }

    public Collection<MethodExposer> getMethodExposers() {
        return this.methodExposers;
    }

    public Collection<DescriptorExposer> getDescriptorExposers() {
        return this.descExposers.values();
    }

    public Exposer getNewExposer() {
        return this.newExposer;
    }

    public String getName() {
        return this.typeName;
    }

    public TypeExposer getTypeExposer() {
        return this.typeExposer;
    }

    public String getExposedClassName() {
        return this.onType.getClassName();
    }

    protected DescriptorExposer getDescriptorExposer(String descName) {
        if (!this.descExposers.containsKey(descName)) {
            this.descExposers.put(descName, new DescriptorExposer(this.onType, descName));
        }
        return this.descExposers.get(descName);
    }

    private final class TypeProcessor
    extends ClassAdapter {
        private Type baseType;
        private boolean generatedStaticBlock;

        private TypeProcessor(ClassVisitor cv) {
            super(cv);
            this.baseType = PyTypes.OBJECT;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            ExposedTypeProcessor.this.onType = Type.getType((String)("L" + name + ";"));
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(PyTypes.EXPOSED_TYPE.getDescriptor())) {
                return new ExposedTypeVisitor(ExposedTypeProcessor.this.onType){

                    public void handleResult(String name) {
                        ExposedTypeProcessor.this.typeName = name;
                    }

                    public void handleResult(Type base) {
                        TypeProcessor.this.baseType = base;
                    }
                };
            }
            return super.visitAnnotation(desc, visible);
        }

        private void throwInvalid(String msg) {
            throw new InvalidExposingException(msg + "[class=" + ExposedTypeProcessor.this.onType.getClassName() + "]");
        }

        public void visitEnd() {
            if (ExposedTypeProcessor.this.typeName == null) {
                this.throwInvalid("A class to be exposed must have the ExposedType annotation");
            }
            ExposedTypeProcessor.this.typeExposer = new TypeExposer(ExposedTypeProcessor.this.onType, this.baseType, ExposedTypeProcessor.this.getName(), ExposedTypeProcessor.this.methodExposers, ExposedTypeProcessor.this.descExposers.values(), ExposedTypeProcessor.this.newExposer);
            for (Exposer exposer : ExposedTypeProcessor.this.methodExposers) {
                this.addInnerClass(exposer.getGeneratedType());
            }
            for (Exposer exposer : ExposedTypeProcessor.this.descExposers.values()) {
                this.addInnerClass(exposer.getGeneratedType());
            }
            if (ExposedTypeProcessor.this.newExposer != null) {
                this.addInnerClass(ExposedTypeProcessor.this.newExposer.getGeneratedType());
            }
            this.addInnerClass(ExposedTypeProcessor.this.typeExposer.getGeneratedType());
            if (!this.generatedStaticBlock) {
                MethodVisitor mv = this.visitMethod(8, "<clinit>", "()V", null, null);
                mv.visitCode();
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            super.visitEnd();
        }

        private void generateAddBuilder(MethodVisitor mv) {
            mv.visitLdcInsn((Object)ExposedTypeProcessor.this.onType);
            Type typeExposerType = Type.getObjectType((String)TypeExposer.makeGeneratedName(ExposedTypeProcessor.this.onType).replace('.', '/'));
            mv.visitTypeInsn(187, typeExposerType.getInternalName());
            mv.visitInsn(89);
            mv.visitMethodInsn(183, typeExposerType.getInternalName(), "<init>", "()V");
            mv.visitMethodInsn(184, PyTypes.PYTYPE.getInternalName(), "addBuilder", Type.getMethodDescriptor((Type)PyTypes.VOID, (Type[])new Type[]{PyTypes.CLASS, PyTypes.TYPEBUILDER}));
        }

        private void addInnerClass(Type inner) {
            super.visitInnerClass(inner.getInternalName(), ExposedTypeProcessor.this.onType.getInternalName(), inner.getClassName().substring(inner.getClassName().lastIndexOf(36) + 1), 10);
        }

        public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions2) {
            if (name.equals("<clinit>")) {
                this.generatedStaticBlock = true;
                final MethodVisitor passthroughVisitor = super.visitMethod(access, name, desc, signature, exceptions2);
                return new MethodAdapter(passthroughVisitor){

                    public void visitCode() {
                        super.visitCode();
                        TypeProcessor.this.generateAddBuilder(passthroughVisitor);
                    }
                };
            }
            MethodVisitor passthroughVisitor = super.visitMethod(access, name, desc, signature, exceptions2);
            return new ExposedMethodFinder(ExposedTypeProcessor.this.getName(), ExposedTypeProcessor.this.onType, access, name, desc, exceptions2, passthroughVisitor){

                public void handleResult(MethodExposer exposer) {
                    ExposedTypeProcessor.this.methodExposers.add(exposer);
                }

                public void handleNewExposer(Exposer exposer) {
                    if (ExposedTypeProcessor.this.newExposer != null) {
                        TypeProcessor.this.throwInvalid("Only one @ExposedNew is allowed per class");
                    }
                    ExposedTypeProcessor.this.newExposer = exposer;
                }

                public void exposeAsGetDescriptor(String descName) {
                    ExposedTypeProcessor.this.getDescriptorExposer(descName).addMethodGetter(name, desc);
                }

                public void exposeAsSetDescriptor(String descName) {
                    ExposedTypeProcessor.this.getDescriptorExposer(descName).addMethodSetter(name, desc);
                }

                public void exposeAsDeleteDescriptor(String descName) {
                    ExposedTypeProcessor.this.getDescriptorExposer(descName).addMethodDeleter(name, desc);
                }
            };
        }

        public FieldVisitor visitField(int access, final String fieldName, final String desc, String signature, Object value) {
            FieldVisitor passthroughVisitor = super.visitField(access, fieldName, desc, signature, value);
            return new ExposedFieldFinder(fieldName, passthroughVisitor){

                public void exposeAsGet(String name) {
                    ExposedTypeProcessor.this.getDescriptorExposer(name).addFieldGetter(fieldName, Type.getType((String)desc));
                }

                public void exposeAsSet(String name) {
                    ExposedTypeProcessor.this.getDescriptorExposer(name).addFieldSetter(fieldName, Type.getType((String)desc));
                }
            };
        }
    }
}

