/*
 * Decompiled with CFR 0.152.
 */
package org.python.expose.generate;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.python.core.BytecodeLoader;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyDataDescr;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.generate.ExposedTypeProcessor;
import org.python.expose.generate.InvalidExposingException;
import org.python.expose.generate.MethodExposer;
import org.python.expose.generate.MethodExposerTest;

public class ExposedTypeProcessorTest
extends TestCase {
    public void testDetectType() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/python/expose/generate/SimpleExposed.class");
        ExposedTypeProcessor ice = new ExposedTypeProcessor(in);
        ExposedTypeProcessorTest.assertEquals((String)"simpleexposed", (String)ice.getName());
        ExposedTypeProcessorTest.assertEquals((int)16, (int)ice.getMethodExposers().size());
        ExposedTypeProcessorTest.assertNotNull((Object)ice.getNewExposer());
        ExposedTypeProcessorTest.assertEquals((int)1, (int)ice.getDescriptorExposers().size());
        ExposedTypeProcessorTest.assertEquals((String)"simpleexposed", (String)ice.getTypeExposer().getName());
        BytecodeLoader.Loader loader = new BytecodeLoader.Loader();
        Class simple_method = null;
        for (MethodExposer exposer : ice.getMethodExposers()) {
            if (exposer.getNames()[0].equals("invisible")) {
                simple_method = exposer.load(loader);
                continue;
            }
            exposer.load(loader);
        }
        Class tostringDesc = ice.getDescriptorExposers().iterator().next().load(loader);
        ice.getNewExposer().load(loader);
        ice.getTypeExposer().load(loader);
        Class doctoredSimple = loader.loadClassFromBytes("org.python.expose.generate.SimpleExposed", ice.getBytecode());
        PyObject simp = (PyObject)doctoredSimple.newInstance();
        PyBuiltinFunction func = MethodExposerTest.instantiate(simple_method, "invisible");
        PyBuiltinFunction bound = func.bind(simp);
        bound.__call__();
        PyDataDescr desc = (PyDataDescr)tostringDesc.newInstance();
        ExposedTypeProcessorTest.assertEquals((Object)doctoredSimple.getField("toStringVal").get(simp), (Object)desc.__get__(simp, PyType.fromClass(doctoredSimple)).toString());
    }

    public void testNoAnnotationType() throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/python/expose/generate/ExposedTypeProcessorTest.class");
        try {
            new ExposedTypeProcessor(in);
            ExposedTypeProcessorTest.fail((String)"Shouldn't be able to create an InnerClassExposer with a class without ExposedType");
        }
        catch (InvalidExposingException invalidExposingException) {
            // empty catch block
        }
    }
}

